# GNU Shepherd --- Test 'shepherd' behavior when its socket is deleted.
# Copyright © 2025 Ludovic Courtès <ludo@gnu.org>
#
# This file is part of the GNU Shepherd.
#
# The GNU Shepherd is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or (at
# your option) any later version.
#
# The GNU Shepherd is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with the GNU Shepherd.  If not, see <https://www.gnu.org/licenses/>.

shepherd --version
herd --version

SHEPHERD_SOCKET="t-socket-$$"
export SHEPHERD_SOCKET

log="t-log-$$"
pid="t-pid-$$"

trap "cat $log || true; rm -f $SHEPHERD_SOCKET $log;
      test -f $pid && kill \`cat $pid\` || true; rm -f $pid" EXIT

rm -f "$pid"
shepherd -I -c /dev/null -l "$log" --pid="$pid" &

until test -f "$pid"; do sleep 0.3; done

kill -0 $(cat "$pid")
herd status

rm "$SHEPHERD_SOCKET"

# Removing the socket should cause 'shepherd' to exit.
while kill -0 $(cat "$pid"); do sleep 1; done

if herd status; then false; else true; fi

grep "Socket '$SHEPHERD_SOCKET' deleted" "$log"
