"""Integration tests for circutibuilder.py"""

import random


def test_build_circuit(cb, rl):
    # Path is empty
    path = []
    circuit_id, _ = cb.build_circuit(path)
    assert not circuit_id

    exits = rl.exits_not_bad_allowing_port(port=443)
    circuit_id = None
    # Circuits can fail randomly
    while circuit_id is None:
        exit_relay = random.choice(exits)
        entry = rl.random_relay()
        path = [entry.fingerprint, exit_relay.fingerprint]
        circuit_id, _ = cb.build_circuit(path)
    assert circuit_id


def test_build_circuit_with_exit_flowctrl(is_cc_tor_version, cb, rl):
    if not is_cc_tor_version:
        import pytest

        pytest.skip("This test can't be run with this tor version")
        return
    rl.consensus_params_dict = {"cc_alg": 2, "bwscanner_cc": 1}

    exits = rl.exits_with_2_in_flowctrl(port=443)
    circuit_id = None
    # Circuits can fail randomly
    while circuit_id is None:
        exit_relay = random.choice(exits)
        entry = random.choice([e for e in exits if e != exit_relay])
        path = [entry.fingerprint, exit_relay.fingerprint]
        circuit_id, _ = cb.build_circuit(path)
    assert circuit_id
