# typed: true

# DO NOT EDIT MANUALLY
# This is an autogenerated file for types exported from the `minitest` gem.
# Please instead update this file by running `bin/tapioca gem minitest`.


# The top-level namespace for Minitest. Also the location of the main
# runtime. See +Minitest.run+ for more information.
#
# source://minitest//lib/minitest/parallel.rb#3
module Minitest
  class << self
    # A simple hook allowing you to run a block of code after everything
    # is done running. Eg:
    #
    #   Minitest.after_run { p $debugging_info }
    #
    # source://minitest//lib/minitest.rb#95
    def after_run(&block); end

    # source://minitest//lib/minitest.rb#20
    def allow_fork; end

    # source://minitest//lib/minitest.rb#20
    def allow_fork=(_arg0); end

    # Registers Minitest to run at process exit
    #
    # source://minitest//lib/minitest.rb#69
    def autorun; end

    # source://minitest//lib/minitest.rb#20
    def backtrace_filter; end

    # source://minitest//lib/minitest.rb#20
    def backtrace_filter=(_arg0); end

    # source://minitest//lib/minitest.rb#19
    def cattr_accessor(name); end

    # source://minitest//lib/minitest.rb#1208
    def clock_time; end

    # source://minitest//lib/minitest.rb#331
    def empty_run!(options); end

    # source://minitest//lib/minitest.rb#20
    def extensions; end

    # source://minitest//lib/minitest.rb#20
    def extensions=(_arg0); end

    # source://minitest//lib/minitest.rb#364
    def filter_backtrace(bt); end

    # source://minitest//lib/minitest.rb#20
    def info_signal; end

    # source://minitest//lib/minitest.rb#20
    def info_signal=(_arg0); end

    # source://minitest//lib/minitest.rb#134
    def init_plugins(options); end

    # Manually load plugins by name.
    #
    # source://minitest//lib/minitest.rb#102
    def load(*names); end

    # source://minitest//lib/minitest.rb#118
    def load_plugins; end

    # source://minitest//lib/minitest.rb#20
    def parallel_executor; end

    # source://minitest//lib/minitest.rb#20
    def parallel_executor=(_arg0); end

    # source://minitest//lib/minitest.rb#152
    def process_args(args = T.unsafe(nil)); end

    # Register a plugin to be used. Does NOT require / load it.
    #
    # source://minitest//lib/minitest.rb#113
    def register_plugin(name_or_mod); end

    # source://minitest//lib/minitest.rb#20
    def reporter; end

    # source://minitest//lib/minitest.rb#20
    def reporter=(_arg0); end

    # This is the top-level run method. Everything starts from here. It
    # tells each Runnable sub-class to run, and each of those are
    # responsible for doing whatever they do.
    #
    # The overall structure of a run looks like this:
    #
    #   [Minitest.load_plugins] optional, called by user, or require what you want
    #   Minitest.autorun
    #     Minitest.run(args)
    #       Minitest.process_args
    #       Minitest.init_plugins
    #       Minitest.run_all_suites(reporter, options)
    #         Runnable.runnables.each |runnable_klass|
    #           runnable_klass.run_suite(reporter, options)
    #             filtered_methods = runnable_klass.filter_runnable_methods options
    #             filtered_methods.each |runnable_method|
    #               runnable_klass.run(self, runnable_method, reporter)
    #                 runnable_klass.new(runnable_method).run
    #
    # source://minitest//lib/minitest.rb#298
    def run(args = T.unsafe(nil)); end

    # Internal run method. Responsible for telling all Runnable
    # sub-classes to run.
    #
    # source://minitest//lib/minitest.rb#351
    def run_all_suites(reporter, options); end

    # source://minitest//lib/minitest.rb#20
    def seed; end

    # source://minitest//lib/minitest.rb#20
    def seed=(_arg0); end
  end
end

# Defines the API for Reporters. Subclass this and override whatever
# you want. Go nuts.
#
# source://minitest//lib/minitest.rb#706
class Minitest::AbstractReporter
  # @return [AbstractReporter] a new instance of AbstractReporter
  #
  # source://minitest//lib/minitest.rb#708
  def initialize; end

  # Did this run pass?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#743
  def passed?; end

  # About to start running a test. This allows a reporter to show
  # that it is starting or that we are in the middle of a test run.
  #
  # source://minitest//lib/minitest.rb#722
  def prerecord(klass, name); end

  # Output and record the result of the test. Call
  # {result#result_code}[rdoc-ref:Runnable#result_code] to get the
  # result character string. Stores the result of the run if the run
  # did not pass.
  #
  # source://minitest//lib/minitest.rb#731
  def record(result); end

  # Outputs the summary of the run.
  #
  # source://minitest//lib/minitest.rb#737
  def report; end

  # Starts reporting on the run.
  #
  # source://minitest//lib/minitest.rb#715
  def start; end

  # source://minitest//lib/minitest.rb#747
  def synchronize(&block); end
end

# Represents run failures.
#
# source://minitest//lib/minitest.rb#1038
class Minitest::Assertion < ::Exception
  # source://minitest//lib/minitest.rb#1041
  def error; end

  # Where was this run before an assertion was raised?
  #
  # source://minitest//lib/minitest.rb#1048
  def location; end

  # source://minitest//lib/minitest.rb#1056
  def result_code; end

  # source://minitest//lib/minitest.rb#1060
  def result_label; end
end

# source://minitest//lib/minitest.rb#1039
Minitest::Assertion::RE = T.let(T.unsafe(nil), Regexp)

# Minitest Assertions.  All assertion methods accept a +msg+ which is
# printed if the assertion fails.
#
# Protocol: Nearly everything here boils up to +assert+, which
# expects to be able to increment an instance accessor named
# +assertions+. This is not provided by Assertions and must be
# provided by the thing including Assertions. See Minitest::Runnable
# for an example.
#
# source://minitest//lib/minitest/assertions.rb#16
module Minitest::Assertions
  # source://minitest//lib/minitest/assertions.rb#181
  def _synchronize; end

  # source://minitest//lib/minitest/assertions.rb#193
  def _where; end

  # Fails unless +test+ is truthy.
  #
  # source://minitest//lib/minitest/assertions.rb#171
  def assert(test, msg = T.unsafe(nil)); end

  # Fails unless +obj+ is empty.
  #
  # source://minitest//lib/minitest/assertions.rb#188
  def assert_empty(obj, msg = T.unsafe(nil)); end

  # Fails unless <tt>exp == act</tt> printing the difference between
  # the two, if possible.
  #
  # If there is no visible difference but the assertion fails, you
  # should suspect that your #== is buggy, or your inspect output is
  # missing crucial details.  For nicer structural diffing, set
  # Minitest::Test.make_my_diffs_pretty!
  #
  # For floats use assert_in_delta.
  #
  # See also: Minitest::Assertions.diff
  #
  # source://minitest//lib/minitest/assertions.rb#211
  def assert_equal(exp, act, msg = T.unsafe(nil)); end

  # For comparing Floats.  Fails unless +exp+ and +act+ are within +delta+
  # of each other.
  #
  #   assert_in_delta Math::PI, (22.0 / 7.0), 0.01
  #
  # source://minitest//lib/minitest/assertions.rb#225
  def assert_in_delta(exp, act, delta = T.unsafe(nil), msg = T.unsafe(nil)); end

  # For comparing Floats.  Fails unless +exp+ and +act+ have a relative
  # error less than +epsilon+.
  #
  # source://minitest//lib/minitest/assertions.rb#237
  def assert_in_epsilon(exp, act, epsilon = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Fails unless +collection+ includes +obj+.
  #
  # source://minitest//lib/minitest/assertions.rb#244
  def assert_includes(collection, obj, msg = T.unsafe(nil)); end

  # Fails unless +obj+ is an instance of +cls+.
  #
  # source://minitest//lib/minitest/assertions.rb#254
  def assert_instance_of(cls, obj, msg = T.unsafe(nil)); end

  # Fails unless +obj+ is a kind of +cls+.
  #
  # source://minitest//lib/minitest/assertions.rb#265
  def assert_kind_of(cls, obj, msg = T.unsafe(nil)); end

  # Fails unless +matcher+ <tt>=~</tt> +obj+.
  #
  # source://minitest//lib/minitest/assertions.rb#276
  def assert_match(matcher, obj, msg = T.unsafe(nil)); end

  # Fails unless +obj+ is nil
  #
  # source://minitest//lib/minitest/assertions.rb#288
  def assert_nil(obj, msg = T.unsafe(nil)); end

  # For testing with binary operators. Eg:
  #
  #   assert_operator 5, :<=, 4
  #
  # source://minitest//lib/minitest/assertions.rb#298
  def assert_operator(o1, op, o2 = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Fails if stdout or stderr do not output the expected results.
  # Pass in nil if you don't care about that streams output. Pass in
  # "" if you require it to be silent. Pass in a regexp if you want
  # to pattern match.
  #
  #   assert_output(/hey/) { method_with_output }
  #
  # NOTE: this uses #capture_io, not #capture_subprocess_io.
  #
  # See also: #assert_silent
  #
  # source://minitest//lib/minitest/assertions.rb#317
  def assert_output(stdout = T.unsafe(nil), stderr = T.unsafe(nil)); end

  # Fails unless +path+ exists.
  #
  # source://minitest//lib/minitest/assertions.rb#341
  def assert_path_exists(path, msg = T.unsafe(nil)); end

  # For testing with pattern matching (only supported with Ruby 3.0 and later)
  #
  #   # pass
  #   assert_pattern { [1,2,3] => [Integer, Integer, Integer] }
  #
  #   # fail "length mismatch (given 3, expected 1)"
  #   assert_pattern { [1,2,3] => [Integer] }
  #
  # The bare <tt>=></tt> pattern will raise a NoMatchingPatternError on failure, which would
  # normally be counted as a test error. This assertion rescues NoMatchingPatternError and
  # generates a test failure. Any other exception will be raised as normal and generate a test
  # error.
  #
  # source://minitest//lib/minitest/assertions.rb#360
  def assert_pattern; end

  # For testing with predicates. Eg:
  #
  #   assert_predicate str, :empty?
  #
  # This is really meant for specs and is front-ended by assert_operator:
  #
  #   str.must_be :empty?
  #
  # source://minitest//lib/minitest/assertions.rb#378
  def assert_predicate(o1, op, msg = T.unsafe(nil)); end

  # Fails unless the block raises one of +exp+. Returns the
  # exception matched so you can check the message, attributes, etc.
  #
  # +exp+ takes an optional message on the end to help explain
  # failures and defaults to StandardError if no exception class is
  # passed. Eg:
  #
  #   assert_raises(CustomError) { method_with_custom_error }
  #
  # With custom error message:
  #
  #   assert_raises(CustomError, 'This should have raised CustomError') { method_with_custom_error }
  #
  # Using the returned object:
  #
  #   error = assert_raises(CustomError) do
  #     raise CustomError, 'This is really bad'
  #   end
  #
  #   assert_equal 'This is really bad', error.message
  #
  # source://minitest//lib/minitest/assertions.rb#406
  def assert_raises(*exp); end

  # Fails unless +obj+ responds to +meth+.
  # include_all defaults to false to match Object#respond_to?
  #
  # source://minitest//lib/minitest/assertions.rb#438
  def assert_respond_to(obj, meth, msg = T.unsafe(nil), include_all: T.unsafe(nil)); end

  # Fails unless +exp+ and +act+ are #equal?
  #
  # source://minitest//lib/minitest/assertions.rb#446
  def assert_same(exp, act, msg = T.unsafe(nil)); end

  # Fails if the block outputs anything to stderr or stdout.
  #
  # See also: #assert_output
  #
  # source://minitest//lib/minitest/assertions.rb#459
  def assert_silent; end

  # Fails unless the block throws +sym+
  #
  # source://minitest//lib/minitest/assertions.rb#468
  def assert_throws(sym, msg = T.unsafe(nil)); end

  # Captures $stdout and $stderr into strings:
  #
  #   out, err = capture_io do
  #     puts "Some info"
  #     warn "You did a bad thing"
  #   end
  #
  #   assert_match %r%info%, out
  #   assert_match %r%bad%, err
  #
  # NOTE: For efficiency, this method uses StringIO and does not
  # capture IO for subprocesses. Use #capture_subprocess_io for
  # that.
  #
  # source://minitest//lib/minitest/assertions.rb#504
  def capture_io; end

  # Captures $stdout and $stderr into strings, using Tempfile to
  # ensure that subprocess IO is captured as well.
  #
  #   out, err = capture_subprocess_io do
  #     system "echo Some info"
  #     system "echo You did a bad thing 1>&2"
  #   end
  #
  #   assert_match %r%info%, out
  #   assert_match %r%bad%, err
  #
  # NOTE: This method is approximately 10x slower than #capture_io so
  # only use it when you need to test the output of a subprocess.
  #
  # source://minitest//lib/minitest/assertions.rb#537
  def capture_subprocess_io; end

  # Returns a diff between +exp+ and +act+. If there is no known
  # diff command or if it doesn't make sense to diff the output
  # (single line, short output), then it simply returns a basic
  # comparison between the two.
  #
  # See +things_to_diff+ for more info.
  #
  # source://minitest//lib/minitest/assertions.rb#57
  def diff(exp, act); end

  # Returns details for exception +e+
  #
  # source://minitest//lib/minitest/assertions.rb#569
  def exception_details(e, msg); end

  # Fails after a given date (in the local time zone). This allows
  # you to put time-bombs in your tests if you need to keep
  # something around until a later date lest you forget about it.
  #
  # source://minitest//lib/minitest/assertions.rb#585
  def fail_after(y, m, d, msg); end

  # Fails with +msg+.
  #
  # source://minitest//lib/minitest/assertions.rb#592
  def flunk(msg = T.unsafe(nil)); end

  # Returns a proc that delays generation of an output message. If
  # +msg+ is a proc (eg, from another +message+ call) return +msg+
  # as-is. Otherwise, return a proc that will output +msg+ along
  # with the value of the result of the block passed to +message+.
  #
  # source://minitest//lib/minitest/assertions.rb#603
  def message(msg = T.unsafe(nil), ending = T.unsafe(nil), &default); end

  # This returns a human-readable version of +obj+. By default
  # #inspect is called. You can override this to use #pretty_inspect
  # if you want.
  #
  # See Minitest::Test.make_my_diffs_pretty!
  #
  # source://minitest//lib/minitest/assertions.rb#127
  def mu_pp(obj); end

  # This returns a diff-able more human-readable version of +obj+.
  # This differs from the regular mu_pp because it expands escaped
  # newlines and makes hex-values (like object_ids) generic. This
  # uses mu_pp to do the first pass and then cleans it up.
  #
  # source://minitest//lib/minitest/assertions.rb#145
  def mu_pp_for_diff(obj); end

  # used for counting assertions
  #
  # source://minitest//lib/minitest/assertions.rb#614
  def pass(_msg = T.unsafe(nil)); end

  # Fails if +test+ is truthy.
  #
  # source://minitest//lib/minitest/assertions.rb#621
  def refute(test, msg = T.unsafe(nil)); end

  # Fails if +obj+ is empty.
  #
  # source://minitest//lib/minitest/assertions.rb#629
  def refute_empty(obj, msg = T.unsafe(nil)); end

  # Fails if <tt>exp == act</tt>.
  #
  # For floats use refute_in_delta.
  #
  # source://minitest//lib/minitest/assertions.rb#639
  def refute_equal(exp, act, msg = T.unsafe(nil)); end

  # For comparing Floats.  Fails if +exp+ is within +delta+ of +act+.
  #
  #   refute_in_delta Math::PI, (22.0 / 7.0)
  #
  # source://minitest//lib/minitest/assertions.rb#651
  def refute_in_delta(exp, act, delta = T.unsafe(nil), msg = T.unsafe(nil)); end

  # For comparing Floats.  Fails if +exp+ and +act+ have a relative error
  # less than +epsilon+.
  #
  # source://minitest//lib/minitest/assertions.rb#663
  def refute_in_epsilon(exp, act, epsilon = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Fails if +obj+ includes +sub+.
  #
  # source://minitest//lib/minitest/assertions.rb#670
  def refute_includes(obj, sub, msg = T.unsafe(nil)); end

  # Fails if +obj+ is an instance of +cls+.
  #
  # source://minitest//lib/minitest/assertions.rb#678
  def refute_instance_of(cls, obj, msg = T.unsafe(nil)); end

  # Fails if +obj+ is a kind of +cls+.
  #
  # source://minitest//lib/minitest/assertions.rb#688
  def refute_kind_of(cls, obj, msg = T.unsafe(nil)); end

  # Fails if +matcher+ <tt>=~</tt> +obj+.
  #
  # source://minitest//lib/minitest/assertions.rb#696
  def refute_match(matcher, obj, msg = T.unsafe(nil)); end

  # Fails if +obj+ is nil.
  #
  # source://minitest//lib/minitest/assertions.rb#705
  def refute_nil(obj, msg = T.unsafe(nil)); end

  # Fails if +o1+ is not +op+ +o2+. Eg:
  #
  #   refute_operator 1, :>, 2 #=> pass
  #   refute_operator 1, :<, 2 #=> fail
  #
  # source://minitest//lib/minitest/assertions.rb#737
  def refute_operator(o1, op, o2 = T.unsafe(nil), msg = T.unsafe(nil)); end

  # Fails if +path+ exists.
  #
  # source://minitest//lib/minitest/assertions.rb#747
  def refute_path_exists(path, msg = T.unsafe(nil)); end

  # For testing with pattern matching (only supported with Ruby 3.0 and later)
  #
  #   # pass
  #   refute_pattern { [1,2,3] => [String] }
  #
  #   # fail "NoMatchingPatternError expected, but nothing was raised."
  #   refute_pattern { [1,2,3] => [Integer, Integer, Integer] }
  #
  # This assertion expects a NoMatchingPatternError exception, and will fail if none is raised. Any
  # other exceptions will be raised as normal and generate a test error.
  #
  # source://minitest//lib/minitest/assertions.rb#722
  def refute_pattern; end

  # For testing with predicates.
  #
  #   refute_predicate str, :empty?
  #
  # This is really meant for specs and is front-ended by refute_operator:
  #
  #   str.wont_be :empty?
  #
  # source://minitest//lib/minitest/assertions.rb#761
  def refute_predicate(o1, op, msg = T.unsafe(nil)); end

  # Fails if +obj+ responds to the message +meth+.
  # include_all defaults to false to match Object#respond_to?
  #
  # source://minitest//lib/minitest/assertions.rb#771
  def refute_respond_to(obj, meth, msg = T.unsafe(nil), include_all: T.unsafe(nil)); end

  # Fails if +exp+ is the same (by object identity) as +act+.
  #
  # source://minitest//lib/minitest/assertions.rb#780
  def refute_same(exp, act, msg = T.unsafe(nil)); end

  # Skips the current run. If run in verbose-mode, the skipped run
  # gets listed at the end of the run but doesn't cause a failure
  # exit code.
  #
  # @raise [Minitest::Skip]
  #
  # source://minitest//lib/minitest/assertions.rb#793
  def skip(msg = T.unsafe(nil), _ignored = T.unsafe(nil)); end

  # Skips the current run until a given date (in the local time
  # zone). This allows you to put some fixes on hold until a later
  # date, but still holds you accountable and prevents you from
  # forgetting it.
  #
  # source://minitest//lib/minitest/assertions.rb#805
  def skip_until(y, m, d, msg); end

  # Was this testcase skipped? Meant for #teardown.
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest/assertions.rb#814
  def skipped?; end

  # Returns things to diff [expect, butwas], or [nil, nil] if nothing to diff.
  #
  # Criterion:
  #
  # 1. Strings include newlines or escaped newlines, but not both.
  # 2. or:  String lengths are > 30 characters.
  # 3. or:  Strings are equal to each other (but maybe different encodings?).
  # 4. and: we found a diff executable.
  #
  # source://minitest//lib/minitest/assertions.rb#102
  def things_to_diff(exp, act); end

  class << self
    # Returns the diff command to use in #diff. Tries to intelligently
    # figure out what diff to use.
    #
    # source://minitest//lib/minitest/assertions.rb#27
    def diff; end

    # Set the diff command to use in #diff.
    #
    # source://minitest//lib/minitest/assertions.rb#45
    def diff=(o); end
  end
end

# source://minitest//lib/minitest/assertions.rb#17
Minitest::Assertions::UNDEFINED = T.let(T.unsafe(nil), Object)

# The standard backtrace filter for minitest.
#
# See Minitest.backtrace_filter=.
#
# source://minitest//lib/minitest.rb#1173
class Minitest::BacktraceFilter
  # @return [BacktraceFilter] a new instance of BacktraceFilter
  #
  # source://minitest//lib/minitest.rb#1182
  def initialize(regexp = T.unsafe(nil)); end

  # Filter +bt+ to something useful. Returns the whole thing if
  # $DEBUG (ruby) or $MT_DEBUG (env).
  #
  # source://minitest//lib/minitest.rb#1190
  def filter(bt); end

  # The regular expression to use to filter backtraces. Defaults to +MT_RE+.
  #
  # source://minitest//lib/minitest.rb#1180
  def regexp; end

  # The regular expression to use to filter backtraces. Defaults to +MT_RE+.
  #
  # source://minitest//lib/minitest.rb#1180
  def regexp=(_arg0); end
end

# source://minitest//lib/minitest.rb#1175
Minitest::BacktraceFilter::MT_RE = T.let(T.unsafe(nil), Regexp)

# Dispatch to multiple reporters as one.
#
# source://minitest//lib/minitest.rb#988
class Minitest::CompositeReporter < ::Minitest::AbstractReporter
  # @return [CompositeReporter] a new instance of CompositeReporter
  #
  # source://minitest//lib/minitest.rb#994
  def initialize(*reporters); end

  # Add another reporter to the mix.
  #
  # source://minitest//lib/minitest.rb#1006
  def <<(reporter); end

  # source://minitest//lib/minitest.rb#999
  def io; end

  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1010
  def passed?; end

  # source://minitest//lib/minitest.rb#1018
  def prerecord(klass, name); end

  # source://minitest//lib/minitest.rb#1024
  def record(result); end

  # source://minitest//lib/minitest.rb#1030
  def report; end

  # The list of reporters to dispatch to.
  #
  # source://minitest//lib/minitest.rb#992
  def reporters; end

  # The list of reporters to dispatch to.
  #
  # source://minitest//lib/minitest.rb#992
  def reporters=(_arg0); end

  # source://minitest//lib/minitest.rb#1014
  def start; end
end

# Compresses backtraces.
#
# source://minitest//lib/minitest/compress.rb#5
module Minitest::Compress
  # Takes a backtrace (array of strings) and compresses repeating
  # cycles in it to make it more readable.
  #
  # source://minitest//lib/minitest/compress.rb#11
  def compress(orig); end
end

# Provides a simple set of guards that you can use in your tests
# to skip execution if it is not applicable. These methods are
# mixed into Test as both instance and class methods so you
# can use them inside or outside of the test methods.
#
#   def test_something_for_mri
#     skip "bug 1234"  if jruby?
#     # ...
#   end
#
#   if windows? then
#     # ... lots of test methods ...
#   end
#
# source://minitest//lib/minitest.rb#1137
module Minitest::Guard
  # Is this running on jruby?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1142
  def jruby?(platform = T.unsafe(nil)); end

  # Is this running on mri?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1149
  def mri?(platform = T.unsafe(nil)); end

  # Is this running on macOS?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1156
  def osx?(platform = T.unsafe(nil)); end

  # Is this running on windows?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#1163
  def windows?(platform = T.unsafe(nil)); end
end

# source://minitest//lib/minitest/parallel.rb#4
module Minitest::Parallel; end

# The engine used to run multiple tests in parallel.
#
# source://minitest//lib/minitest/parallel.rb#9
class Minitest::Parallel::Executor
  # Create a parallel test executor of with +size+ workers.
  #
  # @return [Executor] a new instance of Executor
  #
  # source://minitest//lib/minitest/parallel.rb#19
  def initialize(size); end

  # Add a job to the queue
  #
  # source://minitest//lib/minitest/parallel.rb#45
  def <<(work); end

  # Shuts down the pool of workers by signalling them to quit and
  # waiting for them all to finish what they're currently working
  # on.
  #
  # source://minitest//lib/minitest/parallel.rb#52
  def shutdown; end

  # The size of the pool of workers.
  #
  # source://minitest//lib/minitest/parallel.rb#14
  def size; end

  # Start the executor
  #
  # source://minitest//lib/minitest/parallel.rb#28
  def start; end
end

# source://minitest//lib/minitest/parallel.rb#58
module Minitest::Parallel::Test
  # source://minitest//lib/minitest/parallel.rb#59
  def _synchronize; end
end

# source://minitest//lib/minitest/parallel.rb#61
module Minitest::Parallel::Test::ClassMethods
  # source://minitest//lib/minitest/parallel.rb#62
  def run(klass, method_name, reporter); end

  # source://minitest//lib/minitest/parallel.rb#66
  def run_order; end
end

# A very simple reporter that prints the "dots" during the run.
#
# This is added to the top-level CompositeReporter at the start of
# the run. If you want to change the output of minitest via a
# plugin, pull this out of the composite and replace it with your
# own.
#
# source://minitest//lib/minitest.rb#778
class Minitest::ProgressReporter < ::Minitest::Reporter
  # source://minitest//lib/minitest.rb#779
  def prerecord(klass, name); end

  # source://minitest//lib/minitest.rb#786
  def record(result); end
end

# Shared code for anything that can get passed to a Reporter. See
# Minitest::Test & Minitest::Result.
#
# source://minitest//lib/minitest.rb#603
module Minitest::Reportable
  # @raise [NotImplementedError]
  #
  # source://minitest//lib/minitest.rb#625
  def class_name; end

  # Did this run error?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#646
  def error?; end

  # The location identifier of this test. Depends on a method
  # existing called class_name.
  #
  # source://minitest//lib/minitest.rb#620
  def location; end

  # Did this run pass?
  #
  # Note: skipped runs are not considered passing, but they don't
  # cause the process to exit non-zero.
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#610
  def passed?; end

  # Returns ".", "F", or "E" based on the result of the run.
  #
  # source://minitest//lib/minitest.rb#632
  def result_code; end

  # Was this run skipped?
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#639
  def skipped?; end
end

# source://minitest//lib/minitest.rb#614
Minitest::Reportable::BASE_DIR = T.let(T.unsafe(nil), String)

# AbstractReportera
#
# source://minitest//lib/minitest.rb#754
class Minitest::Reporter < ::Minitest::AbstractReporter
  # @return [Reporter] a new instance of Reporter
  #
  # source://minitest//lib/minitest.rb#763
  def initialize(io = T.unsafe(nil), options = T.unsafe(nil)); end

  # The IO used to report.
  #
  # source://minitest//lib/minitest.rb#756
  def io; end

  # The IO used to report.
  #
  # source://minitest//lib/minitest.rb#756
  def io=(_arg0); end

  # Command-line options for this run.
  #
  # source://minitest//lib/minitest.rb#761
  def options; end

  # Command-line options for this run.
  #
  # source://minitest//lib/minitest.rb#761
  def options=(_arg0); end
end

# This represents a test result in a clean way that can be
# marshalled over a wire. Tests can do anything they want to the
# test instance and can create conditions that cause Marshal.dump to
# blow up. By using Result.from(a_test) you can be reasonably sure
# that the test result can be marshalled.
#
# source://minitest//lib/minitest.rb#658
class Minitest::Result < ::Minitest::Runnable
  include ::Minitest::Reportable

  # source://minitest//lib/minitest.rb#689
  def class_name; end

  # The class name of the test result.
  #
  # source://minitest//lib/minitest.rb#664
  def klass; end

  # The class name of the test result.
  #
  # source://minitest//lib/minitest.rb#664
  def klass=(_arg0); end

  # The location of the test method.
  #
  # source://minitest//lib/minitest.rb#669
  def source_location; end

  # The location of the test method.
  #
  # source://minitest//lib/minitest.rb#669
  def source_location=(_arg0); end

  # source://minitest//lib/minitest.rb#693
  def to_s; end

  class << self
    # Create a new test result from a Runnable instance.
    #
    # source://minitest//lib/minitest.rb#674
    def from(runnable); end
  end
end

# re-open
#
# source://minitest//lib/minitest.rb#377
class Minitest::Runnable
  # @return [Runnable] a new instance of Runnable
  #
  # source://minitest//lib/minitest.rb#534
  def initialize(name); end

  # Number of assertions executed in this run.
  #
  # source://minitest//lib/minitest.rb#381
  def assertions; end

  # Number of assertions executed in this run.
  #
  # source://minitest//lib/minitest.rb#381
  def assertions=(_arg0); end

  # source://minitest//lib/minitest.rb#530
  def failure; end

  # An assertion raised during the run, if any.
  #
  # source://minitest//lib/minitest.rb#386
  def failures; end

  # An assertion raised during the run, if any.
  #
  # source://minitest//lib/minitest.rb#386
  def failures=(_arg0); end

  # Metadata you attach to the test results that get sent to the reporter.
  #
  # Lazily initializes to a hash, to keep memory down.
  #
  # NOTE: this data *must* be plain (read: marshal-able) data!
  # Hashes! Arrays! Strings!
  #
  # source://minitest//lib/minitest.rb#549
  def metadata; end

  # Sets metadata, mainly used for +Result.from+.
  #
  # source://minitest//lib/minitest.rb#556
  def metadata=(_arg0); end

  # Returns true if metadata exists.
  #
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#561
  def metadata?; end

  # Name of the run.
  #
  # source://minitest//lib/minitest.rb#404
  def name; end

  # Set the name of the run.
  #
  # source://minitest//lib/minitest.rb#411
  def name=(o); end

  # Did this run pass?
  #
  # Note: skipped runs are not considered passing, but they don't
  # cause the process to exit non-zero.
  #
  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#578
  def passed?; end

  # Returns a single character string to print based on the result
  # of the run. One of <tt>"."</tt>, <tt>"F"</tt>,
  # <tt>"E"</tt> or <tt>"S"</tt>.
  #
  # @raise [NotImplementedError]
  #
  # source://minitest//lib/minitest.rb#587
  def result_code; end

  # Runs a single method. Needs to return self.
  #
  # @raise [NotImplementedError]
  #
  # source://minitest//lib/minitest.rb#568
  def run; end

  # Was this run skipped? See #passed? for more information.
  #
  # @raise [NotImplementedError]
  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#594
  def skipped?; end

  # The time it took to run.
  #
  # source://minitest//lib/minitest.rb#391
  def time; end

  # The time it took to run.
  #
  # source://minitest//lib/minitest.rb#391
  def time=(_arg0); end

  # source://minitest//lib/minitest.rb#393
  def time_it; end

  class << self
    # Returns an array of filtered +runnable_methods+. Uses
    # options[:include] (--include arguments) and options[:exclude]
    # (--exclude arguments) values to filter.
    #
    # source://minitest//lib/minitest.rb#433
    def filter_runnable_methods(options = T.unsafe(nil)); end

    # source://minitest//lib/minitest.rb#1218
    def inherited(klass); end

    # Returns all instance methods matching the pattern +re+.
    #
    # source://minitest//lib/minitest.rb#418
    def methods_matching(re); end

    # source://minitest//lib/minitest.rb#502
    def on_signal(name, action); end

    # source://minitest//lib/minitest.rb#422
    def reset; end

    # Runs a single method and has the reporter record the result.
    # This was considered internal API but is factored out of run so
    # that subclasses can specialize the running of an individual
    # test. See Minitest::ParallelTest::ClassMethods for an example.
    #
    # source://minitest//lib/minitest.rb#483
    def run(klass, method_name, reporter); end

    # Defines the order to run tests (:random by default). Override
    # this or use a convenience method to change it for your tests.
    #
    # source://minitest//lib/minitest.rb#492
    def run_order; end

    # Responsible for running all runnable methods in a given class,
    # each in its own instance. Each instance is passed to the
    # reporter to record.
    #
    # source://minitest//lib/minitest.rb#451
    def run_suite(reporter, options = T.unsafe(nil)); end

    # Each subclass of Runnable is responsible for overriding this
    # method to return all runnable methods. See #methods_matching.
    #
    # @raise [NotImplementedError]
    #
    # source://minitest//lib/minitest.rb#519
    def runnable_methods; end

    # Returns all subclasses of Runnable.
    #
    # source://minitest//lib/minitest.rb#526
    def runnables; end

    # source://minitest//lib/minitest.rb#496
    def with_info_handler(_reporter = T.unsafe(nil), &block); end
  end
end

# source://minitest//lib/minitest.rb#500
Minitest::Runnable::SIGNALS = T.let(T.unsafe(nil), Hash)

# Assertion raised when skipping a run.
#
# source://minitest//lib/minitest.rb#1068
class Minitest::Skip < ::Minitest::Assertion
  # source://minitest//lib/minitest.rb#1069
  def result_label; end
end

# A reporter that gathers statistics about a test run. Does not do
# any IO because meant to be used as a parent class for a reporter
# that does.
#
# If you want to create an entirely different type of output (eg,
# CI, HTML, etc), this is the place to start.
#
# Example:
#
#   class JenkinsCIReporter < StatisticsReporter
#     def report
#       super  # Needed to calculate some statistics
#
#       print "<testsuite "
#       print "tests='#{count}' "
#       print "failures='#{failures}' "
#       # Remaining XML...
#     end
#   end
#
# source://minitest//lib/minitest.rb#814
class Minitest::StatisticsReporter < ::Minitest::Reporter
  # @return [StatisticsReporter] a new instance of StatisticsReporter
  #
  # source://minitest//lib/minitest.rb#863
  def initialize(io = T.unsafe(nil), options = T.unsafe(nil)); end

  # Total number of assertions.
  #
  # source://minitest//lib/minitest.rb#818
  def assertions; end

  # Total number of assertions.
  #
  # source://minitest//lib/minitest.rb#818
  def assertions=(_arg0); end

  # Total number of test cases.
  #
  # source://minitest//lib/minitest.rb#823
  def count; end

  # Total number of test cases.
  #
  # source://minitest//lib/minitest.rb#823
  def count=(_arg0); end

  # Total number of tests that erred.
  #
  # source://minitest//lib/minitest.rb#851
  def errors; end

  # Total number of tests that erred.
  #
  # source://minitest//lib/minitest.rb#851
  def errors=(_arg0); end

  # Total number of tests that failed.
  #
  # source://minitest//lib/minitest.rb#846
  def failures; end

  # Total number of tests that failed.
  #
  # source://minitest//lib/minitest.rb#846
  def failures=(_arg0); end

  # @return [Boolean]
  #
  # source://minitest//lib/minitest.rb#877
  def passed?; end

  # source://minitest//lib/minitest.rb#885
  def record(result); end

  # Report on the tracked statistics.
  #
  # source://minitest//lib/minitest.rb#895
  def report; end

  # An +Array+ of test cases that failed or were skipped.
  #
  # source://minitest//lib/minitest.rb#828
  def results; end

  # An +Array+ of test cases that failed or were skipped.
  #
  # source://minitest//lib/minitest.rb#828
  def results=(_arg0); end

  # Total number of tests that where skipped.
  #
  # source://minitest//lib/minitest.rb#861
  def skips; end

  # Total number of tests that where skipped.
  #
  # source://minitest//lib/minitest.rb#861
  def skips=(_arg0); end

  # source://minitest//lib/minitest.rb#881
  def start; end

  # Time the test run started. If available, the monotonic clock is
  # used and this is a +Float+, otherwise it's an instance of
  # +Time+.
  #
  # source://minitest//lib/minitest.rb#835
  def start_time; end

  # Time the test run started. If available, the monotonic clock is
  # used and this is a +Float+, otherwise it's an instance of
  # +Time+.
  #
  # source://minitest//lib/minitest.rb#835
  def start_time=(_arg0); end

  # Test run time. If available, the monotonic clock is used and
  # this is a +Float+, otherwise it's an instance of +Time+.
  #
  # source://minitest//lib/minitest.rb#841
  def total_time; end

  # Test run time. If available, the monotonic clock is used and
  # this is a +Float+, otherwise it's an instance of +Time+.
  #
  # source://minitest//lib/minitest.rb#841
  def total_time=(_arg0); end

  # Total number of tests that warned.
  #
  # source://minitest//lib/minitest.rb#856
  def warnings; end

  # Total number of tests that warned.
  #
  # source://minitest//lib/minitest.rb#856
  def warnings=(_arg0); end
end

# A reporter that prints the header, summary, and failure details at
# the end of the run.
#
# This is added to the top-level CompositeReporter at the start of
# the run. If you want to change the output of minitest via a
# plugin, pull this out of the composite and replace it with your
# own.
#
# source://minitest//lib/minitest.rb#916
class Minitest::SummaryReporter < ::Minitest::StatisticsReporter
  # source://minitest//lib/minitest.rb#949
  def aggregated_results(io); end

  # source://minitest//lib/minitest.rb#918
  def old_sync; end

  # source://minitest//lib/minitest.rb#918
  def old_sync=(_arg0); end

  # source://minitest//lib/minitest.rb#932
  def report; end

  # source://minitest//lib/minitest.rb#920
  def start; end

  # source://minitest//lib/minitest.rb#944
  def statistics; end

  # source://minitest//lib/minitest.rb#969
  def summary; end

  # source://minitest//lib/minitest.rb#917
  def sync; end

  # source://minitest//lib/minitest.rb#917
  def sync=(_arg0); end

  # source://minitest//lib/minitest.rb#965
  def to_s; end
end

# Subclass Test to create your own tests. Typically you'll want a
# Test subclass per implementation class.
#
# See Minitest::Assertions
#
# source://minitest//lib/minitest/test.rb#10
class Minitest::Test < ::Minitest::Runnable
  include ::Minitest::Reportable
  include ::Minitest::Assertions
  include ::Minitest::Test::LifecycleHooks
  include ::Minitest::Guard
  include ::Mocha::ParameterMatchers
  include ::Mocha::Hooks
  include ::Mocha::API
  extend ::Minitest::Guard

  # LifecycleHooks
  #
  # source://minitest//lib/minitest/test.rb#186
  def capture_exceptions; end

  # source://minitest//lib/minitest/test.rb#203
  def neuter_exception(e); end

  # source://minitest//lib/minitest/test.rb#214
  def new_exception(klass, msg, bt, kill = T.unsafe(nil)); end

  # Runs a single test with setup/teardown hooks.
  #
  # source://minitest//lib/minitest/test.rb#84
  def run; end

  # source://minitest//lib/minitest/test.rb#196
  def sanitize_exception(e); end

  class << self
    # Call this at the top of your tests when you absolutely
    # positively need to have ordered tests. In doing so, you're
    # admitting that you suck and your tests are weak.
    #
    # source://minitest//lib/minitest/test.rb#31
    def i_suck_and_my_tests_are_order_dependent!; end

    # Returns the value of attribute io_lock.
    #
    # source://minitest//lib/minitest/test.rb#22
    def io_lock; end

    # Sets the attribute io_lock
    #
    # @param value the value to set the attribute io_lock to.
    #
    # source://minitest//lib/minitest/test.rb#22
    def io_lock=(_arg0); end

    # Make diffs for this Test use #pretty_inspect so that diff
    # in assert_equal can have more details. NOTE: this is much slower
    # than the regular inspect but much more usable for complex
    # objects.
    #
    # source://minitest//lib/minitest/test.rb#44
    def make_my_diffs_pretty!; end

    # Call this at the top of your tests (inside the +Minitest::Test+
    # subclass or +describe+ block) when you want to run your tests in
    # parallel. In doing so, you're admitting that you rule and your
    # tests are awesome.
    #
    # source://minitest//lib/minitest/test.rb#56
    def parallelize_me!; end

    # Returns all instance methods starting with "test_". Based on
    # #run_order, the methods are either sorted, randomized
    # (default), or run in parallel.
    #
    # source://minitest//lib/minitest/test.rb#67
    def runnable_methods; end
  end
end

# Provides before/after hooks for setup and teardown. These are
# meant for library writers, NOT for regular test authors. See
# #before_setup for an example.
#
# source://minitest//lib/minitest/test.rb#109
module Minitest::Test::LifecycleHooks
  # Runs before every test, after setup. This hook is meant for
  # libraries to extend minitest. It is not meant to be used by
  # test developers.
  #
  # See #before_setup for an example.
  #
  # source://minitest//lib/minitest/test.rb#159
  def after_setup; end

  # Runs after every test, after teardown. This hook is meant for
  # libraries to extend minitest. It is not meant to be used by
  # test developers.
  #
  # See #before_setup for an example.
  #
  # source://minitest//lib/minitest/test.rb#183
  def after_teardown; end

  # Runs before every test, before setup. This hook is meant for
  # libraries to extend minitest. It is not meant to be used by
  # test developers.
  #
  # As a simplistic example:
  #
  #   module MyMinitestPlugin
  #     def before_setup
  #       super
  #       # ... stuff to do before setup is run
  #     end
  #
  #     def after_setup
  #       # ... stuff to do after setup is run
  #       super
  #     end
  #
  #     def before_teardown
  #       super
  #       # ... stuff to do before teardown is run
  #     end
  #
  #     def after_teardown
  #       # ... stuff to do after teardown is run
  #       super
  #     end
  #   end
  #
  #   class Minitest::Test
  #     include MyMinitestPlugin
  #   end
  #
  # source://minitest//lib/minitest/test.rb#144
  def before_setup; end

  # Runs after every test, before teardown. This hook is meant for
  # libraries to extend minitest. It is not meant to be used by
  # test developers.
  #
  # See #before_setup for an example.
  #
  # source://minitest//lib/minitest/test.rb#168
  def before_teardown; end

  # Runs before every test. Use this to set up before each test
  # run.
  #
  # source://minitest//lib/minitest/test.rb#150
  def setup; end

  # Runs after every test. Use this to clean up after each test
  # run.
  #
  # source://minitest//lib/minitest/test.rb#174
  def teardown; end
end

# source://minitest//lib/minitest/test.rb#15
Minitest::Test::PASSTHROUGH_EXCEPTIONS = T.let(T.unsafe(nil), Array)

# source://minitest//lib/minitest/test.rb#17
Minitest::Test::SETUP_METHODS = T.let(T.unsafe(nil), Array)

# source://minitest//lib/minitest/test.rb#19
Minitest::Test::TEARDOWN_METHODS = T.let(T.unsafe(nil), Array)

# Assertion wrapping an unexpected error that was raised during a run.
#
# source://minitest//lib/minitest.rb#1077
class Minitest::UnexpectedError < ::Minitest::Assertion
  include ::Minitest::Compress

  # @return [UnexpectedError] a new instance of UnexpectedError
  #
  # source://minitest//lib/minitest.rb#1083
  def initialize(error); end

  # source://minitest//lib/minitest.rb#1096
  def backtrace; end

  # TODO: figure out how to use `cause` instead
  #
  # source://minitest//lib/minitest.rb#1081
  def error; end

  # TODO: figure out how to use `cause` instead
  #
  # source://minitest//lib/minitest.rb#1081
  def error=(_arg0); end

  # source://minitest//lib/minitest.rb#1102
  def message; end

  # source://minitest//lib/minitest.rb#1108
  def result_label; end
end

# source://minitest//lib/minitest.rb#1100
Minitest::UnexpectedError::BASE_RE = T.let(T.unsafe(nil), Regexp)

# Assertion raised on warning when running in -Werror mode.
#
# source://minitest//lib/minitest.rb#1116
class Minitest::UnexpectedWarning < ::Minitest::Assertion
  # source://minitest//lib/minitest.rb#1117
  def result_label; end
end

# source://minitest//lib/minitest.rb#13
Minitest::VERSION = T.let(T.unsafe(nil), String)
