// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class InterfaceIPv4Info : ICloneable {
    public object Clone() {
      InterfaceIPv4Info copy = new InterfaceIPv4Info();
      copy.enabled = this.enabled;
      copy.configMethod = this.configMethod;
      copy.addrsCidr = this.addrsCidr;
      copy.dhcpServerAddr = this.dhcpServerAddr;
      copy.dhcpPreferredHostname = this.dhcpPreferredHostname;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["configMethod"] = (int)this.configMethod;
      json["addrsCidr"] = new JsonArray(this.addrsCidr.Select(
        _value => (JsonValue)(_value.Encode())));
      json["dhcpServerAddr"] = this.dhcpServerAddr;
      json["dhcpPreferredHostname"] = this.dhcpPreferredHostname;
      return json;
    }

    public static InterfaceIPv4Info Decode(LightJson.JsonObject json, Agent agent) {
      InterfaceIPv4Info inst = new InterfaceIPv4Info();
      inst.enabled = (bool)json["enabled"];
      inst.configMethod = (Com.Raritan.Idl.net.IpConfigMethod)(int)json["configMethod"];
      inst.addrsCidr = new System.Collections.Generic.List<Com.Raritan.Idl.net.IpAddrCidr>(json["addrsCidr"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.net.IpAddrCidr.Decode(_value, agent)));
      inst.dhcpServerAddr = (string)json["dhcpServerAddr"];
      inst.dhcpPreferredHostname = (string)json["dhcpPreferredHostname"];
      return inst;
    }

    public bool enabled = false;
    public Com.Raritan.Idl.net.IpConfigMethod configMethod = Com.Raritan.Idl.net.IpConfigMethod.STATIC;
    public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.net.IpAddrCidr> addrsCidr = new System.Collections.Generic.List<Com.Raritan.Idl.net.IpAddrCidr>();
    public string dhcpServerAddr = "";
    public string dhcpPreferredHostname = "";
  }
}
