% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docdata.R
\docType{data}
\name{beta.prob}
\alias{beta.prob}
\title{List with assembling probabilities of beta chain TCRs.}
\format{
\code{beta.prob} is a list of matrices and data frames.
}
\description{
\code{beta.prob} is a list with probabilities of TCR assembling taken from
\code{Murugan et al. Statistical inference of the generation probability
of T-cell receptors from sequence repertoires}. It's a list with the following elements:

- P.V - matrix with 1 column and row names stands for V-beta segments. Each element is
a probability of choosing corresponding V-beta segment.

- P.del.D1 - matrix 17x17 with probabilities of choosing D5-D3 deletions for TRBD1.

- P.del.D1 - matrix 17x17 with probabilities of choosing D5-D3 deletions for TRBD2.

- P.ins.len - matrix with first columns stands for number of insertions, second and third columns filled
with probability values of choosing corresponding number of insertions in VD- and DJ-junctions
correspondingly.

- P.ins.nucl - data frame with probability of choosing a nucleotide in the insertion on junctions with known
previous nucleotide. First column with names of nucleotides, 2-5 columns are probabilities of choosing
adjacent nucleotide in VD-junction, 6-9 columns are probabilities of choosing adjacent nucleotide in DJ-junction.

- P.del.J - matrix with the first column "P.del.V" with number of deletions, and other columns with
names for V-segments and with probabilities of corresponding deletions.

- P.del.J - matrix with the first column "P.del.J" with number of deletions, and other columns with
names for J-segments and with probabilities of corresponding deletions.

- P.J.D - matrix with two columns ("TRBD1" and "TRBD2") and 13 rows with row names stands for 
J-beta segments. Each element is a mutual probability of choosing J-D segments.
}
\examples{
\dontrun{
# Generate 10 kmers with adjacent nucleotide probability.
generate.kmers.prob(rep.int(10, 10), .probs=beta.prob$P.ins.nucl[,c(1, 2:5)])
}
}
