% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retired-invoke.R
\name{invoke}
\alias{invoke}
\alias{invoke_map}
\alias{invoke_map_lgl}
\alias{invoke_map_int}
\alias{invoke_map_dbl}
\alias{invoke_map_chr}
\alias{invoke_map_raw}
\alias{invoke_map_dfr}
\alias{invoke_map_dfc}
\alias{invoke_map_df}
\alias{map_call}
\title{Invoke functions.}
\usage{
invoke(.f, .x = NULL, ..., .env = NULL)

invoke_map(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_lgl(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_int(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_dbl(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_chr(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_raw(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_dfr(.f, .x = list(NULL), ..., .env = NULL)

invoke_map_dfc(.f, .x = list(NULL), ..., .env = NULL)
}
\arguments{
\item{.f}{For \code{invoke}, a function; for \code{invoke_map} a
list of functions.}

\item{.x}{For \code{invoke}, an argument-list; for \code{invoke_map} a
list of argument-lists the same length as \code{.f} (or length 1).
The default argument, \code{list(NULL)}, will be recycled to the
same length as \code{.f}, and will call each function with no
arguments (apart from any supplied in \code{...}.}

\item{...}{Additional arguments passed to each function.}

\item{.env}{Environment in which \code{\link[=do.call]{do.call()}} should
evaluate a constructed expression. This only matters if you pass
as \code{.f} the name of a function rather than its value, or as
\code{.x} symbols of objects rather than their values.}
}
\description{
\Sexpr[results=rd, stage=render]{purrr:::lifecycle("retired")}

This pair of functions make it easier to combine a function and list
of parameters to get a result. \code{invoke} is a wrapper around
\code{do.call} that makes it easy to use in a pipe. \code{invoke_map}
makes it easier to call lists of functions with lists of parameters.
}
\section{Life cycle}{


These functions are retired in favour of \code{\link[=exec]{exec()}}. They are no
longer under active development but we will maintain them in the
package undefinitely.
\itemize{
\item \code{invoke()} is retired in favour of the simpler \code{exec()} function
reexported from rlang. \code{exec()} evaluates a function call built
from its inputs and supports tidy dots:\preformatted{# Before:
invoke(mean, list(na.rm = TRUE), x = 1:10)

# After
exec(mean, 1:10, !!!list(na.rm = TRUE))
}
\item \code{invoke_map()} is is retired without replacement because it is
more complex to understand than the corresponding code using
\code{map()}, \code{map2()} and \code{exec()}:\preformatted{# Before:
invoke_map(fns, list(args))
invoke_map(fns, list(args1, args2))

# After:
map(fns, exec, !!!args)
map2(fns, list(args1, args2), function(fn, args) exec(fn, !!!args))
}
}
}

\examples{
# Invoke a function with a list of arguments
invoke(runif, list(n = 10))
# Invoke a function with named arguments
invoke(runif, n = 10)

# Combine the two:
invoke(paste, list("01a", "01b"), sep = "-")
# That's more natural as part of a pipeline:
list("01a", "01b") \%>\%
  invoke(paste, ., sep = "-")

# Invoke a list of functions, each with different arguments
invoke_map(list(runif, rnorm), list(list(n = 10), list(n = 5)))
# Or with the same inputs:
invoke_map(list(runif, rnorm), list(list(n = 5)))
invoke_map(list(runif, rnorm), n = 5)
# Or the same function with different inputs:
invoke_map("runif", list(list(n = 5), list(n = 10)))

# Or as a pipeline
list(m1 = mean, m2 = median) \%>\% invoke_map(x = rcauchy(100))
list(m1 = mean, m2 = median) \%>\% invoke_map_dbl(x = rcauchy(100))

# Note that you can also match by position by explicitly omitting `.x`.
# This can be useful when the argument names of the functions are not
# identical
list(m1 = mean, m2 = median) \%>\%
  invoke_map(, rcauchy(100))

# If you have pairs of function name and arguments, it's natural
# to store them in a data frame. Here we use a tibble because
# it has better support for list-columns
if (rlang::is_installed("tibble")) {
  df <- tibble::tibble(
    f = c("runif", "rpois", "rnorm"),
    params = list(
      list(n = 10),
      list(n = 5, lambda = 10),
      list(n = 10, mean = -3, sd = 10)
    )
  )
  df
  invoke_map(df$f, df$params)
}
}
\seealso{
Other map variants: 
\code{\link{imap}()},
\code{\link{lmap}()},
\code{\link{map2}()},
\code{\link{map_if}()},
\code{\link{map}()},
\code{\link{modify}()}
}
\concept{map variants}
\keyword{internal}
