% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/low-level.R
\name{ps_wait}
\alias{ps_wait}
\title{Wait for one or more processes to terminate, with a timeout}
\usage{
ps_wait(p, timeout = -1)
}
\arguments{
\item{p}{A process handle, or a list of process handles. The
process(es) to wait for.}

\item{timeout}{Timeout in milliseconds. If -1, \code{ps_wait()} will wait
indefinitely (or until it is interrupted). If 0, then it checks which
processes have already terminated, and returns immediately.}
}
\value{
Logical vector, with one value of each process in \code{p}.
For processes that terminated it contains a \code{TRUE} value. For
processes that are still running it contains a \code{FALSE} value.
}
\description{
This function supports interruption with SIGINT on Unix, or CTRL+C
or CTRL+BREAK on Windows.
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check() && ps::ps_os_type()["POSIX"]) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# this example calls `sleep`, so it only works on Unix
p1 <- processx::process$new("sleep", "100")
p2 <- processx::process$new("sleep", "100")

# returns c(FALSE, FALSE) immediately if p1 and p2 are running
ps_wait(list(p1$as_ps_handle(), p2$as_ps_handle()), 0)

# timeouts at one second
ps_wait(list(p1$as_ps_handle(), p2$as_ps_handle()), 1000)

p1$kill()
p2$kill()
# returns c(TRUE, TRUE) immediately
ps_wait(list(p1$as_ps_handle(), p2$as_ps_handle()), 1000)
\dontshow{\}) # examplesIf}
}
