% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg-reticulate.R
\name{as_nanoarrow_schema.python.builtin.object}
\alias{as_nanoarrow_schema.python.builtin.object}
\alias{as_nanoarrow_array.python.builtin.object}
\alias{as_nanoarrow_array_stream.python.builtin.object}
\alias{test_reticulate_with_nanoarrow}
\title{Python integration via reticulate}
\usage{
\method{as_nanoarrow_schema}{python.builtin.object}(x, ...)

\method{as_nanoarrow_array}{python.builtin.object}(x, ..., schema = NULL)

\method{as_nanoarrow_array_stream}{python.builtin.object}(x, ..., schema = NULL)

test_reticulate_with_nanoarrow()
}
\arguments{
\item{x}{An Python object to convert}

\item{...}{Unused}

\item{schema}{A requested schema, which may or may not be honoured depending
on the capabilities of the producer}
}
\value{
\itemize{
\item \code{as_nanoarrow_schema()} returns an object of class nanoarrow_schema
\item \code{as_nanoarrow_array()} returns an object of class nanoarrow_array
\item \code{as_nanoarrow_array_stream()} returns an object of class
nanoarrow_array_stream.
}
}
\description{
These functions enable Python wrapper objects created via reticulate to
be used with any function that uses \code{\link[=as_nanoarrow_array]{as_nanoarrow_array()}} or
\code{\link[=as_nanoarrow_array_stream]{as_nanoarrow_array_stream()}} to accept generic "arrowable" input.
Implementations for \code{\link[reticulate:r-py-conversion]{reticulate::py_to_r()}} and \code{\link[reticulate:r-py-conversion]{reticulate::r_to_py()}}
are also included such that nanoarrow's array/schema/array stream objects
can be passed as arguments to Python functions that would otherwise accept
an object implementing the Arrow PyCapsule protocol.
}
\details{
This implementation uses the
\href{https://arrow.apache.org/docs/format/CDataInterface/PyCapsuleInterface.html}{Arrow PyCapsule protocol}
to interpret an arbitrary Python object as an Arrow array/schema/array stream
and produces Python objects that implement this protocol. This is currently
implemented using the nanoarrow Python package which provides similar
primitives for facilitating interchange in Python.
}
\examples{
\dontshow{if (test_reticulate_with_nanoarrow()) withAutoprint(\{ # examplesIf}
library(reticulate)

py_require("nanoarrow")

na <- import("nanoarrow", convert = FALSE)
python_arrayish_thing <- na$Array(1:3, na_int32())
as_nanoarrow_array(python_arrayish_thing)

r_to_py(as_nanoarrow_array(1:3))
\dontshow{\}) # examplesIf}
}
