
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Message_ProgressRange.hxx>

// module includes
#include <RWStl.hxx>
#include <RWStl_ConfigurationNode.hxx>
#include <RWStl_Provider.hxx>
#include <RWStl_Reader.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
        #include <DE_ConfigurationContext.hxx>
        #include <NCollection_Buffer.hxx>
        #include <TDocStd_Document.hxx>
        #include <XSControl_WorkSession.hxx>
        #include <TopoDS_Shape.hxx>

// Module definiiton
void register_RWStl_enums(py::module &main_module) {


py::module m = main_module.def_submodule("RWStl", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes
    class Py_RWStl_Reader : public RWStl_Reader{
    public:
        using RWStl_Reader::RWStl_Reader;


        // public pure virtual
        Standard_Integer AddNode( const gp_XYZ & thePnt) override { using return_type = Standard_Integer;
    PYBIND11_OVERLOAD_PURE(return_type,RWStl_Reader,AddNode,thePnt) };
        void AddTriangle(Standard_Integer theN1,Standard_Integer theN2,Standard_Integer theN3) override { using return_type = void;
    PYBIND11_OVERLOAD_PURE(return_type,RWStl_Reader,AddTriangle,theN1,theN2,theN3) };


        // protected pure virtual


        // private pure virtual

    };

// pre-register typdefs+classes (topologically sorted)
    py::class_<RWStl , shared_ptr<RWStl>  >(m,"RWStl",R"#(This class provides methods to read and write triangulation from / to the STL files.)#");
    py::class_<RWStl_Reader ,opencascade::handle<RWStl_Reader> ,Py_RWStl_Reader , Standard_Transient >(m,"RWStl_Reader",R"#(An abstract class implementing procedure to read STL file.)#");

};

// user-defined post-inclusion per module

// user-defined post
