
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <BRepTopAdaptor_TopolTool.hxx>
#include <IntCurveSurface_HInter.hxx>
#include <Adaptor2d_Curve2d.hxx>

// module includes
#include <IntCurvesFace_Intersector.hxx>
#include <IntCurvesFace_ShapeIntersector.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_IntCurvesFace_enums(py::module &main_module) {


py::module m = main_module.def_submodule("IntCurvesFace", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<IntCurvesFace_ShapeIntersector , shared_ptr<IntCurvesFace_ShapeIntersector>  >(m,"IntCurvesFace_ShapeIntersector",R"#()#");
    py::class_<IntCurvesFace_Intersector ,opencascade::handle<IntCurvesFace_Intersector>  , Standard_Transient >(m,"IntCurvesFace_Intersector",R"#()#");

};

// user-defined post-inclusion per module

// user-defined post
