# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.servicelinker.aio import ServiceLinkerManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestServiceLinkerManagementLinkerOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ServiceLinkerManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.linker.list(
            resource_uri="str",
            api_version="2024-07-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.linker.get(
            resource_uri="str",
            linker_name="str",
            api_version="2024-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.linker.begin_create_or_update(
                resource_uri="str",
                linker_name="str",
                parameters={
                    "authInfo": "auth_info_base",
                    "clientType": "str",
                    "configurationInfo": {
                        "action": "str",
                        "additionalConfigurations": {"str": "str"},
                        "additionalConnectionStringProperties": {"str": "str"},
                        "configurationStore": {"appConfigurationId": "str"},
                        "customizedKeys": {"str": "str"},
                        "daprProperties": {
                            "bindingComponentDirection": "str",
                            "componentType": "str",
                            "metadata": [
                                {
                                    "description": "str",
                                    "name": "str",
                                    "required": "str",
                                    "secretRef": "str",
                                    "value": "str",
                                }
                            ],
                            "runtimeVersion": "str",
                            "scopes": ["str"],
                            "secretStoreComponent": "str",
                            "version": "str",
                        },
                        "deleteOrUpdateBehavior": "str",
                    },
                    "id": "str",
                    "name": "str",
                    "provisioningState": "str",
                    "publicNetworkSolution": {
                        "action": "str",
                        "deleteOrUpdateBehavior": "str",
                        "firewallRules": {"azureServices": "str", "callerClientIP": "str", "ipRanges": ["str"]},
                    },
                    "scope": "str",
                    "secretStore": {"keyVaultId": "str", "keyVaultSecretName": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "targetService": "target_service_base",
                    "type": "str",
                    "vNetSolution": {"deleteOrUpdateBehavior": "str", "type": "str"},
                },
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.linker.begin_delete(
                resource_uri="str",
                linker_name="str",
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.linker.begin_update(
                resource_uri="str",
                linker_name="str",
                parameters={
                    "authInfo": "auth_info_base",
                    "clientType": "str",
                    "configurationInfo": {
                        "action": "str",
                        "additionalConfigurations": {"str": "str"},
                        "additionalConnectionStringProperties": {"str": "str"},
                        "configurationStore": {"appConfigurationId": "str"},
                        "customizedKeys": {"str": "str"},
                        "daprProperties": {
                            "bindingComponentDirection": "str",
                            "componentType": "str",
                            "metadata": [
                                {
                                    "description": "str",
                                    "name": "str",
                                    "required": "str",
                                    "secretRef": "str",
                                    "value": "str",
                                }
                            ],
                            "runtimeVersion": "str",
                            "scopes": ["str"],
                            "secretStoreComponent": "str",
                            "version": "str",
                        },
                        "deleteOrUpdateBehavior": "str",
                    },
                    "provisioningState": "str",
                    "publicNetworkSolution": {
                        "action": "str",
                        "deleteOrUpdateBehavior": "str",
                        "firewallRules": {"azureServices": "str", "callerClientIP": "str", "ipRanges": ["str"]},
                    },
                    "scope": "str",
                    "secretStore": {"keyVaultId": "str", "keyVaultSecretName": "str"},
                    "targetService": "target_service_base",
                    "vNetSolution": {"deleteOrUpdateBehavior": "str", "type": "str"},
                },
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_validate(self, resource_group):
        response = await (
            await self.client.linker.begin_validate(
                resource_uri="str",
                linker_name="str",
                api_version="2024-07-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_configurations(self, resource_group):
        response = await self.client.linker.list_configurations(
            resource_uri="str",
            linker_name="str",
            api_version="2024-07-01-preview",
        )

        # please add some check logic here by yourself
        # ...
