"""Enumerables for the values Homee uses."""
from enum import IntEnum, unique


@unique
class NodeProfile(IntEnum):
    NONE = 0
    HOMEE = 1
    ON_OFF_PLUG = 10
    DIMMABLE_METERING_SWITCH = 11
    METERING_SWITCH = 12
    METERING_PLUG = 13
    DIMMABLE_PLUG = 14
    DIMMABLE_SWITCH = 15
    ON_OFF_SWITCH = 16
    DOUBLE_ON_OFF_SWITCH = 18
    DIMMABLE_METERING_PLUG = 19
    ONE_BUTTON_REMOTE = 20
    BINARY_INPUT = 21
    DIMMABLE_COLOR_METERING_PLUG = 22
    DOUBLE_BINARY_INPUT = 23
    TWO_BUTTON_REMOTE = 24
    THREE_BUTTON_REMOTE = 25
    FOUR_BUTTON_REMOTE = 26
    ALARM_SENSOR = 27
    DOUBLE_ON_OFF_PLUG = 28
    ON_OFF_SWITCH_WITH_BINARY_INPUT = 29
    WATCH_DOG_WITH_PRESSURE_AND_TEMPERATURES = 30
    FIBARO_BUTTON = 31
    ENERGY_METER = 32
    DOUBLE_METERING_SWITCH = 33
    FIBARO_SWIPE = 34
    ENERGY_MANAGER = 38
    LEVEL_METER = 39
    RANGE_EXTENDER = 40
    REMOTE = 41
    IMPULSE_PLUG = 42
    IMPULSE_RELAY = 43
    WALL_MOTE = 44
    WIFI_ONE_BUTTON_REMOTE = 45
    WIFI_METERING_SWITCH = 46
    WIFI_ON_OFF_METERING_SWITCH = 47
    WIFI_ON_OFF_METERING_PLUG = 48
    WIFI_ON_OFF_DIMMABLE_METERING_SWITCH = 49
    WIFI_ON_OFF_SWITCH = 50
    WIFI_ENERGY_METER = 51
    BRIGHTNESS_SENSOR = 1e3
    DIMMABLE_COLOR_LIGHT = 1001
    DIMMABLE_EXTENDED_COLOR_LIGHT = 1002
    DIMMABLE_COLOR_TEMPERATURE_LIGHT = 1003
    DIMMABLE_LIGHT = 1004
    DIMMABLE_LIGHT_WITH_BRIGHTNESS_SENSOR = 1005
    DIMMABLE_LIGHT_WITH_BRIGHTNESS_AND_PRESENCE_SENSOR = 1006
    DIMMABLE_LIGHT_WITH_PRESENCE_SENSOR = 1007
    DIMMABLE_RGBWLIGHT = 1008
    WIFI_DIMMABLE_RGBWLIGHT = 1009
    WIFI_DIMMABLE_LIGHT = 1010
    OPEN_CLOSE_SENSOR = 2e3
    WINDOW_HANDLE = 2001
    SHUTTER_POSITION_SWITCH = 2002
    OPEN_CLOSE_AND_TEMPERATURE_SENSOR = 2003
    ELECTRIC_MOTOR_METERING_SWITCH = 2004
    OPEN_CLOSE_WITH_TEMPERATURE_AND_BRIGHTNESS_SENSOR = 2005
    ELECTRIC_MOTOR_METERING_SWITCH_WITHOUT_SLAT_POSITION = 2006
    LOCK = 2007
    WINDOW_HANDLE_WITH_BUTTONS = 2008
    WINDOW_HANDLE_WITH_BUTTONS_AND_TEMPERATURE_AND_HUMIDITY_SENSOR = 2009
    ENTRANCE_GATE_OPERATOR = 2010
    PERIMETER_PROTECTION_SYSTEM = 2011
    GARAGE_DOOR_OPERATOR = 2012
    GATE_OPERATOR = 2013
    INNER_DOOR_OPERATOR = 2014
    GARAGE_DOOR_IMPULSE_OPERATOR = 2015
    ENTRANCE_DOOR = 2016
    WINDOW_MOTOR_SWITCH = 2017
    WIFI_OPEN_CLOSE_SENSOR = 2018
    WIFI_ELECTRIC_MOTOR_METERING_SWITCH = 2019
    TEMPERATURE_AND_HUMIDITY_SENSOR = 3001
    CO2SENSOR = 3002
    ROOM_THERMOSTAT = 3003
    ROOM_THERMOSTAT_WITH_HUMIDITY_SENSOR = 3004
    BINARY_INPUT_WITH_TEMPERATURE_SENSOR = 3005
    RADIATOR_THERMOSTAT = 3006
    TEMPERATURE_SENSOR = 3009
    HUMIDITY_SENSOR = 3010
    WATER_VALVE = 3011
    WATER_METER = 3012
    WEATHER_STATION = 3013
    NETATMO_MAIN_MODULE = 3014
    NETATMO_OUTDOOR_MODULE = 3015
    NETATMO_INDOOR_MODULE = 3016
    NETATMO_RAIN_MODULE = 3017
    COSI_THERM_CHANNEL = 3018
    VENTILATION_CONTROL = 3019
    THERMOSTAT_WITH_HEATING_AND_COOLING = 3022
    NETATMO_WIND_MODULE = 3023
    ELECTRICAL_HEATING = 3024
    VALVE_DRIVE = 3025
    CAMERA = 3026
    CAMERA_WITH_FLOODLIGHT = 3027
    HEATING_SYSTEM = 3028
    WARM_WATER_CIRCUIT = 3029
    HEATING_CIRCUIT = 3030
    AIR_QUALITY_SENSOR = 3031
    WIFI_ROOM_THERMOSTAT = 3032
    WIFI_RADIATOR_THERMOSTAT = 3033
    MOTION_DETECTOR_WITH_TEMPERATURE_BRIGHTNESS_AND_HUMIDITY_SENSOR = 4010
    MOTION_DETECTOR = 4011
    SMOKE_DETECTOR = 4012
    FLOOD_DETECTOR = 4013
    PRESENCE_DETECTOR = 4014
    MOTION_DETECTOR_WITH_TEMPERATURE_AND_BRIGHTNESS_SENSOR = 4015
    SMOKE_DETECTOR_WITH_TEMPERATURE_SENSOR = 4016
    FLOOD_DETECTOR_WITH_TEMPERATURE_SENSOR = 4017
    WATCH_DOG_DEVICE = 4018
    LAG = 4019
    OWU = 4020
    EUROVAC = 4021
    OWWG3 = 4022
    EUROPRESS = 4023
    MINIMUM_DETECTOR = 4024
    MAXIMUM_DETECTOR = 4025
    SMOKE_DETECTOR_AND_CODETECTOR = 4026
    SIREN = 4027
    MOTION_DETECTOR_WITH_OPEN_CLOSE_TEMPERATURE_AND_BRIGHTNESS_SENSOR = 4028
    MOTION_DETECTOR_WITH_BRIGHTNESS = 4029
    DOORBELL = 4030
    SMOKE_DETECTOR_AND_SIREN = 4031
    FLOOD_DETECTOR_WITH_TEMPERATURE_AND_HUMIDITY_SENSOR = 4032
    MINIMUM_DETECTOR_WITH_TEMPERATURE_SENSOR = 4033
    MAXIMUM_DETECTOR_WITH_TEMPERATURE_SENSOR = 4034
    PRESENCE_DETECTOR_WITH_TEMPERATURE_AND_BRIGHTNESS_SENSOR = 4035
    CODETECTOR = 4036
    TRACKER = 4037
    WIFI_FLOOD_DETECTOR = 4038
    WIFI_MOTION_DETECTOR = 4039
    WIFI_GAS_DETECTOR = 4040
    INOVA_ALARM_SYSTEM = 5e3
    INOVA_DETECTOR = 5001
    INOVA_SIREN = 5002
    INOVA_COMMAND = 5003
    INOVA_TRANSMITTER = 5004
    INOVA_RECIEVER = 5005
    INOVA_KOALA = 5006
    INOVA_INTERNAL_TRANSMITTER = 5007
    INOVA_CONTROL_PANEL = 5008
    INOVA_INPUT_OUTPUT_EXTENSION = 5009
    INOVA_MOTION_DETECTOR_WITH_VOD = 5010
    INOVA_MOTION_DETECTOR = 5011
    WASHING_MACHINE = 6e3
    TUMBLE_DRYER = 6001
    DISHWASHER = 6002


@unique
class NodeProtocol(IntEnum):
    NONE = 0
    ZWAVE = 1
    ZIG_BEE = 2
    EN_OCEAN = 3
    WM_BUS = 4
    HOMEMATIC = 5
    KNXRF = 6
    INOVA = 7
    HTTP_AVM = 8
    HTTP_NETATMO = 9
    HTTP_KOUBACHI = 10
    HTTP_NEST = 11
    IO_CUBE = 12
    HTTP_CCU_2 = 13
    HTTP_UPN_P = 14
    HTTP_NUKI = 15
    HTTP_SEMS = 16
    ZWAVE_V3 = 17
    LO_RA = 18
    BI_SECUR = 19
    HTTP_WOLF = 20
    EXTERNAL_HOMEE = 21
    WMS = 23
    HTTP_MY_STROM = 24
    HTTP_STECA = 25
    MQTT_SHELLY = 27
    VIRTUAL_DEVICE = 28
    ALL = 100


@unique
class NodeState(IntEnum):
    NONE = 0
    AVAILABLE = 1
    UNAVAILABLE = 2
    UPDATE_IN_PROGRESS = 3
    WAITING_FOR_ATTRIBUTES = 4
    INITIALIZING = 5
    USER_INTERACTION_REQUIRED = 6
    PASSWORD_REQUIRED = 7
    HOST_UNAVAILABLE = 8
    DELETE_IN_PROGRESS = 9
    COSI_CONNECTED = 10
    BLOCKED = 11
    WAITING_FOR_WAKEUP = 12
    REMOTE_NODE_DELETED = 13
    FIRMWARE_UPDATE_IN_PROGRESS = 14


@unique
class AttributeType(IntEnum):
    NONE = 0
    ON_OFF = 1
    DIMMING_LEVEL = 2
    CURRENT_ENERGY_USE = 3
    ACCUMULATED_ENERGY_USE = 4
    TEMPERATURE = 5
    TARGET_TEMPERATURE = 6
    RELATIVE_HUMIDITY = 7
    BATTERY_LEVEL = 8
    STATUS_LED = 9
    WINDOW_POSITION = 10
    BRIGHTNESS = 11
    FLOOD_ALARM = 12
    SIREN = 13
    OPEN_CLOSE = 14
    POSITION = 15
    SMOKE_ALARM = 16
    BLACKOUT_ALARM = 17
    CURRENT_VALVE_POSITION = 18
    BINARY_INPUT = 19
    CO2LEVEL = 20
    PRESSURE = 21
    LEVEL = 22
    COLOR = 23
    SATURATION = 24
    MOTION_ALARM = 25
    MOTION_SENSITIVITY = 26
    MOTION_INSENSITIVITY = 27
    MOTION_ALARM_CANCELATION_DELAY = 28
    WAKE_UP_INTERVAL = 29
    TAMPER_ALARM = 30
    WARM_WATER_TEMPERATURE = 31
    WARM_WATER_TARGET_TEMPERATURE = 32
    LINK_QUALITY = 33
    INOVA_ALARM_SYSTEM_STATE = 34
    INOVA_ALARM_GROUP_STATE = 35
    INOVA_ALARM_INTRUSION_STATE = 36
    INOVA_ALARM_ERROR_STATE = 37
    INOVA_ALARM_DOOR_STATE = 38
    INOVA_ALARM_EXTERNAL_SENSOR = 39
    BUTTON_STATE = 40
    HUE = 41
    COLOR_TEMPERATURE = 42
    HARDWARE_REVISION = 43
    FIRMWARE_REVISION = 44
    SOFTWARE_REVISION = 45
    LEDSTATE = 46
    LEDSTATE_WHEN_ON = 47
    LEDSTATE_WHEN_OFF = 48
    TARGET_TEMPERATURE_OFFSET = 49
    SAVING_FACTOR = 50
    TOTAL_VOLTAGE = 51
    HIGH_TEMPERATURE_ALARM = 52
    HIGH_TEMPERATURE_ALARM_TRESHOLD = 53
    LOW_TEMPERATURE_ALARM = 54
    LOW_TEMPERATURE_ALARM_TRESHOLD = 55
    TAMPER_SENSITIVITY = 56
    TAMPER_ALARM_CANCELATION_DELAY = 57
    BRIGHTNESS_REPORT_INTERVAL = 58
    TEMPERATURE_REPORT_INTERVAL = 59
    MOTION_ALARM_INDICATION_MODE = 60
    LEDBRIGHTNESS = 61
    TAMPER_ALARM_INDICATION_MODE = 62
    SWITCH_TYPE = 63
    TEMPERATURE_OFFSET = 64
    ACCUMULATED_WATER_USE = 65
    ACCUMULATED_WATER_USE_LAST_MONTH = 66
    CURRENT_DATE = 67
    LEAK_ALARM = 68
    BATTERY_LOW_ALARM = 69
    MALFUNCTION_ALARM = 70
    LINK_QUALITY_ALARM = 71
    MODE = 72
    HEATING_PROGRAM = 73
    WARM_WATER_PROGRAM = 74
    CALIBRATION = 75
    PRESENCE_ALARM = 76
    MINIMUM_ALARM = 77
    MAXIMUM_ALARM = 78
    OIL_ALARM = 79
    WATER_ALARM = 80
    INOVA_ALARM_INHIBITION = 81
    INOVA_ALARM_EJECTION = 82
    INOVA_ALARM_COMMERCIAL_REF = 83
    SERIAL_NUMBER = 84
    RADIATOR_THERMOSTAT_SUMMER_MODE = 85
    INOVA_ALARM_OPERATION_MODE = 86
    AUTOMATIC_MODE = 87
    POLLING_INTERVAL = 88
    FEED_TEMPERATURE = 89
    DISPLAY_ORIENTATION = 90
    MANUAL_OPERATION = 91
    DEVICE_TEMPERATURE = 92
    SONOMETER = 93
    AIR_PRESSURE = 94
    OUTDOOR_RELATIVE_HUMIDITY = 95
    INDOOR_RELATIVE_HUMIDITY = 96
    OUTDOOR_TEMPERATURE = 97
    INDOOR_TEMPERATURE = 98
    VENTILATION_LEVEL = 99
    VENTILATION_MODE = 100
    RAIN_FALL = 101
    INTAKE_MOTOR_REVS = 102
    EXHAUST_MOTOR_REVS = 103
    OPERATING_HOURS = 104
    INOVA_ALARM_SILENT_ALERT = 105
    INOVA_ALARM_PRE_ALARM = 106
    INOVA_ALARM_DETERRENCE_ALARM = 107
    INOVA_ALARM_WARNING = 108
    INOVA_ALARM_FIRE_ALARM = 109
    UP_TIME = 110
    DOWN_TIME = 111
    SHUTTER_BLIND_MODE = 112
    SHUTTER_SLAT_POSITION = 113
    SHUTTER_SLAT_TIME = 114
    RESTART_DEVICE = 115
    SOIL_MOISTURE = 116
    WATER_PLANT_ALARM = 117
    MIST_PLANT_ALARM = 118
    FERTILIZE_PLANT_ALARM = 119
    COOL_PLANT_ALARM = 120
    HEAT_PLANT_ALARM = 121
    PUT_PLANT_INTO_LIGHT_ALARM = 122
    PUT_PLANT_INTO_SHADE_ALARM = 123
    COLOR_MODE = 124
    TARGET_TEMPERATURE_LOW = 125
    TARGET_TEMPERATURE_HIGH = 126
    HVACMODE = 127
    AWAY = 128
    HVACSTATE = 129
    HAS_LEAF = 130
    SET_ENERGY_CONSUMPTION = 131
    COALARM = 132
    RESTORE_LAST_KNOWN_STATE = 133
    LAST_IMAGE_RECEIVED = 134
    UP_DOWN = 135
    REQUEST_VOD = 136
    INOVA_DETECTOR_HISTORY = 137
    SURGE_ALARM = 138
    LOAD_ALARM = 139
    OVERLOAD_ALARM = 140
    VOLTAGE_DROP_ALARM = 141
    SHUTTER_ORIENTATION = 142
    OVER_CURRENT_ALARM = 143
    SIREN_MODE = 144
    ALARM_AUTO_STOP_TIME = 145
    WIND_SPEED = 146
    WIND_DIRECTION = 147
    COMFORT_TEMPERATURE = 148
    ECO_TEMPERATURE = 149
    REDUCE_TEMPERATURE = 150
    PROTECT_TEMPERATURE = 151
    INOVA_SYSTEM_TIME = 152
    INOVA_CORRESPONDENT_PROTOCOL = 153
    INOVA_CORRESPONDENT_ID = 154
    INOVA_CORRESPONDENT_LISTEN = 155
    INOVA_CORRESPONDENT_NUMBER = 156
    INOVA_CALL_CYCLE_FIRE_PROTECTION = 157
    INOVA_CALL_CYCLE_INTRUSION = 158
    INOVA_CALL_CYCLE_TECHNICAL_PROTECT = 159
    INOVA_CALL_CYCLE_FAULTS = 160
    INOVA_CALL_CYCLE_DETERRENCE = 161
    INOVA_CALL_CYCLE_PREALARM = 162
    INOVA_PSTNRINGS = 163
    INOVA_DOUBLE_CALL_RINGS = 164
    INOVA_PIN = 165
    INOVA_PUK = 166
    INOVA_MAIN_MEDIA_SELECTION = 167
    RAIN_FALL_LAST_HOUR = 168
    RAIN_FALL_TODAY = 169
    IDENTIFICATION_MODE = 170
    BUTTON_DOUBLE_CLICK = 171
    SIREN_TRIGGER_MODE = 172
    UV = 173
    SLAT_STEPS = 174
    ECO_MODE_CONFIG = 175
    BUTTON_LONG_RELEASE = 176
    VISUAL_GONG = 177
    ACOUSTIC_GONG = 178
    SURVEILLANCE_ON_OFF = 179
    STORAGE_ALARM = 181
    POWER_SUPPLY_ALARM = 182
    NETATMO_HOME = 183
    NETATMO_PERSON = 184
    NETATMO_LAST_EVENT_PERSON_ID = 185
    NETATMO_LAST_EVENT_TIME = 186
    NETATMO_LAST_EVENT_TYPE = 187
    NETATMO_LAST_EVENT_IS_KNOWN_PERSON = 188
    NETATMO_LAST_EVENT_IS_ARRIVAL = 189
    PRESENCE_TIMEOUT = 190
    KNOWN_PERSON_PRESENCE = 191
    UNKNOWN_PERSON_PRESENCE = 192
    CURRENT = 193
    FREQUENCY = 194
    VOLTAGE = 195
    PRESENCE_ALARM_CANCELATION_DELAY = 196
    PRESENCE_ALARM_DETECTION_DELAY = 197
    PRESENCE_ALARM_THRESHOLD = 198
    NETATMO_THERMOSTAT_MODE = 199
    NETATMO_RELAY_BOILER_CONNECTED = 200
    NETATMO_RELAY_MAC = 201
    NETATMO_THERMOSTAT_MODE_TIMEOUT = 202
    NETATMO_THERMOSTAT_NEXT_CHANGE = 203
    NETATMO_THERMOSTAT_PROGRAMS = 204
    HOMEE_MODE = 205
    COLOR_WHITE = 206
    MOVEMENT_ALARM = 207
    MOVEMENT_SENSITIVITY = 208
    VIBRATION_ALARM = 209
    VIBRATION_SENSITIVITY = 210
    AVERAGE_ENERGY_USE = 211
    BINARY_INPUT_MODE = 212
    DEVICE_STATUS = 213
    DEVICE_REMAINING_TIME = 214
    DEVICE_START_TIME = 215
    DEVICE_PROGRAM = 216
    MULTILEVEL_INPUT = 222
    BUTTON_PRESSED3TIMES = 223
    BUTTON_PRESSED4TIMES = 224
    BUTTON_PRESSED5TIMES = 225
    REPEATER_MODE = 226
    AUTO_OFF_TIME = 227
    CO2ALARM = 228
    INPUT_ENDPOINT_CONFIGURATION = 229
    GUST_SPEED = 230
    GUST_DIRECTION = 231
    LOCK_STATE = 232
    AEOTEC_SMART_PLUG_LEDSTATE = 233
    ALARM_DURATION = 234
    DEW_POINT = 235
    GESTURE = 236
    GESTURE_SEQUENCE_LEARNING_MODE = 237
    GESTURE_SEQUENCE = 238
    TOTAL_CURRENT_ENERGY_USE = 239
    TOTAL_ACCUMULATED_ENERGY_USE = 240
    SUNSET_TIME = 241
    SUNRISE_TIME = 242
    CURRENT_LOCAL_WEATHER_CONDITION = 243
    CURRENT_LOCAL_TEMPERATURE = 244
    CURRENT_LOCAL_HUMIDITY = 245
    FORECAST_LOCAL_WEATHER_CONDITION = 246
    FORECAST_LOCAL_TEMP_MIN = 247
    FORECAST_LOCAL_TEMP_MAX = 248
    ARMED = 249
    FLOODLIGHT = 250
    HUMAN_DETECTED = 251
    VEHICLE_DETECTED = 252
    ANIMAL_DETECTED = 253
    VACATION_MODE = 254
    BLINK_INTERVAL = 255
    OTHER_MOTION_DETECTED = 256
    IRCODE_NUMBER = 257
    HEATING_MODE = 258
    DISPLAY_AUTO_OFF_TIME = 259
    BACKLIGHT = 260
    OPEN_WINDOW_DETECTION_SENSIBILITY = 261
    CURRENT_LOCAL_WIND_SPEED = 262
    CURRENT_LOCAL_GUST_SPEED = 263
    POWER_OUTPUT_GRID = 264
    POWER_INPUT_GRID = 265
    POWER_PV = 266
    POWER_LOAD = 267
    POWER_OUTPUT_BATTERY = 268
    POWER_INPUT_BATTERY = 269
    RELATIVE_AUTONOMY = 270
    RELATIVE_SELF_CONSUMPTION = 271
    TOTAL_CURRENT = 272
    ENERGY_STORAGE_LEVEL = 273
    TOTAL_ENERGY_LOAD = 274
    TOTAL_ENERGY_PRODUCTION = 275
    TOTAL_ENERGY_OUTPUT_GRID = 276
    TOTAL_ENERGY_INPUT_GRID = 277
    TOTAL_ENERGY_STORED = 278
    TOTAL_ENERGY_RESTORED = 279
    REPLACE_FILTER_ALARM = 289
    UP_DOWN_REMOTE = 300
    DAWN = 301
    RAINFALL_INTENSITY = 302
    IMPULSE = 304
    LIGHT_IMPULSE = 305
    OPEN_PARTIAL_IMPULSE = 306
    EXTERNAL_BINARY_INPUT = 309
    BUTTON_PRESSED_LONG = 310
    MEMORY_USAGE = 311
    PROCESSOR_UTILIZATION = 312
    USED_STORAGE = 313
    DUTY_CYCLE = 314
    EXTERNAL_TEMPERATURE = 315
    FLOOR_TEMPERATURE = 316
    SLAT_MIN_ANGLE = 322
    SLAT_MAX_ANGLE = 323
    MOTOR_ROTATION = 324
    ENDPOSITION_CONFIGURATION = 325
    AUTOMATIC_MODE_IMPULSE = 326
    BRIEFLY_OPEN_IMPULSE = 327
    PERMANENTLY_OPEN_IMPULSE = 328
    WIND_THRESHOLD = 329
    MOTOR_BLOCKED_ALARM = 330
    FREEZE_PROTECTION = 331
    FLYSCREEN = 332
    SUN_PROTECTION = 333
    MEMO = 334
    SLAT_ROTATION_IMPULSE = 337
    WIND_MONITORING_STATE = 338
    HVAC_OPERATING_STATE = 339
    EXTERNAL_TEMPERATURE_OFFSET = 340
    FLOOR_TEMPERATURE_OFFSET = 341
    DISPLAY_BRIGHTNESS_ACTIVE = 342
    DISPLAY_BRIGHTNESS_DIMMED = 343
    BUTTON_BRIGHTNESS_ACTIVE = 344
    BUTTON_BRIGHTNESS_DIMMED = 345
    DISPLAY_TEMPERATURE_SELECTION = 346
    RESET_METER = 347
    AUTOMATIC_RUNTIME_CALCULATION = 348
    DOWN_POSITION = 349
    DOWN_SLAT_POSITION = 350
    FIRMWARE_UPDATEABLE = 351
    VOC_LEVEL = 352
    VOC_VALUE = 353
    COVALUE = 354
    TARGET_TEMPERATURE_TYPE = 355
    SETBACK_MODE = 356
    SYSTEM_ALARM = 357
    HEALTH_ALARM = 358
    ACCESSCONTROL_ALARM = 359
    SECURITY_ALARM = 360
    EMERGENCY_ALARM = 361
    CLOCK_ALARM = 362
    APPLIANCE_ALARM = 363
    WATERVALVE_ALARM = 364
    WEATHER_ALARM = 365
    IRRIGATION_ALARM = 366
    GAS_ALARM = 367
    PEST_ALARM = 368
    LIGHT_ALARM = 369
    WATERQUALITY_ALARM = 370
    ANTI_THEFT_RESTRICTED = 371
    UNKNOWN_METERING_VALUE = 372
    COLOR_EXPERT = 373
    SWITCH_MULTILEVEL_EXPERT = 375
    UNKNOWN_SENSOR_VALUE = 376
    DOOR_LOCK_EXPERT = 377
    VENTILATE_IMPULSE = 378
    VIBRATION_ON_OFF = 379
    SOUND_ON_OFF = 380
    VIRTUAL_VOLANT_POSTION = 381
    FABRIC_UNTENSIONING = 382
    AUTOMATIC_REVERSING = 383
    LOCKED = 384
    WATCHDOG_ON_OFF = 385
    IP_ADDRESS = 386
    GAS_ALARM_STATE = 387
    GAS_CONCENTRATION = 388
    HOST_NAME = 389
    BRIGHTNESS_LEVEL = 390
    FORECAST_LOCAL_HUMIDITY = 391
    FORECAST_LOCAL_WINDSPEED = 392
    FORECAST_LOCAL_GUSTSPEED = 393


@unique
class AttributeState(IntEnum):
    NONE = 0
    NORMAL = 1
    WAITING_FOR_WAKE_UP = 2
    WAITING_FOR_VALUE = 3
    WAITING_FOR_ACKNOWLEDGE = 4
    INACTIVE = 5
    IGNORED = 6
    UNAVAILABLE = 7
    STATE_UNLISTED = 9


@unique
class AttributeChangedBy(IntEnum):
    NONE = 0
    ITSELF = 1
    USER = 2
    HOMEEGRAM = 3
    UNKNOWN = 4
    AI = 6


@unique
class AttributeBasedOn(IntEnum):
    NONE = 0
    EVENTS = 1
    INTERVAL = 2
    POLLING = 4
    MANUAL = 8


@unique
class HomeegramState(IntEnum):
    NONE = 0
    NORMAL = 1
    EXECUTING = 2
    NO_TRIGGERS = 3
    NO_ACTIONS = 4


@unique
class WarningCode(IntEnum):
    NONE = 0
    CUBE_ADDED = 100
    CUBE_REMOVED = 101
    CUBE_IS_MISSING = 102
    CUBE_IN_LEARN_MODE = 103
    CUBE_LEARN_MODE_STARTED = 104
    CUBE_LEARN_MODE_SUCCESSFUL = 105
    CUBE_LEARN_MODE_TIMEOUT = 106
    CUBE_LEARN_MODE_NODE_ALREADY_ADDED = 107
    CUBE_LEARN_MODE_FAILED = 108
    CUBE_IN_REMOVE_MODE = 109
    CUBE_REMOVE_MODE_STARTED = 110
    CUBE_REMOVE_MODE_SUCCESSFUL = 111
    CUBE_REMOVE_MODE_TIMEOUT = 112
    CUBE_REMOVE_MODE_NODE_ALREADY_DELETED = 113
    CUBE_REMOVE_MODE_FAILED = 114
    CUBE_SCANNED_NODES = 115
    CUBE_UPDATE_IN_PROGESS = 116
    CUBE_UPDATE_STARTED = 117
    CUBE_UPDATE_FINISHED = 118
    CUBE_UPDATE_FAILED = 119
    CUBE_REMOVE_MODE_REQUIRES_ACTION = 120
    CUBE_REMOVE_MODE_CANCELED = 121
    CUBE_LEARN_MODE_CANCELED = 122
    CUBE_AUTHORIZATION_REQUIRED = 123
    CUBE_LEARN_MODE_INITIALIZING = 124
    CUBE_REMOVE_MODE_FORBIDDEN = 125
    CUBE_RESET_STARTED = 126
    CUBE_RESET_SUCCESSFUL = 127
    CUBE_RESET_FAILED = 128
    CUBE_RESET_TIMEOUT = 129
    CUBE_RESET_NOT_SUPPORTED = 130
    CUBE_HEAL_PROGRESS = 131
    CUBE_SERVER_STARTED = 144
    NO_NODES_TO_ADD = 145
    CUBE_SMART_START_INITIALIZING = 146
    NODE_BAD_LINK_QUALITY = 200
    NODE_IS_MISSING = 201
    NODE_WATER_DETECTED = 202
    NODE_SMOKE_DETECTED = 203
    NODE_BATTERY_LOW = 204
    NODE_LOCKED = 205
    NODE_NOT_COMPATIBLE = 206
    NODE_RESET_SUCCESSFUL = 207
    NODE_RESET_STARTED = 208
    NODE_RESET_FAILED = 209
    NODE_RESET_TIMEOUT = 210
    NODE_WRONG_HVACMODE = 211
    NODE_RANGE_ERROR = 212
    NODE_BLOCKED = 213
    NODE_WRONG_AWAY_MODE = 214
    NODE_RESET_CANCELED = 215
    NODE_REMOVE_MISSING_STARTED = 216
    NODE_REMOVE_MISSING_DONE = 217
    NODE_CALIBRATION_NEEDED = 218
    NODE_VALUE_OUT_OF_RANGE = 219
    SETTING_REMOTE_ACCESS_ACTIVATED = 300
    SETTING_REMOTE_ACCESS_DEACTIVATED = 301
    SETTING_ONLINE = 302
    SETTING_OFFLINE = 303
    SETTING_NETWORK_UNINITIALIZED = 304
    SETTING_NETWORK_INITIALIZING = 305
    SETTING_NETWORK_INITIALIZED = 306
    SETTING_GENERATING_CERTIFICATE = 307
    UPDATE_AVAILABLE = 400
    UPDATE_DOWNLOADING = 401
    UPDATE_INSTALLING = 402
    UPDATE_IN_PROGRESS = 403
    UPDATE_SUCCESSFUL = 404
    UPDATE_CONNECTION_FAILED = 405
    UPDATE_DOWNLOAD_FAILED = 406
    UPDATE_INSTALLATION_FAILED = 407
    UPDATE_PREPARING = 408
    NO_UPDATE_AVAILABLE = 409
    USBUPDATE_AVAILABLE = 410
    NO_USBUPDATE_AVAILABLE = 411
    USBUPDATE_CANCELED = 412
    UPDATE_CHECK_FAILED = 413
    BACKUP_AVAILABLE = 450
    BACKUP_CREATION_FAILED = 451
    RESTORE_AVAILABLE = 452
    NO_RESTORE_AVAILABLE = 453
    RESTORE_FAILED = 454
    RESTORE_RESTARTING = 455
    RESTORE_CANCELED = 456
    PERMISSION_DENIED = 500
    TEACH_IN_FORBIDDEN = 501
    PERMISSION_GRANTED = 502
    VIDEOCODE_WRONG = 503
    PASSCODE_WRONG = 504
    CHANGE_VIDEOCODE_SUCCESSFUL = 505
    CHANGE_PASSCODE_SUCCESSFUL = 506
    CHANGE_VIDEOCODE_FAILED = 507
    CHANGE_PASSCODE_FAILED = 508
    DEVICE_REMOVED = 600
    DEVICE_ADDED = 601
    USER_REMOVED = 700
    ALL_USERS_REMOVED = 701
    USER_PASSWORD_CHANGE_REQUIRED = 702
    USER_PASSWORD_CHANGE_FAILED = 703
    USER_PASSWORD_CHANGE_SUCCESSFUL = 704
    USER_ALREADY_EXISTS = 705
    GOOGLE_ASSISTANT_SYNC_SUCCESS = 800
    GOOGLE_ASSISTANT_SYNC_ERROR = 801
    APPLE_HOME_KIT_PAIRING_SUCCESS = 802
    APPLE_HOME_KIT_PAIRING_ERROR = 803
    APPLE_HOME_KIT_SYNC_SUCCESS = 804
    APPLE_HOME_KIT_SYNC_ERROR = 805
    FTPTEST_SUCCESS = 806
    FTPTEST_ERROR = 807
    MANUAL_BACKUP_EXPORT_SUCCESS = 808
    MANUAL_BACKUP_EXPORT_ERROR = 809
    QUAR_ZENABLE_ERROR = 810
    QUAR_ZENABLE_SUCCESS = 811
    HOMEEGRAM_COULD_NOT_DOWNLOAD_TTS = 900
    HOMEEGRAM_TEST_RESULTS = 901
    EMAIL_VERIFICATION_SUCCESS = 1100
    EMAIL_VERIFICATION_CODE_EXPIRED = 1101
    EMAIL_VERIFICATION_WRONG_CODE = 1102
    EMAIL_VERIFICATION_NEEDED = 1103
    EMAIL_VERIFICATION_ALREADY_VERIFIED = 1104
    EMAIL_VERIFICATION_MAIL_SENT = 1105
    PLAN_COPY_NOT_ALLOWED = 1200
    PLAN_NODE_ALREADY_IN_OTHER_PLAN = 1201
    PLAN_DELETE_FAILED = 1202
    PLAN_REMOVE_NODE_FAILED = 1203
    PLAN_ADD_NODE_FAILED = 1204
    FIRMWARE_UPDATE_STARTED = 1300
    FIRMWARE_UPDATE_UPLOADING = 1301
    FIRMWARE_UPDATE_FILE_UPLOAD_COMPLETE = 1302
    FIRMWARE_UPDATE_FAILED = 1303
    FIRMWARE_UPDATE_SUCCESSFUL = 1304
    FIRMWARE_UPDATE_WAITING_FOR_ACTIVATION = 1305
    FIRMWARE_UPDATE_DEVICE_RESTARTED = 1306
    UNLOCK_FAILED = 1400


@unique
class ErrorCode(IntEnum):
    MISSING_PARAMETER = 1
    INVALID_FORMAT = 2
    INVALID_PATH = 3
    INVALID_VERSION = 4
    OBJECT_NOT_FOUND = 5
    INVALID_RESOURCE_ID = 6
    INTERNAL_SERVER_EXCEPTION = 7
    TOO_MANY_PARAMETERS = 8
    INVALID_PARAMETERS = 9
    CONFLICTING_PARAMETERS = 10


@unique
class UserRole(IntEnum):
    NONE = 0
    SERVICE = 1
    ADMIN = 2
    STANDARD = 3
    LIMITED = 4
    CAUSEROLE_EXTERNAL_SERVICE = 5


@unique
class TriggerType(IntEnum):
    NONE = 0
    TIME = 1
    ATTRIBUTE = 2
    SWITCH = 3
    WEBHOOK = 4
    HOMEEGRAM = 5
    CELESTIAL = 6
    PLAN = 7
    GROUP = 8
    USER = 9


@unique
class TriggerOperator(IntEnum):
    NONE = 0
    RISE_ABOVE = 1
    FALL_BELOW = 2
    BECOME_EQUAL = 3
    ANY_CHANGE_GREATER_THAN = 4

@unique
class TriggerOperand(IntEnum):
    NONE = 0
    VALUE = 1
    ATTRIBUTE = 2


@unique
class HomeegramEvent(IntEnum):
    NONE = 0
    ENABLED = 1
    DISABLED = 2
    PLAYED = 3
    STOPPED = 4


@unique
class TriggerPlan(IntEnum):
    NONE = 0
    ENABLED = 1
    DISABLED = 2
    VARIABLE_ACTIVE = 3


@unique
class ConditionType(IntEnum):
    NONE = 0
    TIME = 1
    ATTRIBUTE = 2
    HOMEEGRAM = 3
    CELESTIAL = 4
    PLAN = 5
    GROUP = 6


@unique
class ConditionOperator(IntEnum):
    NONE = 0
    EQUAL = 1
    LESS_EQUAL = 2
    GREATER_EQUAL = 3
    LESS_THAN = 4
    GREATER_THAN = 5
    NOT_EQUAL = 6

@unique
class ConditionOperand(IntEnum):
    NONE = 0
    VALUE = 1
    ATTRIBUTE = 2

@unique
class ConditionCheckMoment(IntEnum):
    NONE = 0
    START = 1
    END = 2
    START_AND_END = 3


@unique
class ConditionHomeegramEvent(IntEnum):
    NONE = 0
    ENABLED = 1
    DISABLED = 2
    PLAYING = 3
    STOPPED = 4


@unique
class ConditionPlan(IntEnum):
    NONE = 0
    ENABLED = 1
    DISABLED = 2
    VARIABLE_ACTIVE = 3


@unique
class ActionType(IntEnum):
    NONE = 0
    ATTRIBUTE = 1
    TTS = 2
    NOTIFICATION = 3
    GROUP = 4
    WEBHOOK = 5
    HOMEEGRAM = 6
    PLAN = 7


@unique
class NotificationStyle(IntEnum):
    NONE = 0
    PUSH = 1
    SMS = 2
    EMAIL = 3


@unique
class NotificationClass(IntEnum):
    NONE = 0
    CUBES = 1
    WARNING = 2
    NODE = 3
    UPDATE = 4
    HOMEEGRAM = 5
    API = 6
    MLPRESENCE_DETECTION = 7


@unique
class ActionHomeegramEvent(IntEnum):
    NONE = 0
    ENABLE = 1
    DISABLE = 2
    PLAY = 3
    STOP = 4


@unique
class ActionPlan(IntEnum):
    NONE = 0
    ENABLE = 1
    DISABLE = 2
    OVERRIDE = 3


@unique
class CelestialType(IntEnum):
    SUNRISE = 1
    SUNSET = 2


@unique
class TimeOfDay(IntEnum):
    DAY = 1
    NIGHT = 2
    MORNING = 3
    NOON = 4
    AFTERNOON = 5
    EVENING = 6
    MIDNIGHT = 7


@unique
class DeviceType(IntEnum):
    NONE = 0
    PHONE = 1
    TABLET = 2
    DESKTOP = 3
    BROWSER = 4


@unique
class DeviceOS(IntEnum):
    NONE = 0
    I_OS = 1
    ANDROID = 2
    WINDOWS = 3
    WINDOWS_PHONE = 4
    LINUX = 5
    MAC_OS = 6


@unique
class DeviceApp(IntEnum):
    NONE = 0
    HOMEE = 1
    AFRISOHOME = 2
    ESTMK = 3
    COVIVA = 4
    PU_M = 5
    COVIVA_BERKER = 6
    NVB = 7
    TEN = 9
    HOERMANN = 11
    QUAR_Z = 12
    VARIA3 = 13


@unique
class AttributeHistoryError(IntEnum):
    TIMEOUT = 1
    NO_CONNECTION = 2
    WRONG_HOSTNAME = 3
    DISABLED = 4
    UNKNOWN_CURL_CODE = 5
    EMPTY = 6


@unique
class GroupCategory(IntEnum):
    NONE = 0
    LIGHT = 10
    CLIMATE = 11
    DOOR_WINDOW = 12
    ALARM = 13
    ENERGY = 14
    HEATING = 15
    SHUTTER = 16


@unique
class HomeeMode(IntEnum):
    HOME = 0
    SLEEPING = 1
    AWAY = 2
    VACATION = 3


@unique
class DashboardGreeting(IntEnum):
    PREFIX = 0
    MORNING = 1
    AFTERNOON = 2
    EVENING = 3
    MIDNIGHT = 4


@unique
class HomeeUpdate(IntEnum):
    STARTING = 0
    DOWNLOADING = 1
    ERROR_DOWNLOADING = 2
    PREPAIRING = 3
    ERROR_PREPAIRING = 4
    INSTALLING = 5
    ERROR_INSTALLING = 6
    SUCCESSFUL = 7


@unique
class Service(IntEnum):
    APPLE_HOME_KIT = 5
    GOOGLE_ASSISTANT = 6
    AMAZON_ALEXA = 7
    QUAR_Z = 8


@unique
class BackupDestination(IntEnum):
    NONE = 0
    FTP = 1
    DROPBOX = 2


@unique
class BackupDestinationBitmask(IntEnum):
    DROPBOX = 6
    FTP = 7


@unique
class HistoryDestination(IntEnum):
    NONE = 0
    FTP = 1


@unique
class DiaryEventType(IntEnum):
    NONE = 0
    NODE_STATE_CHANGED = 1
    NODE_ATTRIBUTE_CHANGE_SENT = 2
    NODE_ATTRIBUTE_CHANGE_RECEIVED = 3
    HOMEEGRAM_ACTION_NOT_EXECUTED = 100
    HOMEEGRAM_TRIGGERED = 101
    HOMEEGRAM_CANCELED = 102
    HOMEEGRAM_ACTIVATED = 103
    HOMEEGRAM_DEACTIVATED = 104
    GROUP_SWITCHED = 200
    SYSTEM_CUBE_ADDED = 300
    SYSTEM_CUBE_REMOVED = 301
    SYSTEM_USER_LOGIN_SUCCESSFUL = 302
    SYSTEM_USER_LOGIN_FAILED = 303
    SYSTEM_REBOOT = 304
    SYSTEM_SHUTDOWN = 305
    SYSTEM_START = 306
    SYSTEM_UPDATE_STARTED = 307
    SYSTEM_UPDATE_SUCCESSFUL = 308
    SYSTEM_UPDATE_FAILED = 309
    SYSTEM_INTERNET_CONNECTION_ESTABLISHED = 310
    SYSTEM_INTERNET_CONNECTION_LOST = 311
    SYSTEM_PROXY_CONNECTION_ESTABLISHED = 312
    SYSTEM_PROXY_CONNECTION_LOST = 313
    SYSTEM_WEATHER_UPDATE_SUCCESSFUL = 314
    SYSTEM_WEATHER_UPDATE_FAILED = 315
    SYSTEM_BACKUP_CREATION_SUCCESSFUL = 316
    SYSTEM_BACKUP_CREATION_FAILED = 317
    SYSTEM_BACKUP_EXPORT_SUCCESSFUL = 318
    SYSTEM_BACKUP_EXPORT_FAILED = 319
    SYSTEM_HISTORY_EXPORT_SUCCESSFUL = 320
    SYSTEM_HISTORY_EXPORT_FAILED = 321
    SYSTEM_CUBE_UPDATE_STARTED = 322
    SYSTEM_CUBE_UPDATE_SUCCESSFUL = 323
    SYSTEM_CUBE_UPDATE_FAILED = 324
    ELECTRICITY_PRICE_UPDATE_SUCCESSFUL = 325
    ELECTRICITY_PRICE_UPDATE_FAILED = 326
    ENERGY_CONSUMPTION_UPDATE_SUCCESSFUL = 327
    ENERGY_CONSUMPTION_UPDATE_FAILED = 328
    SYSTEM_USER_PRESENCE_CHANGED = 329
    WEBHOOK_SENT = 400
    PUSH_SENT = 500
    PUSH_SENT_FAILED = 501
    MAIL_SENT = 510
    MAIL_SENT_FAILED = 511
    PLAN_ACTIVATED = 600
    PLAN_DEACTIVATED = 601
    PLAN_SCHEDULE_TRIGGERED = 602
    PLAN_SCHEDULE_RESTORED = 603
    PLAN_SCHEDULE_SKIPPED = 604
    PLAN_EVENT_TRIGGERED = 605
    PLAN_TEMPORARY_OVERRIDEN = 606
    WIND_MONITORING_LINK_SUCCESSFUL = 650
    WIND_MONITORING_LINK_FAILED = 651
    WIND_MONITORING_UNLINK_SUCCESSFUL = 652
    WIND_MONITORING_UNLINK_FAILED = 653
    MLPRESENCE_DETECTION_ACTIVATED = 700
    MLPRESENCE_DETECTION_DEACTIVATED = 701
    MLPRESENCE_DETECTION_RESET = 702
    MLPRESENCE_DETECTION_KNOWLEDGE_HAS_BEEN_RESET = 703
    MLPRESENCE_DETECTION_OPERATING_MODE_CHANGED = 704
    MLPRESENCE_DETECTION_VALUE_PREDICTED = 705
    MLPRESENCE_DETECTION_TRAINING_STARTED = 706
    MLPRESENCE_DETECTION_TRAINING_CANCELED = 707
    MLPRESENCE_DETECTION_TRAINING_COMPLETED = 708


@unique
class DiaryCauseType(IntEnum):
    NONE = 0
    NODE_ATTRIBUTE = 1
    HOMEEGRAM_TRIGGER = 10
    HOMEEGRAM_CONDITION = 11
    HOMEEGRAM_ACTION = 12
    GROUP = 20
    SYSTEM = 30
    HIGH_RAM = 31
    UPDATE = 32
    DOWNLOAD_FAILED = 33
    INSTALLATION_FAILED = 34
    USER = 40
    WRONG_PASSWORD = 41
    UNKNOWN_USER_NAME = 42
    PLAN = 50
    PLAN_SCHEDULE = 51
    PLAN_EVENT = 52
    GLOBAL_WATCHDOG = 60
    EMAIL_LIMIT_REACHED = 70
    EMAIL_UNVERIFIED = 71
    EMAIL_VERIFY = 72


@unique
class PlanType(IntEnum):
    NONE = 0
    HEATING = 1
    Energy = 2
    OnOff = 3
    PRESENCE_SIMULATION = 4
    ELECTRICAL_HEATING = 5
    WIND_MONITORING = 50
    SUN_AUTOMATION = 51
    DAWN_AUTOMATION = 52


@unique
class PlanEventType(IntEnum):
    NONE = 0
    OPEN_WINDOW_DETECTION = 1
    AWAY_MODE = 2
    VACATION_MODE = 3
    WINDNOALARM = 4
    WINDALARM = 5
    DARK = 6
    BRIGHT = 7
    RELEASE_TEMPERATURE = 8
    AT_HOME_MODE = 9
    SLEEPIN_GMODE = 10
    MORNING = 11
    EVENING = 12

@unique
class PlansTemplate(IntEnum):
    NONE = 0
    HEATING = 1
    HEATING_EMPTY = 2
    WIND_MONITORING = 50


@unique
class PlanVariableType(IntEnum):
    NONE = 0
    TEMPERATURE_COMFORT_PLUS = 1
    TEMPERATURE_COMFORT = 2
    TEMPERATURE_ECO = 3
    TEMPERATURE_NIGHT = 4
    TEMPERATURE_AWAY = 5
    TEMPERATURE_WINDOW = 6
    TEMPERATURE_VACATION = 7
    WIND_NO_ALARM = 50
    WIND_ALARM = 51
    GENERIC_ON_OFF_PLUG = 100
    TEMPERATURE_ON_OFF_PLUG = 101
