/*
 * Copyright (C) 2025 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_USER_TRACKER_H_
#define SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_USER_TRACKER_H_

#include <cstdint>

#include "perfetto/ext/base/flat_hash_map.h"
#include "src/trace_processor/storage/trace_storage.h"
#include "src/trace_processor/tables/android_tables_py.h"

namespace perfetto::trace_processor {

class TraceProcessorContext;

class UserTracker {
 public:
  explicit UserTracker(TraceProcessorContext*);

  void AddOrUpdateUser(int64_t android_user_id, StringId user_type);

 private:
  TraceProcessorContext* const context_;
  base::FlatHashMap<int64_t, tables::AndroidUserListTable::Id> user_rows_;
};

}  // namespace perfetto::trace_processor

#endif  // SRC_TRACE_PROCESSOR_IMPORTERS_PROTO_USER_TRACKER_H_
