/* This file is generated by "mtxrun --script "mtx-wtoc.lua" from the metapost cweb files. */


# ifndef MP_H
# define MP_H 1

# include "avl.h"
# include "auxmemory.h"
# include "auxposit.h"
# include <string.h>
# include <setjmp.h>

# define metapost_version "3.14"

typedef struct MP_instance *MP;
typedef enum mp_number_type {
    mp_nan_type,
    mp_scaled_type,
    mp_fraction_type,
    mp_angle_type,
    mp_double_type,
    mp_binary_type,
    mp_decimal_type,
    mp_posit_type
} mp_number_type;
typedef union mp_number_store {
    void   *num;
    double  dval;
    int     val;
    posit_t pval;
} mp_number_store;
typedef struct mp_number_data {
    mp_number_store data;
    mp_number_type  type;
} mp_number_data;
typedef struct mp_number_data mp_number;
# define is_number(A) ((A).type != mp_nan_type)
enum mp_filetype {
    mp_filetype_terminal,
    mp_filetype_program,
    mp_filetype_text
};
typedef char *(*mp_file_finder)     (MP, const char *, const char *, int);
typedef char *(*mp_script_runner)   (MP, const char *m, size_t len, int n);
typedef void  (*mp_internal_runner) (MP, int action, int n, int type, const char *iname);
typedef void  (*mp_log_runner)      (MP, int, const char *s, size_t l);
typedef int   (*mp_overload_runner) (MP, int, const char *, int);
typedef void  (*mp_error_runner)    (MP, const char *, const char *, int);
typedef void  (*mp_warning_runner)  (MP, const char *);
typedef char *(*mp_text_maker)      (MP, const char *, size_t, int);
typedef void *(*mp_file_opener)     (MP, const char *, const char *, int);
typedef char *(*mp_file_reader)     (MP, void *, size_t *);
typedef void  (*mp_file_closer)     (MP, void *);
typedef int   (*mp_file_eoftest)    (MP, void *);
typedef void  (*mp_file_flush)      (MP, void *);
typedef void  (*mp_file_writer)     (MP, void *, const char *);
typedef struct mp_lstring {
    unsigned char *str;
    size_t         len;
    int            refs;
} mp_lstring;
typedef mp_lstring *mp_string;
enum mp_interaction_mode {
    mp_unspecified_mode,
    mp_batch_mode,
    mp_nonstop_mode,
    mp_scroll_mode,
    mp_error_stop_mode,
    mp_silent_mode
};
enum mp_history_state {
    mp_spotless,
    mp_warning_issued,
    mp_error_message_issued,
    mp_fatal_error_stop,
    mp_system_error_stop
};
typedef enum mp_math_mode {
    mp_math_scaled_mode,
    mp_math_double_mode,
    mp_math_binary_mode,
    mp_math_decimal_mode,
    mp_math_posit_mode
} mp_math_mode;
typedef struct mp_knot_data *mp_knot;
typedef struct mp_knot_data {
    mp_number     x_coord;
    mp_number     y_coord;
    union {
        mp_number left_x;
        mp_number left_curl;
        mp_number left_given;
    };
    union {
        mp_number left_y;
        mp_number left_tension;
    };
    union {
        mp_number right_x;
        mp_number right_curl;
        mp_number right_given;
    };
    union {
        mp_number right_y;
        mp_number right_tension;
    };
    mp_knot       next;
    mp_knot       prev;
    unsigned char left_type;
    unsigned char right_type;
    unsigned char originator;
    unsigned char state;
    signed   int  info;
} mp_knot_data;
typedef struct mp_gr_knot_data *mp_gr_knot;
typedef struct mp_gr_knot_data {
    double        x_coord;
    double        y_coord;
    double        left_x;
    double        left_y;
    double        right_x;
    double        right_y;
    mp_gr_knot    next;
    mp_gr_knot    prev;
    unsigned char left_type;
    unsigned char right_type;
    unsigned char originator;
    unsigned char state;
    signed int    info;
} mp_gr_knot_data;
enum mp_knot_originator {
    mp_program_code,
    mp_metapost_user
};
enum mp_knot_states {
    mp_regular_knot,
    mp_begin_knot,
    mp_end_knot,
    mp_single_knot,
};
# undef term_in
# undef term_out
typedef struct mp_run_data
{
    void                  *term_in;
    struct mp_edge_object *edges;
} mp_run_data;
typedef struct mp_color {
    union {
        double red;
        double cyan;
    };
    union {
        double green;
        double magenta;
    };
    union {
        double blue;
        double yellow;
    };
    union {
        double black;
        double gray;
    };
} mp_color;
typedef struct mp_dash_object {
    double  offset;
    double *array;
} mp_dash_object;
typedef struct mp_graphic_object {
    int                       type;
    int                       stacking;
    struct mp_graphic_object *next;
} mp_graphic_object;
typedef struct mp_shape_object {
    int                       type;
    int                       stacking;
    struct mp_graphic_object *next;
    char                     *pre_script;
    char                     *post_script;
    size_t                    pre_length;
    size_t                    post_length;
    mp_color                  color;
    mp_gr_knot                path;
    mp_gr_knot                htap;
    mp_gr_knot                pen;
    double                    miterlimit;
    mp_dash_object           *dash;
    unsigned char             color_model;
    unsigned char             linejoin;
    unsigned char             linecap;
    unsigned char             padding;
} mp_shape_object;
typedef struct mp_start_object {
    int                       type;
    int                       stacking;
    struct mp_graphic_object *next;
    char                     *pre_script;
    char                     *post_script;
    size_t                    pre_length;
    size_t                    post_length;
    mp_gr_knot                path;
} mp_start_object;
typedef struct mp_stop_object {
    int                       type;
    int                       stacking;
    struct mp_graphic_object *next;
    char                     *pre_script;
    char                     *post_script;
    size_t                    pre_length;
    size_t                    post_length;
    mp_gr_knot                path;
} mp_stop_object;
typedef struct mp_edge_object {
    struct mp_graphic_object *body;
    struct mp_edge_object    *next;
    MP                        parent;
    double                    minx;
    double                    miny;
    double                    maxx;
    double                    maxy;
    double                    width;
    double                    height;
    double                    depth;
    double                    italic;
    int                       charcode;
    int                       padding;
} mp_edge_object;
typedef void (*mp_backend_writer) (MP, void *);

typedef struct MP_options {
    int   halt_on_error;
    void *userdata;
    char *banner;
    int   utf8_mode;
    int   text_mode;
    int   show_mode;
    mp_file_finder     find_file;
    mp_script_runner   run_script;
    mp_internal_runner run_internal;
    mp_log_runner      run_logger;
    mp_overload_runner run_overload;
    mp_error_runner    run_error;
    mp_warning_runner  run_warning;
    mp_text_maker      make_text;
    mp_file_opener     open_file;
    mp_file_closer     close_file;
    mp_file_reader     read_file;
    mp_file_writer     write_file;
    int find_file_id;
    int run_script_id;
    int run_internal_id;
    int run_logger_id;
    int run_overload_id;
    int run_error_id;
    int run_warning_id;
    int make_text_id;
    int open_file_id;
    int interaction;
    int extensions;
    int random_seed;
    int math_mode;
    char *job_name;
    mp_backend_writer shipout_backend;

} MP_options;
extern MP_options *mp_options    (void);
extern MP          mp_initialize (MP_options * opt);
extern int         mp_status     (MP mp);
extern int         mp_finished   (MP mp);
extern void       *mp_userdata   (MP mp);
extern void mp_print_e_str (MP mp, const char *s);
extern void mp_print_e_chr (MP mp, unsigned char k);
extern void mp_show_context (MP mp);
extern void mp_error (MP mp, const char *msg, const char *hlp);
extern void mp_warn  (MP mp, const char *msg);
extern void mp_fatal_error (MP mp, const char *s);
extern int   mp_initialize_symbol_traverse (MP mp);
extern void  mp_kill_symbol_traverse       (MP mp);
extern void *mp_fetch_symbol_traverse      (MP mp);
extern void *mp_fetch_symbol               (MP mp, char *s);
int     mp_close_path_cycle        (MP mp, mp_knot p, mp_knot q);
int     mp_close_path              (MP mp, mp_knot q, mp_knot first);
mp_knot mp_create_knot             (MP mp);
int     mp_set_knot                (MP mp, mp_knot p, double x, double y);
mp_knot mp_append_knot             (MP mp, mp_knot p, double x, double y);
mp_knot mp_append_knot_xy          (MP mp, mp_knot p, double x, double y);
int     mp_set_knot_curl           (MP mp, mp_knot q, double value);
int     mp_set_knot_left_curl      (MP mp, mp_knot q, double value);
int     mp_set_knot_right_curl     (MP mp, mp_knot q, double value);
int     mp_set_knot_simple_curl    (MP mp, mp_knot q);
int     mp_set_knotpair_curls      (MP mp, mp_knot p, mp_knot q, double t1, double t2) ;
int     mp_set_knotpair_tensions   (MP mp, mp_knot p, mp_knot q, double t1, double t2) ;
int     mp_set_knot_left_tension   (MP mp, mp_knot p, double t1);
int     mp_set_knot_right_tension  (MP mp, mp_knot p, double t1);
int     mp_set_knot_left_control   (MP mp, mp_knot p, double t1, double t2);
int     mp_set_knot_right_control  (MP mp, mp_knot p, double t1, double t2);
int     mp_set_knotpair_controls   (MP mp, mp_knot p, mp_knot q, double x1, double y1, double x2, double y2) ;
int     mp_set_knot_direction      (MP mp, mp_knot q, double x, double y) ;
int     mp_set_knotpair_directions (MP mp, mp_knot p, mp_knot q, double x1, double y1, double x2, double y2) ;
int     mp_solve_path              (MP mp, mp_knot first);
void    mp_free_path               (MP mp, mp_knot p);
double mp_number_as_double (MP mp, mp_number n);
void mp_set_internal (MP mp, char *n, char *v, int isstring);
void  mplib_shipout_backend (MP mp, void *h);
extern mp_run_data *mp_rundata (MP mp);
int   mp_run              (MP mp);
int   mp_execute          (MP mp, const char *s, size_t l);
int   mp_finish           (MP mp);
char *mp_metapost_version (void);
void mp_scan_next_value      (MP mp, int keep, int *token, int *mode, int *kind);
void mp_scan_expr_value      (MP mp, int keep, int *kind);
void mp_scan_token_value     (MP mp, int keep, int *token, int *mode, int *kind);
void mp_scan_symbol_value    (MP mp, int keep, char **s, int expand);
void mp_scan_property_value  (MP mp, int keep, int *kind, char **s, int *property, int *detail);
int  mp_skip_token_value     (MP mp, int token);
void mp_scan_numeric_value   (MP mp, int primary, double *d);
void mp_scan_boolean_value   (MP mp, int primary, int *b);
void mp_scan_string_value    (MP mp, int primary, char **s, size_t *l);
void mp_scan_pair_value      (MP mp, int primary, double *x, double *y);
void mp_scan_color_value     (MP mp, int primary, double *r, double *g, double *b);
void mp_scan_cmykcolor_value (MP mp, int primary, double *c, double *m, double *y, double *k);
void mp_scan_transform_value (MP mp, int primary, double *x, double *y, double *xx, double *xy, double *yx, double *yy);
void mp_scan_path_value      (MP mp, int primary, mp_knot *k);
void mp_push_numeric_value   (MP mp, double n);
void mp_push_integer_value   (MP mp, int i);
void mp_push_boolean_value   (MP mp, int b);
void mp_push_string_value    (MP mp, const char *s, int l);
void mp_push_pair_value      (MP mp, double x, double y);
void mp_push_color_value     (MP mp, double r, double g, double b);
void mp_push_cmykcolor_value (MP mp, double c, double m, double y, double k);
void mp_push_transform_value (MP mp, double x, double y, double xx, double xy, double yx, double yy);
void mp_push_path_value      (MP mp, mp_knot k);

typedef enum mp_color_model {
    mp_no_model,
    mp_grey_model,
    mp_rgb_model,
    mp_cmyk_model,
    mp_uninitialized_model,
} mp_color_model;
typedef enum mp_knot_type {
    mp_endpoint_knot,
    mp_explicit_knot,
    mp_given_knot,
    mp_curl_knot,
    mp_open_knot,
    mp_end_cycle_knot
} mp_knot_type;
enum mp_graphical_object_code {
    mp_unset_code,
    mp_fill_code,
    mp_stroked_code,
    mp_start_clip_code,
    mp_start_group_code,
    mp_start_bounds_code,
    mp_stop_clip_code,
    mp_stop_group_code,
    mp_stop_bounds_code,
    mp_final_graphic
};

extern void *mp_memory_allocate       (size_t size);
extern void *mp_memory_clear_allocate (size_t size);
extern void *mp_memory_reallocate     (void *p, size_t size);
extern void  mp_memory_free           (void *p);
extern void *mp_allocate_node         (MP mp, size_t size);
extern void *mp_allocate_dash         (MP mp);

typedef enum mp_command_code {
    mp_undefined_command,
    mp_btex_command,
    mp_etex_command,
    mp_if_test_command,
    mp_fi_or_else_command,
    mp_input_command,
    mp_iteration_command,
    mp_repeat_loop_command,
    mp_exit_test_command,
    mp_relax_command,
    mp_scan_tokens_command,
    mp_runscript_command,
    mp_maketext_command,
    mp_expand_after_command,
    mp_defined_macro_command,
    mp_save_command,
    mp_interim_command,
    mp_let_command,
    mp_new_internal_command,
    mp_macro_def_command,
    mp_ship_out_command,
    mp_add_to_command,
    mp_bounds_command,
    mp_protection_command,
    mp_property_command,
    mp_show_command,
    mp_mode_command,
    mp_only_set_command,
    mp_message_command,
    mp_every_job_command,
    mp_delimiters_command,
    mp_write_command,
    mp_type_name_command,
    mp_left_delimiter_command,
    mp_begin_group_command,
    mp_nullary_command,
    mp_unary_command,
    mp_str_command,
    mp_void_command,
    mp_cycle_command,
    mp_of_binary_command,
    mp_capsule_command,
    mp_string_command,
    mp_internal_command,
    mp_tag_command,
    mp_numeric_command,
    mp_plus_or_minus_command,
    mp_secondary_def_command,
    mp_tertiary_binary_command,
    mp_left_brace_command,
    mp_path_join_command,
    mp_ampersand_command,
    mp_tertiary_def_command,
    mp_primary_binary_command,
    mp_equals_command,
    mp_and_command,
    mp_primary_def_command,
    mp_slash_command,
    mp_secondary_binary_command,
    mp_parameter_commmand,
    mp_controls_command,
    mp_tension_command,
    mp_at_least_command,
    mp_curl_command,
    mp_macro_special_command,
    mp_right_delimiter_command,
    mp_left_bracket_command,
    mp_right_bracket_command,
    mp_right_brace_command,
    mp_with_option_command,
    mp_thing_to_add_command,
    mp_of_command,
    mp_to_command,
    mp_step_command,
    mp_until_command,
    mp_within_command,
    mp_assignment_command,
    mp_colon_command,
    mp_comma_command,
    mp_semicolon_command,
    mp_end_group_command,
    mp_stop_command,

    mp_undefined_cs_command,
} mp_command_code;
typedef enum mp_variable_type {
    mp_undefined_type,
    mp_vacuous_type,
    mp_boolean_type,
    mp_unknown_boolean_type,
    mp_string_type,
    mp_unknown_string_type,
    mp_pen_type,
    mp_unknown_pen_type,
    mp_nep_type,
    mp_unknown_nep_type,
    mp_path_type,
    mp_unknown_path_type,
    mp_picture_type,
    mp_unknown_picture_type,
    mp_transform_type,
    mp_color_type,
    mp_cmykcolor_type,
    mp_pair_type,
    mp_numeric_type,
    mp_known_type,
    mp_dependent_type,
    mp_proto_dependent_type,
    mp_independent_type,
    mp_token_list_type,
    mp_structured_type,
    mp_unsuffixed_macro_type,
    mp_suffixed_macro_type,
    mp_symbol_node_type,
    mp_token_node_type,
    mp_value_node_type,
    mp_attribute_node_type,
    mp_subscript_node_type,
    mp_pair_node_type,
    mp_transform_node_type,
    mp_color_node_type,
    mp_cmykcolor_node_type,
    mp_fill_node_type,
    mp_stroked_node_type,
    mp_start_clip_node_type,
    mp_start_group_node_type,
    mp_start_bounds_node_type,
    mp_stop_clip_node_type,
    mp_stop_group_node_type,
    mp_stop_bounds_node_type,
    mp_dash_node_type,
    mp_dep_node_type,
    mp_if_node_type,
    mp_edge_header_node_type,
} mp_variable_type;
typedef enum mp_name_type_type {
    mp_root_operation,
    mp_saved_root_operation,
    mp_structured_root_operation,
    mp_subscript_operation,
    mp_attribute_operation,
    mp_x_part_operation,
    mp_y_part_operation,
    mp_xx_part_operation,
    mp_xy_part_operation,
    mp_yx_part_operation,
    mp_yy_part_operation,
    mp_red_part_operation,
    mp_green_part_operation,
    mp_blue_part_operation,
    mp_cyan_part_operation,
    mp_magenta_part_operation,
    mp_yellow_part_operation,
    mp_black_part_operation,
    mp_grey_part_operation,
    mp_capsule_operation,
    mp_token_operation,
    mp_boolean_type_operation,
    mp_string_type_operation,
    mp_pen_type_operation,
    mp_nep_type_operation,
    mp_path_type_operation,
    mp_picture_type_operation,
    mp_transform_type_operation,
    mp_color_type_operation,
    mp_cmykcolor_type_operation,
    mp_pair_type_operation,
    mp_numeric_type_operation,
    mp_normal_operation,
    mp_internal_operation,
    mp_macro_operation,
    mp_expr_operation,
    mp_suffix_operation,
    mp_text_operation,
    mp_true_operation,
    mp_false_operation,
    mp_null_picture_operation,
    mp_null_pen_operation,
    mp_read_string_operation,
    mp_pen_circle_operation,
    mp_normal_deviate_operation,
    mp_read_from_operation,
    mp_close_from_operation,
    mp_odd_operation,
    mp_known_operation,
    mp_unknown_operation,
    mp_not_operation,
    mp_decimal_operation,
    mp_reverse_operation,
    mp_uncycle_operation,
    mp_make_path_operation,
    mp_make_pen_operation,
    mp_make_nep_operation,
    mp_convexed_operation,
    mp_uncontrolled_operation,
    mp_oct_operation,
    mp_hex_operation,
    mp_ASCII_operation,
    mp_char_operation,
    mp_length_operation,
    mp_no_length_operation,
    mp_turning_operation,
    mp_color_model_operation,
    mp_path_part_operation,
    mp_pen_part_operation,
    mp_dash_part_operation,
    mp_prescript_part_operation,
    mp_postscript_part_operation,
    mp_stacking_part_operation,
    mp_sqrt_operation,
    mp_m_exp_operation,
    mp_m_log_operation,
    mp_sin_d_operation,
    mp_cos_d_operation,
    mp_floor_operation,
    mp_uniform_deviate_operation,
    mp_ll_corner_operation,
    mp_lr_corner_operation,
    mp_ul_corner_operation,
    mp_ur_corner_operation,
    mp_center_of_operation,
    mp_center_of_mass_operation,
    mp_corners_operation,
    mp_x_range_operation,
    mp_y_range_operation,
    mp_delta_point_operation,
    mp_delta_precontrol_operation,
    mp_delta_postcontrol_operation,
    mp_delta_direction_operation,
    mp_arc_length_operation,
    mp_angle_operation,
    mp_cycle_operation,
    mp_no_cycle_operation,
    mp_filled_operation,
    mp_stroked_operation,
    mp_clipped_operation,
    mp_grouped_operation,
    mp_bounded_operation,
    mp_plus_operation,
    mp_minus_operation,
    mp_times_operation,
    mp_over_operation,
    mp_power_operation,
    mp_pythag_add_operation,
    mp_pythag_sub_operation,
    mp_or_operation,
    mp_and_operation,
    mp_less_than_operation,
    mp_less_or_equal_operation,
    mp_greater_than_operation,
    mp_greater_or_equal_operation,
    mp_equal_operation,
    mp_unequal_operation,
    mp_concatenate_operation,
    mp_just_append_operation,
    mp_tolerant_concat_operation,
    mp_tolerant_append_operation,
    mp_rotated_operation,
    mp_slanted_operation,
    mp_scaled_operation,
    mp_shifted_operation,
    mp_transformed_operation,
    mp_uncycled_operation,
    mp_x_scaled_operation,
    mp_y_scaled_operation,
    mp_z_scaled_operation,
    mp_intertimes_operation,
    mp_intertimes_list_operation,
    mp_double_dot_operation,
    mp_substring_operation,
    mp_subpath_operation,
    mp_direction_time_operation,
    mp_point_operation,
    mp_precontrol_operation,
    mp_postcontrol_operation,
    mp_direction_operation,
    mp_path_point_operation,
    mp_path_precontrol_operation,
    mp_path_postcontrol_operation,
    mp_path_direction_operation,
    mp_path_state_operation,
    mp_path_index_operation,
    mp_path_lastindex_operation,
    mp_path_length_operation,
    mp_path_first_operation,
    mp_path_last_operation,
    mp_pen_offset_operation,
    mp_arc_time_operation,
    mp_arc_point_operation,
    mp_arc_point_list_operation,
    mp_subarc_length_operation,
    mp_version_operation,
    mp_envelope_operation,
    mp_boundingpath_operation,

} mp_name_type_type;
typedef enum mp_class_codes {
    mp_digit_class             =  0,
    mp_period_class            =  1,
    mp_space_class             =  2,
    mp_percent_class           =  3,
    mp_string_class            =  4,
    mp_comma_class             =  5,
    mp_semicolon_class         =  6,
    mp_left_parenthesis_class  =  7,
    mp_right_parenthesis_class =  8,
    mp_letter_class            =  9,
    mp_suffix_class            = 15,
    mp_left_bracket_class      = 17,
    mp_right_bracket_class     = 18,
    mp_brace_class             = 19,
    mp_invalid_class           = 20,
    mp_max_class               = 20,
} mp_class_codes;
typedef enum mp_text_codes {
    mp_forever_text,
    mp_loop_text,
    mp_parameter_text,
    mp_backed_up_text,
    mp_inserted_text,
    mp_macro_text,
    mp_file_bottom_text,
} mp_text_codes;
typedef enum mp_scanner_states {
    mp_normal_state,
    mp_skipping_state,
    mp_flushing_state,
    mp_absorbing_state,
    mp_var_defining_state,
    mp_op_defining_state,
    mp_loop_defining_state,
    mp_tex_flushing_state,
} mp_scanner_states;
typedef enum mp_verbatim_codes {
    mp_btex_code,
    mp_verbatim_code,
} mp_verbatim_codes;
typedef enum mp_def_codes {
    mp_end_def_code,
    mp_def_code,
    mp_var_def_code,
    mp_primary_def_code,
    mp_secondary_def_code,
    mp_tertiary_def_code,
} mp_def_codes;
typedef enum mp_only_set_codes {
    mp_random_seed_code,
    mp_max_knot_pool_code,
} mp_only_set_codes;
typedef enum mp_for_codes {
    mp_end_for_code,
    mp_start_forever_code,
    mp_start_for_code,
    mp_start_forsuffixes_code,
} mp_for_codes;
typedef enum mp_macro_fix_codes {
    mp_macro_quote_code,
    mp_macro_prefix_code,
    mp_macro_at_code,
    mp_macro_suffix_code,
} mp_macro_fix_codes;
typedef enum mp_if_codes {
    mp_no_if_code,
    mp_if_code,
    mp_fi_code,
    mp_else_code,
    mp_else_if_code,
} mp_if_codes;
typedef enum mp_show_codes {
    mp_show_token_code,
    mp_show_stats_code,
    mp_show_code,
    mp_show_var_code,
    mp_show_dependencies_code,
} mp_show_codes;
typedef enum mp_with_codes {
    mp_with_pen_code,
    mp_with_dashed_code,
    mp_with_pre_script_code,
    mp_with_post_script_code,
    mp_with_stacking_code,
    mp_with_no_model_code,
    mp_with_grey_model_code,
    mp_with_uninitialized_model_code,
    mp_with_rgb_model_code,
    mp_with_cmyk_model_code,
    mp_with_linecap_code,
    mp_with_linejoin_code,
    mp_with_miterlimit_code,
} mp_with_codes;
typedef enum mp_add_codes {
    mp_add_double_path_code,
    mp_add_contour_code,
    mp_add_also_code,
} mp_add_codes ;

typedef void   (*convert_func)                      (mp_number *r);
typedef void   (*m_log_func)                        (MP mp, mp_number *r, mp_number *a);
typedef void   (*m_exp_func)                        (MP mp, mp_number *r, mp_number *a);
typedef void   (*m_unif_rand_func)                  (MP mp, mp_number *ret, mp_number *x_orig);
typedef void   (*m_norm_rand_func)                  (MP mp, mp_number *ret);
typedef void   (*pyth_add_func)                     (MP mp, mp_number *r, mp_number *a, mp_number *b);
typedef void   (*pyth_sub_func)                     (MP mp, mp_number *r, mp_number *a, mp_number *b);
typedef void   (*power_of_func)                     (MP mp, mp_number *r, mp_number *a, mp_number *b);
typedef void   (*n_arg_func)                        (MP mp, mp_number *r, mp_number *a, mp_number *b);
typedef void   (*velocity_func)                     (MP mp, mp_number *r, mp_number *a, mp_number *b, mp_number *c, mp_number *d, mp_number *e);
typedef int    (*ab_vs_cd_func)                     (mp_number *a, mp_number *b, mp_number *c, mp_number *d);
typedef void   (*crossing_point_func)               (MP mp, mp_number *r, mp_number *a, mp_number *b, mp_number *c);
typedef void   (*number_from_int_func)              (mp_number *A, int B);
typedef void   (*number_from_boolean_func)          (mp_number *A, int B);
typedef void   (*number_from_scaled_func)           (mp_number *A, int B);
typedef void   (*number_from_double_func)           (mp_number *A, double B);
typedef void   (*number_from_addition_func)         (mp_number *A, mp_number *B, mp_number *C);
typedef void   (*number_half_from_addition_func)    (mp_number *A, mp_number *B, mp_number *C);
typedef void   (*number_from_subtraction_func)      (mp_number *A, mp_number *B, mp_number *C);
typedef void   (*number_half_from_subtraction_func) (mp_number *A, mp_number *B, mp_number *C);
typedef void   (*number_from_div_func)              (mp_number *A, mp_number *B, mp_number *C);
typedef void   (*number_from_mul_func)              (mp_number *A, mp_number *B, mp_number *C);
typedef void   (*number_from_int_div_func)          (mp_number *A, mp_number *B, int C);
typedef void   (*number_from_int_mul_func)          (mp_number *A, mp_number *B, int C);
typedef void   (*number_from_oftheway_func)         (MP mp, mp_number *A, mp_number *t, mp_number *B, mp_number *C);
typedef void   (*number_negate_func)                (mp_number *A);
typedef void   (*number_add_func)                   (mp_number *A, mp_number *B);
typedef void   (*number_subtract_func)              (mp_number *A, mp_number *B);
typedef void   (*number_modulo_func)                (mp_number *A, mp_number *B);
typedef void   (*number_half_func)                  (mp_number *A);
typedef void   (*number_double_func)                (mp_number *A);
typedef void   (*number_abs_func)                   (mp_number *A);
typedef void   (*number_clone_func)                 (mp_number *A, mp_number *B);
typedef void   (*number_negated_clone_func)         (mp_number *A, mp_number *B);
typedef void   (*number_abs_clone_func)             (mp_number *A, mp_number *B);
typedef void   (*number_swap_func)                  (mp_number *A, mp_number *B);
typedef void   (*number_add_scaled_func)            (mp_number *A, int b);
typedef void   (*number_multiply_int_func)          (mp_number *A, int b);
typedef void   (*number_divide_int_func)            (mp_number *A, int b);
typedef int    (*number_to_int_func)                (mp_number *A);
typedef int    (*number_to_boolean_func)            (mp_number *A);
typedef int    (*number_to_scaled_func)             (mp_number *A);
typedef int    (*number_round_func)                 (mp_number *A);
typedef void   (*number_floor_func)                 (mp_number *A);
typedef double (*number_to_double_func)             (mp_number *A);
typedef int    (*number_odd_func)                   (mp_number *A);
typedef int    (*number_equal_func)                 (mp_number *A, mp_number *B);
typedef int    (*number_less_func)                  (mp_number *A, mp_number *B);
typedef int    (*number_greater_func)               (mp_number *A, mp_number *B);
typedef int    (*number_nonequalabs_func)           (mp_number *A, mp_number *B);
typedef void   (*make_scaled_func)                  (MP mp, mp_number *ret, mp_number *A, mp_number *B);
typedef void   (*make_fraction_func)                (MP mp, mp_number *ret, mp_number *A, mp_number *B);
typedef void   (*take_fraction_func)                (MP mp, mp_number *ret, mp_number *A, mp_number *B);
typedef void   (*take_scaled_func)                  (MP mp, mp_number *ret, mp_number *A, mp_number *B);
typedef void   (*sin_cos_func)                      (MP mp, mp_number *A, mp_number *S, mp_number *C);
typedef void   (*slow_add_func)                     (MP mp, mp_number *A, mp_number *S, mp_number *C);
typedef void   (*sqrt_func)                         (MP mp, mp_number *ret, mp_number *A);
typedef void   (*init_randoms_func)                 (MP mp, int seed);
typedef void   (*allocate_number_func)              (MP mp, mp_number *A, mp_number_type t);
typedef void   (*allocate_number_clone_func)        (MP mp, mp_number *A, mp_number_type t, mp_number *B);
typedef void   (*allocate_number_abs_func)          (MP mp, mp_number *A, mp_number_type t, mp_number *B);
typedef void   (*allocate_number_double_func)       (MP mp, mp_number *A, double B);
typedef void   (*free_number_func)                  (MP mp, mp_number *n);
typedef void   (*fraction_to_round_scaled_func)     (mp_number *n);
typedef void   (*print_func)                        (MP mp, mp_number *A);
typedef char  *(*tostring_func)                     (MP mp, mp_number *A);
typedef void   (*scan_func)                         (MP mp, int A);
typedef void   (*mp_free_func)                      (MP mp);
typedef void   (*set_precision_func)                (MP mp);
typedef struct math_data {
    mp_number                         md_precision_default;
    mp_number                         md_precision_max;
    mp_number                         md_precision_min;
    mp_number                         md_epsilon_t;
    mp_number                         md_inf_t;
    mp_number                         md_negative_inf_t;
    mp_number                         md_one_third_inf_t;
    mp_number                         md_zero_t;
    mp_number                         md_unity_t;
    mp_number                         md_two_t;
    mp_number                         md_three_t;
    mp_number                         md_half_unit_t;
    mp_number                         md_three_quarter_unit_t;
    mp_number                         md_fraction_one_t;
    mp_number                         md_fraction_half_t;
    mp_number                         md_fraction_three_t;
    mp_number                         md_fraction_four_t;
    mp_number                         md_one_eighty_deg_t;
    mp_number                         md_negative_one_eighty_deg_t;
    mp_number                         md_three_sixty_deg_t;
    mp_number                         md_one_k;
    mp_number                         md_sqrt_8_e_k;
    mp_number                         md_twelve_ln_2_k;
    mp_number                         md_coef_bound_k;
    mp_number                         md_coef_bound_minus_1;
    mp_number                         md_twelvebits_3;
    mp_number                         md_arc_tol_k;
    mp_number                         md_twentysixbits_sqrt2_t;
    mp_number                         md_twentyeightbits_d_t;
    mp_number                         md_twentysevenbits_sqrt2_d_t;
    mp_number                         md_fraction_threshold_t;
    mp_number                         md_half_fraction_threshold_t;
    mp_number                         md_scaled_threshold_t;
    mp_number                         md_half_scaled_threshold_t;
    mp_number                         md_near_zero_angle_t;
    mp_number                         md_p_over_v_threshold_t;
    mp_number                         md_equation_threshold_t;
    mp_number                         md_warning_limit_t;
    allocate_number_func              md_allocate;
    allocate_number_clone_func        md_allocate_clone;
    allocate_number_abs_func          md_allocate_abs;
    allocate_number_double_func       md_allocate_double;
    free_number_func                  md_free;
    number_from_int_func              md_from_int;
    number_from_boolean_func          md_from_boolean;
    number_from_scaled_func           md_from_scaled;
    number_from_double_func           md_from_double;
    number_from_addition_func         md_from_addition;
    number_half_from_addition_func    md_half_from_addition;
    number_from_subtraction_func      md_from_subtraction;
    number_half_from_subtraction_func md_half_from_subtraction;
    number_from_div_func              md_from_div;
    number_from_mul_func              md_from_mul;
    number_from_int_div_func          md_from_int_div;
    number_from_int_mul_func          md_from_int_mul;
    number_from_oftheway_func         md_from_oftheway;
    number_negate_func                md_negate;
    number_add_func                   md_add;
    number_subtract_func              md_subtract;
    number_half_func                  md_half;
    number_modulo_func                md_modulo;
    number_double_func                md_do_double;
    number_abs_func                   md_abs;
    number_clone_func                 md_clone;
    number_negated_clone_func         md_negated_clone;
    number_abs_clone_func             md_abs_clone;
    number_swap_func                  md_swap;
    number_add_scaled_func            md_add_scaled;
    number_multiply_int_func          md_multiply_int;
    number_divide_int_func            md_divide_int;
    number_to_int_func                md_to_int;
    number_to_boolean_func            md_to_boolean;
    number_to_scaled_func             md_to_scaled;
    number_to_double_func             md_to_double;
    number_odd_func                   md_odd;
    number_equal_func                 md_equal;
    number_less_func                  md_less;
    number_greater_func               md_greater;
    number_nonequalabs_func           md_nonequalabs;
    number_round_func                 md_round_unscaled;
    number_floor_func                 md_floor_scaled;
    make_scaled_func                  md_make_scaled;
    make_fraction_func                md_make_fraction;
    take_fraction_func                md_take_fraction;
    take_scaled_func                  md_take_scaled;
    velocity_func                     md_velocity;
    ab_vs_cd_func                     md_ab_vs_cd;
    crossing_point_func               md_crossing_point;
    n_arg_func                        md_n_arg;
    m_log_func                        md_m_log;
    m_exp_func                        md_m_exp;
    m_unif_rand_func                  md_m_unif_rand;
    m_norm_rand_func                  md_m_norm_rand;
    pyth_add_func                     md_pyth_add;
    pyth_sub_func                     md_pyth_sub;
    power_of_func                     md_power_of;
    fraction_to_round_scaled_func     md_fraction_to_round_scaled;
    convert_func                      md_fraction_to_scaled;
    convert_func                      md_scaled_to_fraction;
    convert_func                      md_scaled_to_angle;
    convert_func                      md_angle_to_scaled;
    init_randoms_func                 md_init_randoms;
    sin_cos_func                      md_sin_cos;
    sqrt_func                         md_sqrt;
    slow_add_func                     md_slow_add;
    print_func                        md_print;
    tostring_func                     md_tostring;
    scan_func                         md_scan_numeric;
    scan_func                         md_scan_fractional;
    mp_free_func                      md_free_math;
    set_precision_func                md_set_precision;
} math_data;
typedef struct mp_value_node_data *mp_value_node;
typedef struct mp_node_data       *mp_node;
typedef struct mp_symbol_entry    *mp_sym;
typedef unsigned short  quarterword;
typedef int             halfword;
typedef struct mp_independent_data {
    int scale;
    int serial;
} mp_independent_data;
typedef struct mp_value_data {
    mp_independent_data indep;
    mp_number           n;
    mp_string           str;
    mp_sym              sym;
    mp_node             node;
    mp_knot             p;
} mp_value_data;
typedef struct mp_value {
    mp_variable_type type;
    int              padding;
    mp_value_data    data;
} mp_value;
typedef enum mp_given_internal {
    mp_number_system_internal = 1,
    mp_number_precision_internal,
    mp_job_name_internal,
    mp_tracing_titles_internal,
    mp_tracing_equations_internal,
    mp_tracing_capsules_internal,
    mp_tracing_choices_internal,
    mp_tracing_specs_internal,
    mp_tracing_commands_internal,
    mp_tracing_restores_internal,
    mp_tracing_macros_internal,
    mp_tracing_output_internal,
    mp_tracing_stats_internal,
    mp_tracing_online_internal,
    mp_year_internal,
    mp_month_internal,
    mp_day_internal,
    mp_time_internal,
    mp_hour_internal,
    mp_minute_internal,
    mp_char_code_internal,
    mp_char_wd_internal,
    mp_char_ht_internal,
    mp_char_dp_internal,
    mp_char_ic_internal,
    mp_pausing_internal,
    mp_showstopping_internal,
    mp_texscriptmode_internal,
    mp_overloadmode_internal,
    mp_linejoin_internal,
    mp_linecap_internal,
    mp_stacking_internal,
    mp_miterlimit_internal,
    mp_warning_check_internal,
    mp_true_corners_internal,
    mp_default_color_model_internal,
    mp_restore_clip_color_internal,
} mp_given_internal;
typedef struct mp_internal {
    mp_value  v;
    char     *intname;
    int       run;
    int       padding;
} mp_internal;
typedef struct mp_symbol_entry {
    int        type;
    int        property;
    mp_value   v;
    mp_string  text;
    void      *parent;
} mp_symbol_entry;
typedef enum mp_macro_info {
    mp_general_macro,
    mp_primary_macro,
    mp_secondary_macro,
    mp_tertiary_macro,
    mp_expr_macro,
    mp_of_macro,
    mp_suffix_macro,
    mp_text_macro,
    mp_expr_parameter,
    mp_suffix_parameter,
    mp_text_parameter
} mp_macro_info;
typedef struct mp_save_data {
    int                  type;
    int                  padding;
    mp_internal          value;
    struct mp_save_data *link;
} mp_save_data;
enum mp_bb_code {
    mp_x_code,
    mp_y_code
};
typedef struct mp_dash_node_data *mp_dash_node;
typedef struct mp_in_state_record {
    int       start_field;
    int       loc_field;
    int       limit_field;
    int       index_field;
    mp_node   nstart_field;
    mp_node   nloc_field;
    mp_string name_field;
} mp_in_state_record;
typedef struct mp_subst_list_item {
    mp_name_type_type          info_mod;
    int                        value_mod;
    int                        value_data;
    int                        padding;
    mp_sym                     info;
    struct mp_subst_list_item *link;
} mp_subst_list_item;
typedef struct mp_loop_data {
    mp_sym               var ;
    mp_node              info;
    mp_node              type;
    mp_node              list;
    mp_node              list_start;
    mp_number            old_value;
    mp_number            value;
    mp_number            step_size;
    mp_number            final_value;
    struct mp_loop_data *link;
    mp_knot              point;
} mp_loop_data;
typedef struct File {
    FILE *f;
} File;

# define bistack_size 1500

typedef struct MP_instance {
    int   halt_on_error;
    void *userdata;
    char *banner;
    int   utf8_mode;
    int   text_mode;
    int   show_mode;
    mp_file_finder     find_file;
    mp_script_runner   run_script;
    mp_internal_runner run_internal;
    mp_log_runner      run_logger;
    mp_overload_runner run_overload;
    mp_error_runner    run_error;
    mp_warning_runner  run_warning;
    mp_text_maker      make_text;
    mp_file_opener     open_file;
    mp_file_closer     close_file;
    mp_file_reader     read_file;
    mp_file_writer     write_file;
    int find_file_id;
    int run_script_id;
    int run_internal_id;
    int run_logger_id;
    int run_overload_id;
    int run_error_id;
    int run_warning_id;
    int make_text_id;
    int open_file_id;
    int interaction;
    int extensions;
    int random_seed;
    int math_mode;
    char *job_name;
    mp_backend_writer shipout_backend;

    math_data *math;
    int max_in_open;
    int param_size;
    int padding_size;
    char *name_of_file;
    size_t         buf_size;
    unsigned char *buffer;
    size_t         first;
    size_t         last;
    size_t         max_buf_stack;
    void *term_in;
    avl_tree       strings;
    unsigned char *cur_string;
    size_t         cur_length;
    size_t         cur_string_size;
    int pool_in_use;
    int max_pl_used;
    int strs_in_use;
    int max_strs_used;
    unsigned int   selector;
    unsigned int   term_offset;
    unsigned int   file_offset;
    int history;
    int error_count;
    int       use_err_help;
    int       padding_help;
    mp_string err_help;
    jmp_buf *jump_buf;
    int run_state;
    int finished;
    int arith_error;
    mp_number randoms[55];
    int j_random;
    int j_padding;
    mp_node token_nodes;
    mp_node pair_nodes;
    int     num_token_nodes;
    int     num_pair_nodes;
    mp_knot knot_nodes;
    mp_node value_nodes;
    int     max_knot_nodes;
    int     num_knot_nodes;
    int     num_value_nodes;
    mp_node symbolic_nodes;
    int     num_symbolic_nodes;
    size_t var_used;
    size_t var_used_max;
    mp_dash_node  null_dash;
    mp_value_node dep_head;
    mp_node       inf_val;
    mp_node       zero_val;
    mp_node       temp_val;
    mp_node       end_attr;
    mp_node       bad_vardef;
    mp_node       temp_head;
    mp_node       hold_head;
    mp_node       spec_head;
    mp_internal *internal;
    int          int_ptr;
    int          max_internal;
    unsigned int old_selector;
    int char_class[256];
    int          st_count;
    avl_tree     symbols;
    avl_tree     frozen_symbols;
    avl_iterator symbol_iterator;
    mp_sym frozen_bad_vardef;
    mp_sym frozen_colon;
    mp_sym frozen_end_def;
    mp_sym frozen_end_for;
    mp_sym frozen_end_group;
    mp_sym frozen_etex;
    mp_sym frozen_fi;
    mp_sym frozen_inaccessible;
    mp_sym frozen_left_bracket;
    mp_sym frozen_repeat_loop;
    mp_sym frozen_right_delimiter;
    mp_sym frozen_semicolon;
    mp_sym frozen_slash;
    mp_sym frozen_undefined;
    mp_sym frozen_dump;
    mp_sym id_lookup_test;
    mp_save_data *save_ptr;
    mp_knot path_tail;
    int path_size;
    int path_padding;
    mp_number *delta_x;
    mp_number *delta_y;
    mp_number *delta;
    mp_number *psi;
    mp_number *theta;
    mp_number *uu;
    mp_number *vv;
    mp_number *ww;
    mp_number st;
    mp_number ct;
    mp_number sf;
    mp_number cf;
    mp_number bbmin[mp_y_code + 1];
    mp_number bbmax[mp_y_code + 1];
    mp_number half_cos[8];
    mp_number d_cos[8];
    mp_number cur_x;
    mp_number cur_y;
    int spec_offset;
    int spec_padding;
    mp_knot spec_p1;
    mp_knot spec_p2;
    unsigned int tol_step;
    mp_number *bisect_stack;
    int bisect_ptr;
    mp_number cur_t;
    mp_number cur_tt;
    int time_to_go;
    mp_number max_t;
    mp_number delx;
    mp_number dely;
    int       tol;
    int       uv;
    int       xy;
    int       three_l;
    mp_number appr_t;
    mp_number appr_tt;
    int serial_no;
    int           fix_needed;
    int           watch_coefs;
    mp_value_node dep_final;
    mp_node cur_mod_;
    mp_in_state_record *input_stack;
    int                 input_ptr;
    int                 max_in_stack;
    mp_in_state_record  cur_input;
    int                 stack_size;
    int            in_open;
    int            in_open_max;
    unsigned int   open_parens;
    void         **input_file;
    int           *line_stack;
    mp_node *param_stack;
    int      param_ptr;
    int      max_param_stack;
    int file_ptr;
    int     scanner_status;
    mp_sym  warning_info;
    int     warning_line;
    mp_node warning_info_node;
    int force_eof;
    mp_sym bg_loc;
    mp_sym eg_loc;
    int expand_depth_count;
    int expand_depth;
    mp_node cond_ptr;
    int     if_limit;
    int     cur_if;
    int     if_line;
    mp_loop_data *loop_ptr;
    char *cur_name;
    int quoted_filename;
    int    max_read_files;
    void **rd_file;
    char **rd_fname;
    int    read_files;
    int    max_write_files;
    void **wr_file;
    char **wr_fname;
    int    write_files;
    mp_value cur_exp;
    mp_number max_c[mp_proto_dependent_type + 1];
    mp_value_node max_ptr[mp_proto_dependent_type + 1];
    mp_value_node max_link[mp_proto_dependent_type + 1];
    int var_flag;
    mp_string eof_line;
    mp_string eof_file;
    mp_number txx;
    mp_number txy;
    mp_number tyx;
    mp_number tyy;
    mp_number tx;
    mp_number ty;
    mp_run_data run_data;
    int last_add_type;
    mp_sym every_job_sym;
    int long_help_seen;
    int ten_pow[10];
    int scaled_out;

} MP_instance;
void mp_normalize_selector (MP mp);
void mp_jump_out (MP mp);
void mp_confusion (MP mp, const char *s);
void mp_new_randoms (MP mp);
# define mp_snprintf snprintf
void mp_make_choices (MP mp, mp_knot knots);
void mp_pack_file_name (MP mp, const char *n);
void mp_grow_internals (MP mp, int l);

# define update_terminal()  mp_print_nl_only(mp);
# define clear_terminal()
# define wake_up_terminal() mp_print_nl_only(mp);
typedef enum mp_selectors {
    mp_new_string_selector,
    mp_no_print_selector,
    mp_term_only_selector,
    mp_log_only_selector,
    mp_term_and_log_selector,
    mp_first_file_selector,
} mp_selectors;
typedef enum mp_logging_targets {
    mp_void_logging_target,
    mp_term_logging_target,
    mp_file_logging_target,
    mp_both_logging_target,
    mp_error_logging_target,
} mp_logging_targets;
# define mp_fputs(b,f) (mp->write_file)(mp, f, b)
# define mp_log_string(target,s)  (mp->run_logger)(mp, target, s, strlen(s))
# define mp_log_mpstr(target,s,l) (mp->run_logger)(mp, target, s, l)
# define mp_log_cr(target)        (mp->run_logger)(mp, target, "\n", 1)
# define mp_log_chr(target,s)     { unsigned char ss[2] = { s, 0 }; (mp->run_logger)(mp, target, (const char *) ss, 1); }
# define mp_log_error(s)          (mp->run_logger)(mp, mp_error_logging_target, s, strlen(s))
typedef struct mp_node_data {
    union {
        mp_command_code  command;
        mp_variable_type type;
    };
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  padding;
    struct mp_node_data *link;
    mp_value_data        data;
} mp_node_data;
typedef struct mp_node_data *mp_symbolic_node;
typedef enum mp_linecap_codes {
    mp_butt_linecap_code,
    mp_rounded_linecap_code,
    mp_squared_linecap_code,
    mp_weird_linecap_code,
} mp_linecap_codes;
typedef enum mp_linejoin_codes {
    mp_mitered_linejoin_code,
    mp_rounded_linejoin_code,
    mp_beveled_linejoin_code,
    mp_weird_linejoin_code,
} mp_linejoin_codes;
# define internal_value(A)        mp->internal[(A)].v.data.n
# define internal_string(A)       mp->internal[A].v.data.str
# define set_internal_string(A,B) mp->internal[(A)].v.data.str=(B)
# define internal_name(A)         mp->internal[(A)].intname
# define set_internal_name(A,B)   mp->internal[(A)].intname=(B)
# define internal_type(A)         mp->internal[A].v.type
# define set_internal_type(A,B)   mp->internal[(A)].v.type=(B)
# define internal_run(A)          mp->internal[(A)].run
# define set_internal_run(A,B)    mp->internal[(A)].run=(B)
typedef struct mp_node_data *mp_token_node;
typedef struct mp_value_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  padding;
    struct mp_node_data *link;
    mp_value_data        data;
    mp_number            subscript;
    mp_sym               hashloc_;
    mp_node              parent;
    mp_node              attr_head;
    mp_node              subscr_head;
} mp_value_node_data;
typedef struct mp_pair_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  padding;
    struct mp_node_data *link;
    mp_node              x_part;
    mp_node              y_part;
} mp_pair_node_data;
typedef struct mp_pair_node_data *mp_pair_node;
typedef struct mp_transform_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  padding;
    struct mp_node_data *link;
    mp_node              tx_part;
    mp_node              ty_part;
    mp_node              xx_part;
    mp_node              yx_part;
    mp_node              xy_part;
    mp_node              yy_part;
} mp_transform_node_data;
typedef struct mp_transform_node_data *mp_transform_node;
typedef struct mp_color_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  padding;
    struct mp_node_data *link;
    union {
        mp_node red_part;
        mp_node cyan_part;
    };
    union {
        mp_node green_part;
        mp_node magenta_part;
    };
    union {
        mp_node blue_part;
        mp_node yellow_part;
    };
    union {
        mp_node grey_part;
        mp_node black_part;
    };
} mp_color_node_data;
typedef struct mp_color_node_data *mp_color_node;
typedef struct mp_shape_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  stacking;
    struct mp_node_data *link;
    mp_string            pre_script;
    mp_string            post_script;
    union {
        mp_number        red;
        mp_number        cyan;
    };
    union {
        mp_number        green;
        mp_number        magenta;
    };
    union {
        mp_number        blue;
        mp_number        yellow;
    };
    union {
        mp_number        black;
        mp_number        grey;
    };
    mp_knot              path;
    mp_knot              pen;
    mp_node              dash;
    mp_number            dashscale;
    mp_number            miterlimit;
    unsigned char        color_model;
    unsigned char        linejoin;
    unsigned char        linecap;
    unsigned char        pen_type;
} mp_shape_node_data;
typedef struct mp_shape_node_data *mp_shape_node;
typedef struct mp_start_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  stacking;
    struct mp_node_data *link;
    mp_string            pre_script;
    mp_string            post_script;
    mp_knot              path;
} mp_start_node_data;
typedef struct mp_start_node_data *mp_start_node;
typedef struct mp_stop_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  stacking;
    struct mp_node_data *link;
} mp_stop_node_data;
typedef struct mp_stop_node_data *mp_stop_node;
typedef struct mp_dash_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  padding;
    struct mp_node_data *link;
    mp_number            start_x;
    mp_number            stop_x;
    mp_number            dash_y;
    mp_node              dash_info;
} mp_dash_node_data;
typedef struct mp_edge_header_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  padding;
    struct mp_node_data *link;
    mp_number            start_x;
    mp_number            stop_x;
    mp_number            dash_y;
    mp_node              dash_info;
    mp_number            minx;
    mp_number            miny;
    mp_number            maxx;
    mp_number            maxy;
    mp_node              bblast;
    int                  bbtype;
    int                  ref_count;
    mp_node              list;
    mp_node              obj_tail;
} mp_edge_header_node_data;
typedef struct mp_edge_header_node_data *mp_edge_header_node;
typedef enum mp_bound_codes {
    mp_no_bounds_code,
    mp_bounds_set_code,
    mp_bounds_unset_code,
} mp_bound_codes;
typedef struct mp_if_node_data {
    mp_variable_type     type;
    mp_name_type_type    name_type;
    int                  hasnumber;
    int                  if_line_field;
    struct mp_node_data *link;
} mp_if_node_data;
typedef struct mp_if_node_data *mp_if_node;

struct mp_edge_object *mp_gr_export          (MP mp, mp_edge_header_node h);
mp_graphic_object     *mp_new_graphic_object (MP mp, int type);
void                   mp_gr_toss_objects    (mp_edge_object *hh);
void                   mp_gr_toss_object     (mp_graphic_object *p);

# endif

