/*************************************************************************
* Copyright (C) 2002 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

/*
//
//  Purpose:
//     Cryptography Primitive.
//     Digesting message according to SHA1
//
//  Contents:
//        ippsHashMethod_SHA1()
//
*/

#include "owndefs.h"
#include "owncp.h"
#include "hash/pcphash.h"
#include "hash/pcphash_rmf.h"
#include "pcptool.h"
#include "hash/sha1/pcpsha1stuff.h"

/*F*
//    Name: ippsHashMethod_SHA1
//
// Purpose: Return SHA1 method.
//
// Returns:
//          Pointer to SHA1 hash-method.
//
*F*/

IPPFUN(const IppsHashMethod*, ippsHashMethod_SHA1, (void))
{
    /* Prevents re-initialization for better multi-threaded/repeated call performance */
    static volatile int isInitialized = 0;

    static IppsHashMethod method = { ippHashAlg_SHA1,
                                     IPP_SHA1_DIGEST_BITSIZE / 8,
                                     MBS_SHA1,
                                     MLR_SHA1,
                                     IPP_SHA1_STATE_BYTESIZE,
                                     NULL,
                                     NULL,
                                     NULL,
                                     NULL };
    if (isInitialized) {
        CP_PREVENT_REORDER();
        return &method;
    }

    method.hashInit   = sha1_hashInit;
    method.hashUpdate = sha1_hashUpdate;
    method.hashOctStr = sha1_hashOctString;
    method.msgLenRep  = sha1_msgRep;

    CP_PREVENT_REORDER();
    isInitialized = 1;

    return &method;
}
