/*************************************************************************
* Copyright (C) 2016 Intel Corporation
*
* Licensed under the Apache License,  Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* 	http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law  or agreed  to  in  writing,  software
* distributed under  the License  is  distributed  on  an  "AS IS"  BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the  specific  language  governing  permissions  and
* limitations under the License.
*************************************************************************/

/*
//     Intel(R) Cryptography Primitives Library
//     GF(p) methods
//
*/
#include "owncp.h"
#include "owndefs.h"

#include "gfpec/pcpgfpmethod.h"

/*F*
// Name: ippsGFpMethod_pArb
//
// Purpose: Returns a reference to an implementation of
//          arithmetic operations over GF(q).
//
// Returns:  Pointer to a structure containing an implementation of arithmetic
//           operations over GF(q). Arbitrary modulus q.
*F*/

IPPFUN(const IppsGFpMethod*, ippsGFpMethod_pArb, (void))
{
    /* Prevents re-initialization for better multi-threaded/repeated call performance */
    static volatile int isInitialized = 0;

    static IppsGFpMethod method = { cpID_Prime, 0, NULL, NULL, NULL };
    if (isInitialized) {
        CP_PREVENT_REORDER();
        return &method;
    }

    method.arith = gsArithGFp();

    CP_PREVENT_REORDER();
    isInitialized = 1;

    return &method;
}
