//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsynapse_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ListSqlPoolVulnerabilityAssessmentScanRecords.json
func ExampleSQLPoolVulnerabilityAssessmentScansClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewSQLPoolVulnerabilityAssessmentScansClient().NewListPager("vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.VulnerabilityAssessmentScanRecordListResult = armsynapse.VulnerabilityAssessmentScanRecordListResult{
		// 	Value: []*armsynapse.VulnerabilityAssessmentScanRecord{
		// 		{
		// 			Name: to.Ptr("scan001"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityassessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default/scans/scan001"),
		// 			Properties: &armsynapse.VulnerabilityAssessmentScanRecordProperties{
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:47:06.000Z"); return t}()),
		// 				Errors: []*armsynapse.VulnerabilityAssessmentScanError{
		// 				},
		// 				NumberOfFailedSecurityChecks: to.Ptr[int32](9),
		// 				ScanID: to.Ptr("scan001"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:45:06.000Z"); return t}()),
		// 				State: to.Ptr(armsynapse.VulnerabilityAssessmentScanStatePassed),
		// 				TriggerType: to.Ptr(armsynapse.VulnerabilityAssessmentScanTriggerTypeOnDemand),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("scan002"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityassessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default/scans/scan002"),
		// 			Properties: &armsynapse.VulnerabilityAssessmentScanRecordProperties{
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:47:06.000Z"); return t}()),
		// 				Errors: []*armsynapse.VulnerabilityAssessmentScanError{
		// 				},
		// 				NumberOfFailedSecurityChecks: to.Ptr[int32](9),
		// 				ScanID: to.Ptr("scan002"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:45:06.000Z"); return t}()),
		// 				State: to.Ptr(armsynapse.VulnerabilityAssessmentScanStateFailed),
		// 				TriggerType: to.Ptr(armsynapse.VulnerabilityAssessmentScanTriggerTypeRecurring),
		// 			},
		// 		},
		// 		{
		// 			Name: to.Ptr("scan003"),
		// 			Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/scans"),
		// 			ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityassessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default/scans/scan003"),
		// 			Properties: &armsynapse.VulnerabilityAssessmentScanRecordProperties{
		// 				EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:47:06.000Z"); return t}()),
		// 				Errors: []*armsynapse.VulnerabilityAssessmentScanError{
		// 					{
		// 						Code: to.Ptr("StorageNotFound"),
		// 						Message: to.Ptr("Storage not found"),
		// 				}},
		// 				NumberOfFailedSecurityChecks: to.Ptr[int32](0),
		// 				ScanID: to.Ptr("scan003"),
		// 				StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:45:06.000Z"); return t}()),
		// 				State: to.Ptr(armsynapse.VulnerabilityAssessmentScanStateFailedToRun),
		// 				TriggerType: to.Ptr(armsynapse.VulnerabilityAssessmentScanTriggerTypeRecurring),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ExecuteSqlPoolVulnerabilityAssessmentScans.json
func ExampleSQLPoolVulnerabilityAssessmentScansClient_BeginInitiateScan() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewSQLPoolVulnerabilityAssessmentScansClient().BeginInitiateScan(ctx, "vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, "scan01", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/ExportSqlPoolVulnerabilityAssessmentScan.json
func ExampleSQLPoolVulnerabilityAssessmentScansClient_Export() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLPoolVulnerabilityAssessmentScansClient().Export(ctx, "vulnerabilityassessmenttest-4799", "vulnerabilityassessmenttest-6440", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, "scan001", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.SQLPoolVulnerabilityAssessmentScansExport = armsynapse.SQLPoolVulnerabilityAssessmentScansExport{
	// 	Name: to.Ptr("scan001"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/scans/export"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityassessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default/scans/scan001/export"),
	// 	Properties: &armsynapse.SQLPoolVulnerabilityAssessmentScanExportProperties{
	// 		ExportedReportLocation: to.Ptr("https://myaccount.blob.core.windows.net/vulnerabilityAssessment/vulnerabilityassessmenttest-6440/testdb/scan001.xlsx"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/630ec444f8dd7c09b9cdd5fa99951f8a0d1ad41f/specification/synapse/resource-manager/Microsoft.Synapse/stable/2021-06-01/examples/SqlPoolVulnerabilityAssessmentScanRecordsGet.json
func ExampleSQLPoolVulnerabilityAssessmentScansClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armsynapse.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewSQLPoolVulnerabilityAssessmentScansClient().Get(ctx, "vulnerabilityassessmenttest-4711", "vulnerabilityassessmenttest-6411", "testdb", armsynapse.VulnerabilityAssessmentNameDefault, "scan001", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.VulnerabilityAssessmentScanRecord = armsynapse.VulnerabilityAssessmentScanRecord{
	// 	Name: to.Ptr("scan001"),
	// 	Type: to.Ptr("Microsoft.Synapse/workspaces/sqlPools/vulnerabilityAssessments/scans"),
	// 	ID: to.Ptr("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/vulnerabilityassessmenttest-4799/providers/Microsoft.Synapse/workspaces/vulnerabilityassessmenttest-6440/sqlPools/testdb/vulnerabilityAssessments/default/scans/scan001"),
	// 	Properties: &armsynapse.VulnerabilityAssessmentScanRecordProperties{
	// 		EndTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:47:06.000Z"); return t}()),
	// 		Errors: []*armsynapse.VulnerabilityAssessmentScanError{
	// 		},
	// 		NumberOfFailedSecurityChecks: to.Ptr[int32](9),
	// 		ScanID: to.Ptr("scan001"),
	// 		StartTime: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-12-12T17:45:06.000Z"); return t}()),
	// 		State: to.Ptr(armsynapse.VulnerabilityAssessmentScanStatePassed),
	// 		StorageContainerPath: to.Ptr("https://myaccount.blob.core.windows.net/vulnerability-assessment"),
	// 		TriggerType: to.Ptr(armsynapse.VulnerabilityAssessmentScanTriggerTypeOnDemand),
	// 	},
	// }
}
