//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedInstancePrivateLinkResourcesServer is a fake server for instances of the armsql.ManagedInstancePrivateLinkResourcesClient type.
type ManagedInstancePrivateLinkResourcesServer struct {
	// Get is the fake for method ManagedInstancePrivateLinkResourcesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, groupName string, options *armsql.ManagedInstancePrivateLinkResourcesClientGetOptions) (resp azfake.Responder[armsql.ManagedInstancePrivateLinkResourcesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByManagedInstancePager is the fake for method ManagedInstancePrivateLinkResourcesClient.NewListByManagedInstancePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByManagedInstancePager func(resourceGroupName string, managedInstanceName string, options *armsql.ManagedInstancePrivateLinkResourcesClientListByManagedInstanceOptions) (resp azfake.PagerResponder[armsql.ManagedInstancePrivateLinkResourcesClientListByManagedInstanceResponse])
}

// NewManagedInstancePrivateLinkResourcesServerTransport creates a new instance of ManagedInstancePrivateLinkResourcesServerTransport with the provided implementation.
// The returned ManagedInstancePrivateLinkResourcesServerTransport instance is connected to an instance of armsql.ManagedInstancePrivateLinkResourcesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedInstancePrivateLinkResourcesServerTransport(srv *ManagedInstancePrivateLinkResourcesServer) *ManagedInstancePrivateLinkResourcesServerTransport {
	return &ManagedInstancePrivateLinkResourcesServerTransport{
		srv:                           srv,
		newListByManagedInstancePager: newTracker[azfake.PagerResponder[armsql.ManagedInstancePrivateLinkResourcesClientListByManagedInstanceResponse]](),
	}
}

// ManagedInstancePrivateLinkResourcesServerTransport connects instances of armsql.ManagedInstancePrivateLinkResourcesClient to instances of ManagedInstancePrivateLinkResourcesServer.
// Don't use this type directly, use NewManagedInstancePrivateLinkResourcesServerTransport instead.
type ManagedInstancePrivateLinkResourcesServerTransport struct {
	srv                           *ManagedInstancePrivateLinkResourcesServer
	newListByManagedInstancePager *tracker[azfake.PagerResponder[armsql.ManagedInstancePrivateLinkResourcesClientListByManagedInstanceResponse]]
}

// Do implements the policy.Transporter interface for ManagedInstancePrivateLinkResourcesServerTransport.
func (m *ManagedInstancePrivateLinkResourcesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedInstancePrivateLinkResourcesClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedInstancePrivateLinkResourcesClient.NewListByManagedInstancePager":
		resp, err = m.dispatchNewListByManagedInstancePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedInstancePrivateLinkResourcesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources/(?P<groupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	groupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("groupName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, groupNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ManagedInstancePrivateLink, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedInstancePrivateLinkResourcesServerTransport) dispatchNewListByManagedInstancePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByManagedInstancePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByManagedInstancePager not implemented")}
	}
	newListByManagedInstancePager := m.newListByManagedInstancePager.get(req)
	if newListByManagedInstancePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/privateLinkResources`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByManagedInstancePager(resourceGroupNameParam, managedInstanceNameParam, nil)
		newListByManagedInstancePager = &resp
		m.newListByManagedInstancePager.add(req, newListByManagedInstancePager)
		server.PagerResponderInjectNextLinks(newListByManagedInstancePager, req, func(page *armsql.ManagedInstancePrivateLinkResourcesClientListByManagedInstanceResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByManagedInstancePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByManagedInstancePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByManagedInstancePager) {
		m.newListByManagedInstancePager.remove(req)
	}
	return resp, nil
}
