//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DatabaseSQLVulnerabilityAssessmentBaselinesServer is a fake server for instances of the armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClient type.
type DatabaseSQLVulnerabilityAssessmentBaselinesServer struct {
	// CreateOrUpdate is the fake for method DatabaseSQLVulnerabilityAssessmentBaselinesClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, baselineName armsql.BaselineName, parameters armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput, options *armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateOptions) (resp azfake.Responder[armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DatabaseSQLVulnerabilityAssessmentBaselinesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, baselineName armsql.BaselineName, options *armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientGetOptions) (resp azfake.Responder[armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListBySQLVulnerabilityAssessmentPager is the fake for method DatabaseSQLVulnerabilityAssessmentBaselinesClient.NewListBySQLVulnerabilityAssessmentPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySQLVulnerabilityAssessmentPager func(resourceGroupName string, serverName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentOptions) (resp azfake.PagerResponder[armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse])
}

// NewDatabaseSQLVulnerabilityAssessmentBaselinesServerTransport creates a new instance of DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport with the provided implementation.
// The returned DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport instance is connected to an instance of armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDatabaseSQLVulnerabilityAssessmentBaselinesServerTransport(srv *DatabaseSQLVulnerabilityAssessmentBaselinesServer) *DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport {
	return &DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport{
		srv:                                      srv,
		newListBySQLVulnerabilityAssessmentPager: newTracker[azfake.PagerResponder[armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse]](),
	}
}

// DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport connects instances of armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClient to instances of DatabaseSQLVulnerabilityAssessmentBaselinesServer.
// Don't use this type directly, use NewDatabaseSQLVulnerabilityAssessmentBaselinesServerTransport instead.
type DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport struct {
	srv                                      *DatabaseSQLVulnerabilityAssessmentBaselinesServer
	newListBySQLVulnerabilityAssessmentPager *tracker[azfake.PagerResponder[armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse]]
}

// Do implements the policy.Transporter interface for DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport.
func (d *DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DatabaseSQLVulnerabilityAssessmentBaselinesClient.CreateOrUpdate":
		resp, err = d.dispatchCreateOrUpdate(req)
	case "DatabaseSQLVulnerabilityAssessmentBaselinesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DatabaseSQLVulnerabilityAssessmentBaselinesClient.NewListBySQLVulnerabilityAssessmentPager":
		resp, err = d.dispatchNewListBySQLVulnerabilityAssessmentPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsql.DatabaseSQLVulnerabilityAssessmentRuleBaselineListInput](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsql.BaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.BaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, baselineNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseSQLVulnerabilityAssessmentBaselineSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines/(?P<baselineName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	baselineNameParam, err := parseWithCast(matches[regex.SubexpIndex("baselineName")], func(v string) (armsql.BaselineName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.BaselineName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, baselineNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseSQLVulnerabilityAssessmentBaselineSet, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DatabaseSQLVulnerabilityAssessmentBaselinesServerTransport) dispatchNewListBySQLVulnerabilityAssessmentPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListBySQLVulnerabilityAssessmentPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySQLVulnerabilityAssessmentPager not implemented")}
	}
	newListBySQLVulnerabilityAssessmentPager := d.newListBySQLVulnerabilityAssessmentPager.get(req)
	if newListBySQLVulnerabilityAssessmentPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/servers/(?P<serverName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlVulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/baselines`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serverNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serverName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListBySQLVulnerabilityAssessmentPager(resourceGroupNameParam, serverNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, nil)
		newListBySQLVulnerabilityAssessmentPager = &resp
		d.newListBySQLVulnerabilityAssessmentPager.add(req, newListBySQLVulnerabilityAssessmentPager)
		server.PagerResponderInjectNextLinks(newListBySQLVulnerabilityAssessmentPager, req, func(page *armsql.DatabaseSQLVulnerabilityAssessmentBaselinesClientListBySQLVulnerabilityAssessmentResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySQLVulnerabilityAssessmentPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListBySQLVulnerabilityAssessmentPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySQLVulnerabilityAssessmentPager) {
		d.newListBySQLVulnerabilityAssessmentPager.remove(req)
	}
	return resp, nil
}
