//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/recoveryservices/armrecoveryservicesbackup/v3"
	"net/http"
	"net/url"
	"regexp"
)

// FeatureSupportServer is a fake server for instances of the armrecoveryservicesbackup.FeatureSupportClient type.
type FeatureSupportServer struct {
	// Validate is the fake for method FeatureSupportClient.Validate
	// HTTP status codes to indicate success: http.StatusOK
	Validate func(ctx context.Context, azureRegion string, parameters armrecoveryservicesbackup.FeatureSupportRequestClassification, options *armrecoveryservicesbackup.FeatureSupportClientValidateOptions) (resp azfake.Responder[armrecoveryservicesbackup.FeatureSupportClientValidateResponse], errResp azfake.ErrorResponder)
}

// NewFeatureSupportServerTransport creates a new instance of FeatureSupportServerTransport with the provided implementation.
// The returned FeatureSupportServerTransport instance is connected to an instance of armrecoveryservicesbackup.FeatureSupportClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFeatureSupportServerTransport(srv *FeatureSupportServer) *FeatureSupportServerTransport {
	return &FeatureSupportServerTransport{srv: srv}
}

// FeatureSupportServerTransport connects instances of armrecoveryservicesbackup.FeatureSupportClient to instances of FeatureSupportServer.
// Don't use this type directly, use NewFeatureSupportServerTransport instead.
type FeatureSupportServerTransport struct {
	srv *FeatureSupportServer
}

// Do implements the policy.Transporter interface for FeatureSupportServerTransport.
func (f *FeatureSupportServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "FeatureSupportClient.Validate":
		resp, err = f.dispatchValidate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (f *FeatureSupportServerTransport) dispatchValidate(req *http.Request) (*http.Response, error) {
	if f.srv.Validate == nil {
		return nil, &nonRetriableError{errors.New("fake for method Validate not implemented")}
	}
	const regexStr = `/Subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.RecoveryServices/locations/(?P<azureRegion>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/backupValidateFeatures`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 2 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	raw, err := readRequestBody(req)
	if err != nil {
		return nil, err
	}
	body, err := unmarshalFeatureSupportRequestClassification(raw)
	if err != nil {
		return nil, err
	}
	azureRegionParam, err := url.PathUnescape(matches[regex.SubexpIndex("azureRegion")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.Validate(req.Context(), azureRegionParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AzureVMResourceFeatureSupportResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
