//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armproviderhub_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/providerhub/armproviderhub"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/ProviderRegistrations_Get.json
func ExampleProviderRegistrationsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armproviderhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProviderRegistrationsClient().Get(ctx, "Microsoft.Contoso", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderRegistration = armproviderhub.ProviderRegistration{
	// 	Properties: &armproviderhub.ProviderRegistrationProperties{
	// 		Capabilities: []*armproviderhub.ResourceProviderCapabilities{
	// 			{
	// 				Effect: to.Ptr(armproviderhub.ResourceProviderCapabilitiesEffectAllow),
	// 				QuotaID: to.Ptr("CSP_2015-05-01"),
	// 			},
	// 			{
	// 				Effect: to.Ptr(armproviderhub.ResourceProviderCapabilitiesEffectAllow),
	// 				QuotaID: to.Ptr("CSP_MG_2017-12-01"),
	// 		}},
	// 		Management: &armproviderhub.ResourceProviderManifestPropertiesManagement{
	// 			IncidentContactEmail: to.Ptr("helpme@contoso.com"),
	// 			IncidentRoutingService: to.Ptr(""),
	// 			IncidentRoutingTeam: to.Ptr(""),
	// 			ManifestOwners: []*string{
	// 				to.Ptr("SPARTA-PlatformServiceAdministrator")},
	// 				ResourceAccessPolicy: to.Ptr(armproviderhub.ResourceProviderManagementResourceAccessPolicyNotSpecified),
	// 			},
	// 			Namespace: to.Ptr("microsoft.contoso"),
	// 			ProviderAuthorizations: []*armproviderhub.ResourceProviderAuthorization{
	// 				{
	// 					ApplicationID: to.Ptr("1a3b5c7d-8e9f-10g1-1h12-i13j14k1"),
	// 					RoleDefinitionID: to.Ptr("123456bf-gkur-2098-b890-98da392a00b2"),
	// 			}},
	// 			ProviderType: to.Ptr(armproviderhub.ResourceProviderType("Internal, Hidden")),
	// 			ProviderVersion: to.Ptr("2.0"),
	// 			ProviderHubMetadata: &armproviderhub.ProviderRegistrationPropertiesProviderHubMetadata{
	// 				ProviderAuthentication: &armproviderhub.MetadataProviderAuthentication{
	// 					AllowedAudiences: []*string{
	// 						to.Ptr("https://management.core.windows.net/")},
	// 					},
	// 				},
	// 				ProvisioningState: to.Ptr(armproviderhub.ProvisioningStateSucceeded),
	// 			},
	// 		}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/ProviderRegistrations_CreateOrUpdate.json
func ExampleProviderRegistrationsClient_BeginCreateOrUpdate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armproviderhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewProviderRegistrationsClient().BeginCreateOrUpdate(ctx, "Microsoft.Contoso", armproviderhub.ProviderRegistration{
		Properties: &armproviderhub.ProviderRegistrationProperties{
			Capabilities: []*armproviderhub.ResourceProviderCapabilities{
				{
					Effect:  to.Ptr(armproviderhub.ResourceProviderCapabilitiesEffectAllow),
					QuotaID: to.Ptr("CSP_2015-05-01"),
				},
				{
					Effect:  to.Ptr(armproviderhub.ResourceProviderCapabilitiesEffectAllow),
					QuotaID: to.Ptr("CSP_MG_2017-12-01"),
				}},
			Management: &armproviderhub.ResourceProviderManifestPropertiesManagement{
				IncidentContactEmail:   to.Ptr("helpme@contoso.com"),
				IncidentRoutingService: to.Ptr("Contoso Resource Provider"),
				IncidentRoutingTeam:    to.Ptr("Contoso Triage"),
			},
			ProviderType:    to.Ptr(armproviderhub.ResourceProviderTypeInternal),
			ProviderVersion: to.Ptr("2.0"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ProviderRegistration = armproviderhub.ProviderRegistration{
	// 	Properties: &armproviderhub.ProviderRegistrationProperties{
	// 		Capabilities: []*armproviderhub.ResourceProviderCapabilities{
	// 			{
	// 				Effect: to.Ptr(armproviderhub.ResourceProviderCapabilitiesEffectAllow),
	// 				QuotaID: to.Ptr("CSP_2015-05-01"),
	// 			},
	// 			{
	// 				Effect: to.Ptr(armproviderhub.ResourceProviderCapabilitiesEffectAllow),
	// 				QuotaID: to.Ptr("CSP_MG_2017-12-01"),
	// 		}},
	// 		Management: &armproviderhub.ResourceProviderManifestPropertiesManagement{
	// 			IncidentContactEmail: to.Ptr("helpme@contoso.com"),
	// 			IncidentRoutingService: to.Ptr(""),
	// 			IncidentRoutingTeam: to.Ptr(""),
	// 			ManifestOwners: []*string{
	// 				to.Ptr("manifestOwners-group")},
	// 				ResourceAccessPolicy: to.Ptr(armproviderhub.ResourceProviderManagementResourceAccessPolicyNotSpecified),
	// 			},
	// 			Metadata: map[string]any{
	// 				"onboardedVia": "ProviderHub",
	// 			},
	// 			Namespace: to.Ptr("Microsoft.Contoso"),
	// 			ProviderAuthorizations: []*armproviderhub.ResourceProviderAuthorization{
	// 				{
	// 					ApplicationID: to.Ptr("1a3b5c7d-8e9f-10g1-1h12-i13j14k1"),
	// 					RoleDefinitionID: to.Ptr("123456bf-gkur-2098-b890-98da392a00b2"),
	// 			}},
	// 			ProviderType: to.Ptr(armproviderhub.ResourceProviderType("Internal, Hidden")),
	// 			ProviderVersion: to.Ptr("2.0"),
	// 			ProvisioningState: to.Ptr(armproviderhub.ProvisioningStateSucceeded),
	// 		},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/ProviderRegistrations_Delete.json
func ExampleProviderRegistrationsClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armproviderhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewProviderRegistrationsClient().Delete(ctx, "Microsoft.Contoso", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/ProviderRegistrations_List.json
func ExampleProviderRegistrationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armproviderhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewProviderRegistrationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ProviderRegistrationArrayResponseWithContinuation = armproviderhub.ProviderRegistrationArrayResponseWithContinuation{
		// 	Value: []*armproviderhub.ProviderRegistration{
		// 		{
		// 			Properties: &armproviderhub.ProviderRegistrationProperties{
		// 				Capabilities: []*armproviderhub.ResourceProviderCapabilities{
		// 					{
		// 						Effect: to.Ptr(armproviderhub.ResourceProviderCapabilitiesEffectAllow),
		// 						QuotaID: to.Ptr("CSP_2015-05-01"),
		// 					},
		// 					{
		// 						Effect: to.Ptr(armproviderhub.ResourceProviderCapabilitiesEffectAllow),
		// 						QuotaID: to.Ptr("CSP_MG_2017-12-01"),
		// 				}},
		// 				Management: &armproviderhub.ResourceProviderManifestPropertiesManagement{
		// 					IncidentContactEmail: to.Ptr("helpme@contoso.com"),
		// 					IncidentRoutingService: to.Ptr(""),
		// 					IncidentRoutingTeam: to.Ptr(""),
		// 					ManifestOwners: []*string{
		// 						to.Ptr("manifestOwners-group")},
		// 						ResourceAccessPolicy: to.Ptr(armproviderhub.ResourceProviderManagementResourceAccessPolicyNotSpecified),
		// 					},
		// 					Namespace: to.Ptr("microsoft.contoso"),
		// 					ProviderAuthorizations: []*armproviderhub.ResourceProviderAuthorization{
		// 						{
		// 							ApplicationID: to.Ptr("1a3b5c7d-8e9f-10g1-1h12-i13j14k1"),
		// 							RoleDefinitionID: to.Ptr("123456bf-gkur-2098-b890-98da392a00b2"),
		// 					}},
		// 					ProviderType: to.Ptr(armproviderhub.ResourceProviderType("Internal, Hidden")),
		// 					ProviderVersion: to.Ptr("2.0"),
		// 					ProviderHubMetadata: &armproviderhub.ProviderRegistrationPropertiesProviderHubMetadata{
		// 						ProviderAuthentication: &armproviderhub.MetadataProviderAuthentication{
		// 							AllowedAudiences: []*string{
		// 								to.Ptr("https://management.core.windows.net/")},
		// 							},
		// 						},
		// 						ProvisioningState: to.Ptr(armproviderhub.ProvisioningStateSucceeded),
		// 					},
		// 			}},
		// 		}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/7a2ac91de424f271cf91cc8009f3fe9ee8249086/specification/providerhub/resource-manager/Microsoft.ProviderHub/stable/2020-11-20/examples/ProviderRegistrations_GenerateOperations.json
func ExampleProviderRegistrationsClient_GenerateOperations() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armproviderhub.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewProviderRegistrationsClient().GenerateOperations(ctx, "Microsoft.Contoso", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationsDefinitionArray = []*armproviderhub.OperationsDefinition{
	// 	{
	// 		Name: to.Ptr("Microsoft.Contoso/Employees/Read"),
	// 		Display: &armproviderhub.OperationsDefinitionDisplay{
	// 			Description: to.Ptr("Read employees"),
	// 			Operation: to.Ptr("Gets/List employee resources"),
	// 			Provider: to.Ptr("Microsoft.Contoso"),
	// 			Resource: to.Ptr("Employees"),
	// 		},
	// 		IsDataAction: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Contoso/Employees/Write"),
	// 		Display: &armproviderhub.OperationsDefinitionDisplay{
	// 			Description: to.Ptr("Writes employees"),
	// 			Operation: to.Ptr("Create/update employee resources"),
	// 			Provider: to.Ptr("Microsoft.Contoso"),
	// 			Resource: to.Ptr("Employees"),
	// 		},
	// 		IsDataAction: to.Ptr(false),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Contoso/Employees/Delete"),
	// 		Display: &armproviderhub.OperationsDefinitionDisplay{
	// 			Description: to.Ptr("Deletes employees"),
	// 			Operation: to.Ptr("Deletes employee resource"),
	// 			Provider: to.Ptr("Microsoft.Contoso"),
	// 			Resource: to.Ptr("Employees"),
	// 		},
	// 		IsDataAction: to.Ptr(false),
	// 		Origin: to.Ptr(armproviderhub.OperationsDefinitionOriginUser),
	// 	},
	// 	{
	// 		Name: to.Ptr("Microsoft.Contoso/Employees/Action"),
	// 		Display: &armproviderhub.OperationsDefinitionDisplay{
	// 			Description: to.Ptr("Writes employees"),
	// 			Operation: to.Ptr("Create/update employee resources"),
	// 			Provider: to.Ptr("Microsoft.Contoso"),
	// 			Resource: to.Ptr("Employees"),
	// 		},
	// 		IsDataAction: to.Ptr(true),
	// 		Origin: to.Ptr(armproviderhub.OperationsDefinitionOriginSystem),
	// }}
}
