//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armfluidrelay_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/fluidrelay/armfluidrelay"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Get.json
func ExampleServersClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().Get(ctx, "myResourceGroup", "myFluidRelayServer", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Server = armfluidrelay.Server{
	// 	Name: to.Ptr("myFluidRelayServer"),
	// 	Type: to.Ptr("Microsoft.FluidRelay/fluidRelayServers"),
	// 	ID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/Microsoft.FluidRelay/fluidRelayServers/myFluidRelayServer"),
	// 	Location: to.Ptr("west-us"),
	// 	Properties: &armfluidrelay.ServerProperties{
	// 		FluidRelayEndpoints: &armfluidrelay.Endpoints{
	// 			OrdererEndpoints: []*string{
	// 				to.Ptr("https://www.contoso.org/orderer")},
	// 				ServiceEndpoints: []*string{
	// 					to.Ptr("https://www.afd.contoso.org")},
	// 					StorageEndpoints: []*string{
	// 						to.Ptr("https://www.contoso.org/storage")},
	// 					},
	// 					FrsTenantID: to.Ptr("yyyy-yyyy-yyyyy-yyyy"),
	// 					ProvisioningState: to.Ptr(armfluidrelay.ProvisioningStateSucceeded),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_CreateOrUpdate.json
func ExampleServersClient_CreateOrUpdate_createAFluidRelayServer() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().CreateOrUpdate(ctx, "myResourceGroup", "myFluidRelayServer", armfluidrelay.Server{
		Location: to.Ptr("west-us"),
		Tags: map[string]*string{
			"Category": to.Ptr("sales"),
		},
		Identity: &armfluidrelay.Identity{
			Type: to.Ptr(armfluidrelay.ResourceIdentityTypeSystemAssigned),
		},
		Properties: &armfluidrelay.ServerProperties{
			Storagesku: to.Ptr(armfluidrelay.StorageSKUBasic),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Server = armfluidrelay.Server{
	// 	Name: to.Ptr("myFluidRelayServer"),
	// 	Type: to.Ptr("Microsoft.FluidRelay/fluidRelayServers"),
	// 	ID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/Microsoft.FluidRelay/fluidRelayServers/myFluidRelayServer"),
	// 	Location: to.Ptr("west-us"),
	// 	Identity: &armfluidrelay.Identity{
	// 		Type: to.Ptr(armfluidrelay.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 	},
	// 	Properties: &armfluidrelay.ServerProperties{
	// 		FluidRelayEndpoints: &armfluidrelay.Endpoints{
	// 			OrdererEndpoints: []*string{
	// 				to.Ptr("https://www.contoso.org/orderer")},
	// 				ServiceEndpoints: []*string{
	// 					to.Ptr("https://www.afd.contoso.org")},
	// 					StorageEndpoints: []*string{
	// 						to.Ptr("https://www.contoso.org/storage")},
	// 					},
	// 					FrsTenantID: to.Ptr("yyyy-yyyy-yyyyy-yyyy"),
	// 					ProvisioningState: to.Ptr(armfluidrelay.ProvisioningStateSucceeded),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_CreateWithAmi.json
func ExampleServersClient_CreateOrUpdate_createAFluidRelayServerWithAmi() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().CreateOrUpdate(ctx, "myResourceGroup", "myFluidRelayServer", armfluidrelay.Server{
		Location: to.Ptr("west-us"),
		Tags: map[string]*string{
			"Category": to.Ptr("sales"),
		},
		Identity: &armfluidrelay.Identity{
			Type: to.Ptr(armfluidrelay.ResourceIdentityTypeSystemAssignedUserAssigned),
			UserAssignedIdentities: map[string]*armfluidrelay.UserAssignedIdentitiesValue{
				"/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
				"/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": {},
			},
		},
		Properties: &armfluidrelay.ServerProperties{
			Storagesku: to.Ptr(armfluidrelay.StorageSKUBasic),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Server = armfluidrelay.Server{
	// 	Name: to.Ptr("myFluidRelayServer"),
	// 	Type: to.Ptr("Microsoft.FluidRelay/fluidRelayServers"),
	// 	ID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/Microsoft.FluidRelay/fluidRelayServers/myFluidRelayServer"),
	// 	Location: to.Ptr("west-us"),
	// 	Identity: &armfluidrelay.Identity{
	// 		Type: to.Ptr(armfluidrelay.ResourceIdentityTypeSystemAssigned),
	// 		PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		UserAssignedIdentities: map[string]*armfluidrelay.UserAssignedIdentitiesValue{
	// 			"/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": &armfluidrelay.UserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 			"/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id2": &armfluidrelay.UserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armfluidrelay.ServerProperties{
	// 		FluidRelayEndpoints: &armfluidrelay.Endpoints{
	// 			OrdererEndpoints: []*string{
	// 				to.Ptr("https://www.contoso.org/orderer")},
	// 				ServiceEndpoints: []*string{
	// 					to.Ptr("https://www.afd.contoso.org")},
	// 					StorageEndpoints: []*string{
	// 						to.Ptr("https://www.contoso.org/storage")},
	// 					},
	// 					FrsTenantID: to.Ptr("yyyy-yyyy-yyyyy-yyyy"),
	// 					ProvisioningState: to.Ptr(armfluidrelay.ProvisioningStateSucceeded),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_CreateWithCmk.json
func ExampleServersClient_CreateOrUpdate_createAFluidRelayServerWithCmk() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().CreateOrUpdate(ctx, "myResourceGroup", "myFluidRelayServer", armfluidrelay.Server{
		Location: to.Ptr("west-us"),
		Tags: map[string]*string{
			"Category": to.Ptr("sales"),
		},
		Identity: &armfluidrelay.Identity{
			Type: to.Ptr(armfluidrelay.ResourceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armfluidrelay.UserAssignedIdentitiesValue{
				"/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityForCMK": {},
			},
		},
		Properties: &armfluidrelay.ServerProperties{
			Encryption: &armfluidrelay.EncryptionProperties{
				CustomerManagedKeyEncryption: &armfluidrelay.CustomerManagedKeyEncryptionProperties{
					KeyEncryptionKeyIdentity: &armfluidrelay.CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentity{
						IdentityType:                   to.Ptr(armfluidrelay.CmkIdentityTypeUserAssigned),
						UserAssignedIdentityResourceID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityForCMK"),
					},
					KeyEncryptionKeyURL: to.Ptr("https://contosovault.vault.azure.net/keys/contosokek"),
				},
			},
			Storagesku: to.Ptr(armfluidrelay.StorageSKUBasic),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Server = armfluidrelay.Server{
	// 	Name: to.Ptr("myFluidRelayServer"),
	// 	Type: to.Ptr("Microsoft.FluidRelay/fluidRelayServers"),
	// 	ID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/Microsoft.FluidRelay/fluidRelayServers/myFluidRelayServer"),
	// 	Location: to.Ptr("west-us"),
	// 	Identity: &armfluidrelay.Identity{
	// 		Type: to.Ptr(armfluidrelay.ResourceIdentityTypeUserAssigned),
	// 		PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		UserAssignedIdentities: map[string]*armfluidrelay.UserAssignedIdentitiesValue{
	// 			"/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityForCMK": &armfluidrelay.UserAssignedIdentitiesValue{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armfluidrelay.ServerProperties{
	// 		Encryption: &armfluidrelay.EncryptionProperties{
	// 			CustomerManagedKeyEncryption: &armfluidrelay.CustomerManagedKeyEncryptionProperties{
	// 				KeyEncryptionKeyIdentity: &armfluidrelay.CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentity{
	// 					IdentityType: to.Ptr(armfluidrelay.CmkIdentityTypeUserAssigned),
	// 					UserAssignedIdentityResourceID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userAssignedIdentities/identityForCMK"),
	// 				},
	// 				KeyEncryptionKeyURL: to.Ptr("https://contosovault.vault.azure.net/keys/contosokek"),
	// 			},
	// 		},
	// 		FluidRelayEndpoints: &armfluidrelay.Endpoints{
	// 			OrdererEndpoints: []*string{
	// 				to.Ptr("https://www.contoso.org/orderer")},
	// 				ServiceEndpoints: []*string{
	// 					to.Ptr("https://www.afd.contoso.org")},
	// 					StorageEndpoints: []*string{
	// 						to.Ptr("https://www.contoso.org/storage")},
	// 					},
	// 					FrsTenantID: to.Ptr("yyyy-yyyy-yyyyy-yyyy"),
	// 					ProvisioningState: to.Ptr(armfluidrelay.ProvisioningStateSucceeded),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Update.json
func ExampleServersClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().Update(ctx, "myResourceGroup", "myFluidRelayServer", armfluidrelay.ServerUpdate{
		Tags: map[string]*string{
			"Category": to.Ptr("sales"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.Server = armfluidrelay.Server{
	// 	Name: to.Ptr("myFluidRelayServer"),
	// 	Type: to.Ptr("Microsoft.FluidRelay/fluidRelayServers"),
	// 	ID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/Microsoft.FluidRelay/fluidRelayServers/myFluidRelayServer"),
	// 	Location: to.Ptr("west-us"),
	// 	Tags: map[string]*string{
	// 		"Category": to.Ptr("sales"),
	// 	},
	// 	Properties: &armfluidrelay.ServerProperties{
	// 		FluidRelayEndpoints: &armfluidrelay.Endpoints{
	// 			OrdererEndpoints: []*string{
	// 				to.Ptr("https://www.contoso.org/orderer")},
	// 				ServiceEndpoints: []*string{
	// 					to.Ptr("https://www.afd.contoso.org")},
	// 					StorageEndpoints: []*string{
	// 						to.Ptr("https://www.contoso.org/storage")},
	// 					},
	// 					FrsTenantID: to.Ptr("yyyy-yyyy-yyyyy-yyyy"),
	// 					ProvisioningState: to.Ptr(armfluidrelay.ProvisioningStateSucceeded),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_Delete.json
func ExampleServersClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewServersClient().Delete(ctx, "myResourceGroup", "myFluidRelayServer", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_RegenerateKeys.json
func ExampleServersClient_RegenerateKey() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().RegenerateKey(ctx, "myResourceGroup", "myFluidRelayServer", armfluidrelay.RegenerateKeyRequest{
		KeyName: to.Ptr(armfluidrelay.KeyNameKey1),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerKeys = armfluidrelay.ServerKeys{
	// 	Key1: to.Ptr("xxx-xxxx-xxxxx-xxxx"),
	// 	Key2: to.Ptr("yyy-yyyy-yyyyy-yyyy"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_ListKeys.json
func ExampleServersClient_ListKeys() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewServersClient().ListKeys(ctx, "myResourceGroup", "myFluidRelayServer", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServerKeys = armfluidrelay.ServerKeys{
	// 	Key1: to.Ptr("xxx-xxxx-xxxxx-xxxx"),
	// 	Key2: to.Ptr("yyy-yyyy-yyyyy-yyyy"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_ListBySubscription.json
func ExampleServersClient_NewListBySubscriptionPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServersClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServerList = armfluidrelay.ServerList{
		// 	Value: []*armfluidrelay.Server{
		// 		{
		// 			Name: to.Ptr("myFluidRelayServer"),
		// 			Type: to.Ptr("Microsoft.FluidRelay/fluidRelayServers"),
		// 			ID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/Microsoft.FluidRelay/fluidRelayServers/myFluidRelayServer"),
		// 			Location: to.Ptr("west-us"),
		// 			Properties: &armfluidrelay.ServerProperties{
		// 				FluidRelayEndpoints: &armfluidrelay.Endpoints{
		// 					OrdererEndpoints: []*string{
		// 						to.Ptr("https://www.contoso.org/orderer")},
		// 						ServiceEndpoints: []*string{
		// 							to.Ptr("https://www.afd.contoso.org")},
		// 							StorageEndpoints: []*string{
		// 								to.Ptr("https://www.contoso.org/storage")},
		// 							},
		// 							FrsTenantID: to.Ptr("yyyy-yyyy-yyyyy-yyyy"),
		// 							ProvisioningState: to.Ptr(armfluidrelay.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/432872fac1d0f8edcae98a0e8504afc0ee302710/specification/fluidrelay/resource-manager/Microsoft.FluidRelay/stable/2022-06-01/examples/FluidRelayServers_ListByResourceGroup.json
func ExampleServersClient_NewListByResourceGroupPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armfluidrelay.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewServersClient().NewListByResourceGroupPager("myResourceGroup", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ServerList = armfluidrelay.ServerList{
		// 	Value: []*armfluidrelay.Server{
		// 		{
		// 			Name: to.Ptr("myFluidRelayServer"),
		// 			Type: to.Ptr("Microsoft.FluidRelay/fluidRelayServers"),
		// 			ID: to.Ptr("/subscriptions/xxxx-xxxx-xxxx-xxxx/resourceGroups/myResourceGroup/Microsoft.FluidRelay/fluidRelayServers/myFluidRelayServer"),
		// 			Location: to.Ptr("west-us"),
		// 			Properties: &armfluidrelay.ServerProperties{
		// 				FluidRelayEndpoints: &armfluidrelay.Endpoints{
		// 					OrdererEndpoints: []*string{
		// 						to.Ptr("https://www.contoso.org/orderer")},
		// 						ServiceEndpoints: []*string{
		// 							to.Ptr("https://www.afd.contoso.org")},
		// 							StorageEndpoints: []*string{
		// 								to.Ptr("https://www.contoso.org/storage")},
		// 							},
		// 							FrsTenantID: to.Ptr("yyyy-yyyy-yyyyy-yyyy"),
		// 							ProvisioningState: to.Ptr(armfluidrelay.ProvisioningStateSucceeded),
		// 						},
		// 				}},
		// 			}
	}
}
