//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/devcenter/armdevcenter"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// CustomizationTasksServer is a fake server for instances of the armdevcenter.CustomizationTasksClient type.
type CustomizationTasksServer struct {
	// Get is the fake for method CustomizationTasksClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, devCenterName string, catalogName string, taskName string, options *armdevcenter.CustomizationTasksClientGetOptions) (resp azfake.Responder[armdevcenter.CustomizationTasksClientGetResponse], errResp azfake.ErrorResponder)

	// GetErrorDetails is the fake for method CustomizationTasksClient.GetErrorDetails
	// HTTP status codes to indicate success: http.StatusOK
	GetErrorDetails func(ctx context.Context, resourceGroupName string, devCenterName string, catalogName string, taskName string, options *armdevcenter.CustomizationTasksClientGetErrorDetailsOptions) (resp azfake.Responder[armdevcenter.CustomizationTasksClientGetErrorDetailsResponse], errResp azfake.ErrorResponder)

	// NewListByCatalogPager is the fake for method CustomizationTasksClient.NewListByCatalogPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByCatalogPager func(resourceGroupName string, devCenterName string, catalogName string, options *armdevcenter.CustomizationTasksClientListByCatalogOptions) (resp azfake.PagerResponder[armdevcenter.CustomizationTasksClientListByCatalogResponse])
}

// NewCustomizationTasksServerTransport creates a new instance of CustomizationTasksServerTransport with the provided implementation.
// The returned CustomizationTasksServerTransport instance is connected to an instance of armdevcenter.CustomizationTasksClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewCustomizationTasksServerTransport(srv *CustomizationTasksServer) *CustomizationTasksServerTransport {
	return &CustomizationTasksServerTransport{
		srv:                   srv,
		newListByCatalogPager: newTracker[azfake.PagerResponder[armdevcenter.CustomizationTasksClientListByCatalogResponse]](),
	}
}

// CustomizationTasksServerTransport connects instances of armdevcenter.CustomizationTasksClient to instances of CustomizationTasksServer.
// Don't use this type directly, use NewCustomizationTasksServerTransport instead.
type CustomizationTasksServerTransport struct {
	srv                   *CustomizationTasksServer
	newListByCatalogPager *tracker[azfake.PagerResponder[armdevcenter.CustomizationTasksClientListByCatalogResponse]]
}

// Do implements the policy.Transporter interface for CustomizationTasksServerTransport.
func (c *CustomizationTasksServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "CustomizationTasksClient.Get":
		resp, err = c.dispatchGet(req)
	case "CustomizationTasksClient.GetErrorDetails":
		resp, err = c.dispatchGetErrorDetails(req)
	case "CustomizationTasksClient.NewListByCatalogPager":
		resp, err = c.dispatchNewListByCatalogPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *CustomizationTasksServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if c.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks/(?P<taskName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
	if err != nil {
		return nil, err
	}
	catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
	if err != nil {
		return nil, err
	}
	taskNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("taskName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.Get(req.Context(), resourceGroupNameParam, devCenterNameParam, catalogNameParam, taskNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CustomizationTask, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CustomizationTasksServerTransport) dispatchGetErrorDetails(req *http.Request) (*http.Response, error) {
	if c.srv.GetErrorDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetErrorDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks/(?P<taskName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getErrorDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
	if err != nil {
		return nil, err
	}
	catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
	if err != nil {
		return nil, err
	}
	taskNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("taskName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := c.srv.GetErrorDetails(req.Context(), resourceGroupNameParam, devCenterNameParam, catalogNameParam, taskNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CatalogResourceValidationErrorDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *CustomizationTasksServerTransport) dispatchNewListByCatalogPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListByCatalogPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByCatalogPager not implemented")}
	}
	newListByCatalogPager := c.newListByCatalogPager.get(req)
	if newListByCatalogPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.DevCenter/devcenters/(?P<devCenterName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/catalogs/(?P<catalogName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/tasks`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		devCenterNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("devCenterName")])
		if err != nil {
			return nil, err
		}
		catalogNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("catalogName")])
		if err != nil {
			return nil, err
		}
		topUnescaped, err := url.QueryUnescape(qp.Get("$top"))
		if err != nil {
			return nil, err
		}
		topParam, err := parseOptional(topUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armdevcenter.CustomizationTasksClientListByCatalogOptions
		if topParam != nil {
			options = &armdevcenter.CustomizationTasksClientListByCatalogOptions{
				Top: topParam,
			}
		}
		resp := c.srv.NewListByCatalogPager(resourceGroupNameParam, devCenterNameParam, catalogNameParam, options)
		newListByCatalogPager = &resp
		c.newListByCatalogPager.add(req, newListByCatalogPager)
		server.PagerResponderInjectNextLinks(newListByCatalogPager, req, func(page *armdevcenter.CustomizationTasksClientListByCatalogResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByCatalogPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListByCatalogPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByCatalogPager) {
		c.newListByCatalogPager.remove(req)
	}
	return resp, nil
}
