// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitosync

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/cognitosync/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	"github.com/aws/smithy-go/tracing"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpBulkPublish struct {
}

func (*awsRestjson1_serializeOpBulkPublish) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBulkPublish) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BulkPublishInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/bulkpublish")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBulkPublishInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBulkPublishInput(v *BulkPublishInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataset struct {
}

func (*awsRestjson1_serializeOpDeleteDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDatasetInput(v *DeleteDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("DatasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeDataset struct {
}

func (*awsRestjson1_serializeOpDescribeDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeDatasetInput(v *DescribeDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("DatasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIdentityPoolUsage struct {
}

func (*awsRestjson1_serializeOpDescribeIdentityPoolUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIdentityPoolUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIdentityPoolUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIdentityPoolUsageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIdentityPoolUsageInput(v *DescribeIdentityPoolUsageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIdentityUsage struct {
}

func (*awsRestjson1_serializeOpDescribeIdentityUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIdentityUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIdentityUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identities/{IdentityId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIdentityUsageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIdentityUsageInput(v *DescribeIdentityUsageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBulkPublishDetails struct {
}

func (*awsRestjson1_serializeOpGetBulkPublishDetails) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBulkPublishDetails) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBulkPublishDetailsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/getBulkPublishDetails")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBulkPublishDetailsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBulkPublishDetailsInput(v *GetBulkPublishDetailsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCognitoEvents struct {
}

func (*awsRestjson1_serializeOpGetCognitoEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCognitoEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCognitoEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/events")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCognitoEventsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCognitoEventsInput(v *GetCognitoEventsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetIdentityPoolConfiguration struct {
}

func (*awsRestjson1_serializeOpGetIdentityPoolConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIdentityPoolConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityPoolConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIdentityPoolConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIdentityPoolConfigurationInput(v *GetIdentityPoolConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListDatasets struct {
}

func (*awsRestjson1_serializeOpListDatasets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDatasets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDatasetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDatasetsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDatasetsInput(v *ListDatasetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIdentityPoolUsage struct {
}

func (*awsRestjson1_serializeOpListIdentityPoolUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIdentityPoolUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIdentityPoolUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIdentityPoolUsageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIdentityPoolUsageInput(v *ListIdentityPoolUsageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRecords struct {
}

func (*awsRestjson1_serializeOpListRecords) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRecords) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRecordsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/records")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRecordsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRecordsInput(v *ListRecordsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("DatasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	if v.LastSyncCount != nil {
		encoder.SetQuery("lastSyncCount").Long(*v.LastSyncCount)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.SyncSessionToken != nil {
		encoder.SetQuery("syncSessionToken").String(*v.SyncSessionToken)
	}

	return nil
}

type awsRestjson1_serializeOpRegisterDevice struct {
}

func (*awsRestjson1_serializeOpRegisterDevice) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRegisterDevice) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RegisterDeviceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identity/{IdentityId}/device")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRegisterDeviceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRegisterDeviceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRegisterDeviceInput(v *RegisterDeviceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRegisterDeviceInput(v *RegisterDeviceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Platform) > 0 {
		ok := object.Key("Platform")
		ok.String(string(v.Platform))
	}

	if v.Token != nil {
		ok := object.Key("Token")
		ok.String(*v.Token)
	}

	return nil
}

type awsRestjson1_serializeOpSetCognitoEvents struct {
}

func (*awsRestjson1_serializeOpSetCognitoEvents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetCognitoEvents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetCognitoEventsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/events")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSetCognitoEventsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSetCognitoEventsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetCognitoEventsInput(v *SetCognitoEventsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSetCognitoEventsInput(v *SetCognitoEventsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Events != nil {
		ok := object.Key("Events")
		if err := awsRestjson1_serializeDocumentEvents(v.Events, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSetIdentityPoolConfiguration struct {
}

func (*awsRestjson1_serializeOpSetIdentityPoolConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSetIdentityPoolConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SetIdentityPoolConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSetIdentityPoolConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSetIdentityPoolConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSetIdentityPoolConfigurationInput(v *SetIdentityPoolConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSetIdentityPoolConfigurationInput(v *SetIdentityPoolConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CognitoStreams != nil {
		ok := object.Key("CognitoStreams")
		if err := awsRestjson1_serializeDocumentCognitoStreams(v.CognitoStreams, ok); err != nil {
			return err
		}
	}

	if v.PushSync != nil {
		ok := object.Key("PushSync")
		if err := awsRestjson1_serializeDocumentPushSync(v.PushSync, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpSubscribeToDataset struct {
}

func (*awsRestjson1_serializeOpSubscribeToDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSubscribeToDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SubscribeToDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSubscribeToDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSubscribeToDatasetInput(v *SubscribeToDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("DatasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.DeviceId == nil || len(*v.DeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DeviceId must not be empty")}
	}
	if v.DeviceId != nil {
		if err := encoder.SetURI("DeviceId").String(*v.DeviceId); err != nil {
			return err
		}
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUnsubscribeFromDataset struct {
}

func (*awsRestjson1_serializeOpUnsubscribeFromDataset) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUnsubscribeFromDataset) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UnsubscribeFromDatasetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}/subscriptions/{DeviceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUnsubscribeFromDatasetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUnsubscribeFromDatasetInput(v *UnsubscribeFromDatasetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("DatasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.DeviceId == nil || len(*v.DeviceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DeviceId must not be empty")}
	}
	if v.DeviceId != nil {
		if err := encoder.SetURI("DeviceId").String(*v.DeviceId); err != nil {
			return err
		}
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRecords struct {
}

func (*awsRestjson1_serializeOpUpdateRecords) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRecords) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	_, span := tracing.StartSpan(ctx, "OperationSerializer")
	endTimer := startMetricTimer(ctx, "client.call.serialization_duration")
	defer endTimer()
	defer span.End()
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRecordsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/identitypools/{IdentityPoolId}/identities/{IdentityId}/datasets/{DatasetName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRecordsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRecordsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	endTimer()
	span.End()
	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRecordsInput(v *UpdateRecordsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClientContext != nil {
		locationName := "X-Amz-Client-Context"
		encoder.SetHeader(locationName).String(*v.ClientContext)
	}

	if v.DatasetName == nil || len(*v.DatasetName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DatasetName must not be empty")}
	}
	if v.DatasetName != nil {
		if err := encoder.SetURI("DatasetName").String(*v.DatasetName); err != nil {
			return err
		}
	}

	if v.IdentityId == nil || len(*v.IdentityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityId must not be empty")}
	}
	if v.IdentityId != nil {
		if err := encoder.SetURI("IdentityId").String(*v.IdentityId); err != nil {
			return err
		}
	}

	if v.IdentityPoolId == nil || len(*v.IdentityPoolId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member IdentityPoolId must not be empty")}
	}
	if v.IdentityPoolId != nil {
		if err := encoder.SetURI("IdentityPoolId").String(*v.IdentityPoolId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRecordsInput(v *UpdateRecordsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceId != nil {
		ok := object.Key("DeviceId")
		ok.String(*v.DeviceId)
	}

	if v.RecordPatches != nil {
		ok := object.Key("RecordPatches")
		if err := awsRestjson1_serializeDocumentRecordPatchList(v.RecordPatches, ok); err != nil {
			return err
		}
	}

	if v.SyncSessionToken != nil {
		ok := object.Key("SyncSessionToken")
		ok.String(*v.SyncSessionToken)
	}

	return nil
}

func awsRestjson1_serializeDocumentApplicationArnList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentCognitoStreams(v *types.CognitoStreams, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if len(v.StreamingStatus) > 0 {
		ok := object.Key("StreamingStatus")
		ok.String(string(v.StreamingStatus))
	}

	if v.StreamName != nil {
		ok := object.Key("StreamName")
		ok.String(*v.StreamName)
	}

	return nil
}

func awsRestjson1_serializeDocumentEvents(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentPushSync(v *types.PushSync, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ApplicationArns != nil {
		ok := object.Key("ApplicationArns")
		if err := awsRestjson1_serializeDocumentApplicationArnList(v.ApplicationArns, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentRecordPatch(v *types.RecordPatch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeviceLastModifiedDate != nil {
		ok := object.Key("DeviceLastModifiedDate")
		ok.Double(smithytime.FormatEpochSeconds(*v.DeviceLastModifiedDate))
	}

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if len(v.Op) > 0 {
		ok := object.Key("Op")
		ok.String(string(v.Op))
	}

	if v.SyncCount != nil {
		ok := object.Key("SyncCount")
		ok.Long(*v.SyncCount)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentRecordPatchList(v []types.RecordPatch, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRecordPatch(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}
