import * as ImpLib from "@ot-builder/common-impl";
import * as Ot from "@ot-builder/ot";
import * as Rectify from "@ot-builder/rectify";
import { DesignUnifierSession } from "../design-unifier";
declare class SharedGlyphProp {
    readonly glyph: Ot.Glyph;
    readonly fid: number;
    readonly priority: number;
    constructor(glyph: Ot.Glyph, fid: number, priority: number);
    compare(b: SharedGlyphProp): number;
}
export declare class SharedGlyphStore implements Ot.GlyphStore {
    mapping: Map<string, SharedGlyphProp>;
    decideOrder(): import("@ot-builder/prelude/lib/data").Order<Ot.Glyph>;
}
export declare class GlyphSharingRectifier implements Rectify.GlyphReferenceRectifier {
    readonly gs: SharedGlyphStore;
    private rankMap;
    private mapping;
    constructor(gs: SharedGlyphStore);
    private amendHashByRank;
    put(g: Ot.Glyph, rawHash: string, fid: number, priority: number): Ot.Glyph;
    glyphRef(a: Ot.Glyph): Ot.Glyph | undefined;
}
export declare class GlyphHasher {
    private readonly session;
    constructor(session: DesignUnifierSession);
    private readonly computed;
    private readonly reverse;
    get(glyph: Ot.Glyph): string | undefined;
    compute(glyph: Ot.Glyph): string;
    computeImpl(glyph: Ot.Glyph): ImpLib.Hasher;
}
export {};
//# sourceMappingURL=glyph-hasher.d.ts.map