ConceptCheck, part of collection of the [Boost C++ Libraries](http://github.com/boostorg), 
allows one to add explicit statement and checking of concepts in the style of the proposed C++ language extension.

### License

Distributed under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).

### Properties

* C++03
* Header-only

### Build Status

Branch          | Travis | Appveyor | Coverity Scan | codecov.io | Deps | Docs | Tests |
:-------------: | ------ | -------- | ------------- | ---------- | ---- | ---- | ----- |
[`master`](https://github.com/boostorg/concept_check/tree/master) | [![Build Status](https://travis-ci.org/boostorg/concept_check.svg?branch=master)](https://travis-ci.org/boostorg/concept_check) | [![Build status](https://ci.appveyor.com/api/projects/status/yoj8ae7yopd903i9/branch/master?svg=true)](https://ci.appveyor.com/project/jeking3/concept_check-gp9xw/branch/master) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/16317/badge.svg)](https://scan.coverity.com/projects/boostorg-concept_check) | [![codecov](https://codecov.io/gh/boostorg/concept_check/branch/master/graph/badge.svg)](https://codecov.io/gh/boostorg/concept_check/branch/master)| [![Deps](https://img.shields.io/badge/deps-master-brightgreen.svg)](https://pdimov.github.io/boostdep-report/master/concept_check.html) | [![Documentation](https://img.shields.io/badge/docs-master-brightgreen.svg)](http://www.boost.org/doc/libs/master/doc/html/concept_check.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-master-brightgreen.svg)](http://www.boost.org/development/tests/master/developer/concept_check.html)
[`develop`](https://github.com/boostorg/concept_check/tree/develop) | [![Build Status](https://travis-ci.org/boostorg/concept_check.svg?branch=develop)](https://travis-ci.org/boostorg/concept_check) | [![Build status](https://ci.appveyor.com/api/projects/status/yoj8ae7yopd903i9/branch/develop?svg=true)](https://ci.appveyor.com/project/jeking3/concept_check-gp9xw/branch/develop) | [![Coverity Scan Build Status](https://scan.coverity.com/projects/16317/badge.svg)](https://scan.coverity.com/projects/boostorg-concept_check) | [![codecov](https://codecov.io/gh/boostorg/concept_check/branch/develop/graph/badge.svg)](https://codecov.io/gh/boostorg/concept_check/branch/develop) | [![Deps](https://img.shields.io/badge/deps-develop-brightgreen.svg)](https://pdimov.github.io/boostdep-report/develop/concept_check.html) | [![Documentation](https://img.shields.io/badge/docs-develop-brightgreen.svg)](http://www.boost.org/doc/libs/develop/doc/html/concept_check.html) | [![Enter the Matrix](https://img.shields.io/badge/matrix-develop-brightgreen.svg)](http://www.boost.org/development/tests/develop/developer/concept_check.html)

### Directories

| Name        | Purpose                        |
| ----------- | ------------------------------ |
| `doc`       | documentation                  |
| `include`   | headers                        |
| `test`      | unit tests                     |

### More information

* [Ask questions](http://stackoverflow.com/questions/ask?tags=c%2B%2B,boost,boost-concept_check)
* [Report bugs](https://github.com/boostorg/concept_check/issues): Be sure to mention Boost version, platform and compiler you're using. A small compilable code sample to reproduce the problem is always good as well.
* Submit your patches as pull requests against **develop** branch. Note that by submitting patches you agree to license your modifications under the [Boost Software License, Version 1.0](http://www.boost.org/LICENSE_1_0.txt).
* Discussions about the library are held on the [Boost developers mailing list](http://www.boost.org/community/groups.html#main). Be sure to read the [discussion policy](http://www.boost.org/community/policy.html) before posting and add the `[concept_check]` tag at the beginning of the subject line.

