# Map Object Format

## Description

Full object consists from 3 parts:

- Object group - set of objects that have similar behavior and share
    same identifier in H3 (towns, heroes, mines, etc)
- Object type - object with fixed behavior but without fixed
    appearance. Multiple objects types may share same group
- Object template - defines appearance of an object - image used to
    display it, its size & blockmap. These entries only describe
    templates that will be used when object is placed via map editor or
    generated by the game. When new object is created its starting
    appearance will be copied from template

## Object group format

```json

{
	"myCoolObjectGroup":
	{
		// Mandatory for new objects,
		// human readable name, localized 
		"name": "My cool object",

		// defines C++ class name that handles behavior of this object
		// see Object Types section below for possible values
		"handler" : "mine",

		// default values, will be merged with each type during loading
		"base" : { <object type format> },

		"types" : {
			<list of object types, see below>
		}
	}
}
```

## Object types

### Moddable types

These are object types that are available for modding and have configurable properties

- `configurable` - see [Rewardable](Map_Objects/Rewardable.md). Visitable object which grants all kinds of rewards (gold, experience, Bonuses etc...)
- `bank` - see [Creature Bank](Map_Objects/Creature_Bank.md). Object that grants award on defeating guardians. Deprectated in favor of [Rewardable](Map_Objects/Rewardable.md)
- `dwelling` - see [Dwelling](Map_Objects/Dwelling.md). Object that allows recruitments of units outside of towns
- `market` - see [Market](Map_Objects/Market.md). Trading resources, artifacts, creatures and such
- `mine` - see [Mine](Map_Objects/Mine.md). for Mines
- `boat` - see [Boat](Map_Objects/Boat.md). Object to move across different terrains, such as water
- `flaggable` - see [Flaggable](Map_Objects/Flaggable.md). Object that can be flagged by a player to provide [Bonus](Bonus_Format.md) or resources
- `hillFort` - TODO: documentation. See config files in vcmi installation for reference
- `shipyard` - TODO: documentation. See config files in vcmi installation for reference
- `terrain` - Defines terrain overlays such as magic grounds. TODO: documentation. See config files in vcmi installation for reference

### Common types

These are types that don't have configurable properties, however it is possible to add additional map templates for this objects, for use in editor or in random maps generator

- `static` - Defines unpassable static map obstacles that can be used by RMG
- `generic` - Defines empty object type that provides no functionality. Note that unlike `static`, objects of this type are never used by RMG
- `borderGate`
- `borderGuard`
- `magi`
- `obelisk`
- `subterraneanGate`
- `whirlpool`
- `resource`
- `denOfThieves`
- `garrison`
- `keymaster`
- `pandora`
- `prison`
- `questGuard`
- `seerHut`
- `sign`
- `siren`
- `monolith`

### Internal types

These are internal types that are generally not available for modding and are handled by vcmi internally.

- `hero`
- `town`
- `monster`
- `randomArtifact`
- `randomHero`
- `randomResource`
- `randomTown`
- `randomMonster`
- `randomDwelling`
- `artifact`
- `event`
- `heroPlaceholder`

## Object type format

```json
{
	"myCoolObject":
	{
		// Additional parameters that will be passed over to class that controls behavior of the object
		// See object-specific properties of different object types
		"propertyA" : "value",
		"propertyB" : 12345

		// How valuable this object is to AI
		"aiValue" : 1000,
		
		// Battleground that will be used for combats in this object. Overrides terrain this object was placed on. If array is used battleground will choosen randomly
		"battleground" : "cursed_ground",
		
		// Sounds assigned to this object
		"sounds" : {
			// Ambient sounds that plays when current hero is near this object
			"ambient" : [ "" ],
			// Sounds that plays when hero visits this object
			"visit" : [ "" ],
			// Sounds that play when this object is removed from the map
			"removal" : [ "" ],
		},

		// Data for random map generator that describes how object should be placed.
		// If this entry is missing object will not be placed by RMG
		"rmg" : {
			// How valuable this object is, 1k = worthless, 20k = relic level
			"value" : 5000,

			// Optional, how many of such objects can be placed on map
			"mapLimit" : 25,

			// Optional, how many of such objects can be placed in one zone
			"zoneLimit" : 4,

			// Rarity of object, 10 = rare, 100 = common
			"rarity" : 50
		}

		// default values, will be merged with each template during loading
		// mostly needed to avoid redefining whole template to change 1-2 fields
		"base" : { <template format> },

		"templates" : {
			<templates description, see below>
		}
	}
}
```

## Object template format

```json
{
	"myCoolObjectTemplate" : 
	{
		// Path to def file with animation of this object
		"animation":"DEFNAME.def",

		// Optional path to def file with animation of this object to use in map editor
		"editorAnimation":"DEFNAME.def",

		// Directions from which hero can visit this object.
		// "+" means that object can be visited from that direction, or "-" othervice
		// default not visitable
		"visitableFrom" : [
			"---",
			"+++",
			"+++"
		],

		// passability of the object
		// 0=not visible, passable. Space symbol ' ' can be used as well
		// V=visible, passable
		// B=blocked, visible
		// H=hidden - blocked, not visible tile
		// A=activable, visible, passable depending on visitableFrom field
		// T=trigger - visiting the tile will trigger the object, tile is not visible (e.g. event)
		//top and left leading zeros are optional and in fact ignored
		//bottom, right corner of mask = bottom right corner of animation frame
		//animation can not be larger than size of mask
		"mask":[
			"00000000",
			"00000000",
			"00000000",
			"0000VVVV",
			"0000HBBB",
			"0000HHAT"
		],

		// optional; default or if explicitly set to null: all "land" terrains (e.g. not rock and not water)
		// allowed terrain types to place object to. Affects also RMG.
		// Note that map editor will still allow to place object on other terrains
		// h3 terrain types: "dirt", "sand", "grass", "snow", "swamp", "rough", "subterra", "lava", "water", "rock"
		"allowedTerrains":[
			"dirt",
			"sand",
			"asphalt", // terrain from mod, such form can only be used if mod has dependency on mod with such terrain
			"hota:wasteland", // terrain from mod, such form can be used even without dependency, entry will be ignored if such mod does not exists
		],

		//zindex, defines order in which objects on same tile will be blit. optional, default is 0 
		//NOTE: legacy overlay objects has zindex = 100
		"zIndex": 0
	}
}
```
