% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.plugin-functions.R
\name{rk.list.plugins}
\alias{rk.list.plugins}
\alias{rk.set.plugin.status}
\title{List of modify loaded plugins}
\usage{
rk.list.plugins()

rk.set.plugin.status(id, context = "", visible = TRUE)
}
\arguments{
\item{id}{vector of ids (character) of the plugins to modify}

\item{context}{in which the plugin should be shown / hidden. This can either be "",
meaning the plugin will be affected in all contexts it occurs in, or a character vector
of the same length as id.}

\item{visible}{logical, controlling whether the plugin should be shown (\code{TRUE}) or
hidden (\code{FALSE}). Hidden plugins are essentially removed from the menu. They may still
be accessible embedded into other plugins.}
}
\value{
\code{rk.list.plugins} returns a data.frame listing plugin ids, context, menu path
  (tab-separated), and label of the plugin. If a plugin is available in more
  than one context, it will be listed several times. The exact layout (number and order of columns)
  of this data.frame might be subject to change. However, the \bold{names} of the columns in the
  returned data.frame are expected to remain stable.
  \code{rk.set.plugin.status} returns \code{NULL}, invisibly

\bold{Note}: Each call to \code{rk.set.plugin.status} will result in a complete rebuild of the
             menu (in the current implementation). While this should be hardly noticeable in interactive
             use, it could be an issue when changing the status of many plugins, programatically.
             In this case, make sure to do all changes in \bold{one} call to \code{rk.set.plugin.status},
             rather than many separate calls.
}
\description{
\code{rk.list.plugins} returns the a list of all currently
registered plugins (in loaded pluginmaps).
\code{rk.set.plugin.status} allows to control the status of the given plugin(s). Currently,
   only visibility can be controlled.
}
\examples{
## list all current plugins
rk.list.plugins ()

## NOT RUN
## hide t.test plugin
rk.set.plugin.status ("rkward::t_test", visible=FALSE)
## END NOT RUN

}
\seealso{
\code{\link{rk.call.plugin}} for invoking a plugin, programatically
}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{utilities}
