% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixed.R
\name{mixed_units}
\alias{mixed_units}
\alias{units<-.mixed_units}
\title{Create or convert to a mixed units list-column}
\usage{
mixed_units(x, values, ...)

\method{units}{mixed_units}(x) <- value
}
\arguments{
\item{x}{numeric, or vector of class \code{units}}

\item{values}{character vector with units encodings, or list with symbolic units of class \code{mixed_symbolic_units}}

\item{...}{ignored}

\item{value}{see values}
}
\description{
Create or convert to a mixed units list-column
}
\details{
if \code{x} is of class \code{units}, \code{values} should be missing or of class \code{mixed_symbolic_units}; if \code{x} is numeric, \code{values} should be a character vector the length of \code{x}.
}
\examples{
a <- 1:4
u <- c("m/s", "km/h", "mg/L", "g")
mixed_units(a, u)
units(a) = as_units("m/s")
mixed_units(a) # converts to mixed representation
}
