% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-list.R
\name{post_list}
\alias{post_list}
\title{Manage Twitter lists}
\usage{
post_list(
  users = NULL,
  name = NULL,
  description = NULL,
  private = FALSE,
  destroy = FALSE,
  list_id = NULL,
  slug = NULL,
  token = NULL
)
}
\arguments{
\item{users}{Character vectors of users to be added to list.}

\item{name}{Name of new list to create.}

\item{description}{Optional, description of list (single character string).}

\item{private}{Logical indicating whether created list should be private.
Defaults to false, meaning the list would be public. Not applicable if list
already exists.}

\item{destroy}{Logical indicating whether to delete a list. Either \code{list_id} or
\code{slug} must be provided if \code{destroy = TRUE}.}

\item{list_id}{Optional, numeric ID of list.}

\item{slug}{Optional, list slug.}

\item{token}{Use this to override authentication for
a single API call. In many cases you are better off changing the
default for all calls. See \code{\link[=auth_as]{auth_as()}} for details.}
}
\value{
Response object from HTTP request.
}
\description{
Create, add users, and destroy Twitter lists. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
}
\references{
Create: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/create-manage-lists/api-reference/post-lists-create}
Destroy: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/create-manage-lists/api-reference/post-lists-destroy}
Add users: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/create-manage-lists/api-reference/post-lists-members-create},
\url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/create-manage-lists/api-reference/post-lists-members-create_all}
Remove users: \url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/create-manage-lists/api-reference/post-lists-members-destroy},
\url{https://developer.twitter.com/en/docs/twitter-api/v1/accounts-and-users/create-manage-lists/api-reference/post-lists-members-destroy_all}
}
\seealso{
\code{\link{rtweet-deprecated}}
}
