% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/system.R
\name{ps_shared_lib_users}
\alias{ps_shared_lib_users}
\title{List all processes that loaded a shared library}
\usage{
ps_shared_lib_users(paths, user = ps_username(), filter = NULL)
}
\arguments{
\item{paths}{Character vector of paths of shared libraries to
look up. They must be absolute paths. They don't need to exist.
Forward slashes are converted to backward slashes on Windows, and
the output will always have backward slashes in the paths.}

\item{user}{Character scalar or \code{NULL}. If not \code{NULL}, then only
the processes of this user are considered. It defaults to the
current user.}

\item{filter}{Character vector or \code{NULL}. If not NULL, then it is
a vector of glob expressions, used to filter the process names.}
}
\value{
A data frame with columns:
\itemize{
\item \code{dll}: the file name of the dll file, without the path,
\item \code{path}: path to the shared library,
\item \code{pid}: process ID of the process,
\item \code{name}: name of the process,
\item \code{username}: username of process owner,
\item \code{ps_handle}: \code{ps_handle} object, that can be used to further
query and manipulate the process.
}
}
\description{
List all processes that loaded a shared library
}
\details{
\subsection{Notes:}{

This function currently only works on Windows.

On Windows, a 32 bit R process can only list other 32 bit processes.
Similarly, a 64 bit R process can only list other 64 bit processes.
This is a limitation of the Windows API.

Even though Windows file systems are (almost always) case
insensitive, the matching of \code{paths}, \code{user} and also \code{filter}
are case sensitive. This might change in the future.

This function can be very slow on Windows, because it needs to
enumerate all shared libraries of all processes in the system,
unless the \code{filter} argument is set. Make sure you set \code{filter}
if you can.

If you want to look up multiple shared libraries, list all of them
in \code{paths}, instead of calling \code{ps_shared_lib_users} for each
individually.

If you are after libraries loaded by R processes, you might want to
set \code{filter} to \code{c("Rgui.exe", "Rterm.exe", "rsession.exe")} The
last one is for RStudio.
}
}
\examples{
\dontshow{if (ps::ps_is_supported() && ! ps:::is_cran_check() && ps::ps_os_type()[["WINDOWS"]]) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
dlls <- vapply(getLoadedDLLs(), "[[", character(1), "path")
psdll <- dlls[["ps"]][[1]]
r_procs <- c("Rgui.exe", "Rterm.exe", "rsession.exe")
ps_shared_lib_users(psdll, filter = r_procs)
\dontshow{\}) # examplesIf}
}
\seealso{
Other shared library tools: 
\code{\link{ps_shared_libs}()}
}
\concept{shared library tools}
