if (suppressWarnings(
  requiet("testthat") &&
  requiet("ggeffects") &&
  requiet("lme4") &&
  requiet("sjlabelled")
)) {
  data(efc)

  efc$e15relat <- as_label(efc$e15relat)

  m <- lmer(neg_c_7 ~ c160age + c12hour + (1 | e15relat), data = efc)

  test_that("ggpredict, contrasts-1", {
    options(contrasts = rep("contr.sum", 2))
    pr <- ggpredict(m, c("c160age", "c12hour"))
    expect_false(anyNA(pr$std.error))
  })

  test_that("ggpredict, contrasts-2", {
    options(contrasts = rep("contr.sum", 2))
    pr <- ggpredict(m, "c160age")
    expect_false(anyNA(pr$std.error))
  })

  test_that("ggpredict, contrasts-3", {
    options(contrasts = rep("contr.sum", 2))
    pr <- ggpredict(m, "c12hour")
    expect_false(anyNA(pr$std.error))
  })

  test_that("ggpredict, contrasts-4", {
    options(contrasts = rep("contr.treatment", 2))
    pr <- ggpredict(m, c("c160age", "c12hour"))
    expect_false(anyNA(pr$std.error))
  })

  test_that("ggpredict, contrasts-5", {
    options(contrasts = rep("contr.treatment", 2))
    pr <- ggpredict(m, "c160age")
    expect_false(anyNA(pr$std.error))
  })

  test_that("ggpredict, contrasts-6", {
    options(contrasts = rep("contr.treatment", 2))
    pr <- ggpredict(m, "c12hour")
    expect_false(anyNA(pr$std.error))
  })
}
