% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-modify.R
\name{group_modify.dtplyr_step}
\alias{group_modify.dtplyr_step}
\title{Modify a lazy_dt in place}
\usage{
\method{group_modify}{dtplyr_step}(.tbl, .f, ..., keep = FALSE)
}
\arguments{
\item{.tbl}{A \link{lazy_dt}}

\item{.f}{The name of a two argument function. The first argument is passed
\code{.SD},the data.table representing the current group; the second argument
is passed \code{.BY}, a list giving the current values of the grouping
variables. The function should return a list or data.table.}

\item{...}{Additional arguments passed to \code{.f}}

\item{keep}{Not supported for \link{lazy_dt}.}
}
\description{
\code{group_modify()} applies \code{.f} to each group, returning a modified
\code{\link[=lazy_dt]{lazy_dt()}}. This function is a little less flexible than the data.frame
method due to the constraints of the code generation that dtplyr uses.
}
\examples{
library(dplyr)

mtcars \%>\%
  lazy_dt() \%>\%
  group_by(cyl) \%>\%
  group_modify(head, n = 2L)
}
