% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{BetaBinomial}
\alias{BetaBinomial}
\alias{dbeta_binomial}
\alias{pbeta_binomial}
\alias{rbeta_binomial}
\title{The Beta-binomial Distribution}
\usage{
dbeta_binomial(x, size, mu, phi, log = FALSE)

pbeta_binomial(q, size, mu, phi, lower.tail = TRUE, log.p = FALSE)

rbeta_binomial(n, size, mu, phi)
}
\arguments{
\item{x, q}{Vector of quantiles.}

\item{size}{Vector of number of trials (zero or more).}

\item{mu}{Vector of means.}

\item{phi}{Vector of precisions.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{lower.tail}{Logical; If \code{TRUE} (default), return P(X <= x).
Else, return P(X > x) .}

\item{log.p}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{n}{Number of draws to sample from the distribution.}
}
\description{
Cumulative density & mass functions, and random number generation for the
Beta-binomial distribution using the following re-parameterisation of the
\href{https://mc-stan.org/docs/2_29/functions-reference/beta-binomial-distribution.html}{Stan
Beta-binomial definition}:
\itemize{
 \item{\code{mu = alpha * beta}} mean probability of trial success.
 \item{\code{phi = (1 - mu) * beta}} precision or over-dispersion, component.
}
}
