% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiAssayExperiment-class.R,
%   R/MultiAssayExperiment-methods.R
\name{MultiAssayExperiment-methods}
\alias{MultiAssayExperiment-methods}
\alias{experiments}
\alias{sampleMap}
\alias{experiments<-}
\alias{sampleMap<-}
\alias{sampleMap,MultiAssayExperiment-method}
\alias{experiments,MultiAssayExperiment-method}
\alias{colData,MultiAssayExperiment-method}
\alias{metadata,MultiAssayExperiment-method}
\alias{sampleMap<-,MultiAssayExperiment,DataFrame-method}
\alias{sampleMap<-,MultiAssayExperiment,ANY-method}
\alias{experiments<-,MultiAssayExperiment,ExperimentList-method}
\alias{experiments<-,MultiAssayExperiment,List-method}
\alias{colData<-,MultiAssayExperiment,DataFrame-method}
\alias{colData<-,MultiAssayExperiment,ANY-method}
\alias{metadata<-,MultiAssayExperiment-method}
\alias{$<-,MultiAssayExperiment-method}
\alias{names<-,MultiAssayExperiment-method}
\alias{colnames<-,MultiAssayExperiment,List-method}
\alias{colnames<-,MultiAssayExperiment,list-method}
\alias{$,MultiAssayExperiment-method}
\title{Accessing and modifying information in MultiAssayExperiment}
\usage{
\S4method{sampleMap}{MultiAssayExperiment}(x)

\S4method{experiments}{MultiAssayExperiment}(x)

\S4method{colData}{MultiAssayExperiment}(x, ...)

\S4method{metadata}{MultiAssayExperiment}(x)

\S4method{sampleMap}{MultiAssayExperiment,DataFrame}(object) <- value

\S4method{sampleMap}{MultiAssayExperiment,ANY}(object) <- value

\S4method{experiments}{MultiAssayExperiment,ExperimentList}(object) <- value

\S4method{experiments}{MultiAssayExperiment,List}(object) <- value

\S4method{colData}{MultiAssayExperiment,DataFrame}(x) <- value

\S4method{colData}{MultiAssayExperiment,ANY}(x) <- value

\S4method{metadata}{MultiAssayExperiment}(x, ...) <- value

\S4method{$}{MultiAssayExperiment}(x, name) <- value

\S4method{names}{MultiAssayExperiment}(x) <- value

\S4method{colnames}{MultiAssayExperiment,List}(x) <- value

\S4method{colnames}{MultiAssayExperiment,list}(x) <- value

\S4method{$}{MultiAssayExperiment}(x, name)
}
\arguments{
\item{...}{Argument not in use}

\item{object, x}{A \code{MultiAssayExperiment} object}

\item{value}{See details.}

\item{name}{A column in \code{colData}}
}
\value{
Accessors: Either a \code{sampleMap}, \code{ExperimentList}, or
\code{DataFrame} object

Setters: A \code{MultiAssayExperiment} object
}
\description{
A set of accessor and setter generic functions to extract
either the \code{sampleMap}, the \code{\link{ExperimentList}},
\code{colData}, or \code{metadata} slots of a
\code{\link{MultiAssayExperiment}} object
}
\section{Accessors}{

Eponymous names for accessing \code{MultiAssayExperiment} slots with the
exception of the \link{ExperimentList} accessor named \code{experiments}.
\itemize{
   \item colData: Access the \code{colData} slot
   \item sampleMap: Access the \code{sampleMap} slot
   \item experiments: Access the \link{ExperimentList} slot
   \item `[[`: Access the \link{ExperimentList} slot
   \item `$`: Access a column in \code{colData}
}
}

\section{Setters}{

Setter method values (i.e., '\code{function(x) <- value}'):
\itemize{
    \item experiments<-: An \code{\link{ExperimentList}} object
    containing experiment data of supported classes
    \item sampleMap<-: A \code{\link{DataFrame}} object relating
    samples to biological units and assays
    \item colData<-: A \code{\link{DataFrame}} object describing the
    biological units
    \item metadata<-: A \code{list} object of metadata
    \item `[[<-`: Equivalent to the \code{experiments<-} setter method for
    convenience
    \item `$<-`: A vector to replace the indicated column in \code{colData}
}
}

\examples{
## Load example MultiAssayExperiment
example(MultiAssayExperiment)

## Access the sampleMap
sampleMap(mae)

## Replacement method for a MultiAssayExperiment sampleMap
sampleMap(mae) <- S4Vectors::DataFrame()

## Access the ExperimentList
experiments(mae)

## Replace with an empty ExperimentList
experiments(mae) <- ExperimentList()

## Access the metadata
metadata(mae)

## Replace metadata with a list
metadata(mae) <- list(runDate =
    format(Sys.time(), "\%B \%d, \%Y"))

## Access the colData
colData(mae)

## Access a column in colData
mae$age

## Replace a column in colData
mae$age <- mae$age + 1
}
