% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformVectorForHdf5.R
\name{transformVectorForHdf5}
\alias{transformVectorForHdf5}
\title{Transform a vector to save in a HDF5 file}
\usage{
transformVectorForHdf5(x, .version = 3)
}
\arguments{
\item{x}{An atomic vector to be saved to HDF5.}

\item{.version}{Internal use only.}
}
\value{
A list containing:
\itemize{
\item \code{transformed}, the transformed vector.
This may be the same as \code{x} if no \code{NA} values were detected.
Note that logical vectors are cast to integers.
\item \code{placeholder}, the placeholder value used to represent \code{NA} values.
This is \code{NULL} if no \code{NA} values were detected in \code{x},
otherwise it is the same as the output of \code{\link{chooseMissingPlaceholderForHdf5}}.
}
}
\description{
This handles type casting and missing placeholder value selection/substitution.
It is primarily intended for developers of \pkg{alabaster.*} extensions.
}
\examples{
transformVectorForHdf5(c(TRUE, NA, FALSE))
transformVectorForHdf5(c(1L, NA, 2L))
transformVectorForHdf5(c(1L, NaN, 2L))
transformVectorForHdf5(c("FOO", NA, "BAR"))
transformVectorForHdf5(c("FOO", NA, "NA"))

}
\author{
Aaron Lun
}
