# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AutoHealActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Predefined action to be taken.
    """

    RECYCLE = "Recycle"
    LOG_EVENT = "LogEvent"
    CUSTOM_ACTION = "CustomAction"

class AzureResourceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Azure resource type.
    """

    WEBSITE = "Website"
    TRAFFIC_MANAGER = "TrafficManager"

class BackupItemStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Backup status.
    """

    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    TIMED_OUT = "TimedOut"
    CREATED = "Created"
    SKIPPED = "Skipped"
    PARTIALLY_SUCCEEDED = "PartiallySucceeded"
    DELETE_IN_PROGRESS = "DeleteInProgress"
    DELETE_FAILED = "DeleteFailed"
    DELETED = "Deleted"

class BackupRestoreOperationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the backup.
    """

    DEFAULT = "Default"
    CLONE = "Clone"
    RELOCATION = "Relocation"
    SNAPSHOT = "Snapshot"

class BuiltInAuthenticationProvider(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The default authentication provider to use when multiple providers are configured.
    This setting is only needed if multiple providers are configured and the unauthenticated client
    action is set to "RedirectToLoginPage".
    """

    AZURE_ACTIVE_DIRECTORY = "AzureActiveDirectory"
    FACEBOOK = "Facebook"
    GOOGLE = "Google"
    MICROSOFT_ACCOUNT = "MicrosoftAccount"
    TWITTER = "Twitter"

class CloneAbilityResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of app.
    """

    CLONEABLE = "Cloneable"
    PARTIALLY_CLONEABLE = "PartiallyCloneable"
    NOT_CLONEABLE = "NotCloneable"

class ConnectionStringType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of database.
    """

    MY_SQL = "MySql"
    SQL_SERVER = "SQLServer"
    SQL_AZURE = "SQLAzure"
    CUSTOM = "Custom"
    NOTIFICATION_HUB = "NotificationHub"
    SERVICE_BUS = "ServiceBus"
    EVENT_HUB = "EventHub"
    API_HUB = "ApiHub"
    DOC_DB = "DocDb"
    REDIS_CACHE = "RedisCache"
    POSTGRE_SQL = "PostgreSQL"

class ContinuousWebJobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Job status.
    """

    INITIALIZING = "Initializing"
    STARTING = "Starting"
    RUNNING = "Running"
    PENDING_RESTART = "PendingRestart"
    STOPPED = "Stopped"

class CustomHostNameDnsRecordType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Custom DNS record type.
    """

    C_NAME = "CName"
    A = "A"

class DatabaseType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Database type (e.g. SqlAzure / MySql).
    """

    SQL_AZURE = "SqlAzure"
    MY_SQL = "MySql"
    LOCAL_MY_SQL = "LocalMySql"
    POSTGRE_SQL = "PostgreSql"

class DnsVerificationTestResult(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """DNS verification test result.
    """

    PASSED = "Passed"
    FAILED = "Failed"
    SKIPPED = "Skipped"

class FrequencyUnit(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The unit of time for how often the backup should be executed (e.g. for weekly backup, this
    should be set to Day and FrequencyInterval should be set to 7)
    """

    DAY = "Day"
    HOUR = "Hour"

class HostNameType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Hostname type.
    """

    VERIFIED = "Verified"
    MANAGED = "Managed"

class HostType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the hostname is a standard or repository hostname.
    """

    STANDARD = "Standard"
    REPOSITORY = "Repository"

class LogLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Log level.
    """

    OFF = "Off"
    VERBOSE = "Verbose"
    INFORMATION = "Information"
    WARNING = "Warning"
    ERROR = "Error"

class ManagedPipelineMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Managed pipeline mode.
    """

    INTEGRATED = "Integrated"
    CLASSIC = "Classic"

class ManagedServiceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of managed service identity.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"

class MSDeployLogEntryType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Log entry type
    """

    MESSAGE = "Message"
    WARNING = "Warning"
    ERROR = "Error"

class MSDeployProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state
    """

    ACCEPTED = "accepted"
    RUNNING = "running"
    SUCCEEDED = "succeeded"
    FAILED = "failed"
    CANCELED = "canceled"

class MySqlMigrationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of migration operation to be done
    """

    LOCAL_TO_REMOTE = "LocalToRemote"
    REMOTE_TO_LOCAL = "RemoteToLocal"

class OperationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the operation.
    """

    IN_PROGRESS = "InProgress"
    FAILED = "Failed"
    SUCCEEDED = "Succeeded"
    TIMED_OUT = "TimedOut"
    CREATED = "Created"

class PublicCertificateLocation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Public Certificate Location
    """

    CURRENT_USER_MY = "CurrentUserMy"
    LOCAL_MACHINE_MY = "LocalMachineMy"
    UNKNOWN = "Unknown"

class PublishingProfileFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Name of the format. Valid values are:
    FileZilla3
    WebDeploy -- default
    Ftp
    """

    FILE_ZILLA3 = "FileZilla3"
    WEB_DEPLOY = "WebDeploy"
    FTP = "Ftp"

class RouteType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of route this is:
    DEFAULT - By default, every app has routes to the local address ranges specified by RFC1918
    INHERITED - Routes inherited from the real Virtual Network routes
    STATIC - Static route set on the app only
    
    These values will be used for syncing an app's routes with those from a Virtual Network.
    """

    DEFAULT = "DEFAULT"
    INHERITED = "INHERITED"
    STATIC = "STATIC"

class ScmType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SCM type.
    """

    NONE = "None"
    DROPBOX = "Dropbox"
    TFS = "Tfs"
    LOCAL_GIT = "LocalGit"
    GIT_HUB = "GitHub"
    CODE_PLEX_GIT = "CodePlexGit"
    CODE_PLEX_HG = "CodePlexHg"
    BITBUCKET_GIT = "BitbucketGit"
    BITBUCKET_HG = "BitbucketHg"
    EXTERNAL_GIT = "ExternalGit"
    EXTERNAL_HG = "ExternalHg"
    ONE_DRIVE = "OneDrive"
    VSO = "VSO"

class SiteAvailabilityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Management information availability state for the app.
    """

    NORMAL = "Normal"
    LIMITED = "Limited"
    DISASTER_RECOVERY_MODE = "DisasterRecoveryMode"

class SiteExtensionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Site extension type.
    """

    GALLERY = "Gallery"
    WEB_ROOT = "WebRoot"

class SiteLoadBalancing(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Site load balancing.
    """

    WEIGHTED_ROUND_ROBIN = "WeightedRoundRobin"
    LEAST_REQUESTS = "LeastRequests"
    LEAST_RESPONSE_TIME = "LeastResponseTime"
    WEIGHTED_TOTAL_TRAFFIC = "WeightedTotalTraffic"
    REQUEST_HASH = "RequestHash"

class SslState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SSL type.
    """

    DISABLED = "Disabled"
    SNI_ENABLED = "SniEnabled"
    IP_BASED_ENABLED = "IpBasedEnabled"

class SupportedTlsVersions(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """MinTlsVersion: configures the minimum version of TLS required for SSL requests
    """

    ONE0 = "1.0"
    ONE1 = "1.1"
    ONE2 = "1.2"

class TriggeredWebJobStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Job status.
    """

    SUCCESS = "Success"
    FAILED = "Failed"
    ERROR = "Error"

class UnauthenticatedClientAction(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The action to take when an unauthenticated client attempts to access the app.
    """

    REDIRECT_TO_LOGIN_PAGE = "RedirectToLoginPage"
    ALLOW_ANONYMOUS = "AllowAnonymous"

class UsageState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State indicating whether the app has exceeded its quota usage. Read-only.
    """

    NORMAL = "Normal"
    EXCEEDED = "Exceeded"

class WebJobType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Job type.
    """

    CONTINUOUS = "Continuous"
    TRIGGERED = "Triggered"
