/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonObject;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TextBlockJson
extends AbstractTextBlock
implements TextBlockBackcolored {
    private final List<Line> lines = new ArrayList<Line>();
    private final Style style;
    private final Style styleHightlight;
    private final ISkinParam skinParam;
    private double totalWidth;
    private final JsonValue root;

    private HColor getBackColor() {
        return this.styleHightlight.value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
    }

    public TextBlockJson(ISkinParam skinParam, JsonValue root, List<String> allHighlighteds, Style style, Style styleHightlight) {
        this.styleHightlight = styleHightlight;
        this.skinParam = skinParam;
        this.style = style;
        this.root = root;
        if (root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)root) {
                String key = member.getName();
                String value = this.getShortString(member.getValue());
                boolean highlighted = this.isHighlighted(key, allHighlighteds);
                TextBlock block1 = this.getTextBlock(this.getRightStyle(highlighted), key);
                TextBlock block2 = this.getTextBlock(this.getRightStyle(highlighted), value);
                this.lines.add(new Line(block1, block2, highlighted));
            }
        }
        if (root instanceof JsonArray) {
            int i = 0;
            for (JsonValue value : (JsonArray)root) {
                boolean highlighted = this.isHighlighted("" + i, allHighlighteds);
                TextBlock block2 = this.getTextBlock(this.getRightStyle(highlighted), this.getShortString(value));
                this.lines.add(new Line(block2, highlighted));
                ++i;
            }
        }
    }

    private Style getRightStyle(boolean highlighted) {
        if (highlighted) {
            return this.styleHightlight;
        }
        return this.style;
    }

    private boolean isHighlighted(String key, List<String> highlighted) {
        for (String tmp : highlighted) {
            if (!tmp.trim().equals("\"" + key + "\"")) continue;
            return true;
        }
        return false;
    }

    public int size() {
        int size = 0;
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                ++size;
            }
        }
        if (this.root instanceof JsonArray) {
            for (JsonValue value : (JsonArray)this.root) {
                ++size;
            }
        }
        return size;
    }

    private String getShortString(JsonValue value) {
        if (value.isString()) {
            return value.asString();
        }
        if (value.isNull()) {
            return "<U+2400>";
        }
        if (value.isNumber()) {
            return value.toString();
        }
        if (value.isBoolean()) {
            if (value.isTrue()) {
                return "<U+2611> true";
            }
            return "<U+2610> false";
        }
        return "   ";
    }

    public List<JsonValue> children() {
        ArrayList<JsonValue> result = new ArrayList<JsonValue>();
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                JsonValue value = member.getValue();
                if (value instanceof JsonObject || value instanceof JsonArray) {
                    result.add(value);
                    continue;
                }
                result.add(null);
            }
        }
        if (this.root instanceof JsonArray) {
            for (JsonValue value : (JsonArray)this.root) {
                if (value instanceof JsonObject || value instanceof JsonArray) {
                    result.add(value);
                    continue;
                }
                result.add(null);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<String> keys() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.root instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)this.root) {
                String key = member.getName();
                result.add(key);
            }
        }
        if (this.root instanceof JsonArray) {
            int i = 0;
            for (JsonValue value : (JsonArray)this.root) {
                result.add("" + i);
                ++i;
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getWidthColA(stringBounder) + this.getWidthColB(stringBounder), this.getTotalHeight(stringBounder));
    }

    public double getWidthColA(StringBounder stringBounder) {
        double width = 0.0;
        for (Line line : this.lines) {
            width = Math.max(width, line.b1.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    public double getWidthColB(StringBounder stringBounder) {
        double width = 0.0;
        for (Line line : this.lines) {
            if (line.b2 == null) continue;
            width = Math.max(width, line.b2.calculateDimension(stringBounder).getWidth());
        }
        return width;
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D fullDim = this.calculateDimension(stringBounder);
        double trueWidth = Math.max(fullDim.getWidth(), this.totalWidth);
        double widthColA = this.getWidthColA(stringBounder);
        double widthColB = this.getWidthColB(stringBounder);
        double y = 0.0;
        UGraphic ugNode = this.style.applyStrokeAndLineColor(ug, this.skinParam.getIHtmlColorSet(), this.skinParam.getThemeStyle());
        for (Line line : this.lines) {
            double heightOfRow = line.getHeightOfRow(stringBounder);
            y += heightOfRow;
        }
        if (y == 0.0) {
            y = 15.0;
        }
        if (trueWidth == 0.0) {
            trueWidth = 30.0;
        }
        double round = this.style.value(PName.RoundCorner).asDouble();
        URectangle fullNodeRectangle = new URectangle(trueWidth, y).rounded(round);
        HColor backColor = this.style.value(PName.BackGroundColor).asColor(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        ugNode.apply(backColor.bg()).apply(backColor).draw(fullNodeRectangle);
        Style styleSeparator = this.style.getSignature().add(SName.separator).getMergedStyle(this.skinParam.getCurrentStyleBuilder());
        UGraphic ugSeparator = styleSeparator.applyStrokeAndLineColor(ug, this.skinParam.getIHtmlColorSet(), this.skinParam.getThemeStyle());
        y = 0.0;
        for (Line line : this.lines) {
            UGraphic ugline = ugSeparator.apply(UTranslate.dy(y));
            double heightOfRow = line.getHeightOfRow(stringBounder);
            if (line.highlighted) {
                URectangle back = new URectangle(trueWidth - 2.0, heightOfRow).rounded(4.0);
                ugline.apply(this.getBackColor()).apply(this.getBackColor().bg()).apply(new UTranslate(1.5, 0.0)).draw(back);
            }
            if (y > 0.0) {
                ugline.draw(ULine.hline(trueWidth));
            }
            HorizontalAlignment horizontalAlignment = this.style.getHorizontalAlignment();
            horizontalAlignment.draw(ugline, line.b1, 0.0, widthColA);
            if (line.b2 != null) {
                UGraphic uglineColB = ugline.apply(UTranslate.dx(widthColA));
                horizontalAlignment.draw(uglineColB, line.b2, 0.0, widthColB);
                uglineColB.draw(ULine.vline(heightOfRow));
            }
            y += heightOfRow;
        }
        ugNode.draw(fullNodeRectangle);
    }

    private double getTotalHeight(StringBounder stringBounder) {
        double height = 0.0;
        for (Line line : this.lines) {
            height += line.getHeightOfRow(stringBounder);
        }
        return height;
    }

    private TextBlock getTextBlock(Style style, String key) {
        Display display = Display.getWithNewlines(key);
        FontConfiguration fontConfiguration = style.getFontConfiguration(this.skinParam.getThemeStyle(), this.skinParam.getIHtmlColorSet());
        LineBreakStrategy wrap = style.wrapWidth();
        HorizontalAlignment horizontalAlignment = style.getHorizontalAlignment();
        TextBlock result = display.create0(fontConfiguration, horizontalAlignment, this.skinParam, wrap, CreoleMode.NO_CREOLE, null, null);
        result = TextBlockUtils.withMargin(result, 5.0, 2.0);
        return result;
    }

    public void setTotalWidth(double totalWidth) {
        this.totalWidth = totalWidth;
    }

    @Override
    public HColor getBackcolor() {
        return null;
    }

    static class Line {
        final TextBlock b1;
        final TextBlock b2;
        final boolean highlighted;

        Line(TextBlock b1, TextBlock b2, boolean highlighted) {
            this.b1 = b1;
            this.b2 = b2;
            this.highlighted = highlighted;
        }

        Line(TextBlock b1, boolean highlighted) {
            this(b1, null, highlighted);
        }

        double getHeightOfRow(StringBounder stringBounder) {
            double height = this.b1.calculateDimension(stringBounder).getHeight();
            if (this.b2 == null) {
                return height;
            }
            return Math.max(height, this.b2.calculateDimension(stringBounder).getHeight());
        }
    }
}

