% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ReadList}
\alias{ReadList}
\title{Load dosages for multiple variants as a numeric matrix.}
\usage{
ReadList(pgen, variant_subset, meanimpute = FALSE)
}
\arguments{
\item{pgen}{Object returned by NewPgen().}

\item{variant_subset}{Integer vector containing 1-based indexes of variants
to load.}

\item{meanimpute}{Optional; if true, missing values are mean-imputed
instead of being represented by NA.}
}
\value{
Numeric matrix, where rows correspond to samples, and columns
correspond to variant_subset.  Values are in [0, 2] indicating ALT
allele dosages, or NA for missing dosages.  For multiallelic variants, all
ALT alelles are combined.
}
\description{
This function treats the data as diploid; divide by 2 to obtain haploid
dosages.
}
