/****************************************************************************
 *  Copyright (c) 2014 Anthony Vital <anthony.vital@gmail.com>              *
 *                                                                          *
 *  This file is part of Gmail Feed.                                        *
 *                                                                          *
 *  Gmail Feed is free software: you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by    *
 *  the Free Software Foundation, either version 3 of the License, or       *
 *  (at your option) any later version.                                     *
 *                                                                          *
 *  Gmail Feed is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of          *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           *
 *  GNU General Public License for more details.                            *
 *                                                                          *
 *  You should have received a copy of the GNU General Public License       *
 *  along with Gmail Feed.  If not, see <http://www.gnu.org/licenses/>.     *
 ****************************************************************************/

#include "gmailfeedplugin.h"
#include "networkstatus.h"
#include "notification.h"
#include "account.h"
#include "accountsModel.h"

#include <QtQml>

void GmailFeedPlugin::registerTypes (const char *uri)
{
    Q_ASSERT(uri == QLatin1String("org.kde.plasma.private.gmailfeed"));
    qmlRegisterType<NetworkStatus>(uri, 0, 1, "NetworkStatus");
    qmlRegisterType<Notification>(uri, 0, 1, "Notification");
    qmlRegisterType<Account>(uri, 0, 1, "Account");
    qmlRegisterType<AccountsModel>(uri, 0, 1, "AccountsModel");
}
