// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <MFIXPluginInfo.h>
#include <avtMFIXFileFormat.h>
#include <avtMTMDFileFormatInterface.h>
#include <avtGenericDatabase.h>
#include <avtMFIXOptions.h>

// ****************************************************************************
//  Method:  MFIXCommonPluginInfo::GetDatabaseType
//
//  Purpose:
//    Returns the type of a MFIX database.
//
//  Programmer:  generated by xml2info
//  Creation:    omitted
//
// ****************************************************************************
DatabaseType
MFIXCommonPluginInfo::GetDatabaseType()
{
    return DB_TYPE_MTMD;
}

// ****************************************************************************
//  Method: MFIXCommonPluginInfo::SetupDatabase
//
//  Purpose:
//      Sets up a MFIX database.
//
//  Arguments:
//      list    A list of file names.
//      nList   The number of timesteps in list.
//      nBlocks The number of blocks in the list.
//
//  Returns:    A MFIX database from list.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
avtDatabase *
MFIXCommonPluginInfo::SetupDatabase(const char *const *list,
                                   int nList, int nBlock)
{
    // ignore any nBlocks past 1
    int nTimestepGroups = nList / nBlock;
    avtMTMDFileFormat **ffl = new avtMTMDFileFormat*[nTimestepGroups];
    for (int i = 0; i < nTimestepGroups; i++)
    {
        ffl[i] = new avtMFIXFileFormat(list[i*nBlock], readOptions);
    }
    avtMTMDFileFormatInterface *inter
           = new avtMTMDFileFormatInterface(ffl, nTimestepGroups);
    return new avtGenericDatabase(inter);
}

// ****************************************************************************
//  Method: MFIXCommonPluginInfo::GetReadOptions
//
//  Purpose:
//      Gets the read options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
MFIXCommonPluginInfo::GetReadOptions() const
{
    return GetMFIXReadOptions();
}

// ****************************************************************************
//  Method: MFIXCommonPluginInfo::GetWriteOptions
//
//  Purpose:
//      Gets the write options.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

DBOptionsAttributes *
MFIXCommonPluginInfo::GetWriteOptions() const
{
    return GetMFIXWriteOptions();
}

