# ITK 5.4.0 Release Notes: ReadTheDocs Documentation

We are happy to announce the [Insight Toolkit (ITK)](https://docs.itk.org) 5.4.0 is available for download! 🎉 🍻 🥳 ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration in a spatially-oriented architecture.

🔦 Highlights
-------------------------

We're excited to announce a transformation of ITK's documentation ecosystem in version 5.4.0. The documentation infrastructure has been modernized to provide a more accessible, maintainable, and user-friendly experience.

### New Markdown-Based Documentation

Our documentation has undergone a complete migration from the traditional landing page and wiki to a modern, Markdown-based system hosted on ReadTheDocs. Experience our enhanced documentation at [https://docs.itk.org](https://docs.itk.org).

[![ITK's new documentation](https://i.imgur.com/4gTahoP.png)](https://docs.itk.org)
*ITK's new Markdown-based documentation, editable on GitHub and hosted on ReadTheDocs.*

### Enhanced API Documentation

The Doxygen documentation has been seamlessly integrated into ReadTheDocs, offering several key advantages:
- Global CDN-powered access for fast, responsive performance worldwide
- Complete archive of all previous API versions
- Improved navigation and usability

[![ITK's Doxygen documentation](https://i.imgur.com/6rQ8lrO.png)](https://docs.itk.org/projects/doxygen/en/stable/index.html)
*ITK's Doxygen documentation, hosted on ReadTheDocs, provides easy access to all previous versions.*

### Unified Search Experience

Leveraging ReadTheDocs' subprojects architecture, we've implemented a powerful unified search system that:

- Searches across all documentation sources simultaneously
- Delivers fast, relevant results
- Provides advanced search capabilities
- Improves discovery of related content

[![ITK's unified search](https://i.imgur.com/Y8N7WKH.png)](https://docs.itk.org)
*ITK's unified search across documentation sources, hosted on ReadTheDocs.*

These improvements represent our commitment to providing the best possible documentation experience for the ITK community. The new system not only enhances accessibility but also sets the foundation for future documentation innovations.

### Elegant, Performance-optimized, Modern C++

This release candidate expands our support for elegant, performant, modern C++. For example, specializations of `std::tuple_size ` and `std::tuple_element` for `itk::ImageRegion` in order to support C++17 structured bindings enable compile-time optimized statements to provide a multidimenional region's index and size:

```cxx
auto [index, size] = image.GetRequestedRegion();
```

For more information on ITK 5.4's modern C++ support, see [the Release Candidate 1 release notes](https://docs.itk.org/en/latest/releases/5.4rc01.html).

### Python 3.11 and Stable ABI Wheels

Moreover, this release candidate extends the toolkit's sustainability and Python support through Stable ABI Python wheels. This is made possible by upgrades to SWIG and [scikit-build-core](https://scikit-build-core.readthedocs.io/en/latest/), the modern Python packaging standard evolution of scikit-build classic. Python 3.11 wheels will be recognized by `pip` and work with Python 3.11, 3.12, 3.13, 3.14, etc. While we also provide cross-platform wheels for Python 3.8-3.10, we can only use the Stable ABI with Python 3.11 because it is required for [`itk`'s NumPy support](https://docs.itk.org/en/latest/learn/python_quick_start.html#itk-and-numpy).

### Remote Module Enhancements

ITK Remote Modules now also have GitHub Action-driven mac ARM / Apple Silicon Python wheel generation support. While a Remote Module *setup.py* file is still supported in ITK 5.4, migration to a scikit-build-core *pyproject.toml* file is encouraged. One important advantage is the generation of Stable ABI wheels for Python 3.11+. To migrate to scikit-build-core, use [this pyproject.toml template](https://github.com/InsightSoftwareConsortium/ITKModuleTemplate/blob/main/%7B%7Bcookiecutter.project_name%7D%7D/pyproject.toml) and remove the *setup.py* file.

### DICOM and Web3 Testing Data

For a summary of changes that continue our sustainability evolution with Web3 testing data, see the [5.4 Release Candidate 2 release notes](https://docs.itk.org/en/latest/releases/5.4rc02.html). For a summary of DICOM improvements, including expanded support for additional modality features and crucial spatial metadata for Secondary Capture images, see the [5.4 Release Candidate 4 release notes](https://docs.itk.org/en/latest/releases/5.4rc04.html).

💾 Download
-------------

**Python Packages**

Install [ITK Python packages](https://docs.itk.org/en/latest/learn/python_quick_start.html) with:

```bash
pip install itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.4.0.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightSoftwareGuide-Book1-5.4.0.pdf)
- [InsightSoftwareGuide-Book2-5.4.0.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightSoftwareGuide-Book2-5.4.0.pdf)

**Library Sources**

- [InsightToolkit-5.4.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightToolkit-5.4.0.tar.gz)
- [InsightToolkit-5.4.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightToolkit-5.4.0.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.4.0.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightData-5.4.0.tar.gz)
- [InsightData-5.4.0.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightData-5.4.0.zip)

**Checksums and Signatures**

- [InsightToolkit-5.4.0.tar.gz.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightToolkit-5.4.0.tar.gz.asc)
- [InsightToolkit-5.4.0.zip.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightToolkit-5.4.0.zip.asc)

- [InsightData-5.4.0.tar.gz.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightData-5.4.0.tar.gz.asc)
- [InsightData-5.4.0.zip.asc](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/InsightData-5.4.0.zip.asc)

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4.0/SHA512SUMS)

✨ Features
------------

### Python

- Wrapping for `itk.PhasedArray3DSpecialCoordinatesImage`
- Better support for multi-component images in `image_from_vtk_image`
- `itk.imread` supports a `series_uid` kwarg for DICOM series selection
- TBB version updated to latest stable version, disabled on Intel macOS
- Python binaries for 3.8-3.11 across platforms
- Python 3.11 uses the Stable ABI -- works with Python 3.11+
- Python 3.7 is no longer supported
- Apple Silicon Remote Module GitHub Action wheels
- Updated to the latest version of scikit-build-core
- Import time improvements with `torch`
- Add `dict_from_polyline`, `polyline_from_dict`
- Add `bufferedRegion` to `dict_from_image` representation
- Support passing a single transform to `transformwrite`

### C++

- C++17 is now required
- Many style improvements for modern C++ and consistency
- GCC 13 support
- Name mangling prefix for third party libraries is configurable
- Update mangled 3rd-parties to use `MANGLE_PREFIX` CMake variable
- Many improvements to code coverage
- Enhanced NRRD and Nifti metadata support
- CMake `OPTIONAL_COMPONENTS` support
- Apply cmake-format for a consistent CMake style
- `get()` member function to `itk::SmartPointer`
- `itk::Size::CalculateProductOfElements()`, to compute number of pixels
- `Deref(T *)`, to ease dereferencing a pointer safely
- `itk::ShapedImageNeighborhoodRange` support C-array of offsets (by C++17)
- Add `itk::Copy(const T & original)`, which simply returns a copy
- Make `itk::ImageRegion` trivially copyable, remove inheritance (FUTURE)
- `itk::VTKPolyDataMeshIO` support for reading VTK 5.1 format
- Add `ITK_DEFAULT_COPY_AND_MOVE(TypeName)` macro definition 
- Replace `(const std::string)` casts with C++17 `std::string_view`
- Replace SetSize/Index calls in tests with `region{ index, size }`
- Optionally limit an `ImageMask` to a specific pixel value

### Performance

- Use index/point transforms without bounds checking
- Improved SSE2 detection
- Many improvements to how locks are handled
- Major `itk::SpatialObject` performance improvements

### Documentation

- New GitHub Action to check spelling
- Doxygen formatting cleanup
- Doxygen spelling fixes
- Doxygen Insight Journal links are consistent
- Many Doxygen improvements to the content
- Software Guide updated for style modernization
- Change the Insight Journal handle links to insight-journal links
- Replace `itkTypeMacro` with `itkOverrideGetNameOfClassMacro`
- Cryptographic signatures are provided for release sources

### Remote module updates

New modules:

- [FastBilateral](https://hackmd.io/I4AtOFiKSI6rvHKm1fYmeA) - A Fast Approximation to the Bilateral Filter for ITK. [Insight Journal article](https://insight-journal.org/browse/publication/692).

Updated modules:
- [BSplineGradient](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient.git)
- [BoneMorphometry](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry.git)
- [Cleaver](https://github.com/SCIInstitute/ITKCleaver.git)
- [Cuberille](https://github.com/InsightSoftwareConsortium/ITKCuberille.git),
- [CudaCommon](https://github.com/RTKConsortium/ITKCudaCommon.git)
- [FPFH](https://github.com/InsightSoftwareConsortium/ITKFPFH.git)
- [GenericLabelInterpolator](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator.git)
- [HASI](https://github.com/KitwareMedical/HASI.git)
- [HigherOrderAccurateGradient](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient.git)
- [IOMeshSTL](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL.git)
- [IOMeshSWC](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC.git)
- [IOScanco](https://github.com/KitwareMedical/ITKIOScanco.git)
- [LabelErodeDilate](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate.git)
- [MeshToPolyData](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData.git)
- [MinimalPathExtraction](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction.git)
- [Montage](https://github.com/InsightSoftwareConsortium/ITKMontage.git)
- [MorphologicalContourInterpolation](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation.git)
- [ParabolicMorphology](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology.git)
- [RANSAC](https://github.com/InsightSoftwareConsortium/ITKRANSAC.git)
- [RLEImage](https://github.com/KitwareMedical/ITKRLEImage.git)
- [RTK](https://github.com/RTKConsortium/RTK.git)
- [Shape](https://github.com/SlicerSALT/ITKShape.git)
- [SimpleITKFilters](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters.git)
- [SplitComponents](https://github.com/InsightSoftwareConsortium/ITKSplitComponents.git)
- [Strain](https://github.com/KitwareMedical/ITKStrain.git)
- [TextureFeatures](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures.git)
- [Thickness3D](https://github.com/InsightSoftwareConsortium/ITKThickness3D.git)
- [TubeTK](https://github.com/InsightSoftwareConsortium/ITKTubeTK.git)
- [Ultrasound](https://github.com/KitwareMedical/ITKUltrasound.git)
- [VkFFTBackend](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend.git)
- [WebAssemblyInterface](https://github.com/InsightSoftwareConsortium/itk-wasm.git)


### Third party library updates

- dcmtk
- eigen
- gdcm
- googletest
- kwsys
- minc
- meta-io
- nifti
- pygccxml
- vxl
- zlib-ng


🙏 Congratulations
------------------------

Congratulations and **thank you** to everyone who contributed to this release.

Of the *60 authors* who contributed since v5.3.0, we would like to specially recognize the new contributors:

*Andrei Sandor, Nicklas Larsson, huangjxbq, Sankhesh Jhaveri, adrinkwater, FabioLolix, Vaibhaw, Ningfei Li, Max Aehle, Noah Egnatis, Federico Zivolo, Patrick Linnane, Shreeraj Jadhav, Shengpeng YU, Fernando Bordignon, Andras Lasso, Bernhard Froehler, Thomas BAUDIER, Matthieu LAURENDEAU, Fabian Wenzel, Mikhail Polkovnikov, Pritam Rungta, Florian de Gaulejac, Ramon Emiliani, Martin Hoßbach, Sadhana Ravikumar, and Gabriel Chartrand.*

We extend our gratitude to all the ITK community members who have contributed to this release through code submissions, bug reports, and insightful discussions online.

🗣️ What's Next
---------------

ITK 5.4.0 represents a transformative milestone in our documentation journey. The finalization of 5.4.0 was delayed due to dependency issues in the example documentation's infrastructure. While these are addressed, we'll continue to refine the 5.4 series through patch releases. We're excited to eventually migrate the examples to a similar robust foundation in future innovations. 

Looking ahead, we're thrilled to announce that ITK 6, our next major release, will showcase a substantial array of modernizations. The community has been hard at work implementing significant improvements that will elevate development with and on the toolkit. Watch for upcoming alpha and beta releases of ITK 6, which will run parallel to our 5.4 maintenance efforts.

This dual-track approach ensures both stability for current users and innovation for those ready to explore new features. Stay tuned for announcements about ITK 6's preview releases, which will demonstrate the exciting evolution of the Insight Toolkit.

**Enjoy ITK!**


ITK Changes Since v5.4rc04
---------------------------------------------

### Andrei Sandor (2):

#### Platform Fixes

- Fixed Cpp Warnings ([904c7c5838](https://github.com/InsightSoftwareConsortium/ITK/commit/904c7c5838))
- Remove \brief with nothing after ([0fbb3bca2d](https://github.com/InsightSoftwareConsortium/ITK/commit/0fbb3bca2d))


### Bradley Lowekamp (4):

#### Platform Fixes

- Add testing of IsCongruentImageGeometry IsSameImageGeometryAs ([7f1c584608](https://github.com/InsightSoftwareConsortium/ITK/commit/7f1c584608))
- Suppress LabelGeometryImageFilter deprecated warning ([4f4110a275](https://github.com/InsightSoftwareConsortium/ITK/commit/4f4110a275))

#### Bug Fixes

- Mark LabelGeometryImageFilter as deprecated ([eb8230c46b](https://github.com/InsightSoftwareConsortium/ITK/commit/eb8230c46b))

#### Style Changes

- Improve style of Image.IsXGeometry ([f383fe0a95](https://github.com/InsightSoftwareConsortium/ITK/commit/f383fe0a95))


### Dženan Zukić (4):

#### Enhancements

- Update Montage remote module ([3235b3675c](https://github.com/InsightSoftwareConsortium/ITK/commit/3235b3675c))
- Update remote modules using a script ([004fd7c066](https://github.com/InsightSoftwareConsortium/ITK/commit/004fd7c066))
- Update KWStyle [GCC 13.2 output buffer size truncation warnings] ([a23e9a215a](https://github.com/InsightSoftwareConsortium/ITK/commit/a23e9a215a))

#### Documentation Updates

- Add See Also entries for alternatives to LabelGeometryImageFilter ([f408b77a57](https://github.com/InsightSoftwareConsortium/ITK/commit/f408b77a57))


### GDCM Upstream (1):

#### Miscellaneous Changes

- GDCM 2024-05-03 (2eaae209) ([a6240d348d](https://github.com/InsightSoftwareConsortium/ITK/commit/a6240d348d))


### Hans Johnson (13):

#### Enhancements

- Add tests for known required size constraints ([1540fa4ba4](https://github.com/InsightSoftwareConsortium/ITK/commit/1540fa4ba4))

#### Performance Improvements

- Prefer initialization to assignment ([e64032ae75](https://github.com/InsightSoftwareConsortium/ITK/commit/e64032ae75))

#### Platform Fixes

- Avoid gcc13.2 compiler out-of-bounds index warnings ([a0b816529c](https://github.com/InsightSoftwareConsortium/ITK/commit/a0b816529c))
- Avoid compiler false positive warning when assuming string processing ([323e8217e1](https://github.com/InsightSoftwareConsortium/ITK/commit/323e8217e1))
- Fix uninialized variable warning ([d9fcaa08e7](https://github.com/InsightSoftwareConsortium/ITK/commit/d9fcaa08e7))
- Fix array bound warning for typecast initial value ([462a874af2](https://github.com/InsightSoftwareConsortium/ITK/commit/462a874af2))
- Fix gcc 13.2 compiler warning of large allocation size ([6dcfb74e6b](https://github.com/InsightSoftwareConsortium/ITK/commit/6dcfb74e6b))
- Fix gcc 13.2 compiler warnings ([408cf0c7de](https://github.com/InsightSoftwareConsortium/ITK/commit/408cf0c7de))

#### Style Changes

- Spelling Trasform->Transform fixes. ([6324749c66](https://github.com/InsightSoftwareConsortium/ITK/commit/6324749c66))
- Simplify code to remove unneeded dynamic_cast ([6650d2ce90](https://github.com/InsightSoftwareConsortium/ITK/commit/6650d2ce90))
- Make variable for magic number ([fbe68ab5e2](https://github.com/InsightSoftwareConsortium/ITK/commit/fbe68ab5e2))
- Remove dead code suppression of C++11 warnings ([fdb94eddc5](https://github.com/InsightSoftwareConsortium/ITK/commit/fdb94eddc5))
- Make variables local scope ([1155b5e99b](https://github.com/InsightSoftwareConsortium/ITK/commit/1155b5e99b))


### Jon Haitz Legarreta Gorroño (4):

#### Platform Fixes

- Suppress `-Wformat-nonliteral` warning in diff tensor example ([abc789e834](https://github.com/InsightSoftwareConsortium/ITK/commit/abc789e834))
- Use `default` copy and move construct and assign in `itk::Region` ([ec2677f5a5](https://github.com/InsightSoftwareConsortium/ITK/commit/ec2677f5a5))
- Use `default` copy, move for construc, assign `RealTimeStamp` ([9aff2101c1](https://github.com/InsightSoftwareConsortium/ITK/commit/9aff2101c1))
- Fix implicit copy constructor definition deprecation warnings ([d1ebdfaff6](https://github.com/InsightSoftwareConsortium/ITK/commit/d1ebdfaff6))


### KWSys Upstream (2):

#### Miscellaneous Changes

- KWSys 2024-03-08 (bc0706e7) ([22754ed242](https://github.com/InsightSoftwareConsortium/ITK/commit/22754ed242))
- KWSys 2024-03-08 (bc0706e7) ([7e3f90d526](https://github.com/InsightSoftwareConsortium/ITK/commit/7e3f90d526))


### Matt McCormick (19):

#### Enhancements

- Add dict_from_polyline, polyline_from_dict ([60f89eecbf](https://github.com/InsightSoftwareConsortium/ITK/commit/60f89eecbf))

#### Documentation Updates

- Add 5.4 Release Candidate 4 release notes ([57a6a66cc1](https://github.com/InsightSoftwareConsortium/ITK/commit/57a6a66cc1))
- ITK 5.4 RC 3 release documentation updates ([d7b20b5931](https://github.com/InsightSoftwareConsortium/ITK/commit/d7b20b5931))
- Update logo colors ([54b7807e2a](https://github.com/InsightSoftwareConsortium/ITK/commit/54b7807e2a))

#### Platform Fixes

- Add GDCM system version check for SetSecondaryCaptureImagePlaneModule ([f4e9b0ba28](https://github.com/InsightSoftwareConsortium/ITK/commit/f4e9b0ba28))
- Exclude itkPyBufferMemoryLeak test from macOS ARM CI ([6df6b72557](https://github.com/InsightSoftwareConsortium/ITK/commit/6df6b72557))
- GCC 13 CastXML vector include workaround ([ad6c58223d](https://github.com/InsightSoftwareConsortium/ITK/commit/ad6c58223d))

#### Bug Fixes

- AuthorsChangesSince.py support both single and multiline ([487da6d086](https://github.com/InsightSoftwareConsortium/ITK/commit/487da6d086))
- Make dict_from_transform more consistent with other dict representations ([5397f81b7f](https://github.com/InsightSoftwareConsortium/ITK/commit/5397f81b7f))
- Add bufferedRegion to dict_from_image representation ([c66b0466cd](https://github.com/InsightSoftwareConsortium/ITK/commit/c66b0466cd))
- Support passing a single transform to transform write ([36b3abec9a](https://github.com/InsightSoftwareConsortium/ITK/commit/36b3abec9a))
- array_from_image shape for VectorImage with 1 component ([2447a812b0](https://github.com/InsightSoftwareConsortium/ITK/commit/2447a812b0))
- Use unique filenames for Nifti tests ([396d62f051](https://github.com/InsightSoftwareConsortium/ITK/commit/396d62f051))
- ElementType with PolyLineParametricPath ContinuousIndex ([db44bc8b9a](https://github.com/InsightSoftwareConsortium/ITK/commit/db44bc8b9a))
- VTKPolyDataMeshIO support for reading VTK 5.1 format ([30a9409d89](https://github.com/InsightSoftwareConsortium/ITK/commit/30a9409d89))
- Mark GDCM macOS CMake variables as advanced ([8e928a1cc0](https://github.com/InsightSoftwareConsortium/ITK/commit/8e928a1cc0))
- Mark Module_FastBilateral as advanced ([f1c390a1e2](https://github.com/InsightSoftwareConsortium/ITK/commit/f1c390a1e2))
- Wrap SymmetricEigenAnalysisImageFilter with CovariantVector Image output ([6e96da5956](https://github.com/InsightSoftwareConsortium/ITK/commit/6e96da5956))

#### Style Changes

- Apply clang-format to LabelGeometryImageFilter ([ef9907597b](https://github.com/InsightSoftwareConsortium/ITK/commit/ef9907597b))


### Mihail Isakov (1):

#### Platform Fixes

- Update GDCM system version check for SetSecondaryCaptureImagePlaneModule ([6e14aadeff](https://github.com/InsightSoftwareConsortium/ITK/commit/6e14aadeff))


### Niels Dekker (6):

#### Enhancements

- Add `ITK_DEFAULT_COPY_AND_MOVE(TypeName)` macro definition ([f65623be95](https://github.com/InsightSoftwareConsortium/ITK/commit/f65623be95))

#### Style Changes

- Replace `(const std::string)` casts with C++17 `std::string_view` ([2a1265d75f](https://github.com/InsightSoftwareConsortium/ITK/commit/2a1265d75f))
- Replace SetSize/Index calls in tests with `region{ index, size }` ([8f70ee7da1](https://github.com/InsightSoftwareConsortium/ITK/commit/8f70ee7da1))
- Replace SetIndex/Size calls in tests with `region{ index, size }` ([3282875e7c](https://github.com/InsightSoftwareConsortium/ITK/commit/3282875e7c))
- Use ITK_DEFAULT_COPY_AND_MOVE for exceptions of Image and Mesh IO ([16e6475260](https://github.com/InsightSoftwareConsortium/ITK/commit/16e6475260))
- Use ITK_DEFAULT_COPY_AND_MOVE for `RealTimeStamp` and `Region` ([4f42280e98](https://github.com/InsightSoftwareConsortium/ITK/commit/4f42280e98))


### Philip Cook (2):

#### Enhancements

- Handle NIFTI space and time units more consistently ([d9029dccb9](https://github.com/InsightSoftwareConsortium/ITK/commit/d9029dccb9))

#### Bug Fixes

- Fix path to write itkNiftiImageIOTest14 data ([21b74f0584](https://github.com/InsightSoftwareConsortium/ITK/commit/21b74f0584))


### Sean McBride (2):

#### Platform Fixes

- Suppress some Wformat-nonliteral warnings ([defa7129be](https://github.com/InsightSoftwareConsortium/ITK/commit/defa7129be))
- restored old spelling of CLANG_SUPPRESS_Wfloat_equal ([0c6782999b](https://github.com/InsightSoftwareConsortium/ITK/commit/0c6782999b))


### Simon Rit (1):

#### Enhancements

- update remote module RTK ([2132909781](https://github.com/InsightSoftwareConsortium/ITK/commit/2132909781))


### Stephen R. Aylward (3):

#### Enhancements

- Optionally limit an ImageMask to a specific pixel value ([c377692288](https://github.com/InsightSoftwareConsortium/ITK/commit/c377692288))

#### Performance Improvements

- Changed conditionals and use of const vars for speed ([610de818c0](https://github.com/InsightSoftwareConsortium/ITK/commit/610de818c0))

#### Bug Fixes

- Fix SpatialObjectProperties.GetTag*Value() to return values ([ad25ca8900](https://github.com/InsightSoftwareConsortium/ITK/commit/ad25ca8900))




ITK Sphinx Examples Changes Since v5.4rc04
---------------------------------------------

### Hans J. Johnson (1):

#### Platform Fixes

- Updating to find_package(Python3) ([c84d33bc](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c84d33bc))


### Hans Johnson (3):

#### Platform Fixes

- Fix type comparison mismatch ([00e2fad7](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/00e2fad7))
- Fix set but not used warnings ([15820140](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/15820140))

#### Style Changes

- One declaration per line for readability ([a63e366a](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a63e366a))


### Jon Haitz Legarreta Gorroño (6):

#### Enhancements

- Bump `macOS` version to 10.13 in GHA build, test, publish ([540f1852](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/540f1852))
- Use specific XCode version for GHA macOS 13 build ([a88dee79](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a88dee79))
- Bump macOS version for notebook build, test GHA action step ([e7af6630](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/e7af6630))
- Bump checkout and setup-python GitHub actions versions ([3df5ef36](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3df5ef36))
- Bump super-linter GitHub action version ([38d345a5](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/38d345a5))
- Bump `upload-artifact` actions version to v4 ([f0bd2af9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f0bd2af9))


### Matt McCormick (4):

#### Documentation Updates

- Update Doxygen XML for ITK 5.3.0 ([94e4144f](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/94e4144f))

#### Platform Fixes

- Bump itkwdigets version 1.0a51 ([75bef2a0](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/75bef2a0))

#### Style Changes

- Specify ReadTheDocs custom domain configuration ([be8dcfc3](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/be8dcfc3))
- Remove extra spaces in CMake/Doxygen* ([dfb07dae](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/dfb07dae))


### Niels Dekker (4):

#### Platform Fixes

- Replace itkTypeMacro calls with `itkOverrideGetNameOfClassMacro` ([3b20b544](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3b20b544))

#### Style Changes

- Replace `Fill(0)` on local variables with `{}` initialization ([f5ca3d30](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f5ca3d30))
- Replace `Size var; var.Fill` with `auto var = Size::Filled` ([fe7bd2ae](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/fe7bd2ae))
- Replace `Index var; var.Fill` with `auto var = Index::Filled` ([6fac7f27](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/6fac7f27))


### Pablo Hernandez-Cerdan (1):

#### Enhancements

- Bump ITK to 5.4.0 release ([f6c8b9c8](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f6c8b9c8))


### Tom Birdsong (2):

#### Enhancements

- Modify test macro with option for Python baseline test only ([64c20ec1](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/64c20ec1))
- Add 1D FFT Example ([8b7f38dd](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/8b7f38dd))




ITK Software Guide Changes Since v5.4rc04
---------------------------------------------

### Dženan Zukić (2):

#### Documentation Updates

- Fix a typo in CreateAModule chapter ([1d04a60](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/1d04a60))
- Update supported compiler version information ([95b46fe](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/95b46fe))


### Matt McCormick (6):

#### Enhancements

- Bump ITK Superbuild version to 5.4 RC 4 ([f37b396](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f37b396))
- Improve Actions PDF artifact name ([dd86548](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/dd86548))
- Bump ITK version to v5.4.0 ([c722c6a](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/c722c6a))

#### Documentation Updates

- Update ITK logo ([d341bad](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/d341bad))
- Update single PDF cover page for ITK 5.4.0 ([0e3ae9e](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/0e3ae9e))

#### Platform Fixes

- Bump actions versions ([7af04df](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/7af04df))


### Niels Dekker (2):

#### Enhancements

- Add section "Initializing variables of fixed size array types" ([f10846c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/f10846c))

#### Platform Fixes

- Replace backticks with `\code{}` in Initialization and Assignment ([5246e64](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/5246e64))




Remote Module Changes Since v5.4rc04
---------------------------------------------

## MeshToPolyData:
### Matt McCormick (3):

#### Enhancements

- Build against ITK 5.4 RC 3 ([fbb5cf4](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/fbb5cf4))
- Transition to scikit-build-core, pyproject.toml ([6885961](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/6885961))
- Build macOS ARM wheels ([498b40e](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/498b40e))


### dependabot[bot] (1):

#### Miscellaneous Changes

- Bump vite from 4.5.2 to 4.5.3 ([4d706a8](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/4d706a8))



## Montage:
### Dženan Zukić (7):

#### Enhancements

- Compute and expose per-tile registration reliability ([b354335](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/b354335))
- Update CI for ITK 5.4 RC 04 ([c000499](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/c000499))
- Switch to SciKit build core ([fb14158](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/fb14158))
- Use updated remote module action which includes notebook fix ([91eccc5](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/91eccc5))
- Enable unit tests which are no longer failing ([801bf31](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/801bf31))
- Add per-test regression intensity tolerance ([06cacd6](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/06cacd6))

#### Documentation Updates

- Improve class description and documentation of parameters ([0070c46](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/0070c46))



## MorphologicalContourInterpolation:
### Matt McCormick (3):

#### Enhancements

- Add 4D support to wasm ([1f5f597](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/1f5f597))
- Bump itk-wasm to 1.0.0-b.173 ([bb38356](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/bb38356))
- Bump CI configuration for ITK 5.4rc03 ([6fb73c0](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/6fb73c0))


### Stephen Aylward (5):

#### Enhancements

- Bump setup.py and CI to use ITK v5.4 rc2 ([edb76bb](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/edb76bb))
- Eliminate old compiler requirements ([b38c10a](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/b38c10a))
- Update CI build to macos-12 from macos-11 ([c69fce0](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/c69fce0))
- Specify XCode on MacOS ([a5f0fcb](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/a5f0fcb))

#### Bug Fixes

- Tag is v5.4rc02 - adding missing 0 ([5464e2e](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/5464e2e))



## RTK:
### Simon Rit (11):

#### Enhancements

- Remove CUDA code for compute capability 1 ([4dfa4890](https://github.com/RTKConsortium/RTK/commit/4dfa4890))
- Replace texture references by objects for CUDA 12 compatibility ([5361f69a](https://github.com/RTKConsortium/RTK/commit/5361f69a))
- Rename lp_solve library according to ITK's conventions ([938aa33a](https://github.com/RTKConsortium/RTK/commit/938aa33a))
- Use 64-bit cublas for CUDA 12 ([74d25e0a](https://github.com/RTKConsortium/RTK/commit/74d25e0a))
- Avoid single component intermediate CUDA array for scalar images ([bfdca5b6](https://github.com/RTKConsortium/RTK/commit/bfdca5b6))

#### Platform Fixes

- Display deprecation CUDA messages ([902db67f](https://github.com/RTKConsortium/RTK/commit/902db67f))
- Fix ramp filter redefinition of itkSetMacro ([4e8331f8](https://github.com/RTKConsortium/RTK/commit/4e8331f8))
- Remove deprecated inclusion of CUDA's math_functions.h ([4c2a3b57](https://github.com/RTKConsortium/RTK/commit/4c2a3b57))

#### Bug Fixes

- Use size_t to compute CUDA memory length ([0a1a8ca8](https://github.com/RTKConsortium/RTK/commit/0a1a8ca8))

#### Style Changes

- Refactor function for preparing texture objects for vector images ([f109868a](https://github.com/RTKConsortium/RTK/commit/f109868a))
- Cleanup useless code after CUDA function calls ([1a2ca55e](https://github.com/RTKConsortium/RTK/commit/1a2ca55e))



## TubeTK:
### Stephen Aylward (1):

#### Bug Fixes

- Incorrect class specification for InverseIntensityImageFilter ([ddeae653](https://github.com/InsightSoftwareConsortium/ITKTubeTK/commit/ddeae653))


## WebAssemblyInterface:

**Many**. Removed for size constraints.
