// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package util

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestRetryOK(t *testing.T) {
	Retry(func() {}, 1)
	i := 0
	Retry(func() {
		i++
		if i < 3 {
			panic(fmt.Errorf("i == %d", i))
		}
	}, 5)
	assert.EqualValues(t, i, 3)
}
