/* soapC.c
   Generated by gSOAP 2.7.9k from grisu_ws.h
   Copyright(C) 2000-2007, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#include "soapH.h"

#ifdef __cplusplus
extern "C" {
#endif

SOAP_SOURCE_STAMP("@(#) soapC.c ver 2.7.9k 2008-09-25 02:13:49 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL);
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	soap->header = (struct SOAP_ENV__Header*)soap_malloc(soap, sizeof(struct SOAP_ENV__Header));
		soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = (struct SOAP_ENV__Fault*)soap_malloc(soap, sizeof(struct SOAP_ENV__Fault));
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = (struct SOAP_ENV__Reason*)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason));
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = (struct SOAP_ENV__Code*)soap_malloc(soap, sizeof(struct SOAP_ENV__Code));
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_double:
		return soap_in_double(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_unsignedByte:
		return soap_in_unsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_in_unsignedInt(soap, NULL, NULL, "xsd:unsignedInt");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_xsd__boolean:
		return soap_in_xsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_ns4__JobCreationException:
		return soap_in_ns4__JobCreationException(soap, NULL, NULL, "ns4:JobCreationException");
	case SOAP_TYPE_ns2__JobSubmissionException:
		return soap_in_ns2__JobSubmissionException(soap, NULL, NULL, "ns2:JobSubmissionException");
	case SOAP_TYPE_ns2__JobDescriptionNotValidException:
		return soap_in_ns2__JobDescriptionNotValidException(soap, NULL, NULL, "ns2:JobDescriptionNotValidException");
	case SOAP_TYPE_ns2__NoSuchTemplateException:
		return soap_in_ns2__NoSuchTemplateException(soap, NULL, NULL, "ns2:NoSuchTemplateException");
	case SOAP_TYPE_ns2__NoValidCredentialException:
		return soap_in_ns2__NoValidCredentialException(soap, NULL, NULL, "ns2:NoValidCredentialException");
	case SOAP_TYPE_ns2__NoSuchJobException:
		return soap_in_ns2__NoSuchJobException(soap, NULL, NULL, "ns2:NoSuchJobException");
	case SOAP_TYPE_ns2__RemoteFileSystemException:
		return soap_in_ns2__RemoteFileSystemException(soap, NULL, NULL, "ns2:RemoteFileSystemException");
	case SOAP_TYPE_ns2__VomsException:
		return soap_in_ns2__VomsException(soap, NULL, NULL, "ns2:VomsException");
	case SOAP_TYPE_ns3__ArrayOfMountPoint:
		return soap_in_ns3__ArrayOfMountPoint(soap, NULL, NULL, "ns3:ArrayOfMountPoint");
	case SOAP_TYPE_ns3__MountPoint:
		return soap_in_ns3__MountPoint(soap, NULL, NULL, "ns3:MountPoint");
	case SOAP_TYPE_ns1__anyType2anyTypeMap:
		return soap_in_ns1__anyType2anyTypeMap(soap, NULL, NULL, "ns1:anyType2anyTypeMap");
	case SOAP_TYPE_ns1__ArrayOfString:
		return soap_in_ns1__ArrayOfString(soap, NULL, NULL, "ns1:ArrayOfString");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_in_xsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTo_ns1__getAllHostsResponse:
		return soap_in_PointerTo_ns1__getAllHostsResponse(soap, NULL, NULL, "ns1:getAllHostsResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllHosts:
		return soap_in_PointerTo_ns1__getAllHosts(soap, NULL, NULL, "ns1:getAllHosts");
	case SOAP_TYPE_PointerTo_ns1__submitSupportRequestResponse:
		return soap_in_PointerTo_ns1__submitSupportRequestResponse(soap, NULL, NULL, "ns1:submitSupportRequestResponse");
	case SOAP_TYPE_PointerTo_ns1__submitSupportRequest:
		return soap_in_PointerTo_ns1__submitSupportRequest(soap, NULL, NULL, "ns1:submitSupportRequest");
	case SOAP_TYPE_PointerTo_ns1__getJobPropertyResponse:
		return soap_in_PointerTo_ns1__getJobPropertyResponse(soap, NULL, NULL, "ns1:getJobPropertyResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobProperty:
		return soap_in_PointerTo_ns1__getJobProperty(soap, NULL, NULL, "ns1:getJobProperty");
	case SOAP_TYPE_PointerTo_ns1__mount1Response:
		return soap_in_PointerTo_ns1__mount1Response(soap, NULL, NULL, "ns1:mount1Response");
	case SOAP_TYPE_PointerTo_ns1__mount1:
		return soap_in_PointerTo_ns1__mount1(soap, NULL, NULL, "ns1:mount1");
	case SOAP_TYPE_PointerTo_ns1__getJobDetailsResponse:
		return soap_in_PointerTo_ns1__getJobDetailsResponse(soap, NULL, NULL, "ns1:getJobDetailsResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobDetails:
		return soap_in_PointerTo_ns1__getJobDetails(soap, NULL, NULL, "ns1:getJobDetails");
	case SOAP_TYPE_PointerTo_ns1__umountResponse:
		return soap_in_PointerTo_ns1__umountResponse(soap, NULL, NULL, "ns1:umountResponse");
	case SOAP_TYPE_PointerTo_ns1__umount:
		return soap_in_PointerTo_ns1__umount(soap, NULL, NULL, "ns1:umount");
	case SOAP_TYPE_PointerTo_ns1__getJobStatusResponse:
		return soap_in_PointerTo_ns1__getJobStatusResponse(soap, NULL, NULL, "ns1:getJobStatusResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobStatus:
		return soap_in_PointerTo_ns1__getJobStatus(soap, NULL, NULL, "ns1:getJobStatus");
	case SOAP_TYPE_PointerTo_ns1__getJobDetails_USCOREstringResponse:
		return soap_in_PointerTo_ns1__getJobDetails_USCOREstringResponse(soap, NULL, NULL, "ns1:getJobDetails_stringResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobDetails_USCOREstring:
		return soap_in_PointerTo_ns1__getJobDetails_USCOREstring(soap, NULL, NULL, "ns1:getJobDetails_string");
	case SOAP_TYPE_PointerTo_ns1__getAllSitesResponse:
		return soap_in_PointerTo_ns1__getAllSitesResponse(soap, NULL, NULL, "ns1:getAllSitesResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllSites:
		return soap_in_PointerTo_ns1__getAllSites(soap, NULL, NULL, "ns1:getAllSites");
	case SOAP_TYPE_PointerTo_ns1__setJobDescriptionResponse:
		return soap_in_PointerTo_ns1__setJobDescriptionResponse(soap, NULL, NULL, "ns1:setJobDescriptionResponse");
	case SOAP_TYPE_PointerTo_ns1__setJobDescription:
		return soap_in_PointerTo_ns1__setJobDescription(soap, NULL, NULL, "ns1:setJobDescription");
	case SOAP_TYPE_PointerTo_ns1__getJobDirectoryResponse:
		return soap_in_PointerTo_ns1__getJobDirectoryResponse(soap, NULL, NULL, "ns1:getJobDirectoryResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobDirectory:
		return soap_in_PointerTo_ns1__getJobDirectory(soap, NULL, NULL, "ns1:getJobDirectory");
	case SOAP_TYPE_PointerTo_ns1__uploadResponse:
		return soap_in_PointerTo_ns1__uploadResponse(soap, NULL, NULL, "ns1:uploadResponse");
	case SOAP_TYPE_PointerTo_ns1__upload:
		return soap_in_PointerTo_ns1__upload(soap, NULL, NULL, "ns1:upload");
	case SOAP_TYPE_PointerTo_ns1__deleteFileResponse:
		return soap_in_PointerTo_ns1__deleteFileResponse(soap, NULL, NULL, "ns1:deleteFileResponse");
	case SOAP_TYPE_PointerTo_ns1__deleteFile:
		return soap_in_PointerTo_ns1__deleteFile(soap, NULL, NULL, "ns1:deleteFile");
	case SOAP_TYPE_PointerTo_ns1__getFileSizeResponse:
		return soap_in_PointerTo_ns1__getFileSizeResponse(soap, NULL, NULL, "ns1:getFileSizeResponse");
	case SOAP_TYPE_PointerTo_ns1__getFileSize:
		return soap_in_PointerTo_ns1__getFileSize(soap, NULL, NULL, "ns1:getFileSize");
	case SOAP_TYPE_PointerTo_ns1__cpResponse:
		return soap_in_PointerTo_ns1__cpResponse(soap, NULL, NULL, "ns1:cpResponse");
	case SOAP_TYPE_PointerTo_ns1__cp:
		return soap_in_PointerTo_ns1__cp(soap, NULL, NULL, "ns1:cp");
	case SOAP_TYPE_PointerTo_ns1__uploadByteArrayResponse:
		return soap_in_PointerTo_ns1__uploadByteArrayResponse(soap, NULL, NULL, "ns1:uploadByteArrayResponse");
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray:
		return soap_in_PointerTo_ns1__uploadByteArray(soap, NULL, NULL, "ns1:uploadByteArray");
	case SOAP_TYPE_PointerTo_ns1__submitJobResponse:
		return soap_in_PointerTo_ns1__submitJobResponse(soap, NULL, NULL, "ns1:submitJobResponse");
	case SOAP_TYPE_PointerTo_ns1__submitJob:
		return soap_in_PointerTo_ns1__submitJob(soap, NULL, NULL, "ns1:submitJob");
	case SOAP_TYPE_PointerTo_ns1__logoutResponse:
		return soap_in_PointerTo_ns1__logoutResponse(soap, NULL, NULL, "ns1:logoutResponse");
	case SOAP_TYPE_PointerTo_ns1__logout:
		return soap_in_PointerTo_ns1__logout(soap, NULL, NULL, "ns1:logout");
	case SOAP_TYPE_PointerTo_ns1__setJobDescription_USCOREstringResponse:
		return soap_in_PointerTo_ns1__setJobDescription_USCOREstringResponse(soap, NULL, NULL, "ns1:setJobDescription_stringResponse");
	case SOAP_TYPE_PointerTo_ns1__setJobDescription_USCOREstring:
		return soap_in_PointerTo_ns1__setJobDescription_USCOREstring(soap, NULL, NULL, "ns1:setJobDescription_string");
	case SOAP_TYPE_PointerTo_ns1__calculateRelativeJobDirectoryResponse:
		return soap_in_PointerTo_ns1__calculateRelativeJobDirectoryResponse(soap, NULL, NULL, "ns1:calculateRelativeJobDirectoryResponse");
	case SOAP_TYPE_PointerTo_ns1__calculateRelativeJobDirectory:
		return soap_in_PointerTo_ns1__calculateRelativeJobDirectory(soap, NULL, NULL, "ns1:calculateRelativeJobDirectory");
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails1Response:
		return soap_in_PointerTo_ns1__getApplicationDetails1Response(soap, NULL, NULL, "ns1:getApplicationDetails1Response");
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails1:
		return soap_in_PointerTo_ns1__getApplicationDetails1(soap, NULL, NULL, "ns1:getApplicationDetails1");
	case SOAP_TYPE_PointerTo_ns1__lsResponse:
		return soap_in_PointerTo_ns1__lsResponse(soap, NULL, NULL, "ns1:lsResponse");
	case SOAP_TYPE_PointerTo_ns1__ls:
		return soap_in_PointerTo_ns1__ls(soap, NULL, NULL, "ns1:ls");
	case SOAP_TYPE_PointerTo_ns1__lastModifiedResponse:
		return soap_in_PointerTo_ns1__lastModifiedResponse(soap, NULL, NULL, "ns1:lastModifiedResponse");
	case SOAP_TYPE_PointerTo_ns1__lastModified:
		return soap_in_PointerTo_ns1__lastModified(soap, NULL, NULL, "ns1:lastModified");
	case SOAP_TYPE_PointerTo_ns1__getSiteResponse:
		return soap_in_PointerTo_ns1__getSiteResponse(soap, NULL, NULL, "ns1:getSiteResponse");
	case SOAP_TYPE_PointerTo_ns1__getSite:
		return soap_in_PointerTo_ns1__getSite(soap, NULL, NULL, "ns1:getSite");
	case SOAP_TYPE_PointerTo_ns1__ps_USCOREstringResponse:
		return soap_in_PointerTo_ns1__ps_USCOREstringResponse(soap, NULL, NULL, "ns1:ps_stringResponse");
	case SOAP_TYPE_PointerTo_ns1__ps_USCOREstring:
		return soap_in_PointerTo_ns1__ps_USCOREstring(soap, NULL, NULL, "ns1:ps_string");
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray1Response:
		return soap_in_PointerTo_ns1__uploadByteArray1Response(soap, NULL, NULL, "ns1:uploadByteArray1Response");
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray1:
		return soap_in_PointerTo_ns1__uploadByteArray1(soap, NULL, NULL, "ns1:uploadByteArray1");
	case SOAP_TYPE_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse:
		return soap_in_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(soap, NULL, NULL, "ns1:getVersionsOfApplicationOnSiteResponse");
	case SOAP_TYPE_PointerTo_ns1__getVersionsOfApplicationOnSite:
		return soap_in_PointerTo_ns1__getVersionsOfApplicationOnSite(soap, NULL, NULL, "ns1:getVersionsOfApplicationOnSite");
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations1Response:
		return soap_in_PointerTo_ns1__getAllSubmissionLocations1Response(soap, NULL, NULL, "ns1:getAllSubmissionLocations1Response");
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations1:
		return soap_in_PointerTo_ns1__getAllSubmissionLocations1(soap, NULL, NULL, "ns1:getAllSubmissionLocations1");
	case SOAP_TYPE_PointerTo_ns1__createJobResponse:
		return soap_in_PointerTo_ns1__createJobResponse(soap, NULL, NULL, "ns1:createJobResponse");
	case SOAP_TYPE_PointerTo_ns1__createJob:
		return soap_in_PointerTo_ns1__createJob(soap, NULL, NULL, "ns1:createJob");
	case SOAP_TYPE_PointerTo_ns1__getInterfaceVersionResponse:
		return soap_in_PointerTo_ns1__getInterfaceVersionResponse(soap, NULL, NULL, "ns1:getInterfaceVersionResponse");
	case SOAP_TYPE_PointerTo_ns1__getInterfaceVersion:
		return soap_in_PointerTo_ns1__getInterfaceVersion(soap, NULL, NULL, "ns1:getInterfaceVersion");
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocationsResponse:
		return soap_in_PointerTo_ns1__getAllSubmissionLocationsResponse(soap, NULL, NULL, "ns1:getAllSubmissionLocationsResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations:
		return soap_in_PointerTo_ns1__getAllSubmissionLocations(soap, NULL, NULL, "ns1:getAllSubmissionLocations");
	case SOAP_TYPE_PointerTo_ns1__addJobPropertyResponse:
		return soap_in_PointerTo_ns1__addJobPropertyResponse(soap, NULL, NULL, "ns1:addJobPropertyResponse");
	case SOAP_TYPE_PointerTo_ns1__addJobProperty:
		return soap_in_PointerTo_ns1__addJobProperty(soap, NULL, NULL, "ns1:addJobProperty");
	case SOAP_TYPE_PointerTo_ns1__addJobPropertiesResponse:
		return soap_in_PointerTo_ns1__addJobPropertiesResponse(soap, NULL, NULL, "ns1:addJobPropertiesResponse");
	case SOAP_TYPE_PointerTo_ns1__addJobProperties:
		return soap_in_PointerTo_ns1__addJobProperties(soap, NULL, NULL, "ns1:addJobProperties");
	case SOAP_TYPE_PointerTo_ns1__getAllAvailableApplicationsResponse:
		return soap_in_PointerTo_ns1__getAllAvailableApplicationsResponse(soap, NULL, NULL, "ns1:getAllAvailableApplicationsResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllAvailableApplications:
		return soap_in_PointerTo_ns1__getAllAvailableApplications(soap, NULL, NULL, "ns1:getAllAvailableApplications");
	case SOAP_TYPE_PointerTo_ns1__killResponse:
		return soap_in_PointerTo_ns1__killResponse(soap, NULL, NULL, "ns1:killResponse");
	case SOAP_TYPE_PointerTo_ns1__kill:
		return soap_in_PointerTo_ns1__kill(soap, NULL, NULL, "ns1:kill");
	case SOAP_TYPE_PointerTo_ns1__isFolderResponse:
		return soap_in_PointerTo_ns1__isFolderResponse(soap, NULL, NULL, "ns1:isFolderResponse");
	case SOAP_TYPE_PointerTo_ns1__isFolder:
		return soap_in_PointerTo_ns1__isFolder(soap, NULL, NULL, "ns1:isFolder");
	case SOAP_TYPE_PointerTo_ns1__downloadResponse:
		return soap_in_PointerTo_ns1__downloadResponse(soap, NULL, NULL, "ns1:downloadResponse");
	case SOAP_TYPE_PointerTo_ns1__download:
		return soap_in_PointerTo_ns1__download(soap, NULL, NULL, "ns1:download");
	case SOAP_TYPE_PointerTo_ns1__getAllJobPropertiesResponse:
		return soap_in_PointerTo_ns1__getAllJobPropertiesResponse(soap, NULL, NULL, "ns1:getAllJobPropertiesResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllJobProperties:
		return soap_in_PointerTo_ns1__getAllJobProperties(soap, NULL, NULL, "ns1:getAllJobProperties");
	case SOAP_TYPE_PointerTo_ns1__getAllJobnamesResponse:
		return soap_in_PointerTo_ns1__getAllJobnamesResponse(soap, NULL, NULL, "ns1:getAllJobnamesResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllJobnames:
		return soap_in_PointerTo_ns1__getAllJobnames(soap, NULL, NULL, "ns1:getAllJobnames");
	case SOAP_TYPE_PointerTo_ns1__getDNResponse:
		return soap_in_PointerTo_ns1__getDNResponse(soap, NULL, NULL, "ns1:getDNResponse");
	case SOAP_TYPE_PointerTo_ns1__getDN:
		return soap_in_PointerTo_ns1__getDN(soap, NULL, NULL, "ns1:getDN");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplicationResponse:
		return soap_in_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(soap, NULL, NULL, "ns1:getSubmissionLocationsForApplicationResponse");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication:
		return soap_in_PointerTo_ns1__getSubmissionLocationsForApplication(soap, NULL, NULL, "ns1:getSubmissionLocationsForApplication");
	case SOAP_TYPE_PointerTo_ns1__createJob1Response:
		return soap_in_PointerTo_ns1__createJob1Response(soap, NULL, NULL, "ns1:createJob1Response");
	case SOAP_TYPE_PointerTo_ns1__createJob1:
		return soap_in_PointerTo_ns1__createJob1(soap, NULL, NULL, "ns1:createJob1");
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetailsResponse:
		return soap_in_PointerTo_ns1__getApplicationDetailsResponse(soap, NULL, NULL, "ns1:getApplicationDetailsResponse");
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails:
		return soap_in_PointerTo_ns1__getApplicationDetails(soap, NULL, NULL, "ns1:getApplicationDetails");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication1Response:
		return soap_in_PointerTo_ns1__getSubmissionLocationsForApplication1Response(soap, NULL, NULL, "ns1:getSubmissionLocationsForApplication1Response");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication1:
		return soap_in_PointerTo_ns1__getSubmissionLocationsForApplication1(soap, NULL, NULL, "ns1:getSubmissionLocationsForApplication1");
	case SOAP_TYPE_PointerTo_ns1__ls_USCOREstringResponse:
		return soap_in_PointerTo_ns1__ls_USCOREstringResponse(soap, NULL, NULL, "ns1:ls_stringResponse");
	case SOAP_TYPE_PointerTo_ns1__ls_USCOREstring:
		return soap_in_PointerTo_ns1__ls_USCOREstring(soap, NULL, NULL, "ns1:ls_string");
	case SOAP_TYPE_PointerTo_ns1__calculateAbsoluteJobDirectoryResponse:
		return soap_in_PointerTo_ns1__calculateAbsoluteJobDirectoryResponse(soap, NULL, NULL, "ns1:calculateAbsoluteJobDirectoryResponse");
	case SOAP_TYPE_PointerTo_ns1__calculateAbsoluteJobDirectory:
		return soap_in_PointerTo_ns1__calculateAbsoluteJobDirectory(soap, NULL, NULL, "ns1:calculateAbsoluteJobDirectory");
	case SOAP_TYPE_PointerTo_ns1__getMessagesSinceResponse:
		return soap_in_PointerTo_ns1__getMessagesSinceResponse(soap, NULL, NULL, "ns1:getMessagesSinceResponse");
	case SOAP_TYPE_PointerTo_ns1__getMessagesSince:
		return soap_in_PointerTo_ns1__getMessagesSince(soap, NULL, NULL, "ns1:getMessagesSince");
	case SOAP_TYPE_PointerTo_ns1__deleteFilesResponse:
		return soap_in_PointerTo_ns1__deleteFilesResponse(soap, NULL, NULL, "ns1:deleteFilesResponse");
	case SOAP_TYPE_PointerTo_ns1__deleteFiles:
		return soap_in_PointerTo_ns1__deleteFiles(soap, NULL, NULL, "ns1:deleteFiles");
	case SOAP_TYPE_PointerTo_ns1__listHostedApplicationTemplatesResponse:
		return soap_in_PointerTo_ns1__listHostedApplicationTemplatesResponse(soap, NULL, NULL, "ns1:listHostedApplicationTemplatesResponse");
	case SOAP_TYPE_PointerTo_ns1__listHostedApplicationTemplates:
		return soap_in_PointerTo_ns1__listHostedApplicationTemplates(soap, NULL, NULL, "ns1:listHostedApplicationTemplates");
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray1Response:
		return soap_in_PointerTo_ns1__downloadByteArray1Response(soap, NULL, NULL, "ns1:downloadByteArray1Response");
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray1:
		return soap_in_PointerTo_ns1__downloadByteArray1(soap, NULL, NULL, "ns1:downloadByteArray1");
	case SOAP_TYPE_PointerTo_ns1__getTemplate1Response:
		return soap_in_PointerTo_ns1__getTemplate1Response(soap, NULL, NULL, "ns1:getTemplate1Response");
	case SOAP_TYPE_PointerTo_ns1__getTemplate1:
		return soap_in_PointerTo_ns1__getTemplate1(soap, NULL, NULL, "ns1:getTemplate1");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplicationResponse:
		return soap_in_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, NULL, NULL, "ns1:getSubmissionLocationsPerVersionOfApplicationResponse");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication:
		return soap_in_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication(soap, NULL, NULL, "ns1:getSubmissionLocationsPerVersionOfApplication");
	case SOAP_TYPE_PointerTo_ns1__getDataLocationsForVOResponse:
		return soap_in_PointerTo_ns1__getDataLocationsForVOResponse(soap, NULL, NULL, "ns1:getDataLocationsForVOResponse");
	case SOAP_TYPE_PointerTo_ns1__getDataLocationsForVO:
		return soap_in_PointerTo_ns1__getDataLocationsForVO(soap, NULL, NULL, "ns1:getDataLocationsForVO");
	case SOAP_TYPE_PointerTo_ns1__mkdirResponse:
		return soap_in_PointerTo_ns1__mkdirResponse(soap, NULL, NULL, "ns1:mkdirResponse");
	case SOAP_TYPE_PointerTo_ns1__mkdir:
		return soap_in_PointerTo_ns1__mkdir(soap, NULL, NULL, "ns1:mkdir");
	case SOAP_TYPE_PointerTo_ns1__getUserPropertyResponse:
		return soap_in_PointerTo_ns1__getUserPropertyResponse(soap, NULL, NULL, "ns1:getUserPropertyResponse");
	case SOAP_TYPE_PointerTo_ns1__getUserProperty:
		return soap_in_PointerTo_ns1__getUserProperty(soap, NULL, NULL, "ns1:getUserProperty");
	case SOAP_TYPE_PointerTo_ns1__getStagingFileSystemForSubmissionLocationResponse:
		return soap_in_PointerTo_ns1__getStagingFileSystemForSubmissionLocationResponse(soap, NULL, NULL, "ns1:getStagingFileSystemForSubmissionLocationResponse");
	case SOAP_TYPE_PointerTo_ns1__getStagingFileSystemForSubmissionLocation:
		return soap_in_PointerTo_ns1__getStagingFileSystemForSubmissionLocation(soap, NULL, NULL, "ns1:getStagingFileSystemForSubmissionLocation");
	case SOAP_TYPE_PointerTo_ns1__psResponse:
		return soap_in_PointerTo_ns1__psResponse(soap, NULL, NULL, "ns1:psResponse");
	case SOAP_TYPE_PointerTo_ns1__ps:
		return soap_in_PointerTo_ns1__ps(soap, NULL, NULL, "ns1:ps");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication2Response:
		return soap_in_PointerTo_ns1__getSubmissionLocationsForApplication2Response(soap, NULL, NULL, "ns1:getSubmissionLocationsForApplication2Response");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication2:
		return soap_in_PointerTo_ns1__getSubmissionLocationsForApplication2(soap, NULL, NULL, "ns1:getSubmissionLocationsForApplication2");
	case SOAP_TYPE_PointerTo_ns1__downloadByteArrayResponse:
		return soap_in_PointerTo_ns1__downloadByteArrayResponse(soap, NULL, NULL, "ns1:downloadByteArrayResponse");
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray:
		return soap_in_PointerTo_ns1__downloadByteArray(soap, NULL, NULL, "ns1:downloadByteArray");
	case SOAP_TYPE_PointerTo_ns1__dfResponse:
		return soap_in_PointerTo_ns1__dfResponse(soap, NULL, NULL, "ns1:dfResponse");
	case SOAP_TYPE_PointerTo_ns1__df:
		return soap_in_PointerTo_ns1__df(soap, NULL, NULL, "ns1:df");
	case SOAP_TYPE_PointerTo_ns1__getFqansResponse:
		return soap_in_PointerTo_ns1__getFqansResponse(soap, NULL, NULL, "ns1:getFqansResponse");
	case SOAP_TYPE_PointerTo_ns1__getFqans:
		return soap_in_PointerTo_ns1__getFqans(soap, NULL, NULL, "ns1:getFqans");
	case SOAP_TYPE_PointerTo_ns1__getTemplateResponse:
		return soap_in_PointerTo_ns1__getTemplateResponse(soap, NULL, NULL, "ns1:getTemplateResponse");
	case SOAP_TYPE_PointerTo_ns1__getTemplate:
		return soap_in_PointerTo_ns1__getTemplate(soap, NULL, NULL, "ns1:getTemplate");
	case SOAP_TYPE_PointerTo_ns1__loginResponse:
		return soap_in_PointerTo_ns1__loginResponse(soap, NULL, NULL, "ns1:loginResponse");
	case SOAP_TYPE_PointerTo_ns1__login:
		return soap_in_PointerTo_ns1__login(soap, NULL, NULL, "ns1:login");
	case SOAP_TYPE_PointerTo_ns1__mountResponse:
		return soap_in_PointerTo_ns1__mountResponse(soap, NULL, NULL, "ns1:mountResponse");
	case SOAP_TYPE_PointerTo_ns1__mount:
		return soap_in_PointerTo_ns1__mount(soap, NULL, NULL, "ns1:mount");
	case SOAP_TYPE_PointerTo_ns1__getJobFqanResponse:
		return soap_in_PointerTo_ns1__getJobFqanResponse(soap, NULL, NULL, "ns1:getJobFqanResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobFqan:
		return soap_in_PointerTo_ns1__getJobFqan(soap, NULL, NULL, "ns1:getJobFqan");
	case SOAP_TYPE_PointerTo_ns1__getChildrenFilesResponse:
		return soap_in_PointerTo_ns1__getChildrenFilesResponse(soap, NULL, NULL, "ns1:getChildrenFilesResponse");
	case SOAP_TYPE_PointerTo_ns1__getChildrenFiles:
		return soap_in_PointerTo_ns1__getChildrenFiles(soap, NULL, NULL, "ns1:getChildrenFiles");
	case SOAP_TYPE_PointerTons2__VomsException:
		return soap_in_PointerTons2__VomsException(soap, NULL, NULL, "ns2:VomsException");
	case SOAP_TYPE_PointerTons2__RemoteFileSystemException:
		return soap_in_PointerTons2__RemoteFileSystemException(soap, NULL, NULL, "ns2:RemoteFileSystemException");
	case SOAP_TYPE_PointerTons2__NoValidCredentialException:
		return soap_in_PointerTons2__NoValidCredentialException(soap, NULL, NULL, "ns2:NoValidCredentialException");
	case SOAP_TYPE_PointerTons2__NoSuchTemplateException:
		return soap_in_PointerTons2__NoSuchTemplateException(soap, NULL, NULL, "ns2:NoSuchTemplateException");
	case SOAP_TYPE_PointerTons2__NoSuchJobException:
		return soap_in_PointerTons2__NoSuchJobException(soap, NULL, NULL, "ns2:NoSuchJobException");
	case SOAP_TYPE_PointerTons2__JobSubmissionException:
		return soap_in_PointerTons2__JobSubmissionException(soap, NULL, NULL, "ns2:JobSubmissionException");
	case SOAP_TYPE_PointerTons2__JobDescriptionNotValidException:
		return soap_in_PointerTons2__JobDescriptionNotValidException(soap, NULL, NULL, "ns2:JobDescriptionNotValidException");
	case SOAP_TYPE_PointerTons4__JobCreationException:
		return soap_in_PointerTons4__JobCreationException(soap, NULL, NULL, "ns4:JobCreationException");
	case SOAP_TYPE_PointerToLONG64:
		return soap_in_PointerToLONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_PointerToxsd__boolean:
		return soap_in_PointerToxsd__boolean(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_PointerTons1__anyType2anyTypeMap:
		return soap_in_PointerTons1__anyType2anyTypeMap(soap, NULL, NULL, "ns1:anyType2anyTypeMap");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_in_PointerToxsd__base64Binary(soap, NULL, NULL, "xsd:base64Binary");
	case SOAP_TYPE_PointerTons3__ArrayOfMountPoint:
		return soap_in_PointerTons3__ArrayOfMountPoint(soap, NULL, NULL, "ns3:ArrayOfMountPoint");
	case SOAP_TYPE_PointerTons3__MountPoint:
		return soap_in_PointerTons3__MountPoint(soap, NULL, NULL, "ns3:MountPoint");
	case SOAP_TYPE_PointerTons1__ArrayOfString:
		return soap_in_PointerTons1__ArrayOfString(soap, NULL, NULL, "ns1:ArrayOfString");
	case SOAP_TYPE_PointerTo_ns1__anyType2anyTypeMap_entry:
		return soap_in_PointerTo_ns1__anyType2anyTypeMap_entry(soap, NULL, NULL, "ns1:anyType2anyTypeMap-entry");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_in_PointerTounsignedByte(soap, NULL, NULL, "xsd:unsignedByte");
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedByte"))
		{	*type = SOAP_TYPE_unsignedByte;
			return soap_in_unsignedByte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:unsignedInt"))
		{	*type = SOAP_TYPE_unsignedInt;
			return soap_in_unsignedInt(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_xsd__boolean;
			return soap_in_xsd__boolean(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:JobCreationException"))
		{	*type = SOAP_TYPE_ns4__JobCreationException;
			return soap_in_ns4__JobCreationException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:JobSubmissionException"))
		{	*type = SOAP_TYPE_ns2__JobSubmissionException;
			return soap_in_ns2__JobSubmissionException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:JobDescriptionNotValidException"))
		{	*type = SOAP_TYPE_ns2__JobDescriptionNotValidException;
			return soap_in_ns2__JobDescriptionNotValidException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:NoSuchTemplateException"))
		{	*type = SOAP_TYPE_ns2__NoSuchTemplateException;
			return soap_in_ns2__NoSuchTemplateException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:NoValidCredentialException"))
		{	*type = SOAP_TYPE_ns2__NoValidCredentialException;
			return soap_in_ns2__NoValidCredentialException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:NoSuchJobException"))
		{	*type = SOAP_TYPE_ns2__NoSuchJobException;
			return soap_in_ns2__NoSuchJobException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteFileSystemException"))
		{	*type = SOAP_TYPE_ns2__RemoteFileSystemException;
			return soap_in_ns2__RemoteFileSystemException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:VomsException"))
		{	*type = SOAP_TYPE_ns2__VomsException;
			return soap_in_ns2__VomsException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:ArrayOfMountPoint"))
		{	*type = SOAP_TYPE_ns3__ArrayOfMountPoint;
			return soap_in_ns3__ArrayOfMountPoint(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:MountPoint"))
		{	*type = SOAP_TYPE_ns3__MountPoint;
			return soap_in_ns3__MountPoint(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:anyType2anyTypeMap"))
		{	*type = SOAP_TYPE_ns1__anyType2anyTypeMap;
			return soap_in_ns1__anyType2anyTypeMap(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ArrayOfString"))
		{	*type = SOAP_TYPE_ns1__ArrayOfString;
			return soap_in_ns1__ArrayOfString(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:base64Binary"))
		{	*type = SOAP_TYPE_xsd__base64Binary;
			return soap_in_xsd__base64Binary(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "ns1:getAllHostsResponse"))
		{	*type = SOAP_TYPE__ns1__getAllHostsResponse;
			return soap_in__ns1__getAllHostsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllHosts"))
		{	*type = SOAP_TYPE__ns1__getAllHosts;
			return soap_in__ns1__getAllHosts(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:submitSupportRequestResponse"))
		{	*type = SOAP_TYPE__ns1__submitSupportRequestResponse;
			return soap_in__ns1__submitSupportRequestResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:submitSupportRequest"))
		{	*type = SOAP_TYPE__ns1__submitSupportRequest;
			return soap_in__ns1__submitSupportRequest(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobPropertyResponse"))
		{	*type = SOAP_TYPE__ns1__getJobPropertyResponse;
			return soap_in__ns1__getJobPropertyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobProperty"))
		{	*type = SOAP_TYPE__ns1__getJobProperty;
			return soap_in__ns1__getJobProperty(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mount1Response"))
		{	*type = SOAP_TYPE__ns1__mount1Response;
			return soap_in__ns1__mount1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mount1"))
		{	*type = SOAP_TYPE__ns1__mount1;
			return soap_in__ns1__mount1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobDetailsResponse"))
		{	*type = SOAP_TYPE__ns1__getJobDetailsResponse;
			return soap_in__ns1__getJobDetailsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobDetails"))
		{	*type = SOAP_TYPE__ns1__getJobDetails;
			return soap_in__ns1__getJobDetails(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:umountResponse"))
		{	*type = SOAP_TYPE__ns1__umountResponse;
			return soap_in__ns1__umountResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:umount"))
		{	*type = SOAP_TYPE__ns1__umount;
			return soap_in__ns1__umount(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobStatusResponse"))
		{	*type = SOAP_TYPE__ns1__getJobStatusResponse;
			return soap_in__ns1__getJobStatusResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobStatus"))
		{	*type = SOAP_TYPE__ns1__getJobStatus;
			return soap_in__ns1__getJobStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobDetails_stringResponse"))
		{	*type = SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse;
			return soap_in__ns1__getJobDetails_USCOREstringResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobDetails_string"))
		{	*type = SOAP_TYPE__ns1__getJobDetails_USCOREstring;
			return soap_in__ns1__getJobDetails_USCOREstring(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllSitesResponse"))
		{	*type = SOAP_TYPE__ns1__getAllSitesResponse;
			return soap_in__ns1__getAllSitesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllSites"))
		{	*type = SOAP_TYPE__ns1__getAllSites;
			return soap_in__ns1__getAllSites(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:setJobDescriptionResponse"))
		{	*type = SOAP_TYPE__ns1__setJobDescriptionResponse;
			return soap_in__ns1__setJobDescriptionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:setJobDescription"))
		{	*type = SOAP_TYPE__ns1__setJobDescription;
			return soap_in__ns1__setJobDescription(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobDirectoryResponse"))
		{	*type = SOAP_TYPE__ns1__getJobDirectoryResponse;
			return soap_in__ns1__getJobDirectoryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobDirectory"))
		{	*type = SOAP_TYPE__ns1__getJobDirectory;
			return soap_in__ns1__getJobDirectory(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:uploadResponse"))
		{	*type = SOAP_TYPE__ns1__uploadResponse;
			return soap_in__ns1__uploadResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:upload"))
		{	*type = SOAP_TYPE__ns1__upload;
			return soap_in__ns1__upload(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteFileResponse"))
		{	*type = SOAP_TYPE__ns1__deleteFileResponse;
			return soap_in__ns1__deleteFileResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteFile"))
		{	*type = SOAP_TYPE__ns1__deleteFile;
			return soap_in__ns1__deleteFile(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getFileSizeResponse"))
		{	*type = SOAP_TYPE__ns1__getFileSizeResponse;
			return soap_in__ns1__getFileSizeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getFileSize"))
		{	*type = SOAP_TYPE__ns1__getFileSize;
			return soap_in__ns1__getFileSize(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cpResponse"))
		{	*type = SOAP_TYPE__ns1__cpResponse;
			return soap_in__ns1__cpResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:cp"))
		{	*type = SOAP_TYPE__ns1__cp;
			return soap_in__ns1__cp(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:uploadByteArrayResponse"))
		{	*type = SOAP_TYPE__ns1__uploadByteArrayResponse;
			return soap_in__ns1__uploadByteArrayResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:uploadByteArray"))
		{	*type = SOAP_TYPE__ns1__uploadByteArray;
			return soap_in__ns1__uploadByteArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:submitJobResponse"))
		{	*type = SOAP_TYPE__ns1__submitJobResponse;
			return soap_in__ns1__submitJobResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:submitJob"))
		{	*type = SOAP_TYPE__ns1__submitJob;
			return soap_in__ns1__submitJob(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:logoutResponse"))
		{	*type = SOAP_TYPE__ns1__logoutResponse;
			return soap_in__ns1__logoutResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:logout"))
		{	*type = SOAP_TYPE__ns1__logout;
			return soap_in__ns1__logout(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:setJobDescription_stringResponse"))
		{	*type = SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse;
			return soap_in__ns1__setJobDescription_USCOREstringResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:setJobDescription_string"))
		{	*type = SOAP_TYPE__ns1__setJobDescription_USCOREstring;
			return soap_in__ns1__setJobDescription_USCOREstring(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:calculateRelativeJobDirectoryResponse"))
		{	*type = SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse;
			return soap_in__ns1__calculateRelativeJobDirectoryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:calculateRelativeJobDirectory"))
		{	*type = SOAP_TYPE__ns1__calculateRelativeJobDirectory;
			return soap_in__ns1__calculateRelativeJobDirectory(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getApplicationDetails1Response"))
		{	*type = SOAP_TYPE__ns1__getApplicationDetails1Response;
			return soap_in__ns1__getApplicationDetails1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getApplicationDetails1"))
		{	*type = SOAP_TYPE__ns1__getApplicationDetails1;
			return soap_in__ns1__getApplicationDetails1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:lsResponse"))
		{	*type = SOAP_TYPE__ns1__lsResponse;
			return soap_in__ns1__lsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ls"))
		{	*type = SOAP_TYPE__ns1__ls;
			return soap_in__ns1__ls(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:lastModifiedResponse"))
		{	*type = SOAP_TYPE__ns1__lastModifiedResponse;
			return soap_in__ns1__lastModifiedResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:lastModified"))
		{	*type = SOAP_TYPE__ns1__lastModified;
			return soap_in__ns1__lastModified(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSiteResponse"))
		{	*type = SOAP_TYPE__ns1__getSiteResponse;
			return soap_in__ns1__getSiteResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSite"))
		{	*type = SOAP_TYPE__ns1__getSite;
			return soap_in__ns1__getSite(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ps_stringResponse"))
		{	*type = SOAP_TYPE__ns1__ps_USCOREstringResponse;
			return soap_in__ns1__ps_USCOREstringResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ps_string"))
		{	*type = SOAP_TYPE__ns1__ps_USCOREstring;
			return soap_in__ns1__ps_USCOREstring(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:uploadByteArray1Response"))
		{	*type = SOAP_TYPE__ns1__uploadByteArray1Response;
			return soap_in__ns1__uploadByteArray1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:uploadByteArray1"))
		{	*type = SOAP_TYPE__ns1__uploadByteArray1;
			return soap_in__ns1__uploadByteArray1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getVersionsOfApplicationOnSiteResponse"))
		{	*type = SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse;
			return soap_in__ns1__getVersionsOfApplicationOnSiteResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getVersionsOfApplicationOnSite"))
		{	*type = SOAP_TYPE__ns1__getVersionsOfApplicationOnSite;
			return soap_in__ns1__getVersionsOfApplicationOnSite(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllSubmissionLocations1Response"))
		{	*type = SOAP_TYPE__ns1__getAllSubmissionLocations1Response;
			return soap_in__ns1__getAllSubmissionLocations1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllSubmissionLocations1"))
		{	*type = SOAP_TYPE__ns1__getAllSubmissionLocations1;
			return soap_in__ns1__getAllSubmissionLocations1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:createJobResponse"))
		{	*type = SOAP_TYPE__ns1__createJobResponse;
			return soap_in__ns1__createJobResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:createJob"))
		{	*type = SOAP_TYPE__ns1__createJob;
			return soap_in__ns1__createJob(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getInterfaceVersionResponse"))
		{	*type = SOAP_TYPE__ns1__getInterfaceVersionResponse;
			return soap_in__ns1__getInterfaceVersionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getInterfaceVersion"))
		{	*type = SOAP_TYPE__ns1__getInterfaceVersion;
			return soap_in__ns1__getInterfaceVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllSubmissionLocationsResponse"))
		{	*type = SOAP_TYPE__ns1__getAllSubmissionLocationsResponse;
			return soap_in__ns1__getAllSubmissionLocationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllSubmissionLocations"))
		{	*type = SOAP_TYPE__ns1__getAllSubmissionLocations;
			return soap_in__ns1__getAllSubmissionLocations(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:addJobPropertyResponse"))
		{	*type = SOAP_TYPE__ns1__addJobPropertyResponse;
			return soap_in__ns1__addJobPropertyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:addJobProperty"))
		{	*type = SOAP_TYPE__ns1__addJobProperty;
			return soap_in__ns1__addJobProperty(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:addJobPropertiesResponse"))
		{	*type = SOAP_TYPE__ns1__addJobPropertiesResponse;
			return soap_in__ns1__addJobPropertiesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:addJobProperties"))
		{	*type = SOAP_TYPE__ns1__addJobProperties;
			return soap_in__ns1__addJobProperties(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllAvailableApplicationsResponse"))
		{	*type = SOAP_TYPE__ns1__getAllAvailableApplicationsResponse;
			return soap_in__ns1__getAllAvailableApplicationsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllAvailableApplications"))
		{	*type = SOAP_TYPE__ns1__getAllAvailableApplications;
			return soap_in__ns1__getAllAvailableApplications(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:killResponse"))
		{	*type = SOAP_TYPE__ns1__killResponse;
			return soap_in__ns1__killResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:kill"))
		{	*type = SOAP_TYPE__ns1__kill;
			return soap_in__ns1__kill(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:isFolderResponse"))
		{	*type = SOAP_TYPE__ns1__isFolderResponse;
			return soap_in__ns1__isFolderResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:isFolder"))
		{	*type = SOAP_TYPE__ns1__isFolder;
			return soap_in__ns1__isFolder(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:downloadResponse"))
		{	*type = SOAP_TYPE__ns1__downloadResponse;
			return soap_in__ns1__downloadResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:download"))
		{	*type = SOAP_TYPE__ns1__download;
			return soap_in__ns1__download(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllJobPropertiesResponse"))
		{	*type = SOAP_TYPE__ns1__getAllJobPropertiesResponse;
			return soap_in__ns1__getAllJobPropertiesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllJobProperties"))
		{	*type = SOAP_TYPE__ns1__getAllJobProperties;
			return soap_in__ns1__getAllJobProperties(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllJobnamesResponse"))
		{	*type = SOAP_TYPE__ns1__getAllJobnamesResponse;
			return soap_in__ns1__getAllJobnamesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getAllJobnames"))
		{	*type = SOAP_TYPE__ns1__getAllJobnames;
			return soap_in__ns1__getAllJobnames(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getDNResponse"))
		{	*type = SOAP_TYPE__ns1__getDNResponse;
			return soap_in__ns1__getDNResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getDN"))
		{	*type = SOAP_TYPE__ns1__getDN;
			return soap_in__ns1__getDN(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSubmissionLocationsForApplicationResponse"))
		{	*type = SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse;
			return soap_in__ns1__getSubmissionLocationsForApplicationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSubmissionLocationsForApplication"))
		{	*type = SOAP_TYPE__ns1__getSubmissionLocationsForApplication;
			return soap_in__ns1__getSubmissionLocationsForApplication(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:createJob1Response"))
		{	*type = SOAP_TYPE__ns1__createJob1Response;
			return soap_in__ns1__createJob1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:createJob1"))
		{	*type = SOAP_TYPE__ns1__createJob1;
			return soap_in__ns1__createJob1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getApplicationDetailsResponse"))
		{	*type = SOAP_TYPE__ns1__getApplicationDetailsResponse;
			return soap_in__ns1__getApplicationDetailsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getApplicationDetails"))
		{	*type = SOAP_TYPE__ns1__getApplicationDetails;
			return soap_in__ns1__getApplicationDetails(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSubmissionLocationsForApplication1Response"))
		{	*type = SOAP_TYPE__ns1__getSubmissionLocationsForApplication1Response;
			return soap_in__ns1__getSubmissionLocationsForApplication1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSubmissionLocationsForApplication1"))
		{	*type = SOAP_TYPE__ns1__getSubmissionLocationsForApplication1;
			return soap_in__ns1__getSubmissionLocationsForApplication1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ls_stringResponse"))
		{	*type = SOAP_TYPE__ns1__ls_USCOREstringResponse;
			return soap_in__ns1__ls_USCOREstringResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ls_string"))
		{	*type = SOAP_TYPE__ns1__ls_USCOREstring;
			return soap_in__ns1__ls_USCOREstring(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:calculateAbsoluteJobDirectoryResponse"))
		{	*type = SOAP_TYPE__ns1__calculateAbsoluteJobDirectoryResponse;
			return soap_in__ns1__calculateAbsoluteJobDirectoryResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:calculateAbsoluteJobDirectory"))
		{	*type = SOAP_TYPE__ns1__calculateAbsoluteJobDirectory;
			return soap_in__ns1__calculateAbsoluteJobDirectory(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getMessagesSinceResponse"))
		{	*type = SOAP_TYPE__ns1__getMessagesSinceResponse;
			return soap_in__ns1__getMessagesSinceResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getMessagesSince"))
		{	*type = SOAP_TYPE__ns1__getMessagesSince;
			return soap_in__ns1__getMessagesSince(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteFilesResponse"))
		{	*type = SOAP_TYPE__ns1__deleteFilesResponse;
			return soap_in__ns1__deleteFilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:deleteFiles"))
		{	*type = SOAP_TYPE__ns1__deleteFiles;
			return soap_in__ns1__deleteFiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:listHostedApplicationTemplatesResponse"))
		{	*type = SOAP_TYPE__ns1__listHostedApplicationTemplatesResponse;
			return soap_in__ns1__listHostedApplicationTemplatesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:listHostedApplicationTemplates"))
		{	*type = SOAP_TYPE__ns1__listHostedApplicationTemplates;
			return soap_in__ns1__listHostedApplicationTemplates(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:downloadByteArray1Response"))
		{	*type = SOAP_TYPE__ns1__downloadByteArray1Response;
			return soap_in__ns1__downloadByteArray1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:downloadByteArray1"))
		{	*type = SOAP_TYPE__ns1__downloadByteArray1;
			return soap_in__ns1__downloadByteArray1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getTemplate1Response"))
		{	*type = SOAP_TYPE__ns1__getTemplate1Response;
			return soap_in__ns1__getTemplate1Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getTemplate1"))
		{	*type = SOAP_TYPE__ns1__getTemplate1;
			return soap_in__ns1__getTemplate1(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSubmissionLocationsPerVersionOfApplicationResponse"))
		{	*type = SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplicationResponse;
			return soap_in__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSubmissionLocationsPerVersionOfApplication"))
		{	*type = SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplication;
			return soap_in__ns1__getSubmissionLocationsPerVersionOfApplication(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getDataLocationsForVOResponse"))
		{	*type = SOAP_TYPE__ns1__getDataLocationsForVOResponse;
			return soap_in__ns1__getDataLocationsForVOResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getDataLocationsForVO"))
		{	*type = SOAP_TYPE__ns1__getDataLocationsForVO;
			return soap_in__ns1__getDataLocationsForVO(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mkdirResponse"))
		{	*type = SOAP_TYPE__ns1__mkdirResponse;
			return soap_in__ns1__mkdirResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mkdir"))
		{	*type = SOAP_TYPE__ns1__mkdir;
			return soap_in__ns1__mkdir(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getUserPropertyResponse"))
		{	*type = SOAP_TYPE__ns1__getUserPropertyResponse;
			return soap_in__ns1__getUserPropertyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getUserProperty"))
		{	*type = SOAP_TYPE__ns1__getUserProperty;
			return soap_in__ns1__getUserProperty(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getStagingFileSystemForSubmissionLocationResponse"))
		{	*type = SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocationResponse;
			return soap_in__ns1__getStagingFileSystemForSubmissionLocationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getStagingFileSystemForSubmissionLocation"))
		{	*type = SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocation;
			return soap_in__ns1__getStagingFileSystemForSubmissionLocation(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:psResponse"))
		{	*type = SOAP_TYPE__ns1__psResponse;
			return soap_in__ns1__psResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:ps"))
		{	*type = SOAP_TYPE__ns1__ps;
			return soap_in__ns1__ps(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSubmissionLocationsForApplication2Response"))
		{	*type = SOAP_TYPE__ns1__getSubmissionLocationsForApplication2Response;
			return soap_in__ns1__getSubmissionLocationsForApplication2Response(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getSubmissionLocationsForApplication2"))
		{	*type = SOAP_TYPE__ns1__getSubmissionLocationsForApplication2;
			return soap_in__ns1__getSubmissionLocationsForApplication2(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:downloadByteArrayResponse"))
		{	*type = SOAP_TYPE__ns1__downloadByteArrayResponse;
			return soap_in__ns1__downloadByteArrayResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:downloadByteArray"))
		{	*type = SOAP_TYPE__ns1__downloadByteArray;
			return soap_in__ns1__downloadByteArray(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:dfResponse"))
		{	*type = SOAP_TYPE__ns1__dfResponse;
			return soap_in__ns1__dfResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:df"))
		{	*type = SOAP_TYPE__ns1__df;
			return soap_in__ns1__df(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getFqansResponse"))
		{	*type = SOAP_TYPE__ns1__getFqansResponse;
			return soap_in__ns1__getFqansResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getFqans"))
		{	*type = SOAP_TYPE__ns1__getFqans;
			return soap_in__ns1__getFqans(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getTemplateResponse"))
		{	*type = SOAP_TYPE__ns1__getTemplateResponse;
			return soap_in__ns1__getTemplateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getTemplate"))
		{	*type = SOAP_TYPE__ns1__getTemplate;
			return soap_in__ns1__getTemplate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:loginResponse"))
		{	*type = SOAP_TYPE__ns1__loginResponse;
			return soap_in__ns1__loginResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:login"))
		{	*type = SOAP_TYPE__ns1__login;
			return soap_in__ns1__login(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mountResponse"))
		{	*type = SOAP_TYPE__ns1__mountResponse;
			return soap_in__ns1__mountResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:mount"))
		{	*type = SOAP_TYPE__ns1__mount;
			return soap_in__ns1__mount(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobFqanResponse"))
		{	*type = SOAP_TYPE__ns1__getJobFqanResponse;
			return soap_in__ns1__getJobFqanResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getJobFqan"))
		{	*type = SOAP_TYPE__ns1__getJobFqan;
			return soap_in__ns1__getJobFqan(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getChildrenFilesResponse"))
		{	*type = SOAP_TYPE__ns1__getChildrenFilesResponse;
			return soap_in__ns1__getChildrenFilesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:getChildrenFiles"))
		{	*type = SOAP_TYPE__ns1__getChildrenFiles;
			return soap_in__ns1__getChildrenFiles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:anyType2anyTypeMap-entry"))
		{	*type = SOAP_TYPE__ns1__anyType2anyTypeMap_entry;
			return soap_in__ns1__anyType2anyTypeMap_entry(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xop:Include"))
		{	*type = SOAP_TYPE__xop__Include;
			return soap_in__xop__Include(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unknown element '%s' (level=%u, %d)\n", soap->tag, soap->level, soap->body));
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE_unsignedByte:
		return soap_out_unsignedByte(soap, tag, id, (const unsigned char *)ptr, "xsd:unsignedByte");
	case SOAP_TYPE_unsignedInt:
		return soap_out_unsignedInt(soap, tag, id, (const unsigned int *)ptr, "xsd:unsignedInt");
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE_xsd__boolean:
		return soap_out_xsd__boolean(soap, tag, id, (const enum xsd__boolean *)ptr, "xsd:boolean");
	case SOAP_TYPE_ns4__JobCreationException:
		return soap_out_ns4__JobCreationException(soap, tag, id, (const struct ns4__JobCreationException *)ptr, "ns4:JobCreationException");
	case SOAP_TYPE_ns2__JobSubmissionException:
		return soap_out_ns2__JobSubmissionException(soap, tag, id, (const struct ns2__JobSubmissionException *)ptr, "ns2:JobSubmissionException");
	case SOAP_TYPE_ns2__JobDescriptionNotValidException:
		return soap_out_ns2__JobDescriptionNotValidException(soap, tag, id, (const struct ns2__JobDescriptionNotValidException *)ptr, "ns2:JobDescriptionNotValidException");
	case SOAP_TYPE_ns2__NoSuchTemplateException:
		return soap_out_ns2__NoSuchTemplateException(soap, tag, id, (const struct ns2__NoSuchTemplateException *)ptr, "ns2:NoSuchTemplateException");
	case SOAP_TYPE_ns2__NoValidCredentialException:
		return soap_out_ns2__NoValidCredentialException(soap, tag, id, (const struct ns2__NoValidCredentialException *)ptr, "ns2:NoValidCredentialException");
	case SOAP_TYPE_ns2__NoSuchJobException:
		return soap_out_ns2__NoSuchJobException(soap, tag, id, (const struct ns2__NoSuchJobException *)ptr, "ns2:NoSuchJobException");
	case SOAP_TYPE_ns2__RemoteFileSystemException:
		return soap_out_ns2__RemoteFileSystemException(soap, tag, id, (const struct ns2__RemoteFileSystemException *)ptr, "ns2:RemoteFileSystemException");
	case SOAP_TYPE_ns2__VomsException:
		return soap_out_ns2__VomsException(soap, tag, id, (const struct ns2__VomsException *)ptr, "ns2:VomsException");
	case SOAP_TYPE__ns1__getAllHostsResponse:
		return soap_out__ns1__getAllHostsResponse(soap, "ns1:getAllHostsResponse", id, (const struct _ns1__getAllHostsResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllHosts:
		return soap_out__ns1__getAllHosts(soap, "ns1:getAllHosts", id, (const struct _ns1__getAllHosts *)ptr, NULL);
	case SOAP_TYPE__ns1__submitSupportRequestResponse:
		return soap_out__ns1__submitSupportRequestResponse(soap, "ns1:submitSupportRequestResponse", id, (const struct _ns1__submitSupportRequestResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__submitSupportRequest:
		return soap_out__ns1__submitSupportRequest(soap, "ns1:submitSupportRequest", id, (const struct _ns1__submitSupportRequest *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobPropertyResponse:
		return soap_out__ns1__getJobPropertyResponse(soap, "ns1:getJobPropertyResponse", id, (const struct _ns1__getJobPropertyResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobProperty:
		return soap_out__ns1__getJobProperty(soap, "ns1:getJobProperty", id, (const struct _ns1__getJobProperty *)ptr, NULL);
	case SOAP_TYPE__ns1__mount1Response:
		return soap_out__ns1__mount1Response(soap, "ns1:mount1Response", id, (const struct _ns1__mount1Response *)ptr, NULL);
	case SOAP_TYPE__ns1__mount1:
		return soap_out__ns1__mount1(soap, "ns1:mount1", id, (const struct _ns1__mount1 *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobDetailsResponse:
		return soap_out__ns1__getJobDetailsResponse(soap, "ns1:getJobDetailsResponse", id, (const struct _ns1__getJobDetailsResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobDetails:
		return soap_out__ns1__getJobDetails(soap, "ns1:getJobDetails", id, (const struct _ns1__getJobDetails *)ptr, NULL);
	case SOAP_TYPE__ns1__umountResponse:
		return soap_out__ns1__umountResponse(soap, "ns1:umountResponse", id, (const struct _ns1__umountResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__umount:
		return soap_out__ns1__umount(soap, "ns1:umount", id, (const struct _ns1__umount *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobStatusResponse:
		return soap_out__ns1__getJobStatusResponse(soap, "ns1:getJobStatusResponse", id, (const struct _ns1__getJobStatusResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobStatus:
		return soap_out__ns1__getJobStatus(soap, "ns1:getJobStatus", id, (const struct _ns1__getJobStatus *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse:
		return soap_out__ns1__getJobDetails_USCOREstringResponse(soap, "ns1:getJobDetails_stringResponse", id, (const struct _ns1__getJobDetails_USCOREstringResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobDetails_USCOREstring:
		return soap_out__ns1__getJobDetails_USCOREstring(soap, "ns1:getJobDetails_string", id, (const struct _ns1__getJobDetails_USCOREstring *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllSitesResponse:
		return soap_out__ns1__getAllSitesResponse(soap, "ns1:getAllSitesResponse", id, (const struct _ns1__getAllSitesResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllSites:
		return soap_out__ns1__getAllSites(soap, "ns1:getAllSites", id, (const struct _ns1__getAllSites *)ptr, NULL);
	case SOAP_TYPE__ns1__setJobDescriptionResponse:
		return soap_out__ns1__setJobDescriptionResponse(soap, "ns1:setJobDescriptionResponse", id, (const struct _ns1__setJobDescriptionResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__setJobDescription:
		return soap_out__ns1__setJobDescription(soap, "ns1:setJobDescription", id, (const struct _ns1__setJobDescription *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobDirectoryResponse:
		return soap_out__ns1__getJobDirectoryResponse(soap, "ns1:getJobDirectoryResponse", id, (const struct _ns1__getJobDirectoryResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobDirectory:
		return soap_out__ns1__getJobDirectory(soap, "ns1:getJobDirectory", id, (const struct _ns1__getJobDirectory *)ptr, NULL);
	case SOAP_TYPE__ns1__uploadResponse:
		return soap_out__ns1__uploadResponse(soap, "ns1:uploadResponse", id, (const struct _ns1__uploadResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__upload:
		return soap_out__ns1__upload(soap, "ns1:upload", id, (const struct _ns1__upload *)ptr, NULL);
	case SOAP_TYPE__ns1__deleteFileResponse:
		return soap_out__ns1__deleteFileResponse(soap, "ns1:deleteFileResponse", id, (const struct _ns1__deleteFileResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__deleteFile:
		return soap_out__ns1__deleteFile(soap, "ns1:deleteFile", id, (const struct _ns1__deleteFile *)ptr, NULL);
	case SOAP_TYPE__ns1__getFileSizeResponse:
		return soap_out__ns1__getFileSizeResponse(soap, "ns1:getFileSizeResponse", id, (const struct _ns1__getFileSizeResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getFileSize:
		return soap_out__ns1__getFileSize(soap, "ns1:getFileSize", id, (const struct _ns1__getFileSize *)ptr, NULL);
	case SOAP_TYPE__ns1__cpResponse:
		return soap_out__ns1__cpResponse(soap, "ns1:cpResponse", id, (const struct _ns1__cpResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__cp:
		return soap_out__ns1__cp(soap, "ns1:cp", id, (const struct _ns1__cp *)ptr, NULL);
	case SOAP_TYPE__ns1__uploadByteArrayResponse:
		return soap_out__ns1__uploadByteArrayResponse(soap, "ns1:uploadByteArrayResponse", id, (const struct _ns1__uploadByteArrayResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__uploadByteArray:
		return soap_out__ns1__uploadByteArray(soap, "ns1:uploadByteArray", id, (const struct _ns1__uploadByteArray *)ptr, NULL);
	case SOAP_TYPE__ns1__submitJobResponse:
		return soap_out__ns1__submitJobResponse(soap, "ns1:submitJobResponse", id, (const struct _ns1__submitJobResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__submitJob:
		return soap_out__ns1__submitJob(soap, "ns1:submitJob", id, (const struct _ns1__submitJob *)ptr, NULL);
	case SOAP_TYPE__ns1__logoutResponse:
		return soap_out__ns1__logoutResponse(soap, "ns1:logoutResponse", id, (const struct _ns1__logoutResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__logout:
		return soap_out__ns1__logout(soap, "ns1:logout", id, (const struct _ns1__logout *)ptr, NULL);
	case SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse:
		return soap_out__ns1__setJobDescription_USCOREstringResponse(soap, "ns1:setJobDescription_stringResponse", id, (const struct _ns1__setJobDescription_USCOREstringResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__setJobDescription_USCOREstring:
		return soap_out__ns1__setJobDescription_USCOREstring(soap, "ns1:setJobDescription_string", id, (const struct _ns1__setJobDescription_USCOREstring *)ptr, NULL);
	case SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse:
		return soap_out__ns1__calculateRelativeJobDirectoryResponse(soap, "ns1:calculateRelativeJobDirectoryResponse", id, (const struct _ns1__calculateRelativeJobDirectoryResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__calculateRelativeJobDirectory:
		return soap_out__ns1__calculateRelativeJobDirectory(soap, "ns1:calculateRelativeJobDirectory", id, (const struct _ns1__calculateRelativeJobDirectory *)ptr, NULL);
	case SOAP_TYPE__ns1__getApplicationDetails1Response:
		return soap_out__ns1__getApplicationDetails1Response(soap, "ns1:getApplicationDetails1Response", id, (const struct _ns1__getApplicationDetails1Response *)ptr, NULL);
	case SOAP_TYPE__ns1__getApplicationDetails1:
		return soap_out__ns1__getApplicationDetails1(soap, "ns1:getApplicationDetails1", id, (const struct _ns1__getApplicationDetails1 *)ptr, NULL);
	case SOAP_TYPE__ns1__lsResponse:
		return soap_out__ns1__lsResponse(soap, "ns1:lsResponse", id, (const struct _ns1__lsResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__ls:
		return soap_out__ns1__ls(soap, "ns1:ls", id, (const struct _ns1__ls *)ptr, NULL);
	case SOAP_TYPE__ns1__lastModifiedResponse:
		return soap_out__ns1__lastModifiedResponse(soap, "ns1:lastModifiedResponse", id, (const struct _ns1__lastModifiedResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__lastModified:
		return soap_out__ns1__lastModified(soap, "ns1:lastModified", id, (const struct _ns1__lastModified *)ptr, NULL);
	case SOAP_TYPE__ns1__getSiteResponse:
		return soap_out__ns1__getSiteResponse(soap, "ns1:getSiteResponse", id, (const struct _ns1__getSiteResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getSite:
		return soap_out__ns1__getSite(soap, "ns1:getSite", id, (const struct _ns1__getSite *)ptr, NULL);
	case SOAP_TYPE__ns1__ps_USCOREstringResponse:
		return soap_out__ns1__ps_USCOREstringResponse(soap, "ns1:ps_stringResponse", id, (const struct _ns1__ps_USCOREstringResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__ps_USCOREstring:
		return soap_out__ns1__ps_USCOREstring(soap, "ns1:ps_string", id, (const struct _ns1__ps_USCOREstring *)ptr, NULL);
	case SOAP_TYPE__ns1__uploadByteArray1Response:
		return soap_out__ns1__uploadByteArray1Response(soap, "ns1:uploadByteArray1Response", id, (const struct _ns1__uploadByteArray1Response *)ptr, NULL);
	case SOAP_TYPE__ns1__uploadByteArray1:
		return soap_out__ns1__uploadByteArray1(soap, "ns1:uploadByteArray1", id, (const struct _ns1__uploadByteArray1 *)ptr, NULL);
	case SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse:
		return soap_out__ns1__getVersionsOfApplicationOnSiteResponse(soap, "ns1:getVersionsOfApplicationOnSiteResponse", id, (const struct _ns1__getVersionsOfApplicationOnSiteResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getVersionsOfApplicationOnSite:
		return soap_out__ns1__getVersionsOfApplicationOnSite(soap, "ns1:getVersionsOfApplicationOnSite", id, (const struct _ns1__getVersionsOfApplicationOnSite *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllSubmissionLocations1Response:
		return soap_out__ns1__getAllSubmissionLocations1Response(soap, "ns1:getAllSubmissionLocations1Response", id, (const struct _ns1__getAllSubmissionLocations1Response *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllSubmissionLocations1:
		return soap_out__ns1__getAllSubmissionLocations1(soap, "ns1:getAllSubmissionLocations1", id, (const struct _ns1__getAllSubmissionLocations1 *)ptr, NULL);
	case SOAP_TYPE__ns1__createJobResponse:
		return soap_out__ns1__createJobResponse(soap, "ns1:createJobResponse", id, (const struct _ns1__createJobResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__createJob:
		return soap_out__ns1__createJob(soap, "ns1:createJob", id, (const struct _ns1__createJob *)ptr, NULL);
	case SOAP_TYPE__ns1__getInterfaceVersionResponse:
		return soap_out__ns1__getInterfaceVersionResponse(soap, "ns1:getInterfaceVersionResponse", id, (const struct _ns1__getInterfaceVersionResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getInterfaceVersion:
		return soap_out__ns1__getInterfaceVersion(soap, "ns1:getInterfaceVersion", id, (const struct _ns1__getInterfaceVersion *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllSubmissionLocationsResponse:
		return soap_out__ns1__getAllSubmissionLocationsResponse(soap, "ns1:getAllSubmissionLocationsResponse", id, (const struct _ns1__getAllSubmissionLocationsResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllSubmissionLocations:
		return soap_out__ns1__getAllSubmissionLocations(soap, "ns1:getAllSubmissionLocations", id, (const struct _ns1__getAllSubmissionLocations *)ptr, NULL);
	case SOAP_TYPE__ns1__addJobPropertyResponse:
		return soap_out__ns1__addJobPropertyResponse(soap, "ns1:addJobPropertyResponse", id, (const struct _ns1__addJobPropertyResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__addJobProperty:
		return soap_out__ns1__addJobProperty(soap, "ns1:addJobProperty", id, (const struct _ns1__addJobProperty *)ptr, NULL);
	case SOAP_TYPE__ns1__addJobPropertiesResponse:
		return soap_out__ns1__addJobPropertiesResponse(soap, "ns1:addJobPropertiesResponse", id, (const struct _ns1__addJobPropertiesResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__addJobProperties:
		return soap_out__ns1__addJobProperties(soap, "ns1:addJobProperties", id, (const struct _ns1__addJobProperties *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllAvailableApplicationsResponse:
		return soap_out__ns1__getAllAvailableApplicationsResponse(soap, "ns1:getAllAvailableApplicationsResponse", id, (const struct _ns1__getAllAvailableApplicationsResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllAvailableApplications:
		return soap_out__ns1__getAllAvailableApplications(soap, "ns1:getAllAvailableApplications", id, (const struct _ns1__getAllAvailableApplications *)ptr, NULL);
	case SOAP_TYPE__ns1__killResponse:
		return soap_out__ns1__killResponse(soap, "ns1:killResponse", id, (const struct _ns1__killResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__kill:
		return soap_out__ns1__kill(soap, "ns1:kill", id, (const struct _ns1__kill *)ptr, NULL);
	case SOAP_TYPE__ns1__isFolderResponse:
		return soap_out__ns1__isFolderResponse(soap, "ns1:isFolderResponse", id, (const struct _ns1__isFolderResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__isFolder:
		return soap_out__ns1__isFolder(soap, "ns1:isFolder", id, (const struct _ns1__isFolder *)ptr, NULL);
	case SOAP_TYPE__ns1__downloadResponse:
		return soap_out__ns1__downloadResponse(soap, "ns1:downloadResponse", id, (const struct _ns1__downloadResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__download:
		return soap_out__ns1__download(soap, "ns1:download", id, (const struct _ns1__download *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllJobPropertiesResponse:
		return soap_out__ns1__getAllJobPropertiesResponse(soap, "ns1:getAllJobPropertiesResponse", id, (const struct _ns1__getAllJobPropertiesResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllJobProperties:
		return soap_out__ns1__getAllJobProperties(soap, "ns1:getAllJobProperties", id, (const struct _ns1__getAllJobProperties *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllJobnamesResponse:
		return soap_out__ns1__getAllJobnamesResponse(soap, "ns1:getAllJobnamesResponse", id, (const struct _ns1__getAllJobnamesResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getAllJobnames:
		return soap_out__ns1__getAllJobnames(soap, "ns1:getAllJobnames", id, (const struct _ns1__getAllJobnames *)ptr, NULL);
	case SOAP_TYPE__ns1__getDNResponse:
		return soap_out__ns1__getDNResponse(soap, "ns1:getDNResponse", id, (const struct _ns1__getDNResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getDN:
		return soap_out__ns1__getDN(soap, "ns1:getDN", id, (const struct _ns1__getDN *)ptr, NULL);
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse:
		return soap_out__ns1__getSubmissionLocationsForApplicationResponse(soap, "ns1:getSubmissionLocationsForApplicationResponse", id, (const struct _ns1__getSubmissionLocationsForApplicationResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication:
		return soap_out__ns1__getSubmissionLocationsForApplication(soap, "ns1:getSubmissionLocationsForApplication", id, (const struct _ns1__getSubmissionLocationsForApplication *)ptr, NULL);
	case SOAP_TYPE__ns1__createJob1Response:
		return soap_out__ns1__createJob1Response(soap, "ns1:createJob1Response", id, (const struct _ns1__createJob1Response *)ptr, NULL);
	case SOAP_TYPE__ns1__createJob1:
		return soap_out__ns1__createJob1(soap, "ns1:createJob1", id, (const struct _ns1__createJob1 *)ptr, NULL);
	case SOAP_TYPE__ns1__getApplicationDetailsResponse:
		return soap_out__ns1__getApplicationDetailsResponse(soap, "ns1:getApplicationDetailsResponse", id, (const struct _ns1__getApplicationDetailsResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getApplicationDetails:
		return soap_out__ns1__getApplicationDetails(soap, "ns1:getApplicationDetails", id, (const struct _ns1__getApplicationDetails *)ptr, NULL);
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication1Response:
		return soap_out__ns1__getSubmissionLocationsForApplication1Response(soap, "ns1:getSubmissionLocationsForApplication1Response", id, (const struct _ns1__getSubmissionLocationsForApplication1Response *)ptr, NULL);
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication1:
		return soap_out__ns1__getSubmissionLocationsForApplication1(soap, "ns1:getSubmissionLocationsForApplication1", id, (const struct _ns1__getSubmissionLocationsForApplication1 *)ptr, NULL);
	case SOAP_TYPE__ns1__ls_USCOREstringResponse:
		return soap_out__ns1__ls_USCOREstringResponse(soap, "ns1:ls_stringResponse", id, (const struct _ns1__ls_USCOREstringResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__ls_USCOREstring:
		return soap_out__ns1__ls_USCOREstring(soap, "ns1:ls_string", id, (const struct _ns1__ls_USCOREstring *)ptr, NULL);
	case SOAP_TYPE__ns1__calculateAbsoluteJobDirectoryResponse:
		return soap_out__ns1__calculateAbsoluteJobDirectoryResponse(soap, "ns1:calculateAbsoluteJobDirectoryResponse", id, (const struct _ns1__calculateAbsoluteJobDirectoryResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__calculateAbsoluteJobDirectory:
		return soap_out__ns1__calculateAbsoluteJobDirectory(soap, "ns1:calculateAbsoluteJobDirectory", id, (const struct _ns1__calculateAbsoluteJobDirectory *)ptr, NULL);
	case SOAP_TYPE__ns1__getMessagesSinceResponse:
		return soap_out__ns1__getMessagesSinceResponse(soap, "ns1:getMessagesSinceResponse", id, (const struct _ns1__getMessagesSinceResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getMessagesSince:
		return soap_out__ns1__getMessagesSince(soap, "ns1:getMessagesSince", id, (const struct _ns1__getMessagesSince *)ptr, NULL);
	case SOAP_TYPE__ns1__deleteFilesResponse:
		return soap_out__ns1__deleteFilesResponse(soap, "ns1:deleteFilesResponse", id, (const struct _ns1__deleteFilesResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__deleteFiles:
		return soap_out__ns1__deleteFiles(soap, "ns1:deleteFiles", id, (const struct _ns1__deleteFiles *)ptr, NULL);
	case SOAP_TYPE__ns1__listHostedApplicationTemplatesResponse:
		return soap_out__ns1__listHostedApplicationTemplatesResponse(soap, "ns1:listHostedApplicationTemplatesResponse", id, (const struct _ns1__listHostedApplicationTemplatesResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__listHostedApplicationTemplates:
		return soap_out__ns1__listHostedApplicationTemplates(soap, "ns1:listHostedApplicationTemplates", id, (const struct _ns1__listHostedApplicationTemplates *)ptr, NULL);
	case SOAP_TYPE__ns1__downloadByteArray1Response:
		return soap_out__ns1__downloadByteArray1Response(soap, "ns1:downloadByteArray1Response", id, (const struct _ns1__downloadByteArray1Response *)ptr, NULL);
	case SOAP_TYPE__ns1__downloadByteArray1:
		return soap_out__ns1__downloadByteArray1(soap, "ns1:downloadByteArray1", id, (const struct _ns1__downloadByteArray1 *)ptr, NULL);
	case SOAP_TYPE__ns1__getTemplate1Response:
		return soap_out__ns1__getTemplate1Response(soap, "ns1:getTemplate1Response", id, (const struct _ns1__getTemplate1Response *)ptr, NULL);
	case SOAP_TYPE__ns1__getTemplate1:
		return soap_out__ns1__getTemplate1(soap, "ns1:getTemplate1", id, (const struct _ns1__getTemplate1 *)ptr, NULL);
	case SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplicationResponse:
		return soap_out__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, "ns1:getSubmissionLocationsPerVersionOfApplicationResponse", id, (const struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplication:
		return soap_out__ns1__getSubmissionLocationsPerVersionOfApplication(soap, "ns1:getSubmissionLocationsPerVersionOfApplication", id, (const struct _ns1__getSubmissionLocationsPerVersionOfApplication *)ptr, NULL);
	case SOAP_TYPE__ns1__getDataLocationsForVOResponse:
		return soap_out__ns1__getDataLocationsForVOResponse(soap, "ns1:getDataLocationsForVOResponse", id, (const struct _ns1__getDataLocationsForVOResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getDataLocationsForVO:
		return soap_out__ns1__getDataLocationsForVO(soap, "ns1:getDataLocationsForVO", id, (const struct _ns1__getDataLocationsForVO *)ptr, NULL);
	case SOAP_TYPE__ns1__mkdirResponse:
		return soap_out__ns1__mkdirResponse(soap, "ns1:mkdirResponse", id, (const struct _ns1__mkdirResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__mkdir:
		return soap_out__ns1__mkdir(soap, "ns1:mkdir", id, (const struct _ns1__mkdir *)ptr, NULL);
	case SOAP_TYPE__ns1__getUserPropertyResponse:
		return soap_out__ns1__getUserPropertyResponse(soap, "ns1:getUserPropertyResponse", id, (const struct _ns1__getUserPropertyResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getUserProperty:
		return soap_out__ns1__getUserProperty(soap, "ns1:getUserProperty", id, (const struct _ns1__getUserProperty *)ptr, NULL);
	case SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocationResponse:
		return soap_out__ns1__getStagingFileSystemForSubmissionLocationResponse(soap, "ns1:getStagingFileSystemForSubmissionLocationResponse", id, (const struct _ns1__getStagingFileSystemForSubmissionLocationResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocation:
		return soap_out__ns1__getStagingFileSystemForSubmissionLocation(soap, "ns1:getStagingFileSystemForSubmissionLocation", id, (const struct _ns1__getStagingFileSystemForSubmissionLocation *)ptr, NULL);
	case SOAP_TYPE__ns1__psResponse:
		return soap_out__ns1__psResponse(soap, "ns1:psResponse", id, (const struct _ns1__psResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__ps:
		return soap_out__ns1__ps(soap, "ns1:ps", id, (const struct _ns1__ps *)ptr, NULL);
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication2Response:
		return soap_out__ns1__getSubmissionLocationsForApplication2Response(soap, "ns1:getSubmissionLocationsForApplication2Response", id, (const struct _ns1__getSubmissionLocationsForApplication2Response *)ptr, NULL);
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication2:
		return soap_out__ns1__getSubmissionLocationsForApplication2(soap, "ns1:getSubmissionLocationsForApplication2", id, (const struct _ns1__getSubmissionLocationsForApplication2 *)ptr, NULL);
	case SOAP_TYPE__ns1__downloadByteArrayResponse:
		return soap_out__ns1__downloadByteArrayResponse(soap, "ns1:downloadByteArrayResponse", id, (const struct _ns1__downloadByteArrayResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__downloadByteArray:
		return soap_out__ns1__downloadByteArray(soap, "ns1:downloadByteArray", id, (const struct _ns1__downloadByteArray *)ptr, NULL);
	case SOAP_TYPE_ns3__ArrayOfMountPoint:
		return soap_out_ns3__ArrayOfMountPoint(soap, tag, id, (const struct ns3__ArrayOfMountPoint *)ptr, "ns3:ArrayOfMountPoint");
	case SOAP_TYPE__ns1__dfResponse:
		return soap_out__ns1__dfResponse(soap, "ns1:dfResponse", id, (const struct _ns1__dfResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__df:
		return soap_out__ns1__df(soap, "ns1:df", id, (const struct _ns1__df *)ptr, NULL);
	case SOAP_TYPE__ns1__getFqansResponse:
		return soap_out__ns1__getFqansResponse(soap, "ns1:getFqansResponse", id, (const struct _ns1__getFqansResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getFqans:
		return soap_out__ns1__getFqans(soap, "ns1:getFqans", id, (const struct _ns1__getFqans *)ptr, NULL);
	case SOAP_TYPE__ns1__getTemplateResponse:
		return soap_out__ns1__getTemplateResponse(soap, "ns1:getTemplateResponse", id, (const struct _ns1__getTemplateResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getTemplate:
		return soap_out__ns1__getTemplate(soap, "ns1:getTemplate", id, (const struct _ns1__getTemplate *)ptr, NULL);
	case SOAP_TYPE__ns1__loginResponse:
		return soap_out__ns1__loginResponse(soap, "ns1:loginResponse", id, (const struct _ns1__loginResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__login:
		return soap_out__ns1__login(soap, "ns1:login", id, (const struct _ns1__login *)ptr, NULL);
	case SOAP_TYPE_ns3__MountPoint:
		return soap_out_ns3__MountPoint(soap, tag, id, (const struct ns3__MountPoint *)ptr, "ns3:MountPoint");
	case SOAP_TYPE__ns1__mountResponse:
		return soap_out__ns1__mountResponse(soap, "ns1:mountResponse", id, (const struct _ns1__mountResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__mount:
		return soap_out__ns1__mount(soap, "ns1:mount", id, (const struct _ns1__mount *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobFqanResponse:
		return soap_out__ns1__getJobFqanResponse(soap, "ns1:getJobFqanResponse", id, (const struct _ns1__getJobFqanResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getJobFqan:
		return soap_out__ns1__getJobFqan(soap, "ns1:getJobFqan", id, (const struct _ns1__getJobFqan *)ptr, NULL);
	case SOAP_TYPE__ns1__getChildrenFilesResponse:
		return soap_out__ns1__getChildrenFilesResponse(soap, "ns1:getChildrenFilesResponse", id, (const struct _ns1__getChildrenFilesResponse *)ptr, NULL);
	case SOAP_TYPE__ns1__getChildrenFiles:
		return soap_out__ns1__getChildrenFiles(soap, "ns1:getChildrenFiles", id, (const struct _ns1__getChildrenFiles *)ptr, NULL);
	case SOAP_TYPE__ns1__anyType2anyTypeMap_entry:
		return soap_out__ns1__anyType2anyTypeMap_entry(soap, "ns1:anyType2anyTypeMap-entry", id, (const struct _ns1__anyType2anyTypeMap_entry *)ptr, NULL);
	case SOAP_TYPE_ns1__anyType2anyTypeMap:
		return soap_out_ns1__anyType2anyTypeMap(soap, tag, id, (const struct ns1__anyType2anyTypeMap *)ptr, "ns1:anyType2anyTypeMap");
	case SOAP_TYPE_ns1__ArrayOfString:
		return soap_out_ns1__ArrayOfString(soap, tag, id, (const struct ns1__ArrayOfString *)ptr, "ns1:ArrayOfString");
	case SOAP_TYPE_xsd__base64Binary:
		return soap_out_xsd__base64Binary(soap, tag, id, (const struct xsd__base64Binary *)ptr, "xsd:base64Binary");
	case SOAP_TYPE__xop__Include:
		return soap_out__xop__Include(soap, "xop:Include", id, (const struct _xop__Include *)ptr, NULL);
	case SOAP_TYPE_PointerTo_ns1__getAllHostsResponse:
		return soap_out_PointerTo_ns1__getAllHostsResponse(soap, tag, id, (struct _ns1__getAllHostsResponse *const*)ptr, "ns1:getAllHostsResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllHosts:
		return soap_out_PointerTo_ns1__getAllHosts(soap, tag, id, (struct _ns1__getAllHosts *const*)ptr, "ns1:getAllHosts");
	case SOAP_TYPE_PointerTo_ns1__submitSupportRequestResponse:
		return soap_out_PointerTo_ns1__submitSupportRequestResponse(soap, tag, id, (struct _ns1__submitSupportRequestResponse *const*)ptr, "ns1:submitSupportRequestResponse");
	case SOAP_TYPE_PointerTo_ns1__submitSupportRequest:
		return soap_out_PointerTo_ns1__submitSupportRequest(soap, tag, id, (struct _ns1__submitSupportRequest *const*)ptr, "ns1:submitSupportRequest");
	case SOAP_TYPE_PointerTo_ns1__getJobPropertyResponse:
		return soap_out_PointerTo_ns1__getJobPropertyResponse(soap, tag, id, (struct _ns1__getJobPropertyResponse *const*)ptr, "ns1:getJobPropertyResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobProperty:
		return soap_out_PointerTo_ns1__getJobProperty(soap, tag, id, (struct _ns1__getJobProperty *const*)ptr, "ns1:getJobProperty");
	case SOAP_TYPE_PointerTo_ns1__mount1Response:
		return soap_out_PointerTo_ns1__mount1Response(soap, tag, id, (struct _ns1__mount1Response *const*)ptr, "ns1:mount1Response");
	case SOAP_TYPE_PointerTo_ns1__mount1:
		return soap_out_PointerTo_ns1__mount1(soap, tag, id, (struct _ns1__mount1 *const*)ptr, "ns1:mount1");
	case SOAP_TYPE_PointerTo_ns1__getJobDetailsResponse:
		return soap_out_PointerTo_ns1__getJobDetailsResponse(soap, tag, id, (struct _ns1__getJobDetailsResponse *const*)ptr, "ns1:getJobDetailsResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobDetails:
		return soap_out_PointerTo_ns1__getJobDetails(soap, tag, id, (struct _ns1__getJobDetails *const*)ptr, "ns1:getJobDetails");
	case SOAP_TYPE_PointerTo_ns1__umountResponse:
		return soap_out_PointerTo_ns1__umountResponse(soap, tag, id, (struct _ns1__umountResponse *const*)ptr, "ns1:umountResponse");
	case SOAP_TYPE_PointerTo_ns1__umount:
		return soap_out_PointerTo_ns1__umount(soap, tag, id, (struct _ns1__umount *const*)ptr, "ns1:umount");
	case SOAP_TYPE_PointerTo_ns1__getJobStatusResponse:
		return soap_out_PointerTo_ns1__getJobStatusResponse(soap, tag, id, (struct _ns1__getJobStatusResponse *const*)ptr, "ns1:getJobStatusResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobStatus:
		return soap_out_PointerTo_ns1__getJobStatus(soap, tag, id, (struct _ns1__getJobStatus *const*)ptr, "ns1:getJobStatus");
	case SOAP_TYPE_PointerTo_ns1__getJobDetails_USCOREstringResponse:
		return soap_out_PointerTo_ns1__getJobDetails_USCOREstringResponse(soap, tag, id, (struct _ns1__getJobDetails_USCOREstringResponse *const*)ptr, "ns1:getJobDetails_stringResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobDetails_USCOREstring:
		return soap_out_PointerTo_ns1__getJobDetails_USCOREstring(soap, tag, id, (struct _ns1__getJobDetails_USCOREstring *const*)ptr, "ns1:getJobDetails_string");
	case SOAP_TYPE_PointerTo_ns1__getAllSitesResponse:
		return soap_out_PointerTo_ns1__getAllSitesResponse(soap, tag, id, (struct _ns1__getAllSitesResponse *const*)ptr, "ns1:getAllSitesResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllSites:
		return soap_out_PointerTo_ns1__getAllSites(soap, tag, id, (struct _ns1__getAllSites *const*)ptr, "ns1:getAllSites");
	case SOAP_TYPE_PointerTo_ns1__setJobDescriptionResponse:
		return soap_out_PointerTo_ns1__setJobDescriptionResponse(soap, tag, id, (struct _ns1__setJobDescriptionResponse *const*)ptr, "ns1:setJobDescriptionResponse");
	case SOAP_TYPE_PointerTo_ns1__setJobDescription:
		return soap_out_PointerTo_ns1__setJobDescription(soap, tag, id, (struct _ns1__setJobDescription *const*)ptr, "ns1:setJobDescription");
	case SOAP_TYPE_PointerTo_ns1__getJobDirectoryResponse:
		return soap_out_PointerTo_ns1__getJobDirectoryResponse(soap, tag, id, (struct _ns1__getJobDirectoryResponse *const*)ptr, "ns1:getJobDirectoryResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobDirectory:
		return soap_out_PointerTo_ns1__getJobDirectory(soap, tag, id, (struct _ns1__getJobDirectory *const*)ptr, "ns1:getJobDirectory");
	case SOAP_TYPE_PointerTo_ns1__uploadResponse:
		return soap_out_PointerTo_ns1__uploadResponse(soap, tag, id, (struct _ns1__uploadResponse *const*)ptr, "ns1:uploadResponse");
	case SOAP_TYPE_PointerTo_ns1__upload:
		return soap_out_PointerTo_ns1__upload(soap, tag, id, (struct _ns1__upload *const*)ptr, "ns1:upload");
	case SOAP_TYPE_PointerTo_ns1__deleteFileResponse:
		return soap_out_PointerTo_ns1__deleteFileResponse(soap, tag, id, (struct _ns1__deleteFileResponse *const*)ptr, "ns1:deleteFileResponse");
	case SOAP_TYPE_PointerTo_ns1__deleteFile:
		return soap_out_PointerTo_ns1__deleteFile(soap, tag, id, (struct _ns1__deleteFile *const*)ptr, "ns1:deleteFile");
	case SOAP_TYPE_PointerTo_ns1__getFileSizeResponse:
		return soap_out_PointerTo_ns1__getFileSizeResponse(soap, tag, id, (struct _ns1__getFileSizeResponse *const*)ptr, "ns1:getFileSizeResponse");
	case SOAP_TYPE_PointerTo_ns1__getFileSize:
		return soap_out_PointerTo_ns1__getFileSize(soap, tag, id, (struct _ns1__getFileSize *const*)ptr, "ns1:getFileSize");
	case SOAP_TYPE_PointerTo_ns1__cpResponse:
		return soap_out_PointerTo_ns1__cpResponse(soap, tag, id, (struct _ns1__cpResponse *const*)ptr, "ns1:cpResponse");
	case SOAP_TYPE_PointerTo_ns1__cp:
		return soap_out_PointerTo_ns1__cp(soap, tag, id, (struct _ns1__cp *const*)ptr, "ns1:cp");
	case SOAP_TYPE_PointerTo_ns1__uploadByteArrayResponse:
		return soap_out_PointerTo_ns1__uploadByteArrayResponse(soap, tag, id, (struct _ns1__uploadByteArrayResponse *const*)ptr, "ns1:uploadByteArrayResponse");
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray:
		return soap_out_PointerTo_ns1__uploadByteArray(soap, tag, id, (struct _ns1__uploadByteArray *const*)ptr, "ns1:uploadByteArray");
	case SOAP_TYPE_PointerTo_ns1__submitJobResponse:
		return soap_out_PointerTo_ns1__submitJobResponse(soap, tag, id, (struct _ns1__submitJobResponse *const*)ptr, "ns1:submitJobResponse");
	case SOAP_TYPE_PointerTo_ns1__submitJob:
		return soap_out_PointerTo_ns1__submitJob(soap, tag, id, (struct _ns1__submitJob *const*)ptr, "ns1:submitJob");
	case SOAP_TYPE_PointerTo_ns1__logoutResponse:
		return soap_out_PointerTo_ns1__logoutResponse(soap, tag, id, (struct _ns1__logoutResponse *const*)ptr, "ns1:logoutResponse");
	case SOAP_TYPE_PointerTo_ns1__logout:
		return soap_out_PointerTo_ns1__logout(soap, tag, id, (struct _ns1__logout *const*)ptr, "ns1:logout");
	case SOAP_TYPE_PointerTo_ns1__setJobDescription_USCOREstringResponse:
		return soap_out_PointerTo_ns1__setJobDescription_USCOREstringResponse(soap, tag, id, (struct _ns1__setJobDescription_USCOREstringResponse *const*)ptr, "ns1:setJobDescription_stringResponse");
	case SOAP_TYPE_PointerTo_ns1__setJobDescription_USCOREstring:
		return soap_out_PointerTo_ns1__setJobDescription_USCOREstring(soap, tag, id, (struct _ns1__setJobDescription_USCOREstring *const*)ptr, "ns1:setJobDescription_string");
	case SOAP_TYPE_PointerTo_ns1__calculateRelativeJobDirectoryResponse:
		return soap_out_PointerTo_ns1__calculateRelativeJobDirectoryResponse(soap, tag, id, (struct _ns1__calculateRelativeJobDirectoryResponse *const*)ptr, "ns1:calculateRelativeJobDirectoryResponse");
	case SOAP_TYPE_PointerTo_ns1__calculateRelativeJobDirectory:
		return soap_out_PointerTo_ns1__calculateRelativeJobDirectory(soap, tag, id, (struct _ns1__calculateRelativeJobDirectory *const*)ptr, "ns1:calculateRelativeJobDirectory");
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails1Response:
		return soap_out_PointerTo_ns1__getApplicationDetails1Response(soap, tag, id, (struct _ns1__getApplicationDetails1Response *const*)ptr, "ns1:getApplicationDetails1Response");
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails1:
		return soap_out_PointerTo_ns1__getApplicationDetails1(soap, tag, id, (struct _ns1__getApplicationDetails1 *const*)ptr, "ns1:getApplicationDetails1");
	case SOAP_TYPE_PointerTo_ns1__lsResponse:
		return soap_out_PointerTo_ns1__lsResponse(soap, tag, id, (struct _ns1__lsResponse *const*)ptr, "ns1:lsResponse");
	case SOAP_TYPE_PointerTo_ns1__ls:
		return soap_out_PointerTo_ns1__ls(soap, tag, id, (struct _ns1__ls *const*)ptr, "ns1:ls");
	case SOAP_TYPE_PointerTo_ns1__lastModifiedResponse:
		return soap_out_PointerTo_ns1__lastModifiedResponse(soap, tag, id, (struct _ns1__lastModifiedResponse *const*)ptr, "ns1:lastModifiedResponse");
	case SOAP_TYPE_PointerTo_ns1__lastModified:
		return soap_out_PointerTo_ns1__lastModified(soap, tag, id, (struct _ns1__lastModified *const*)ptr, "ns1:lastModified");
	case SOAP_TYPE_PointerTo_ns1__getSiteResponse:
		return soap_out_PointerTo_ns1__getSiteResponse(soap, tag, id, (struct _ns1__getSiteResponse *const*)ptr, "ns1:getSiteResponse");
	case SOAP_TYPE_PointerTo_ns1__getSite:
		return soap_out_PointerTo_ns1__getSite(soap, tag, id, (struct _ns1__getSite *const*)ptr, "ns1:getSite");
	case SOAP_TYPE_PointerTo_ns1__ps_USCOREstringResponse:
		return soap_out_PointerTo_ns1__ps_USCOREstringResponse(soap, tag, id, (struct _ns1__ps_USCOREstringResponse *const*)ptr, "ns1:ps_stringResponse");
	case SOAP_TYPE_PointerTo_ns1__ps_USCOREstring:
		return soap_out_PointerTo_ns1__ps_USCOREstring(soap, tag, id, (struct _ns1__ps_USCOREstring *const*)ptr, "ns1:ps_string");
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray1Response:
		return soap_out_PointerTo_ns1__uploadByteArray1Response(soap, tag, id, (struct _ns1__uploadByteArray1Response *const*)ptr, "ns1:uploadByteArray1Response");
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray1:
		return soap_out_PointerTo_ns1__uploadByteArray1(soap, tag, id, (struct _ns1__uploadByteArray1 *const*)ptr, "ns1:uploadByteArray1");
	case SOAP_TYPE_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse:
		return soap_out_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(soap, tag, id, (struct _ns1__getVersionsOfApplicationOnSiteResponse *const*)ptr, "ns1:getVersionsOfApplicationOnSiteResponse");
	case SOAP_TYPE_PointerTo_ns1__getVersionsOfApplicationOnSite:
		return soap_out_PointerTo_ns1__getVersionsOfApplicationOnSite(soap, tag, id, (struct _ns1__getVersionsOfApplicationOnSite *const*)ptr, "ns1:getVersionsOfApplicationOnSite");
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations1Response:
		return soap_out_PointerTo_ns1__getAllSubmissionLocations1Response(soap, tag, id, (struct _ns1__getAllSubmissionLocations1Response *const*)ptr, "ns1:getAllSubmissionLocations1Response");
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations1:
		return soap_out_PointerTo_ns1__getAllSubmissionLocations1(soap, tag, id, (struct _ns1__getAllSubmissionLocations1 *const*)ptr, "ns1:getAllSubmissionLocations1");
	case SOAP_TYPE_PointerTo_ns1__createJobResponse:
		return soap_out_PointerTo_ns1__createJobResponse(soap, tag, id, (struct _ns1__createJobResponse *const*)ptr, "ns1:createJobResponse");
	case SOAP_TYPE_PointerTo_ns1__createJob:
		return soap_out_PointerTo_ns1__createJob(soap, tag, id, (struct _ns1__createJob *const*)ptr, "ns1:createJob");
	case SOAP_TYPE_PointerTo_ns1__getInterfaceVersionResponse:
		return soap_out_PointerTo_ns1__getInterfaceVersionResponse(soap, tag, id, (struct _ns1__getInterfaceVersionResponse *const*)ptr, "ns1:getInterfaceVersionResponse");
	case SOAP_TYPE_PointerTo_ns1__getInterfaceVersion:
		return soap_out_PointerTo_ns1__getInterfaceVersion(soap, tag, id, (struct _ns1__getInterfaceVersion *const*)ptr, "ns1:getInterfaceVersion");
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocationsResponse:
		return soap_out_PointerTo_ns1__getAllSubmissionLocationsResponse(soap, tag, id, (struct _ns1__getAllSubmissionLocationsResponse *const*)ptr, "ns1:getAllSubmissionLocationsResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations:
		return soap_out_PointerTo_ns1__getAllSubmissionLocations(soap, tag, id, (struct _ns1__getAllSubmissionLocations *const*)ptr, "ns1:getAllSubmissionLocations");
	case SOAP_TYPE_PointerTo_ns1__addJobPropertyResponse:
		return soap_out_PointerTo_ns1__addJobPropertyResponse(soap, tag, id, (struct _ns1__addJobPropertyResponse *const*)ptr, "ns1:addJobPropertyResponse");
	case SOAP_TYPE_PointerTo_ns1__addJobProperty:
		return soap_out_PointerTo_ns1__addJobProperty(soap, tag, id, (struct _ns1__addJobProperty *const*)ptr, "ns1:addJobProperty");
	case SOAP_TYPE_PointerTo_ns1__addJobPropertiesResponse:
		return soap_out_PointerTo_ns1__addJobPropertiesResponse(soap, tag, id, (struct _ns1__addJobPropertiesResponse *const*)ptr, "ns1:addJobPropertiesResponse");
	case SOAP_TYPE_PointerTo_ns1__addJobProperties:
		return soap_out_PointerTo_ns1__addJobProperties(soap, tag, id, (struct _ns1__addJobProperties *const*)ptr, "ns1:addJobProperties");
	case SOAP_TYPE_PointerTo_ns1__getAllAvailableApplicationsResponse:
		return soap_out_PointerTo_ns1__getAllAvailableApplicationsResponse(soap, tag, id, (struct _ns1__getAllAvailableApplicationsResponse *const*)ptr, "ns1:getAllAvailableApplicationsResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllAvailableApplications:
		return soap_out_PointerTo_ns1__getAllAvailableApplications(soap, tag, id, (struct _ns1__getAllAvailableApplications *const*)ptr, "ns1:getAllAvailableApplications");
	case SOAP_TYPE_PointerTo_ns1__killResponse:
		return soap_out_PointerTo_ns1__killResponse(soap, tag, id, (struct _ns1__killResponse *const*)ptr, "ns1:killResponse");
	case SOAP_TYPE_PointerTo_ns1__kill:
		return soap_out_PointerTo_ns1__kill(soap, tag, id, (struct _ns1__kill *const*)ptr, "ns1:kill");
	case SOAP_TYPE_PointerTo_ns1__isFolderResponse:
		return soap_out_PointerTo_ns1__isFolderResponse(soap, tag, id, (struct _ns1__isFolderResponse *const*)ptr, "ns1:isFolderResponse");
	case SOAP_TYPE_PointerTo_ns1__isFolder:
		return soap_out_PointerTo_ns1__isFolder(soap, tag, id, (struct _ns1__isFolder *const*)ptr, "ns1:isFolder");
	case SOAP_TYPE_PointerTo_ns1__downloadResponse:
		return soap_out_PointerTo_ns1__downloadResponse(soap, tag, id, (struct _ns1__downloadResponse *const*)ptr, "ns1:downloadResponse");
	case SOAP_TYPE_PointerTo_ns1__download:
		return soap_out_PointerTo_ns1__download(soap, tag, id, (struct _ns1__download *const*)ptr, "ns1:download");
	case SOAP_TYPE_PointerTo_ns1__getAllJobPropertiesResponse:
		return soap_out_PointerTo_ns1__getAllJobPropertiesResponse(soap, tag, id, (struct _ns1__getAllJobPropertiesResponse *const*)ptr, "ns1:getAllJobPropertiesResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllJobProperties:
		return soap_out_PointerTo_ns1__getAllJobProperties(soap, tag, id, (struct _ns1__getAllJobProperties *const*)ptr, "ns1:getAllJobProperties");
	case SOAP_TYPE_PointerTo_ns1__getAllJobnamesResponse:
		return soap_out_PointerTo_ns1__getAllJobnamesResponse(soap, tag, id, (struct _ns1__getAllJobnamesResponse *const*)ptr, "ns1:getAllJobnamesResponse");
	case SOAP_TYPE_PointerTo_ns1__getAllJobnames:
		return soap_out_PointerTo_ns1__getAllJobnames(soap, tag, id, (struct _ns1__getAllJobnames *const*)ptr, "ns1:getAllJobnames");
	case SOAP_TYPE_PointerTo_ns1__getDNResponse:
		return soap_out_PointerTo_ns1__getDNResponse(soap, tag, id, (struct _ns1__getDNResponse *const*)ptr, "ns1:getDNResponse");
	case SOAP_TYPE_PointerTo_ns1__getDN:
		return soap_out_PointerTo_ns1__getDN(soap, tag, id, (struct _ns1__getDN *const*)ptr, "ns1:getDN");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplicationResponse:
		return soap_out_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(soap, tag, id, (struct _ns1__getSubmissionLocationsForApplicationResponse *const*)ptr, "ns1:getSubmissionLocationsForApplicationResponse");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication:
		return soap_out_PointerTo_ns1__getSubmissionLocationsForApplication(soap, tag, id, (struct _ns1__getSubmissionLocationsForApplication *const*)ptr, "ns1:getSubmissionLocationsForApplication");
	case SOAP_TYPE_PointerTo_ns1__createJob1Response:
		return soap_out_PointerTo_ns1__createJob1Response(soap, tag, id, (struct _ns1__createJob1Response *const*)ptr, "ns1:createJob1Response");
	case SOAP_TYPE_PointerTo_ns1__createJob1:
		return soap_out_PointerTo_ns1__createJob1(soap, tag, id, (struct _ns1__createJob1 *const*)ptr, "ns1:createJob1");
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetailsResponse:
		return soap_out_PointerTo_ns1__getApplicationDetailsResponse(soap, tag, id, (struct _ns1__getApplicationDetailsResponse *const*)ptr, "ns1:getApplicationDetailsResponse");
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails:
		return soap_out_PointerTo_ns1__getApplicationDetails(soap, tag, id, (struct _ns1__getApplicationDetails *const*)ptr, "ns1:getApplicationDetails");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication1Response:
		return soap_out_PointerTo_ns1__getSubmissionLocationsForApplication1Response(soap, tag, id, (struct _ns1__getSubmissionLocationsForApplication1Response *const*)ptr, "ns1:getSubmissionLocationsForApplication1Response");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication1:
		return soap_out_PointerTo_ns1__getSubmissionLocationsForApplication1(soap, tag, id, (struct _ns1__getSubmissionLocationsForApplication1 *const*)ptr, "ns1:getSubmissionLocationsForApplication1");
	case SOAP_TYPE_PointerTo_ns1__ls_USCOREstringResponse:
		return soap_out_PointerTo_ns1__ls_USCOREstringResponse(soap, tag, id, (struct _ns1__ls_USCOREstringResponse *const*)ptr, "ns1:ls_stringResponse");
	case SOAP_TYPE_PointerTo_ns1__ls_USCOREstring:
		return soap_out_PointerTo_ns1__ls_USCOREstring(soap, tag, id, (struct _ns1__ls_USCOREstring *const*)ptr, "ns1:ls_string");
	case SOAP_TYPE_PointerTo_ns1__calculateAbsoluteJobDirectoryResponse:
		return soap_out_PointerTo_ns1__calculateAbsoluteJobDirectoryResponse(soap, tag, id, (struct _ns1__calculateAbsoluteJobDirectoryResponse *const*)ptr, "ns1:calculateAbsoluteJobDirectoryResponse");
	case SOAP_TYPE_PointerTo_ns1__calculateAbsoluteJobDirectory:
		return soap_out_PointerTo_ns1__calculateAbsoluteJobDirectory(soap, tag, id, (struct _ns1__calculateAbsoluteJobDirectory *const*)ptr, "ns1:calculateAbsoluteJobDirectory");
	case SOAP_TYPE_PointerTo_ns1__getMessagesSinceResponse:
		return soap_out_PointerTo_ns1__getMessagesSinceResponse(soap, tag, id, (struct _ns1__getMessagesSinceResponse *const*)ptr, "ns1:getMessagesSinceResponse");
	case SOAP_TYPE_PointerTo_ns1__getMessagesSince:
		return soap_out_PointerTo_ns1__getMessagesSince(soap, tag, id, (struct _ns1__getMessagesSince *const*)ptr, "ns1:getMessagesSince");
	case SOAP_TYPE_PointerTo_ns1__deleteFilesResponse:
		return soap_out_PointerTo_ns1__deleteFilesResponse(soap, tag, id, (struct _ns1__deleteFilesResponse *const*)ptr, "ns1:deleteFilesResponse");
	case SOAP_TYPE_PointerTo_ns1__deleteFiles:
		return soap_out_PointerTo_ns1__deleteFiles(soap, tag, id, (struct _ns1__deleteFiles *const*)ptr, "ns1:deleteFiles");
	case SOAP_TYPE_PointerTo_ns1__listHostedApplicationTemplatesResponse:
		return soap_out_PointerTo_ns1__listHostedApplicationTemplatesResponse(soap, tag, id, (struct _ns1__listHostedApplicationTemplatesResponse *const*)ptr, "ns1:listHostedApplicationTemplatesResponse");
	case SOAP_TYPE_PointerTo_ns1__listHostedApplicationTemplates:
		return soap_out_PointerTo_ns1__listHostedApplicationTemplates(soap, tag, id, (struct _ns1__listHostedApplicationTemplates *const*)ptr, "ns1:listHostedApplicationTemplates");
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray1Response:
		return soap_out_PointerTo_ns1__downloadByteArray1Response(soap, tag, id, (struct _ns1__downloadByteArray1Response *const*)ptr, "ns1:downloadByteArray1Response");
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray1:
		return soap_out_PointerTo_ns1__downloadByteArray1(soap, tag, id, (struct _ns1__downloadByteArray1 *const*)ptr, "ns1:downloadByteArray1");
	case SOAP_TYPE_PointerTo_ns1__getTemplate1Response:
		return soap_out_PointerTo_ns1__getTemplate1Response(soap, tag, id, (struct _ns1__getTemplate1Response *const*)ptr, "ns1:getTemplate1Response");
	case SOAP_TYPE_PointerTo_ns1__getTemplate1:
		return soap_out_PointerTo_ns1__getTemplate1(soap, tag, id, (struct _ns1__getTemplate1 *const*)ptr, "ns1:getTemplate1");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplicationResponse:
		return soap_out_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, tag, id, (struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *const*)ptr, "ns1:getSubmissionLocationsPerVersionOfApplicationResponse");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication:
		return soap_out_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication(soap, tag, id, (struct _ns1__getSubmissionLocationsPerVersionOfApplication *const*)ptr, "ns1:getSubmissionLocationsPerVersionOfApplication");
	case SOAP_TYPE_PointerTo_ns1__getDataLocationsForVOResponse:
		return soap_out_PointerTo_ns1__getDataLocationsForVOResponse(soap, tag, id, (struct _ns1__getDataLocationsForVOResponse *const*)ptr, "ns1:getDataLocationsForVOResponse");
	case SOAP_TYPE_PointerTo_ns1__getDataLocationsForVO:
		return soap_out_PointerTo_ns1__getDataLocationsForVO(soap, tag, id, (struct _ns1__getDataLocationsForVO *const*)ptr, "ns1:getDataLocationsForVO");
	case SOAP_TYPE_PointerTo_ns1__mkdirResponse:
		return soap_out_PointerTo_ns1__mkdirResponse(soap, tag, id, (struct _ns1__mkdirResponse *const*)ptr, "ns1:mkdirResponse");
	case SOAP_TYPE_PointerTo_ns1__mkdir:
		return soap_out_PointerTo_ns1__mkdir(soap, tag, id, (struct _ns1__mkdir *const*)ptr, "ns1:mkdir");
	case SOAP_TYPE_PointerTo_ns1__getUserPropertyResponse:
		return soap_out_PointerTo_ns1__getUserPropertyResponse(soap, tag, id, (struct _ns1__getUserPropertyResponse *const*)ptr, "ns1:getUserPropertyResponse");
	case SOAP_TYPE_PointerTo_ns1__getUserProperty:
		return soap_out_PointerTo_ns1__getUserProperty(soap, tag, id, (struct _ns1__getUserProperty *const*)ptr, "ns1:getUserProperty");
	case SOAP_TYPE_PointerTo_ns1__getStagingFileSystemForSubmissionLocationResponse:
		return soap_out_PointerTo_ns1__getStagingFileSystemForSubmissionLocationResponse(soap, tag, id, (struct _ns1__getStagingFileSystemForSubmissionLocationResponse *const*)ptr, "ns1:getStagingFileSystemForSubmissionLocationResponse");
	case SOAP_TYPE_PointerTo_ns1__getStagingFileSystemForSubmissionLocation:
		return soap_out_PointerTo_ns1__getStagingFileSystemForSubmissionLocation(soap, tag, id, (struct _ns1__getStagingFileSystemForSubmissionLocation *const*)ptr, "ns1:getStagingFileSystemForSubmissionLocation");
	case SOAP_TYPE_PointerTo_ns1__psResponse:
		return soap_out_PointerTo_ns1__psResponse(soap, tag, id, (struct _ns1__psResponse *const*)ptr, "ns1:psResponse");
	case SOAP_TYPE_PointerTo_ns1__ps:
		return soap_out_PointerTo_ns1__ps(soap, tag, id, (struct _ns1__ps *const*)ptr, "ns1:ps");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication2Response:
		return soap_out_PointerTo_ns1__getSubmissionLocationsForApplication2Response(soap, tag, id, (struct _ns1__getSubmissionLocationsForApplication2Response *const*)ptr, "ns1:getSubmissionLocationsForApplication2Response");
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication2:
		return soap_out_PointerTo_ns1__getSubmissionLocationsForApplication2(soap, tag, id, (struct _ns1__getSubmissionLocationsForApplication2 *const*)ptr, "ns1:getSubmissionLocationsForApplication2");
	case SOAP_TYPE_PointerTo_ns1__downloadByteArrayResponse:
		return soap_out_PointerTo_ns1__downloadByteArrayResponse(soap, tag, id, (struct _ns1__downloadByteArrayResponse *const*)ptr, "ns1:downloadByteArrayResponse");
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray:
		return soap_out_PointerTo_ns1__downloadByteArray(soap, tag, id, (struct _ns1__downloadByteArray *const*)ptr, "ns1:downloadByteArray");
	case SOAP_TYPE_PointerTo_ns1__dfResponse:
		return soap_out_PointerTo_ns1__dfResponse(soap, tag, id, (struct _ns1__dfResponse *const*)ptr, "ns1:dfResponse");
	case SOAP_TYPE_PointerTo_ns1__df:
		return soap_out_PointerTo_ns1__df(soap, tag, id, (struct _ns1__df *const*)ptr, "ns1:df");
	case SOAP_TYPE_PointerTo_ns1__getFqansResponse:
		return soap_out_PointerTo_ns1__getFqansResponse(soap, tag, id, (struct _ns1__getFqansResponse *const*)ptr, "ns1:getFqansResponse");
	case SOAP_TYPE_PointerTo_ns1__getFqans:
		return soap_out_PointerTo_ns1__getFqans(soap, tag, id, (struct _ns1__getFqans *const*)ptr, "ns1:getFqans");
	case SOAP_TYPE_PointerTo_ns1__getTemplateResponse:
		return soap_out_PointerTo_ns1__getTemplateResponse(soap, tag, id, (struct _ns1__getTemplateResponse *const*)ptr, "ns1:getTemplateResponse");
	case SOAP_TYPE_PointerTo_ns1__getTemplate:
		return soap_out_PointerTo_ns1__getTemplate(soap, tag, id, (struct _ns1__getTemplate *const*)ptr, "ns1:getTemplate");
	case SOAP_TYPE_PointerTo_ns1__loginResponse:
		return soap_out_PointerTo_ns1__loginResponse(soap, tag, id, (struct _ns1__loginResponse *const*)ptr, "ns1:loginResponse");
	case SOAP_TYPE_PointerTo_ns1__login:
		return soap_out_PointerTo_ns1__login(soap, tag, id, (struct _ns1__login *const*)ptr, "ns1:login");
	case SOAP_TYPE_PointerTo_ns1__mountResponse:
		return soap_out_PointerTo_ns1__mountResponse(soap, tag, id, (struct _ns1__mountResponse *const*)ptr, "ns1:mountResponse");
	case SOAP_TYPE_PointerTo_ns1__mount:
		return soap_out_PointerTo_ns1__mount(soap, tag, id, (struct _ns1__mount *const*)ptr, "ns1:mount");
	case SOAP_TYPE_PointerTo_ns1__getJobFqanResponse:
		return soap_out_PointerTo_ns1__getJobFqanResponse(soap, tag, id, (struct _ns1__getJobFqanResponse *const*)ptr, "ns1:getJobFqanResponse");
	case SOAP_TYPE_PointerTo_ns1__getJobFqan:
		return soap_out_PointerTo_ns1__getJobFqan(soap, tag, id, (struct _ns1__getJobFqan *const*)ptr, "ns1:getJobFqan");
	case SOAP_TYPE_PointerTo_ns1__getChildrenFilesResponse:
		return soap_out_PointerTo_ns1__getChildrenFilesResponse(soap, tag, id, (struct _ns1__getChildrenFilesResponse *const*)ptr, "ns1:getChildrenFilesResponse");
	case SOAP_TYPE_PointerTo_ns1__getChildrenFiles:
		return soap_out_PointerTo_ns1__getChildrenFiles(soap, tag, id, (struct _ns1__getChildrenFiles *const*)ptr, "ns1:getChildrenFiles");
	case SOAP_TYPE_PointerTons2__VomsException:
		return soap_out_PointerTons2__VomsException(soap, tag, id, (struct ns2__VomsException *const*)ptr, "ns2:VomsException");
	case SOAP_TYPE_PointerTons2__RemoteFileSystemException:
		return soap_out_PointerTons2__RemoteFileSystemException(soap, tag, id, (struct ns2__RemoteFileSystemException *const*)ptr, "ns2:RemoteFileSystemException");
	case SOAP_TYPE_PointerTons2__NoValidCredentialException:
		return soap_out_PointerTons2__NoValidCredentialException(soap, tag, id, (struct ns2__NoValidCredentialException *const*)ptr, "ns2:NoValidCredentialException");
	case SOAP_TYPE_PointerTons2__NoSuchTemplateException:
		return soap_out_PointerTons2__NoSuchTemplateException(soap, tag, id, (struct ns2__NoSuchTemplateException *const*)ptr, "ns2:NoSuchTemplateException");
	case SOAP_TYPE_PointerTons2__NoSuchJobException:
		return soap_out_PointerTons2__NoSuchJobException(soap, tag, id, (struct ns2__NoSuchJobException *const*)ptr, "ns2:NoSuchJobException");
	case SOAP_TYPE_PointerTons2__JobSubmissionException:
		return soap_out_PointerTons2__JobSubmissionException(soap, tag, id, (struct ns2__JobSubmissionException *const*)ptr, "ns2:JobSubmissionException");
	case SOAP_TYPE_PointerTons2__JobDescriptionNotValidException:
		return soap_out_PointerTons2__JobDescriptionNotValidException(soap, tag, id, (struct ns2__JobDescriptionNotValidException *const*)ptr, "ns2:JobDescriptionNotValidException");
	case SOAP_TYPE_PointerTons4__JobCreationException:
		return soap_out_PointerTons4__JobCreationException(soap, tag, id, (struct ns4__JobCreationException *const*)ptr, "ns4:JobCreationException");
	case SOAP_TYPE_PointerToLONG64:
		return soap_out_PointerToLONG64(soap, tag, id, (LONG64 *const*)ptr, "xsd:long");
	case SOAP_TYPE_PointerToxsd__boolean:
		return soap_out_PointerToxsd__boolean(soap, tag, id, (enum xsd__boolean *const*)ptr, "xsd:boolean");
	case SOAP_TYPE_PointerTons1__anyType2anyTypeMap:
		return soap_out_PointerTons1__anyType2anyTypeMap(soap, tag, id, (struct ns1__anyType2anyTypeMap *const*)ptr, "ns1:anyType2anyTypeMap");
	case SOAP_TYPE_PointerToxsd__base64Binary:
		return soap_out_PointerToxsd__base64Binary(soap, tag, id, (struct xsd__base64Binary *const*)ptr, "xsd:base64Binary");
	case SOAP_TYPE_PointerTons3__ArrayOfMountPoint:
		return soap_out_PointerTons3__ArrayOfMountPoint(soap, tag, id, (struct ns3__ArrayOfMountPoint *const*)ptr, "ns3:ArrayOfMountPoint");
	case SOAP_TYPE_PointerTons3__MountPoint:
		return soap_out_PointerTons3__MountPoint(soap, tag, id, (struct ns3__MountPoint *const*)ptr, "ns3:MountPoint");
	case SOAP_TYPE_PointerTons1__ArrayOfString:
		return soap_out_PointerTons1__ArrayOfString(soap, tag, id, (struct ns1__ArrayOfString *const*)ptr, "ns1:ArrayOfString");
	case SOAP_TYPE_PointerTo_ns1__anyType2anyTypeMap_entry:
		return soap_out_PointerTo_ns1__anyType2anyTypeMap_entry(soap, tag, id, (struct _ns1__anyType2anyTypeMap_entry *const*)ptr, "ns1:anyType2anyTypeMap-entry");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTounsignedByte:
		return soap_out_PointerTounsignedByte(soap, tag, id, (unsigned char *const*)ptr, "xsd:unsignedByte");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, "xsd:QName", id, (char*const*)&ptr, NULL);
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE___ns1__getAllHosts:
		soap_serialize___ns1__getAllHosts(soap, (const struct __ns1__getAllHosts *)ptr);
		break;
	case SOAP_TYPE___ns1__submitSupportRequest:
		soap_serialize___ns1__submitSupportRequest(soap, (const struct __ns1__submitSupportRequest *)ptr);
		break;
	case SOAP_TYPE___ns1__getJobProperty:
		soap_serialize___ns1__getJobProperty(soap, (const struct __ns1__getJobProperty *)ptr);
		break;
	case SOAP_TYPE___ns1__mount1:
		soap_serialize___ns1__mount1(soap, (const struct __ns1__mount1 *)ptr);
		break;
	case SOAP_TYPE___ns1__getJobDetails:
		soap_serialize___ns1__getJobDetails(soap, (const struct __ns1__getJobDetails *)ptr);
		break;
	case SOAP_TYPE___ns1__umount:
		soap_serialize___ns1__umount(soap, (const struct __ns1__umount *)ptr);
		break;
	case SOAP_TYPE___ns1__getJobStatus:
		soap_serialize___ns1__getJobStatus(soap, (const struct __ns1__getJobStatus *)ptr);
		break;
	case SOAP_TYPE___ns1__getJobDetails_USCOREstring:
		soap_serialize___ns1__getJobDetails_USCOREstring(soap, (const struct __ns1__getJobDetails_USCOREstring *)ptr);
		break;
	case SOAP_TYPE___ns1__getAllSites:
		soap_serialize___ns1__getAllSites(soap, (const struct __ns1__getAllSites *)ptr);
		break;
	case SOAP_TYPE___ns1__setJobDescription:
		soap_serialize___ns1__setJobDescription(soap, (const struct __ns1__setJobDescription *)ptr);
		break;
	case SOAP_TYPE___ns1__getJobDirectory:
		soap_serialize___ns1__getJobDirectory(soap, (const struct __ns1__getJobDirectory *)ptr);
		break;
	case SOAP_TYPE___ns1__upload:
		soap_serialize___ns1__upload(soap, (const struct __ns1__upload *)ptr);
		break;
	case SOAP_TYPE___ns1__deleteFile:
		soap_serialize___ns1__deleteFile(soap, (const struct __ns1__deleteFile *)ptr);
		break;
	case SOAP_TYPE___ns1__getFileSize:
		soap_serialize___ns1__getFileSize(soap, (const struct __ns1__getFileSize *)ptr);
		break;
	case SOAP_TYPE___ns1__cp:
		soap_serialize___ns1__cp(soap, (const struct __ns1__cp *)ptr);
		break;
	case SOAP_TYPE___ns1__uploadByteArray:
		soap_serialize___ns1__uploadByteArray(soap, (const struct __ns1__uploadByteArray *)ptr);
		break;
	case SOAP_TYPE___ns1__submitJob:
		soap_serialize___ns1__submitJob(soap, (const struct __ns1__submitJob *)ptr);
		break;
	case SOAP_TYPE___ns1__logout:
		soap_serialize___ns1__logout(soap, (const struct __ns1__logout *)ptr);
		break;
	case SOAP_TYPE___ns1__setJobDescription_USCOREstring:
		soap_serialize___ns1__setJobDescription_USCOREstring(soap, (const struct __ns1__setJobDescription_USCOREstring *)ptr);
		break;
	case SOAP_TYPE___ns1__calculateRelativeJobDirectory:
		soap_serialize___ns1__calculateRelativeJobDirectory(soap, (const struct __ns1__calculateRelativeJobDirectory *)ptr);
		break;
	case SOAP_TYPE___ns1__getApplicationDetails1:
		soap_serialize___ns1__getApplicationDetails1(soap, (const struct __ns1__getApplicationDetails1 *)ptr);
		break;
	case SOAP_TYPE___ns1__ls:
		soap_serialize___ns1__ls(soap, (const struct __ns1__ls *)ptr);
		break;
	case SOAP_TYPE___ns1__lastModified:
		soap_serialize___ns1__lastModified(soap, (const struct __ns1__lastModified *)ptr);
		break;
	case SOAP_TYPE___ns1__getSite:
		soap_serialize___ns1__getSite(soap, (const struct __ns1__getSite *)ptr);
		break;
	case SOAP_TYPE___ns1__ps_USCOREstring:
		soap_serialize___ns1__ps_USCOREstring(soap, (const struct __ns1__ps_USCOREstring *)ptr);
		break;
	case SOAP_TYPE___ns1__uploadByteArray1:
		soap_serialize___ns1__uploadByteArray1(soap, (const struct __ns1__uploadByteArray1 *)ptr);
		break;
	case SOAP_TYPE___ns1__getVersionsOfApplicationOnSite:
		soap_serialize___ns1__getVersionsOfApplicationOnSite(soap, (const struct __ns1__getVersionsOfApplicationOnSite *)ptr);
		break;
	case SOAP_TYPE___ns1__getAllSubmissionLocations1:
		soap_serialize___ns1__getAllSubmissionLocations1(soap, (const struct __ns1__getAllSubmissionLocations1 *)ptr);
		break;
	case SOAP_TYPE___ns1__createJob:
		soap_serialize___ns1__createJob(soap, (const struct __ns1__createJob *)ptr);
		break;
	case SOAP_TYPE___ns1__getInterfaceVersion:
		soap_serialize___ns1__getInterfaceVersion(soap, (const struct __ns1__getInterfaceVersion *)ptr);
		break;
	case SOAP_TYPE___ns1__getAllSubmissionLocations:
		soap_serialize___ns1__getAllSubmissionLocations(soap, (const struct __ns1__getAllSubmissionLocations *)ptr);
		break;
	case SOAP_TYPE___ns1__addJobProperty:
		soap_serialize___ns1__addJobProperty(soap, (const struct __ns1__addJobProperty *)ptr);
		break;
	case SOAP_TYPE___ns1__addJobProperties:
		soap_serialize___ns1__addJobProperties(soap, (const struct __ns1__addJobProperties *)ptr);
		break;
	case SOAP_TYPE___ns1__getAllAvailableApplications:
		soap_serialize___ns1__getAllAvailableApplications(soap, (const struct __ns1__getAllAvailableApplications *)ptr);
		break;
	case SOAP_TYPE___ns1__kill:
		soap_serialize___ns1__kill(soap, (const struct __ns1__kill *)ptr);
		break;
	case SOAP_TYPE___ns1__isFolder:
		soap_serialize___ns1__isFolder(soap, (const struct __ns1__isFolder *)ptr);
		break;
	case SOAP_TYPE___ns1__download:
		soap_serialize___ns1__download(soap, (const struct __ns1__download *)ptr);
		break;
	case SOAP_TYPE___ns1__getAllJobProperties:
		soap_serialize___ns1__getAllJobProperties(soap, (const struct __ns1__getAllJobProperties *)ptr);
		break;
	case SOAP_TYPE___ns1__getAllJobnames:
		soap_serialize___ns1__getAllJobnames(soap, (const struct __ns1__getAllJobnames *)ptr);
		break;
	case SOAP_TYPE___ns1__getDN:
		soap_serialize___ns1__getDN(soap, (const struct __ns1__getDN *)ptr);
		break;
	case SOAP_TYPE___ns1__getSubmissionLocationsForApplication:
		soap_serialize___ns1__getSubmissionLocationsForApplication(soap, (const struct __ns1__getSubmissionLocationsForApplication *)ptr);
		break;
	case SOAP_TYPE___ns1__createJob1:
		soap_serialize___ns1__createJob1(soap, (const struct __ns1__createJob1 *)ptr);
		break;
	case SOAP_TYPE___ns1__getApplicationDetails:
		soap_serialize___ns1__getApplicationDetails(soap, (const struct __ns1__getApplicationDetails *)ptr);
		break;
	case SOAP_TYPE___ns1__getSubmissionLocationsForApplication1:
		soap_serialize___ns1__getSubmissionLocationsForApplication1(soap, (const struct __ns1__getSubmissionLocationsForApplication1 *)ptr);
		break;
	case SOAP_TYPE___ns1__ls_USCOREstring:
		soap_serialize___ns1__ls_USCOREstring(soap, (const struct __ns1__ls_USCOREstring *)ptr);
		break;
	case SOAP_TYPE___ns1__calculateAbsoluteJobDirectory:
		soap_serialize___ns1__calculateAbsoluteJobDirectory(soap, (const struct __ns1__calculateAbsoluteJobDirectory *)ptr);
		break;
	case SOAP_TYPE___ns1__getMessagesSince:
		soap_serialize___ns1__getMessagesSince(soap, (const struct __ns1__getMessagesSince *)ptr);
		break;
	case SOAP_TYPE___ns1__deleteFiles:
		soap_serialize___ns1__deleteFiles(soap, (const struct __ns1__deleteFiles *)ptr);
		break;
	case SOAP_TYPE___ns1__listHostedApplicationTemplates:
		soap_serialize___ns1__listHostedApplicationTemplates(soap, (const struct __ns1__listHostedApplicationTemplates *)ptr);
		break;
	case SOAP_TYPE___ns1__downloadByteArray1:
		soap_serialize___ns1__downloadByteArray1(soap, (const struct __ns1__downloadByteArray1 *)ptr);
		break;
	case SOAP_TYPE___ns1__getTemplate1:
		soap_serialize___ns1__getTemplate1(soap, (const struct __ns1__getTemplate1 *)ptr);
		break;
	case SOAP_TYPE___ns1__getSubmissionLocationsPerVersionOfApplication:
		soap_serialize___ns1__getSubmissionLocationsPerVersionOfApplication(soap, (const struct __ns1__getSubmissionLocationsPerVersionOfApplication *)ptr);
		break;
	case SOAP_TYPE___ns1__getDataLocationsForVO:
		soap_serialize___ns1__getDataLocationsForVO(soap, (const struct __ns1__getDataLocationsForVO *)ptr);
		break;
	case SOAP_TYPE___ns1__mkdir:
		soap_serialize___ns1__mkdir(soap, (const struct __ns1__mkdir *)ptr);
		break;
	case SOAP_TYPE___ns1__getUserProperty:
		soap_serialize___ns1__getUserProperty(soap, (const struct __ns1__getUserProperty *)ptr);
		break;
	case SOAP_TYPE___ns1__getStagingFileSystemForSubmissionLocation:
		soap_serialize___ns1__getStagingFileSystemForSubmissionLocation(soap, (const struct __ns1__getStagingFileSystemForSubmissionLocation *)ptr);
		break;
	case SOAP_TYPE___ns1__ps:
		soap_serialize___ns1__ps(soap, (const struct __ns1__ps *)ptr);
		break;
	case SOAP_TYPE___ns1__getSubmissionLocationsForApplication2:
		soap_serialize___ns1__getSubmissionLocationsForApplication2(soap, (const struct __ns1__getSubmissionLocationsForApplication2 *)ptr);
		break;
	case SOAP_TYPE___ns1__downloadByteArray:
		soap_serialize___ns1__downloadByteArray(soap, (const struct __ns1__downloadByteArray *)ptr);
		break;
	case SOAP_TYPE___ns1__df:
		soap_serialize___ns1__df(soap, (const struct __ns1__df *)ptr);
		break;
	case SOAP_TYPE___ns1__getFqans:
		soap_serialize___ns1__getFqans(soap, (const struct __ns1__getFqans *)ptr);
		break;
	case SOAP_TYPE___ns1__getTemplate:
		soap_serialize___ns1__getTemplate(soap, (const struct __ns1__getTemplate *)ptr);
		break;
	case SOAP_TYPE___ns1__login:
		soap_serialize___ns1__login(soap, (const struct __ns1__login *)ptr);
		break;
	case SOAP_TYPE___ns1__mount:
		soap_serialize___ns1__mount(soap, (const struct __ns1__mount *)ptr);
		break;
	case SOAP_TYPE___ns1__getJobFqan:
		soap_serialize___ns1__getJobFqan(soap, (const struct __ns1__getJobFqan *)ptr);
		break;
	case SOAP_TYPE___ns1__getChildrenFiles:
		soap_serialize___ns1__getChildrenFiles(soap, (const struct __ns1__getChildrenFiles *)ptr);
		break;
	case SOAP_TYPE_ns4__JobCreationException:
		soap_serialize_ns4__JobCreationException(soap, (const struct ns4__JobCreationException *)ptr);
		break;
	case SOAP_TYPE_ns2__JobSubmissionException:
		soap_serialize_ns2__JobSubmissionException(soap, (const struct ns2__JobSubmissionException *)ptr);
		break;
	case SOAP_TYPE_ns2__JobDescriptionNotValidException:
		soap_serialize_ns2__JobDescriptionNotValidException(soap, (const struct ns2__JobDescriptionNotValidException *)ptr);
		break;
	case SOAP_TYPE_ns2__NoSuchTemplateException:
		soap_serialize_ns2__NoSuchTemplateException(soap, (const struct ns2__NoSuchTemplateException *)ptr);
		break;
	case SOAP_TYPE_ns2__NoValidCredentialException:
		soap_serialize_ns2__NoValidCredentialException(soap, (const struct ns2__NoValidCredentialException *)ptr);
		break;
	case SOAP_TYPE_ns2__NoSuchJobException:
		soap_serialize_ns2__NoSuchJobException(soap, (const struct ns2__NoSuchJobException *)ptr);
		break;
	case SOAP_TYPE_ns2__RemoteFileSystemException:
		soap_serialize_ns2__RemoteFileSystemException(soap, (const struct ns2__RemoteFileSystemException *)ptr);
		break;
	case SOAP_TYPE_ns2__VomsException:
		soap_serialize_ns2__VomsException(soap, (const struct ns2__VomsException *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllHostsResponse:
		soap_serialize__ns1__getAllHostsResponse(soap, (const struct _ns1__getAllHostsResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllHosts:
		soap_serialize__ns1__getAllHosts(soap, (const struct _ns1__getAllHosts *)ptr);
		break;
	case SOAP_TYPE__ns1__submitSupportRequestResponse:
		soap_serialize__ns1__submitSupportRequestResponse(soap, (const struct _ns1__submitSupportRequestResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__submitSupportRequest:
		soap_serialize__ns1__submitSupportRequest(soap, (const struct _ns1__submitSupportRequest *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobPropertyResponse:
		soap_serialize__ns1__getJobPropertyResponse(soap, (const struct _ns1__getJobPropertyResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobProperty:
		soap_serialize__ns1__getJobProperty(soap, (const struct _ns1__getJobProperty *)ptr);
		break;
	case SOAP_TYPE__ns1__mount1Response:
		soap_serialize__ns1__mount1Response(soap, (const struct _ns1__mount1Response *)ptr);
		break;
	case SOAP_TYPE__ns1__mount1:
		soap_serialize__ns1__mount1(soap, (const struct _ns1__mount1 *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobDetailsResponse:
		soap_serialize__ns1__getJobDetailsResponse(soap, (const struct _ns1__getJobDetailsResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobDetails:
		soap_serialize__ns1__getJobDetails(soap, (const struct _ns1__getJobDetails *)ptr);
		break;
	case SOAP_TYPE__ns1__umountResponse:
		soap_serialize__ns1__umountResponse(soap, (const struct _ns1__umountResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__umount:
		soap_serialize__ns1__umount(soap, (const struct _ns1__umount *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobStatusResponse:
		soap_serialize__ns1__getJobStatusResponse(soap, (const struct _ns1__getJobStatusResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobStatus:
		soap_serialize__ns1__getJobStatus(soap, (const struct _ns1__getJobStatus *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse:
		soap_serialize__ns1__getJobDetails_USCOREstringResponse(soap, (const struct _ns1__getJobDetails_USCOREstringResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobDetails_USCOREstring:
		soap_serialize__ns1__getJobDetails_USCOREstring(soap, (const struct _ns1__getJobDetails_USCOREstring *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllSitesResponse:
		soap_serialize__ns1__getAllSitesResponse(soap, (const struct _ns1__getAllSitesResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllSites:
		soap_serialize__ns1__getAllSites(soap, (const struct _ns1__getAllSites *)ptr);
		break;
	case SOAP_TYPE__ns1__setJobDescriptionResponse:
		soap_serialize__ns1__setJobDescriptionResponse(soap, (const struct _ns1__setJobDescriptionResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__setJobDescription:
		soap_serialize__ns1__setJobDescription(soap, (const struct _ns1__setJobDescription *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobDirectoryResponse:
		soap_serialize__ns1__getJobDirectoryResponse(soap, (const struct _ns1__getJobDirectoryResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobDirectory:
		soap_serialize__ns1__getJobDirectory(soap, (const struct _ns1__getJobDirectory *)ptr);
		break;
	case SOAP_TYPE__ns1__uploadResponse:
		soap_serialize__ns1__uploadResponse(soap, (const struct _ns1__uploadResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__upload:
		soap_serialize__ns1__upload(soap, (const struct _ns1__upload *)ptr);
		break;
	case SOAP_TYPE__ns1__deleteFileResponse:
		soap_serialize__ns1__deleteFileResponse(soap, (const struct _ns1__deleteFileResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__deleteFile:
		soap_serialize__ns1__deleteFile(soap, (const struct _ns1__deleteFile *)ptr);
		break;
	case SOAP_TYPE__ns1__getFileSizeResponse:
		soap_serialize__ns1__getFileSizeResponse(soap, (const struct _ns1__getFileSizeResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getFileSize:
		soap_serialize__ns1__getFileSize(soap, (const struct _ns1__getFileSize *)ptr);
		break;
	case SOAP_TYPE__ns1__cpResponse:
		soap_serialize__ns1__cpResponse(soap, (const struct _ns1__cpResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__cp:
		soap_serialize__ns1__cp(soap, (const struct _ns1__cp *)ptr);
		break;
	case SOAP_TYPE__ns1__uploadByteArrayResponse:
		soap_serialize__ns1__uploadByteArrayResponse(soap, (const struct _ns1__uploadByteArrayResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__uploadByteArray:
		soap_serialize__ns1__uploadByteArray(soap, (const struct _ns1__uploadByteArray *)ptr);
		break;
	case SOAP_TYPE__ns1__submitJobResponse:
		soap_serialize__ns1__submitJobResponse(soap, (const struct _ns1__submitJobResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__submitJob:
		soap_serialize__ns1__submitJob(soap, (const struct _ns1__submitJob *)ptr);
		break;
	case SOAP_TYPE__ns1__logoutResponse:
		soap_serialize__ns1__logoutResponse(soap, (const struct _ns1__logoutResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__logout:
		soap_serialize__ns1__logout(soap, (const struct _ns1__logout *)ptr);
		break;
	case SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse:
		soap_serialize__ns1__setJobDescription_USCOREstringResponse(soap, (const struct _ns1__setJobDescription_USCOREstringResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__setJobDescription_USCOREstring:
		soap_serialize__ns1__setJobDescription_USCOREstring(soap, (const struct _ns1__setJobDescription_USCOREstring *)ptr);
		break;
	case SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse:
		soap_serialize__ns1__calculateRelativeJobDirectoryResponse(soap, (const struct _ns1__calculateRelativeJobDirectoryResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__calculateRelativeJobDirectory:
		soap_serialize__ns1__calculateRelativeJobDirectory(soap, (const struct _ns1__calculateRelativeJobDirectory *)ptr);
		break;
	case SOAP_TYPE__ns1__getApplicationDetails1Response:
		soap_serialize__ns1__getApplicationDetails1Response(soap, (const struct _ns1__getApplicationDetails1Response *)ptr);
		break;
	case SOAP_TYPE__ns1__getApplicationDetails1:
		soap_serialize__ns1__getApplicationDetails1(soap, (const struct _ns1__getApplicationDetails1 *)ptr);
		break;
	case SOAP_TYPE__ns1__lsResponse:
		soap_serialize__ns1__lsResponse(soap, (const struct _ns1__lsResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__ls:
		soap_serialize__ns1__ls(soap, (const struct _ns1__ls *)ptr);
		break;
	case SOAP_TYPE__ns1__lastModifiedResponse:
		soap_serialize__ns1__lastModifiedResponse(soap, (const struct _ns1__lastModifiedResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__lastModified:
		soap_serialize__ns1__lastModified(soap, (const struct _ns1__lastModified *)ptr);
		break;
	case SOAP_TYPE__ns1__getSiteResponse:
		soap_serialize__ns1__getSiteResponse(soap, (const struct _ns1__getSiteResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getSite:
		soap_serialize__ns1__getSite(soap, (const struct _ns1__getSite *)ptr);
		break;
	case SOAP_TYPE__ns1__ps_USCOREstringResponse:
		soap_serialize__ns1__ps_USCOREstringResponse(soap, (const struct _ns1__ps_USCOREstringResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__ps_USCOREstring:
		soap_serialize__ns1__ps_USCOREstring(soap, (const struct _ns1__ps_USCOREstring *)ptr);
		break;
	case SOAP_TYPE__ns1__uploadByteArray1Response:
		soap_serialize__ns1__uploadByteArray1Response(soap, (const struct _ns1__uploadByteArray1Response *)ptr);
		break;
	case SOAP_TYPE__ns1__uploadByteArray1:
		soap_serialize__ns1__uploadByteArray1(soap, (const struct _ns1__uploadByteArray1 *)ptr);
		break;
	case SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse:
		soap_serialize__ns1__getVersionsOfApplicationOnSiteResponse(soap, (const struct _ns1__getVersionsOfApplicationOnSiteResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getVersionsOfApplicationOnSite:
		soap_serialize__ns1__getVersionsOfApplicationOnSite(soap, (const struct _ns1__getVersionsOfApplicationOnSite *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllSubmissionLocations1Response:
		soap_serialize__ns1__getAllSubmissionLocations1Response(soap, (const struct _ns1__getAllSubmissionLocations1Response *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllSubmissionLocations1:
		soap_serialize__ns1__getAllSubmissionLocations1(soap, (const struct _ns1__getAllSubmissionLocations1 *)ptr);
		break;
	case SOAP_TYPE__ns1__createJobResponse:
		soap_serialize__ns1__createJobResponse(soap, (const struct _ns1__createJobResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__createJob:
		soap_serialize__ns1__createJob(soap, (const struct _ns1__createJob *)ptr);
		break;
	case SOAP_TYPE__ns1__getInterfaceVersionResponse:
		soap_serialize__ns1__getInterfaceVersionResponse(soap, (const struct _ns1__getInterfaceVersionResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getInterfaceVersion:
		soap_serialize__ns1__getInterfaceVersion(soap, (const struct _ns1__getInterfaceVersion *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllSubmissionLocationsResponse:
		soap_serialize__ns1__getAllSubmissionLocationsResponse(soap, (const struct _ns1__getAllSubmissionLocationsResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllSubmissionLocations:
		soap_serialize__ns1__getAllSubmissionLocations(soap, (const struct _ns1__getAllSubmissionLocations *)ptr);
		break;
	case SOAP_TYPE__ns1__addJobPropertyResponse:
		soap_serialize__ns1__addJobPropertyResponse(soap, (const struct _ns1__addJobPropertyResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__addJobProperty:
		soap_serialize__ns1__addJobProperty(soap, (const struct _ns1__addJobProperty *)ptr);
		break;
	case SOAP_TYPE__ns1__addJobPropertiesResponse:
		soap_serialize__ns1__addJobPropertiesResponse(soap, (const struct _ns1__addJobPropertiesResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__addJobProperties:
		soap_serialize__ns1__addJobProperties(soap, (const struct _ns1__addJobProperties *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllAvailableApplicationsResponse:
		soap_serialize__ns1__getAllAvailableApplicationsResponse(soap, (const struct _ns1__getAllAvailableApplicationsResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllAvailableApplications:
		soap_serialize__ns1__getAllAvailableApplications(soap, (const struct _ns1__getAllAvailableApplications *)ptr);
		break;
	case SOAP_TYPE__ns1__killResponse:
		soap_serialize__ns1__killResponse(soap, (const struct _ns1__killResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__kill:
		soap_serialize__ns1__kill(soap, (const struct _ns1__kill *)ptr);
		break;
	case SOAP_TYPE__ns1__isFolderResponse:
		soap_serialize__ns1__isFolderResponse(soap, (const struct _ns1__isFolderResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__isFolder:
		soap_serialize__ns1__isFolder(soap, (const struct _ns1__isFolder *)ptr);
		break;
	case SOAP_TYPE__ns1__downloadResponse:
		soap_serialize__ns1__downloadResponse(soap, (const struct _ns1__downloadResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__download:
		soap_serialize__ns1__download(soap, (const struct _ns1__download *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllJobPropertiesResponse:
		soap_serialize__ns1__getAllJobPropertiesResponse(soap, (const struct _ns1__getAllJobPropertiesResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllJobProperties:
		soap_serialize__ns1__getAllJobProperties(soap, (const struct _ns1__getAllJobProperties *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllJobnamesResponse:
		soap_serialize__ns1__getAllJobnamesResponse(soap, (const struct _ns1__getAllJobnamesResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getAllJobnames:
		soap_serialize__ns1__getAllJobnames(soap, (const struct _ns1__getAllJobnames *)ptr);
		break;
	case SOAP_TYPE__ns1__getDNResponse:
		soap_serialize__ns1__getDNResponse(soap, (const struct _ns1__getDNResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getDN:
		soap_serialize__ns1__getDN(soap, (const struct _ns1__getDN *)ptr);
		break;
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse:
		soap_serialize__ns1__getSubmissionLocationsForApplicationResponse(soap, (const struct _ns1__getSubmissionLocationsForApplicationResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication:
		soap_serialize__ns1__getSubmissionLocationsForApplication(soap, (const struct _ns1__getSubmissionLocationsForApplication *)ptr);
		break;
	case SOAP_TYPE__ns1__createJob1Response:
		soap_serialize__ns1__createJob1Response(soap, (const struct _ns1__createJob1Response *)ptr);
		break;
	case SOAP_TYPE__ns1__createJob1:
		soap_serialize__ns1__createJob1(soap, (const struct _ns1__createJob1 *)ptr);
		break;
	case SOAP_TYPE__ns1__getApplicationDetailsResponse:
		soap_serialize__ns1__getApplicationDetailsResponse(soap, (const struct _ns1__getApplicationDetailsResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getApplicationDetails:
		soap_serialize__ns1__getApplicationDetails(soap, (const struct _ns1__getApplicationDetails *)ptr);
		break;
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication1Response:
		soap_serialize__ns1__getSubmissionLocationsForApplication1Response(soap, (const struct _ns1__getSubmissionLocationsForApplication1Response *)ptr);
		break;
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication1:
		soap_serialize__ns1__getSubmissionLocationsForApplication1(soap, (const struct _ns1__getSubmissionLocationsForApplication1 *)ptr);
		break;
	case SOAP_TYPE__ns1__ls_USCOREstringResponse:
		soap_serialize__ns1__ls_USCOREstringResponse(soap, (const struct _ns1__ls_USCOREstringResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__ls_USCOREstring:
		soap_serialize__ns1__ls_USCOREstring(soap, (const struct _ns1__ls_USCOREstring *)ptr);
		break;
	case SOAP_TYPE__ns1__calculateAbsoluteJobDirectoryResponse:
		soap_serialize__ns1__calculateAbsoluteJobDirectoryResponse(soap, (const struct _ns1__calculateAbsoluteJobDirectoryResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__calculateAbsoluteJobDirectory:
		soap_serialize__ns1__calculateAbsoluteJobDirectory(soap, (const struct _ns1__calculateAbsoluteJobDirectory *)ptr);
		break;
	case SOAP_TYPE__ns1__getMessagesSinceResponse:
		soap_serialize__ns1__getMessagesSinceResponse(soap, (const struct _ns1__getMessagesSinceResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getMessagesSince:
		soap_serialize__ns1__getMessagesSince(soap, (const struct _ns1__getMessagesSince *)ptr);
		break;
	case SOAP_TYPE__ns1__deleteFilesResponse:
		soap_serialize__ns1__deleteFilesResponse(soap, (const struct _ns1__deleteFilesResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__deleteFiles:
		soap_serialize__ns1__deleteFiles(soap, (const struct _ns1__deleteFiles *)ptr);
		break;
	case SOAP_TYPE__ns1__listHostedApplicationTemplatesResponse:
		soap_serialize__ns1__listHostedApplicationTemplatesResponse(soap, (const struct _ns1__listHostedApplicationTemplatesResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__listHostedApplicationTemplates:
		soap_serialize__ns1__listHostedApplicationTemplates(soap, (const struct _ns1__listHostedApplicationTemplates *)ptr);
		break;
	case SOAP_TYPE__ns1__downloadByteArray1Response:
		soap_serialize__ns1__downloadByteArray1Response(soap, (const struct _ns1__downloadByteArray1Response *)ptr);
		break;
	case SOAP_TYPE__ns1__downloadByteArray1:
		soap_serialize__ns1__downloadByteArray1(soap, (const struct _ns1__downloadByteArray1 *)ptr);
		break;
	case SOAP_TYPE__ns1__getTemplate1Response:
		soap_serialize__ns1__getTemplate1Response(soap, (const struct _ns1__getTemplate1Response *)ptr);
		break;
	case SOAP_TYPE__ns1__getTemplate1:
		soap_serialize__ns1__getTemplate1(soap, (const struct _ns1__getTemplate1 *)ptr);
		break;
	case SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplicationResponse:
		soap_serialize__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, (const struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplication:
		soap_serialize__ns1__getSubmissionLocationsPerVersionOfApplication(soap, (const struct _ns1__getSubmissionLocationsPerVersionOfApplication *)ptr);
		break;
	case SOAP_TYPE__ns1__getDataLocationsForVOResponse:
		soap_serialize__ns1__getDataLocationsForVOResponse(soap, (const struct _ns1__getDataLocationsForVOResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getDataLocationsForVO:
		soap_serialize__ns1__getDataLocationsForVO(soap, (const struct _ns1__getDataLocationsForVO *)ptr);
		break;
	case SOAP_TYPE__ns1__mkdirResponse:
		soap_serialize__ns1__mkdirResponse(soap, (const struct _ns1__mkdirResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__mkdir:
		soap_serialize__ns1__mkdir(soap, (const struct _ns1__mkdir *)ptr);
		break;
	case SOAP_TYPE__ns1__getUserPropertyResponse:
		soap_serialize__ns1__getUserPropertyResponse(soap, (const struct _ns1__getUserPropertyResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getUserProperty:
		soap_serialize__ns1__getUserProperty(soap, (const struct _ns1__getUserProperty *)ptr);
		break;
	case SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocationResponse:
		soap_serialize__ns1__getStagingFileSystemForSubmissionLocationResponse(soap, (const struct _ns1__getStagingFileSystemForSubmissionLocationResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocation:
		soap_serialize__ns1__getStagingFileSystemForSubmissionLocation(soap, (const struct _ns1__getStagingFileSystemForSubmissionLocation *)ptr);
		break;
	case SOAP_TYPE__ns1__psResponse:
		soap_serialize__ns1__psResponse(soap, (const struct _ns1__psResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__ps:
		soap_serialize__ns1__ps(soap, (const struct _ns1__ps *)ptr);
		break;
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication2Response:
		soap_serialize__ns1__getSubmissionLocationsForApplication2Response(soap, (const struct _ns1__getSubmissionLocationsForApplication2Response *)ptr);
		break;
	case SOAP_TYPE__ns1__getSubmissionLocationsForApplication2:
		soap_serialize__ns1__getSubmissionLocationsForApplication2(soap, (const struct _ns1__getSubmissionLocationsForApplication2 *)ptr);
		break;
	case SOAP_TYPE__ns1__downloadByteArrayResponse:
		soap_serialize__ns1__downloadByteArrayResponse(soap, (const struct _ns1__downloadByteArrayResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__downloadByteArray:
		soap_serialize__ns1__downloadByteArray(soap, (const struct _ns1__downloadByteArray *)ptr);
		break;
	case SOAP_TYPE_ns3__ArrayOfMountPoint:
		soap_serialize_ns3__ArrayOfMountPoint(soap, (const struct ns3__ArrayOfMountPoint *)ptr);
		break;
	case SOAP_TYPE__ns1__dfResponse:
		soap_serialize__ns1__dfResponse(soap, (const struct _ns1__dfResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__df:
		soap_serialize__ns1__df(soap, (const struct _ns1__df *)ptr);
		break;
	case SOAP_TYPE__ns1__getFqansResponse:
		soap_serialize__ns1__getFqansResponse(soap, (const struct _ns1__getFqansResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getFqans:
		soap_serialize__ns1__getFqans(soap, (const struct _ns1__getFqans *)ptr);
		break;
	case SOAP_TYPE__ns1__getTemplateResponse:
		soap_serialize__ns1__getTemplateResponse(soap, (const struct _ns1__getTemplateResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getTemplate:
		soap_serialize__ns1__getTemplate(soap, (const struct _ns1__getTemplate *)ptr);
		break;
	case SOAP_TYPE__ns1__loginResponse:
		soap_serialize__ns1__loginResponse(soap, (const struct _ns1__loginResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__login:
		soap_serialize__ns1__login(soap, (const struct _ns1__login *)ptr);
		break;
	case SOAP_TYPE_ns3__MountPoint:
		soap_serialize_ns3__MountPoint(soap, (const struct ns3__MountPoint *)ptr);
		break;
	case SOAP_TYPE__ns1__mountResponse:
		soap_serialize__ns1__mountResponse(soap, (const struct _ns1__mountResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__mount:
		soap_serialize__ns1__mount(soap, (const struct _ns1__mount *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobFqanResponse:
		soap_serialize__ns1__getJobFqanResponse(soap, (const struct _ns1__getJobFqanResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getJobFqan:
		soap_serialize__ns1__getJobFqan(soap, (const struct _ns1__getJobFqan *)ptr);
		break;
	case SOAP_TYPE__ns1__getChildrenFilesResponse:
		soap_serialize__ns1__getChildrenFilesResponse(soap, (const struct _ns1__getChildrenFilesResponse *)ptr);
		break;
	case SOAP_TYPE__ns1__getChildrenFiles:
		soap_serialize__ns1__getChildrenFiles(soap, (const struct _ns1__getChildrenFiles *)ptr);
		break;
	case SOAP_TYPE__ns1__anyType2anyTypeMap_entry:
		soap_serialize__ns1__anyType2anyTypeMap_entry(soap, (const struct _ns1__anyType2anyTypeMap_entry *)ptr);
		break;
	case SOAP_TYPE_ns1__anyType2anyTypeMap:
		soap_serialize_ns1__anyType2anyTypeMap(soap, (const struct ns1__anyType2anyTypeMap *)ptr);
		break;
	case SOAP_TYPE_ns1__ArrayOfString:
		soap_serialize_ns1__ArrayOfString(soap, (const struct ns1__ArrayOfString *)ptr);
		break;
	case SOAP_TYPE_xsd__base64Binary:
		soap_serialize_xsd__base64Binary(soap, (const struct xsd__base64Binary *)ptr);
		break;
	case SOAP_TYPE__xop__Include:
		soap_serialize__xop__Include(soap, (const struct _xop__Include *)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllHostsResponse:
		soap_serialize_PointerTo_ns1__getAllHostsResponse(soap, (struct _ns1__getAllHostsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllHosts:
		soap_serialize_PointerTo_ns1__getAllHosts(soap, (struct _ns1__getAllHosts *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__submitSupportRequestResponse:
		soap_serialize_PointerTo_ns1__submitSupportRequestResponse(soap, (struct _ns1__submitSupportRequestResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__submitSupportRequest:
		soap_serialize_PointerTo_ns1__submitSupportRequest(soap, (struct _ns1__submitSupportRequest *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobPropertyResponse:
		soap_serialize_PointerTo_ns1__getJobPropertyResponse(soap, (struct _ns1__getJobPropertyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobProperty:
		soap_serialize_PointerTo_ns1__getJobProperty(soap, (struct _ns1__getJobProperty *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__mount1Response:
		soap_serialize_PointerTo_ns1__mount1Response(soap, (struct _ns1__mount1Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__mount1:
		soap_serialize_PointerTo_ns1__mount1(soap, (struct _ns1__mount1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobDetailsResponse:
		soap_serialize_PointerTo_ns1__getJobDetailsResponse(soap, (struct _ns1__getJobDetailsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobDetails:
		soap_serialize_PointerTo_ns1__getJobDetails(soap, (struct _ns1__getJobDetails *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__umountResponse:
		soap_serialize_PointerTo_ns1__umountResponse(soap, (struct _ns1__umountResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__umount:
		soap_serialize_PointerTo_ns1__umount(soap, (struct _ns1__umount *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobStatusResponse:
		soap_serialize_PointerTo_ns1__getJobStatusResponse(soap, (struct _ns1__getJobStatusResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobStatus:
		soap_serialize_PointerTo_ns1__getJobStatus(soap, (struct _ns1__getJobStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobDetails_USCOREstringResponse:
		soap_serialize_PointerTo_ns1__getJobDetails_USCOREstringResponse(soap, (struct _ns1__getJobDetails_USCOREstringResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobDetails_USCOREstring:
		soap_serialize_PointerTo_ns1__getJobDetails_USCOREstring(soap, (struct _ns1__getJobDetails_USCOREstring *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllSitesResponse:
		soap_serialize_PointerTo_ns1__getAllSitesResponse(soap, (struct _ns1__getAllSitesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllSites:
		soap_serialize_PointerTo_ns1__getAllSites(soap, (struct _ns1__getAllSites *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__setJobDescriptionResponse:
		soap_serialize_PointerTo_ns1__setJobDescriptionResponse(soap, (struct _ns1__setJobDescriptionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__setJobDescription:
		soap_serialize_PointerTo_ns1__setJobDescription(soap, (struct _ns1__setJobDescription *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobDirectoryResponse:
		soap_serialize_PointerTo_ns1__getJobDirectoryResponse(soap, (struct _ns1__getJobDirectoryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobDirectory:
		soap_serialize_PointerTo_ns1__getJobDirectory(soap, (struct _ns1__getJobDirectory *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__uploadResponse:
		soap_serialize_PointerTo_ns1__uploadResponse(soap, (struct _ns1__uploadResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__upload:
		soap_serialize_PointerTo_ns1__upload(soap, (struct _ns1__upload *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__deleteFileResponse:
		soap_serialize_PointerTo_ns1__deleteFileResponse(soap, (struct _ns1__deleteFileResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__deleteFile:
		soap_serialize_PointerTo_ns1__deleteFile(soap, (struct _ns1__deleteFile *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getFileSizeResponse:
		soap_serialize_PointerTo_ns1__getFileSizeResponse(soap, (struct _ns1__getFileSizeResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getFileSize:
		soap_serialize_PointerTo_ns1__getFileSize(soap, (struct _ns1__getFileSize *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__cpResponse:
		soap_serialize_PointerTo_ns1__cpResponse(soap, (struct _ns1__cpResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__cp:
		soap_serialize_PointerTo_ns1__cp(soap, (struct _ns1__cp *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__uploadByteArrayResponse:
		soap_serialize_PointerTo_ns1__uploadByteArrayResponse(soap, (struct _ns1__uploadByteArrayResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray:
		soap_serialize_PointerTo_ns1__uploadByteArray(soap, (struct _ns1__uploadByteArray *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__submitJobResponse:
		soap_serialize_PointerTo_ns1__submitJobResponse(soap, (struct _ns1__submitJobResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__submitJob:
		soap_serialize_PointerTo_ns1__submitJob(soap, (struct _ns1__submitJob *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__logoutResponse:
		soap_serialize_PointerTo_ns1__logoutResponse(soap, (struct _ns1__logoutResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__logout:
		soap_serialize_PointerTo_ns1__logout(soap, (struct _ns1__logout *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__setJobDescription_USCOREstringResponse:
		soap_serialize_PointerTo_ns1__setJobDescription_USCOREstringResponse(soap, (struct _ns1__setJobDescription_USCOREstringResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__setJobDescription_USCOREstring:
		soap_serialize_PointerTo_ns1__setJobDescription_USCOREstring(soap, (struct _ns1__setJobDescription_USCOREstring *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__calculateRelativeJobDirectoryResponse:
		soap_serialize_PointerTo_ns1__calculateRelativeJobDirectoryResponse(soap, (struct _ns1__calculateRelativeJobDirectoryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__calculateRelativeJobDirectory:
		soap_serialize_PointerTo_ns1__calculateRelativeJobDirectory(soap, (struct _ns1__calculateRelativeJobDirectory *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails1Response:
		soap_serialize_PointerTo_ns1__getApplicationDetails1Response(soap, (struct _ns1__getApplicationDetails1Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails1:
		soap_serialize_PointerTo_ns1__getApplicationDetails1(soap, (struct _ns1__getApplicationDetails1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__lsResponse:
		soap_serialize_PointerTo_ns1__lsResponse(soap, (struct _ns1__lsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__ls:
		soap_serialize_PointerTo_ns1__ls(soap, (struct _ns1__ls *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__lastModifiedResponse:
		soap_serialize_PointerTo_ns1__lastModifiedResponse(soap, (struct _ns1__lastModifiedResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__lastModified:
		soap_serialize_PointerTo_ns1__lastModified(soap, (struct _ns1__lastModified *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSiteResponse:
		soap_serialize_PointerTo_ns1__getSiteResponse(soap, (struct _ns1__getSiteResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSite:
		soap_serialize_PointerTo_ns1__getSite(soap, (struct _ns1__getSite *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__ps_USCOREstringResponse:
		soap_serialize_PointerTo_ns1__ps_USCOREstringResponse(soap, (struct _ns1__ps_USCOREstringResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__ps_USCOREstring:
		soap_serialize_PointerTo_ns1__ps_USCOREstring(soap, (struct _ns1__ps_USCOREstring *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray1Response:
		soap_serialize_PointerTo_ns1__uploadByteArray1Response(soap, (struct _ns1__uploadByteArray1Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__uploadByteArray1:
		soap_serialize_PointerTo_ns1__uploadByteArray1(soap, (struct _ns1__uploadByteArray1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse:
		soap_serialize_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(soap, (struct _ns1__getVersionsOfApplicationOnSiteResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getVersionsOfApplicationOnSite:
		soap_serialize_PointerTo_ns1__getVersionsOfApplicationOnSite(soap, (struct _ns1__getVersionsOfApplicationOnSite *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations1Response:
		soap_serialize_PointerTo_ns1__getAllSubmissionLocations1Response(soap, (struct _ns1__getAllSubmissionLocations1Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations1:
		soap_serialize_PointerTo_ns1__getAllSubmissionLocations1(soap, (struct _ns1__getAllSubmissionLocations1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__createJobResponse:
		soap_serialize_PointerTo_ns1__createJobResponse(soap, (struct _ns1__createJobResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__createJob:
		soap_serialize_PointerTo_ns1__createJob(soap, (struct _ns1__createJob *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getInterfaceVersionResponse:
		soap_serialize_PointerTo_ns1__getInterfaceVersionResponse(soap, (struct _ns1__getInterfaceVersionResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getInterfaceVersion:
		soap_serialize_PointerTo_ns1__getInterfaceVersion(soap, (struct _ns1__getInterfaceVersion *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocationsResponse:
		soap_serialize_PointerTo_ns1__getAllSubmissionLocationsResponse(soap, (struct _ns1__getAllSubmissionLocationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations:
		soap_serialize_PointerTo_ns1__getAllSubmissionLocations(soap, (struct _ns1__getAllSubmissionLocations *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__addJobPropertyResponse:
		soap_serialize_PointerTo_ns1__addJobPropertyResponse(soap, (struct _ns1__addJobPropertyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__addJobProperty:
		soap_serialize_PointerTo_ns1__addJobProperty(soap, (struct _ns1__addJobProperty *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__addJobPropertiesResponse:
		soap_serialize_PointerTo_ns1__addJobPropertiesResponse(soap, (struct _ns1__addJobPropertiesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__addJobProperties:
		soap_serialize_PointerTo_ns1__addJobProperties(soap, (struct _ns1__addJobProperties *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllAvailableApplicationsResponse:
		soap_serialize_PointerTo_ns1__getAllAvailableApplicationsResponse(soap, (struct _ns1__getAllAvailableApplicationsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllAvailableApplications:
		soap_serialize_PointerTo_ns1__getAllAvailableApplications(soap, (struct _ns1__getAllAvailableApplications *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__killResponse:
		soap_serialize_PointerTo_ns1__killResponse(soap, (struct _ns1__killResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__kill:
		soap_serialize_PointerTo_ns1__kill(soap, (struct _ns1__kill *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__isFolderResponse:
		soap_serialize_PointerTo_ns1__isFolderResponse(soap, (struct _ns1__isFolderResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__isFolder:
		soap_serialize_PointerTo_ns1__isFolder(soap, (struct _ns1__isFolder *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__downloadResponse:
		soap_serialize_PointerTo_ns1__downloadResponse(soap, (struct _ns1__downloadResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__download:
		soap_serialize_PointerTo_ns1__download(soap, (struct _ns1__download *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllJobPropertiesResponse:
		soap_serialize_PointerTo_ns1__getAllJobPropertiesResponse(soap, (struct _ns1__getAllJobPropertiesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllJobProperties:
		soap_serialize_PointerTo_ns1__getAllJobProperties(soap, (struct _ns1__getAllJobProperties *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllJobnamesResponse:
		soap_serialize_PointerTo_ns1__getAllJobnamesResponse(soap, (struct _ns1__getAllJobnamesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getAllJobnames:
		soap_serialize_PointerTo_ns1__getAllJobnames(soap, (struct _ns1__getAllJobnames *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getDNResponse:
		soap_serialize_PointerTo_ns1__getDNResponse(soap, (struct _ns1__getDNResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getDN:
		soap_serialize_PointerTo_ns1__getDN(soap, (struct _ns1__getDN *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplicationResponse:
		soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(soap, (struct _ns1__getSubmissionLocationsForApplicationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication:
		soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication(soap, (struct _ns1__getSubmissionLocationsForApplication *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__createJob1Response:
		soap_serialize_PointerTo_ns1__createJob1Response(soap, (struct _ns1__createJob1Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__createJob1:
		soap_serialize_PointerTo_ns1__createJob1(soap, (struct _ns1__createJob1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetailsResponse:
		soap_serialize_PointerTo_ns1__getApplicationDetailsResponse(soap, (struct _ns1__getApplicationDetailsResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getApplicationDetails:
		soap_serialize_PointerTo_ns1__getApplicationDetails(soap, (struct _ns1__getApplicationDetails *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication1Response:
		soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication1Response(soap, (struct _ns1__getSubmissionLocationsForApplication1Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication1:
		soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication1(soap, (struct _ns1__getSubmissionLocationsForApplication1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__ls_USCOREstringResponse:
		soap_serialize_PointerTo_ns1__ls_USCOREstringResponse(soap, (struct _ns1__ls_USCOREstringResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__ls_USCOREstring:
		soap_serialize_PointerTo_ns1__ls_USCOREstring(soap, (struct _ns1__ls_USCOREstring *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__calculateAbsoluteJobDirectoryResponse:
		soap_serialize_PointerTo_ns1__calculateAbsoluteJobDirectoryResponse(soap, (struct _ns1__calculateAbsoluteJobDirectoryResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__calculateAbsoluteJobDirectory:
		soap_serialize_PointerTo_ns1__calculateAbsoluteJobDirectory(soap, (struct _ns1__calculateAbsoluteJobDirectory *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getMessagesSinceResponse:
		soap_serialize_PointerTo_ns1__getMessagesSinceResponse(soap, (struct _ns1__getMessagesSinceResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getMessagesSince:
		soap_serialize_PointerTo_ns1__getMessagesSince(soap, (struct _ns1__getMessagesSince *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__deleteFilesResponse:
		soap_serialize_PointerTo_ns1__deleteFilesResponse(soap, (struct _ns1__deleteFilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__deleteFiles:
		soap_serialize_PointerTo_ns1__deleteFiles(soap, (struct _ns1__deleteFiles *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__listHostedApplicationTemplatesResponse:
		soap_serialize_PointerTo_ns1__listHostedApplicationTemplatesResponse(soap, (struct _ns1__listHostedApplicationTemplatesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__listHostedApplicationTemplates:
		soap_serialize_PointerTo_ns1__listHostedApplicationTemplates(soap, (struct _ns1__listHostedApplicationTemplates *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray1Response:
		soap_serialize_PointerTo_ns1__downloadByteArray1Response(soap, (struct _ns1__downloadByteArray1Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray1:
		soap_serialize_PointerTo_ns1__downloadByteArray1(soap, (struct _ns1__downloadByteArray1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getTemplate1Response:
		soap_serialize_PointerTo_ns1__getTemplate1Response(soap, (struct _ns1__getTemplate1Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getTemplate1:
		soap_serialize_PointerTo_ns1__getTemplate1(soap, (struct _ns1__getTemplate1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplicationResponse:
		soap_serialize_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, (struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication:
		soap_serialize_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication(soap, (struct _ns1__getSubmissionLocationsPerVersionOfApplication *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getDataLocationsForVOResponse:
		soap_serialize_PointerTo_ns1__getDataLocationsForVOResponse(soap, (struct _ns1__getDataLocationsForVOResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getDataLocationsForVO:
		soap_serialize_PointerTo_ns1__getDataLocationsForVO(soap, (struct _ns1__getDataLocationsForVO *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__mkdirResponse:
		soap_serialize_PointerTo_ns1__mkdirResponse(soap, (struct _ns1__mkdirResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__mkdir:
		soap_serialize_PointerTo_ns1__mkdir(soap, (struct _ns1__mkdir *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getUserPropertyResponse:
		soap_serialize_PointerTo_ns1__getUserPropertyResponse(soap, (struct _ns1__getUserPropertyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getUserProperty:
		soap_serialize_PointerTo_ns1__getUserProperty(soap, (struct _ns1__getUserProperty *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getStagingFileSystemForSubmissionLocationResponse:
		soap_serialize_PointerTo_ns1__getStagingFileSystemForSubmissionLocationResponse(soap, (struct _ns1__getStagingFileSystemForSubmissionLocationResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getStagingFileSystemForSubmissionLocation:
		soap_serialize_PointerTo_ns1__getStagingFileSystemForSubmissionLocation(soap, (struct _ns1__getStagingFileSystemForSubmissionLocation *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__psResponse:
		soap_serialize_PointerTo_ns1__psResponse(soap, (struct _ns1__psResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__ps:
		soap_serialize_PointerTo_ns1__ps(soap, (struct _ns1__ps *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication2Response:
		soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication2Response(soap, (struct _ns1__getSubmissionLocationsForApplication2Response *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication2:
		soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication2(soap, (struct _ns1__getSubmissionLocationsForApplication2 *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__downloadByteArrayResponse:
		soap_serialize_PointerTo_ns1__downloadByteArrayResponse(soap, (struct _ns1__downloadByteArrayResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__downloadByteArray:
		soap_serialize_PointerTo_ns1__downloadByteArray(soap, (struct _ns1__downloadByteArray *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__dfResponse:
		soap_serialize_PointerTo_ns1__dfResponse(soap, (struct _ns1__dfResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__df:
		soap_serialize_PointerTo_ns1__df(soap, (struct _ns1__df *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getFqansResponse:
		soap_serialize_PointerTo_ns1__getFqansResponse(soap, (struct _ns1__getFqansResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getFqans:
		soap_serialize_PointerTo_ns1__getFqans(soap, (struct _ns1__getFqans *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getTemplateResponse:
		soap_serialize_PointerTo_ns1__getTemplateResponse(soap, (struct _ns1__getTemplateResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getTemplate:
		soap_serialize_PointerTo_ns1__getTemplate(soap, (struct _ns1__getTemplate *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__loginResponse:
		soap_serialize_PointerTo_ns1__loginResponse(soap, (struct _ns1__loginResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__login:
		soap_serialize_PointerTo_ns1__login(soap, (struct _ns1__login *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__mountResponse:
		soap_serialize_PointerTo_ns1__mountResponse(soap, (struct _ns1__mountResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__mount:
		soap_serialize_PointerTo_ns1__mount(soap, (struct _ns1__mount *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobFqanResponse:
		soap_serialize_PointerTo_ns1__getJobFqanResponse(soap, (struct _ns1__getJobFqanResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getJobFqan:
		soap_serialize_PointerTo_ns1__getJobFqan(soap, (struct _ns1__getJobFqan *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getChildrenFilesResponse:
		soap_serialize_PointerTo_ns1__getChildrenFilesResponse(soap, (struct _ns1__getChildrenFilesResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__getChildrenFiles:
		soap_serialize_PointerTo_ns1__getChildrenFiles(soap, (struct _ns1__getChildrenFiles *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__VomsException:
		soap_serialize_PointerTons2__VomsException(soap, (struct ns2__VomsException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteFileSystemException:
		soap_serialize_PointerTons2__RemoteFileSystemException(soap, (struct ns2__RemoteFileSystemException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__NoValidCredentialException:
		soap_serialize_PointerTons2__NoValidCredentialException(soap, (struct ns2__NoValidCredentialException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__NoSuchTemplateException:
		soap_serialize_PointerTons2__NoSuchTemplateException(soap, (struct ns2__NoSuchTemplateException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__NoSuchJobException:
		soap_serialize_PointerTons2__NoSuchJobException(soap, (struct ns2__NoSuchJobException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__JobSubmissionException:
		soap_serialize_PointerTons2__JobSubmissionException(soap, (struct ns2__JobSubmissionException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__JobDescriptionNotValidException:
		soap_serialize_PointerTons2__JobDescriptionNotValidException(soap, (struct ns2__JobDescriptionNotValidException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons4__JobCreationException:
		soap_serialize_PointerTons4__JobCreationException(soap, (struct ns4__JobCreationException *const*)ptr);
		break;
	case SOAP_TYPE_PointerToLONG64:
		soap_serialize_PointerToLONG64(soap, (LONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__boolean:
		soap_serialize_PointerToxsd__boolean(soap, (enum xsd__boolean *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__anyType2anyTypeMap:
		soap_serialize_PointerTons1__anyType2anyTypeMap(soap, (struct ns1__anyType2anyTypeMap *const*)ptr);
		break;
	case SOAP_TYPE_PointerToxsd__base64Binary:
		soap_serialize_PointerToxsd__base64Binary(soap, (struct xsd__base64Binary *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons3__ArrayOfMountPoint:
		soap_serialize_PointerTons3__ArrayOfMountPoint(soap, (struct ns3__ArrayOfMountPoint *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons3__MountPoint:
		soap_serialize_PointerTons3__MountPoint(soap, (struct ns3__MountPoint *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons1__ArrayOfString:
		soap_serialize_PointerTons1__ArrayOfString(soap, (struct ns1__ArrayOfString *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__anyType2anyTypeMap_entry:
		soap_serialize_PointerTo_ns1__anyType2anyTypeMap_entry(soap, (struct _ns1__anyType2anyTypeMap_entry *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerTounsignedByte:
		soap_serialize_PointerTounsignedByte(soap, (unsigned char *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}
#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	return soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	return soap_inint(soap, tag, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{
	return soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_double(struct soap *soap, double *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_double
	*a = SOAP_DEFAULT_double;
#else
	*a = (double)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_double);
	if (soap_out_double(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{
	return soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedByte(struct soap *soap, unsigned char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedByte
	*a = SOAP_DEFAULT_unsignedByte;
#else
	*a = (unsigned char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedByte(struct soap *soap, const unsigned char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedByte);
	if (soap_out_unsignedByte(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedByte(struct soap *soap, const char *tag, int id, const unsigned char *a, const char *type)
{
	return soap_outunsignedByte(soap, tag, id, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_get_unsignedByte(struct soap *soap, unsigned char *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedByte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 unsigned char * SOAP_FMAC4 soap_in_unsignedByte(struct soap *soap, const char *tag, unsigned char *a, const char *type)
{
	return soap_inunsignedByte(soap, tag, a, type, SOAP_TYPE_unsignedByte);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_unsignedInt(struct soap *soap, unsigned int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_unsignedInt
	*a = SOAP_DEFAULT_unsignedInt;
#else
	*a = (unsigned int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_unsignedInt(struct soap *soap, const unsigned int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_unsignedInt);
	if (soap_out_unsignedInt(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_unsignedInt(struct soap *soap, const char *tag, int id, const unsigned int *a, const char *type)
{
	return soap_outunsignedInt(soap, tag, id, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_get_unsignedInt(struct soap *soap, unsigned int *p, const char *tag, const char *type)
{
	if ((p = soap_in_unsignedInt(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 unsigned int * SOAP_FMAC4 soap_in_unsignedInt(struct soap *soap, const char *tag, unsigned int *a, const char *type)
{
	return soap_inunsignedInt(soap, tag, a, type, SOAP_TYPE_unsignedInt);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{
	return soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__boolean(struct soap *soap, enum xsd__boolean *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_xsd__boolean
	*a = SOAP_DEFAULT_xsd__boolean;
#else
	*a = (enum xsd__boolean)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__boolean(struct soap *soap, const enum xsd__boolean *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_xsd__boolean);
	if (soap_out_xsd__boolean(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

static const struct soap_code_map soap_codes_xsd__boolean[] =
{	{ (long)xsd__boolean__false_, "false" },
	{ (long)xsd__boolean__true_, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_xsd__boolean2s(struct soap *soap, enum xsd__boolean n)
{	return soap_code_str(soap_codes_xsd__boolean, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__boolean(struct soap *soap, const char *tag, int id, const enum xsd__boolean *a, const char *type)
{	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_xsd__boolean), type);
	soap_send(soap, soap_xsd__boolean2s(soap, *a));
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_get_xsd__boolean(struct soap *soap, enum xsd__boolean *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__boolean(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2xsd__boolean(struct soap *soap, const char *s, enum xsd__boolean *a)
{
	const struct soap_code_map *map;
	if (!s)
		return SOAP_OK;
	map = soap_code(soap_codes_xsd__boolean, s);
	if (map)
		*a = (enum xsd__boolean)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (enum xsd__boolean)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 enum xsd__boolean * SOAP_FMAC4 soap_in_xsd__boolean(struct soap *soap, const char *tag, enum xsd__boolean *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (enum xsd__boolean *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__boolean, sizeof(enum xsd__boolean), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2xsd__boolean(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (enum xsd__boolean *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__boolean, 0, sizeof(enum xsd__boolean), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type);
	soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, "");
	soap_out_string(soap, "faultstring", -1, &a->faultstring, "");
	soap_out_string(soap, "faultactor", -1, &a->faultactor, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, "");
	soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, "");
	soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, "");
	soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, "");
	soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	short soap_flag_faultcode = 1, soap_flag_faultstring = 1, soap_flag_faultactor = 1, soap_flag_detail = 1, soap_flag_SOAP_ENV__Code = 1, soap_flag_SOAP_ENV__Reason = 1, soap_flag_SOAP_ENV__Node = 1, soap_flag_SOAP_ENV__Role = 1, soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type);
	soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	short soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type);
	soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, "");
	soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	short soap_flag_SOAP_ENV__Value = 1, soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type);

/* GDIS insert */
soap_element_begin_out(soap, "ns1:AuthenticationToken", 0, NULL);
soap_out_string(soap, "ns1:Username", 1, &(a->username), "");
soap_out_string(soap, "ns1:Password", 2, &(a->password), "");
soap_out_string(soap, "ns1:MyProxyServer", 3, &(a->myproxyserver), "");
soap_out_string(soap, "ns1:MyProxyPort", 4, &(a->myproxyport), "");
soap_element_end_out(soap, "ns1:AuthenticationToken");

	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getAllHosts(struct soap *soap, struct __ns1__getAllHosts *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getAllHosts = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getAllHosts(struct soap *soap, const struct __ns1__getAllHosts *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getAllHosts(soap, &a->ns1__getAllHosts);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getAllHosts(struct soap *soap, const struct __ns1__getAllHosts *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getAllHosts(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getAllHosts(struct soap *soap, const char *tag, int id, const struct __ns1__getAllHosts *a, const char *type)
{
	soap_out_PointerTo_ns1__getAllHosts(soap, "ns1:getAllHosts", -1, &a->ns1__getAllHosts, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getAllHosts * SOAP_FMAC4 soap_get___ns1__getAllHosts(struct soap *soap, struct __ns1__getAllHosts *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getAllHosts(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getAllHosts * SOAP_FMAC4 soap_in___ns1__getAllHosts(struct soap *soap, const char *tag, struct __ns1__getAllHosts *a, const char *type)
{
	short soap_flag_ns1__getAllHosts = 1;
	short soap_flag;
	a = (struct __ns1__getAllHosts *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getAllHosts, sizeof(struct __ns1__getAllHosts), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getAllHosts(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getAllHosts && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getAllHosts(soap, "ns1:getAllHosts", &a->ns1__getAllHosts, ""))
				{	soap_flag_ns1__getAllHosts--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__submitSupportRequest(struct soap *soap, struct __ns1__submitSupportRequest *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__submitSupportRequest = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__submitSupportRequest(struct soap *soap, const struct __ns1__submitSupportRequest *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__submitSupportRequest(soap, &a->ns1__submitSupportRequest);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__submitSupportRequest(struct soap *soap, const struct __ns1__submitSupportRequest *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__submitSupportRequest(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__submitSupportRequest(struct soap *soap, const char *tag, int id, const struct __ns1__submitSupportRequest *a, const char *type)
{
	soap_out_PointerTo_ns1__submitSupportRequest(soap, "ns1:submitSupportRequest", -1, &a->ns1__submitSupportRequest, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__submitSupportRequest * SOAP_FMAC4 soap_get___ns1__submitSupportRequest(struct soap *soap, struct __ns1__submitSupportRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__submitSupportRequest(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__submitSupportRequest * SOAP_FMAC4 soap_in___ns1__submitSupportRequest(struct soap *soap, const char *tag, struct __ns1__submitSupportRequest *a, const char *type)
{
	short soap_flag_ns1__submitSupportRequest = 1;
	short soap_flag;
	a = (struct __ns1__submitSupportRequest *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__submitSupportRequest, sizeof(struct __ns1__submitSupportRequest), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__submitSupportRequest(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__submitSupportRequest && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__submitSupportRequest(soap, "ns1:submitSupportRequest", &a->ns1__submitSupportRequest, ""))
				{	soap_flag_ns1__submitSupportRequest--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getJobProperty(struct soap *soap, struct __ns1__getJobProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getJobProperty = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getJobProperty(struct soap *soap, const struct __ns1__getJobProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getJobProperty(soap, &a->ns1__getJobProperty);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getJobProperty(struct soap *soap, const struct __ns1__getJobProperty *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getJobProperty(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getJobProperty(struct soap *soap, const char *tag, int id, const struct __ns1__getJobProperty *a, const char *type)
{
	soap_out_PointerTo_ns1__getJobProperty(soap, "ns1:getJobProperty", -1, &a->ns1__getJobProperty, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getJobProperty * SOAP_FMAC4 soap_get___ns1__getJobProperty(struct soap *soap, struct __ns1__getJobProperty *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getJobProperty(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getJobProperty * SOAP_FMAC4 soap_in___ns1__getJobProperty(struct soap *soap, const char *tag, struct __ns1__getJobProperty *a, const char *type)
{
	short soap_flag_ns1__getJobProperty = 1;
	short soap_flag;
	a = (struct __ns1__getJobProperty *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getJobProperty, sizeof(struct __ns1__getJobProperty), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getJobProperty(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getJobProperty && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getJobProperty(soap, "ns1:getJobProperty", &a->ns1__getJobProperty, ""))
				{	soap_flag_ns1__getJobProperty--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__mount1(struct soap *soap, struct __ns1__mount1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__mount1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__mount1(struct soap *soap, const struct __ns1__mount1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__mount1(soap, &a->ns1__mount1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__mount1(struct soap *soap, const struct __ns1__mount1 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__mount1(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__mount1(struct soap *soap, const char *tag, int id, const struct __ns1__mount1 *a, const char *type)
{
	soap_out_PointerTo_ns1__mount1(soap, "ns1:mount1", -1, &a->ns1__mount1, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__mount1 * SOAP_FMAC4 soap_get___ns1__mount1(struct soap *soap, struct __ns1__mount1 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__mount1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__mount1 * SOAP_FMAC4 soap_in___ns1__mount1(struct soap *soap, const char *tag, struct __ns1__mount1 *a, const char *type)
{
	short soap_flag_ns1__mount1 = 1;
	short soap_flag;
	a = (struct __ns1__mount1 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__mount1, sizeof(struct __ns1__mount1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__mount1(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__mount1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__mount1(soap, "ns1:mount1", &a->ns1__mount1, ""))
				{	soap_flag_ns1__mount1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getJobDetails(struct soap *soap, struct __ns1__getJobDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getJobDetails = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getJobDetails(struct soap *soap, const struct __ns1__getJobDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getJobDetails(soap, &a->ns1__getJobDetails);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getJobDetails(struct soap *soap, const struct __ns1__getJobDetails *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getJobDetails(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getJobDetails(struct soap *soap, const char *tag, int id, const struct __ns1__getJobDetails *a, const char *type)
{
	soap_out_PointerTo_ns1__getJobDetails(soap, "ns1:getJobDetails", -1, &a->ns1__getJobDetails, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getJobDetails * SOAP_FMAC4 soap_get___ns1__getJobDetails(struct soap *soap, struct __ns1__getJobDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getJobDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getJobDetails * SOAP_FMAC4 soap_in___ns1__getJobDetails(struct soap *soap, const char *tag, struct __ns1__getJobDetails *a, const char *type)
{
	short soap_flag_ns1__getJobDetails = 1;
	short soap_flag;
	a = (struct __ns1__getJobDetails *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getJobDetails, sizeof(struct __ns1__getJobDetails), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getJobDetails(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getJobDetails && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getJobDetails(soap, "ns1:getJobDetails", &a->ns1__getJobDetails, ""))
				{	soap_flag_ns1__getJobDetails--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__umount(struct soap *soap, struct __ns1__umount *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__umount = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__umount(struct soap *soap, const struct __ns1__umount *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__umount(soap, &a->ns1__umount);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__umount(struct soap *soap, const struct __ns1__umount *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__umount(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__umount(struct soap *soap, const char *tag, int id, const struct __ns1__umount *a, const char *type)
{
	soap_out_PointerTo_ns1__umount(soap, "ns1:umount", -1, &a->ns1__umount, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__umount * SOAP_FMAC4 soap_get___ns1__umount(struct soap *soap, struct __ns1__umount *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__umount(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__umount * SOAP_FMAC4 soap_in___ns1__umount(struct soap *soap, const char *tag, struct __ns1__umount *a, const char *type)
{
	short soap_flag_ns1__umount = 1;
	short soap_flag;
	a = (struct __ns1__umount *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__umount, sizeof(struct __ns1__umount), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__umount(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__umount && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__umount(soap, "ns1:umount", &a->ns1__umount, ""))
				{	soap_flag_ns1__umount--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getJobStatus(struct soap *soap, struct __ns1__getJobStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getJobStatus = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getJobStatus(struct soap *soap, const struct __ns1__getJobStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getJobStatus(soap, &a->ns1__getJobStatus);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getJobStatus(struct soap *soap, const struct __ns1__getJobStatus *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getJobStatus(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getJobStatus(struct soap *soap, const char *tag, int id, const struct __ns1__getJobStatus *a, const char *type)
{
	soap_out_PointerTo_ns1__getJobStatus(soap, "ns1:getJobStatus", -1, &a->ns1__getJobStatus, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getJobStatus * SOAP_FMAC4 soap_get___ns1__getJobStatus(struct soap *soap, struct __ns1__getJobStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getJobStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getJobStatus * SOAP_FMAC4 soap_in___ns1__getJobStatus(struct soap *soap, const char *tag, struct __ns1__getJobStatus *a, const char *type)
{
	short soap_flag_ns1__getJobStatus = 1;
	short soap_flag;
	a = (struct __ns1__getJobStatus *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getJobStatus, sizeof(struct __ns1__getJobStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getJobStatus(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getJobStatus && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getJobStatus(soap, "ns1:getJobStatus", &a->ns1__getJobStatus, ""))
				{	soap_flag_ns1__getJobStatus--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getJobDetails_USCOREstring(struct soap *soap, struct __ns1__getJobDetails_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getJobDetails_USCOREstring = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getJobDetails_USCOREstring(struct soap *soap, const struct __ns1__getJobDetails_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getJobDetails_USCOREstring(soap, &a->ns1__getJobDetails_USCOREstring);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getJobDetails_USCOREstring(struct soap *soap, const struct __ns1__getJobDetails_USCOREstring *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getJobDetails_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getJobDetails_USCOREstring(struct soap *soap, const char *tag, int id, const struct __ns1__getJobDetails_USCOREstring *a, const char *type)
{
	soap_out_PointerTo_ns1__getJobDetails_USCOREstring(soap, "ns1:getJobDetails_string", -1, &a->ns1__getJobDetails_USCOREstring, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getJobDetails_USCOREstring * SOAP_FMAC4 soap_get___ns1__getJobDetails_USCOREstring(struct soap *soap, struct __ns1__getJobDetails_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getJobDetails_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getJobDetails_USCOREstring * SOAP_FMAC4 soap_in___ns1__getJobDetails_USCOREstring(struct soap *soap, const char *tag, struct __ns1__getJobDetails_USCOREstring *a, const char *type)
{
	short soap_flag_ns1__getJobDetails_USCOREstring = 1;
	short soap_flag;
	a = (struct __ns1__getJobDetails_USCOREstring *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getJobDetails_USCOREstring, sizeof(struct __ns1__getJobDetails_USCOREstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getJobDetails_USCOREstring(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getJobDetails_USCOREstring && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getJobDetails_USCOREstring(soap, "ns1:getJobDetails_string", &a->ns1__getJobDetails_USCOREstring, ""))
				{	soap_flag_ns1__getJobDetails_USCOREstring--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getAllSites(struct soap *soap, struct __ns1__getAllSites *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getAllSites = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getAllSites(struct soap *soap, const struct __ns1__getAllSites *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getAllSites(soap, &a->ns1__getAllSites);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getAllSites(struct soap *soap, const struct __ns1__getAllSites *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getAllSites(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getAllSites(struct soap *soap, const char *tag, int id, const struct __ns1__getAllSites *a, const char *type)
{
	soap_out_PointerTo_ns1__getAllSites(soap, "ns1:getAllSites", -1, &a->ns1__getAllSites, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getAllSites * SOAP_FMAC4 soap_get___ns1__getAllSites(struct soap *soap, struct __ns1__getAllSites *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getAllSites(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getAllSites * SOAP_FMAC4 soap_in___ns1__getAllSites(struct soap *soap, const char *tag, struct __ns1__getAllSites *a, const char *type)
{
	short soap_flag_ns1__getAllSites = 1;
	short soap_flag;
	a = (struct __ns1__getAllSites *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getAllSites, sizeof(struct __ns1__getAllSites), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getAllSites(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getAllSites && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getAllSites(soap, "ns1:getAllSites", &a->ns1__getAllSites, ""))
				{	soap_flag_ns1__getAllSites--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__setJobDescription(struct soap *soap, struct __ns1__setJobDescription *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__setJobDescription = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__setJobDescription(struct soap *soap, const struct __ns1__setJobDescription *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__setJobDescription(soap, &a->ns1__setJobDescription);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__setJobDescription(struct soap *soap, const struct __ns1__setJobDescription *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__setJobDescription(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__setJobDescription(struct soap *soap, const char *tag, int id, const struct __ns1__setJobDescription *a, const char *type)
{
	soap_out_PointerTo_ns1__setJobDescription(soap, "ns1:setJobDescription", -1, &a->ns1__setJobDescription, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__setJobDescription * SOAP_FMAC4 soap_get___ns1__setJobDescription(struct soap *soap, struct __ns1__setJobDescription *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__setJobDescription(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__setJobDescription * SOAP_FMAC4 soap_in___ns1__setJobDescription(struct soap *soap, const char *tag, struct __ns1__setJobDescription *a, const char *type)
{
	short soap_flag_ns1__setJobDescription = 1;
	short soap_flag;
	a = (struct __ns1__setJobDescription *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__setJobDescription, sizeof(struct __ns1__setJobDescription), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__setJobDescription(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__setJobDescription && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__setJobDescription(soap, "ns1:setJobDescription", &a->ns1__setJobDescription, ""))
				{	soap_flag_ns1__setJobDescription--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getJobDirectory(struct soap *soap, struct __ns1__getJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getJobDirectory = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getJobDirectory(struct soap *soap, const struct __ns1__getJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getJobDirectory(soap, &a->ns1__getJobDirectory);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getJobDirectory(struct soap *soap, const struct __ns1__getJobDirectory *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getJobDirectory(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getJobDirectory(struct soap *soap, const char *tag, int id, const struct __ns1__getJobDirectory *a, const char *type)
{
	soap_out_PointerTo_ns1__getJobDirectory(soap, "ns1:getJobDirectory", -1, &a->ns1__getJobDirectory, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getJobDirectory * SOAP_FMAC4 soap_get___ns1__getJobDirectory(struct soap *soap, struct __ns1__getJobDirectory *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getJobDirectory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getJobDirectory * SOAP_FMAC4 soap_in___ns1__getJobDirectory(struct soap *soap, const char *tag, struct __ns1__getJobDirectory *a, const char *type)
{
	short soap_flag_ns1__getJobDirectory = 1;
	short soap_flag;
	a = (struct __ns1__getJobDirectory *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getJobDirectory, sizeof(struct __ns1__getJobDirectory), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getJobDirectory(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getJobDirectory && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getJobDirectory(soap, "ns1:getJobDirectory", &a->ns1__getJobDirectory, ""))
				{	soap_flag_ns1__getJobDirectory--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__upload(struct soap *soap, struct __ns1__upload *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__upload = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__upload(struct soap *soap, const struct __ns1__upload *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__upload(soap, &a->ns1__upload);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__upload(struct soap *soap, const struct __ns1__upload *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__upload(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__upload(struct soap *soap, const char *tag, int id, const struct __ns1__upload *a, const char *type)
{
	soap_out_PointerTo_ns1__upload(soap, "ns1:upload", -1, &a->ns1__upload, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__upload * SOAP_FMAC4 soap_get___ns1__upload(struct soap *soap, struct __ns1__upload *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__upload(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__upload * SOAP_FMAC4 soap_in___ns1__upload(struct soap *soap, const char *tag, struct __ns1__upload *a, const char *type)
{
	short soap_flag_ns1__upload = 1;
	short soap_flag;
	a = (struct __ns1__upload *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__upload, sizeof(struct __ns1__upload), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__upload(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__upload && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__upload(soap, "ns1:upload", &a->ns1__upload, ""))
				{	soap_flag_ns1__upload--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__deleteFile(struct soap *soap, struct __ns1__deleteFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__deleteFile = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__deleteFile(struct soap *soap, const struct __ns1__deleteFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__deleteFile(soap, &a->ns1__deleteFile);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__deleteFile(struct soap *soap, const struct __ns1__deleteFile *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__deleteFile(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__deleteFile(struct soap *soap, const char *tag, int id, const struct __ns1__deleteFile *a, const char *type)
{
	soap_out_PointerTo_ns1__deleteFile(soap, "ns1:deleteFile", -1, &a->ns1__deleteFile, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__deleteFile * SOAP_FMAC4 soap_get___ns1__deleteFile(struct soap *soap, struct __ns1__deleteFile *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__deleteFile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__deleteFile * SOAP_FMAC4 soap_in___ns1__deleteFile(struct soap *soap, const char *tag, struct __ns1__deleteFile *a, const char *type)
{
	short soap_flag_ns1__deleteFile = 1;
	short soap_flag;
	a = (struct __ns1__deleteFile *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__deleteFile, sizeof(struct __ns1__deleteFile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__deleteFile(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__deleteFile && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__deleteFile(soap, "ns1:deleteFile", &a->ns1__deleteFile, ""))
				{	soap_flag_ns1__deleteFile--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getFileSize(struct soap *soap, struct __ns1__getFileSize *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getFileSize = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getFileSize(struct soap *soap, const struct __ns1__getFileSize *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getFileSize(soap, &a->ns1__getFileSize);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getFileSize(struct soap *soap, const struct __ns1__getFileSize *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getFileSize(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getFileSize(struct soap *soap, const char *tag, int id, const struct __ns1__getFileSize *a, const char *type)
{
	soap_out_PointerTo_ns1__getFileSize(soap, "ns1:getFileSize", -1, &a->ns1__getFileSize, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getFileSize * SOAP_FMAC4 soap_get___ns1__getFileSize(struct soap *soap, struct __ns1__getFileSize *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getFileSize(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getFileSize * SOAP_FMAC4 soap_in___ns1__getFileSize(struct soap *soap, const char *tag, struct __ns1__getFileSize *a, const char *type)
{
	short soap_flag_ns1__getFileSize = 1;
	short soap_flag;
	a = (struct __ns1__getFileSize *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getFileSize, sizeof(struct __ns1__getFileSize), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getFileSize(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getFileSize && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getFileSize(soap, "ns1:getFileSize", &a->ns1__getFileSize, ""))
				{	soap_flag_ns1__getFileSize--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__cp(struct soap *soap, struct __ns1__cp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__cp = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__cp(struct soap *soap, const struct __ns1__cp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__cp(soap, &a->ns1__cp);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__cp(struct soap *soap, const struct __ns1__cp *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__cp(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__cp(struct soap *soap, const char *tag, int id, const struct __ns1__cp *a, const char *type)
{
	soap_out_PointerTo_ns1__cp(soap, "ns1:cp", -1, &a->ns1__cp, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__cp * SOAP_FMAC4 soap_get___ns1__cp(struct soap *soap, struct __ns1__cp *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__cp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__cp * SOAP_FMAC4 soap_in___ns1__cp(struct soap *soap, const char *tag, struct __ns1__cp *a, const char *type)
{
	short soap_flag_ns1__cp = 1;
	short soap_flag;
	a = (struct __ns1__cp *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__cp, sizeof(struct __ns1__cp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__cp(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__cp && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__cp(soap, "ns1:cp", &a->ns1__cp, ""))
				{	soap_flag_ns1__cp--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__uploadByteArray(struct soap *soap, struct __ns1__uploadByteArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__uploadByteArray = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__uploadByteArray(struct soap *soap, const struct __ns1__uploadByteArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__uploadByteArray(soap, &a->ns1__uploadByteArray);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__uploadByteArray(struct soap *soap, const struct __ns1__uploadByteArray *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__uploadByteArray(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__uploadByteArray(struct soap *soap, const char *tag, int id, const struct __ns1__uploadByteArray *a, const char *type)
{
	soap_out_PointerTo_ns1__uploadByteArray(soap, "ns1:uploadByteArray", -1, &a->ns1__uploadByteArray, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__uploadByteArray * SOAP_FMAC4 soap_get___ns1__uploadByteArray(struct soap *soap, struct __ns1__uploadByteArray *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__uploadByteArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__uploadByteArray * SOAP_FMAC4 soap_in___ns1__uploadByteArray(struct soap *soap, const char *tag, struct __ns1__uploadByteArray *a, const char *type)
{
	short soap_flag_ns1__uploadByteArray = 1;
	short soap_flag;
	a = (struct __ns1__uploadByteArray *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__uploadByteArray, sizeof(struct __ns1__uploadByteArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__uploadByteArray(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__uploadByteArray && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__uploadByteArray(soap, "ns1:uploadByteArray", &a->ns1__uploadByteArray, ""))
				{	soap_flag_ns1__uploadByteArray--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__submitJob(struct soap *soap, struct __ns1__submitJob *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__submitJob = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__submitJob(struct soap *soap, const struct __ns1__submitJob *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__submitJob(soap, &a->ns1__submitJob);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__submitJob(struct soap *soap, const struct __ns1__submitJob *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__submitJob(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__submitJob(struct soap *soap, const char *tag, int id, const struct __ns1__submitJob *a, const char *type)
{
	soap_out_PointerTo_ns1__submitJob(soap, "ns1:submitJob", -1, &a->ns1__submitJob, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__submitJob * SOAP_FMAC4 soap_get___ns1__submitJob(struct soap *soap, struct __ns1__submitJob *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__submitJob(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__submitJob * SOAP_FMAC4 soap_in___ns1__submitJob(struct soap *soap, const char *tag, struct __ns1__submitJob *a, const char *type)
{
	short soap_flag_ns1__submitJob = 1;
	short soap_flag;
	a = (struct __ns1__submitJob *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__submitJob, sizeof(struct __ns1__submitJob), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__submitJob(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__submitJob && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__submitJob(soap, "ns1:submitJob", &a->ns1__submitJob, ""))
				{	soap_flag_ns1__submitJob--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__logout(struct soap *soap, struct __ns1__logout *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__logout = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__logout(struct soap *soap, const struct __ns1__logout *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__logout(soap, &a->ns1__logout);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__logout(struct soap *soap, const struct __ns1__logout *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__logout(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__logout(struct soap *soap, const char *tag, int id, const struct __ns1__logout *a, const char *type)
{
	soap_out_PointerTo_ns1__logout(soap, "ns1:logout", -1, &a->ns1__logout, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__logout * SOAP_FMAC4 soap_get___ns1__logout(struct soap *soap, struct __ns1__logout *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__logout(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__logout * SOAP_FMAC4 soap_in___ns1__logout(struct soap *soap, const char *tag, struct __ns1__logout *a, const char *type)
{
	short soap_flag_ns1__logout = 1;
	short soap_flag;
	a = (struct __ns1__logout *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__logout, sizeof(struct __ns1__logout), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__logout(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__logout && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__logout(soap, "ns1:logout", &a->ns1__logout, ""))
				{	soap_flag_ns1__logout--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__setJobDescription_USCOREstring(struct soap *soap, struct __ns1__setJobDescription_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__setJobDescription_USCOREstring = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__setJobDescription_USCOREstring(struct soap *soap, const struct __ns1__setJobDescription_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__setJobDescription_USCOREstring(soap, &a->ns1__setJobDescription_USCOREstring);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__setJobDescription_USCOREstring(struct soap *soap, const struct __ns1__setJobDescription_USCOREstring *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__setJobDescription_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__setJobDescription_USCOREstring(struct soap *soap, const char *tag, int id, const struct __ns1__setJobDescription_USCOREstring *a, const char *type)
{
	soap_out_PointerTo_ns1__setJobDescription_USCOREstring(soap, "ns1:setJobDescription_string", -1, &a->ns1__setJobDescription_USCOREstring, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__setJobDescription_USCOREstring * SOAP_FMAC4 soap_get___ns1__setJobDescription_USCOREstring(struct soap *soap, struct __ns1__setJobDescription_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__setJobDescription_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__setJobDescription_USCOREstring * SOAP_FMAC4 soap_in___ns1__setJobDescription_USCOREstring(struct soap *soap, const char *tag, struct __ns1__setJobDescription_USCOREstring *a, const char *type)
{
	short soap_flag_ns1__setJobDescription_USCOREstring = 1;
	short soap_flag;
	a = (struct __ns1__setJobDescription_USCOREstring *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__setJobDescription_USCOREstring, sizeof(struct __ns1__setJobDescription_USCOREstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__setJobDescription_USCOREstring(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__setJobDescription_USCOREstring && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__setJobDescription_USCOREstring(soap, "ns1:setJobDescription_string", &a->ns1__setJobDescription_USCOREstring, ""))
				{	soap_flag_ns1__setJobDescription_USCOREstring--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__calculateRelativeJobDirectory(struct soap *soap, struct __ns1__calculateRelativeJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__calculateRelativeJobDirectory = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__calculateRelativeJobDirectory(struct soap *soap, const struct __ns1__calculateRelativeJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__calculateRelativeJobDirectory(soap, &a->ns1__calculateRelativeJobDirectory);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__calculateRelativeJobDirectory(struct soap *soap, const struct __ns1__calculateRelativeJobDirectory *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__calculateRelativeJobDirectory(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__calculateRelativeJobDirectory(struct soap *soap, const char *tag, int id, const struct __ns1__calculateRelativeJobDirectory *a, const char *type)
{
	soap_out_PointerTo_ns1__calculateRelativeJobDirectory(soap, "ns1:calculateRelativeJobDirectory", -1, &a->ns1__calculateRelativeJobDirectory, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__calculateRelativeJobDirectory * SOAP_FMAC4 soap_get___ns1__calculateRelativeJobDirectory(struct soap *soap, struct __ns1__calculateRelativeJobDirectory *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__calculateRelativeJobDirectory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__calculateRelativeJobDirectory * SOAP_FMAC4 soap_in___ns1__calculateRelativeJobDirectory(struct soap *soap, const char *tag, struct __ns1__calculateRelativeJobDirectory *a, const char *type)
{
	short soap_flag_ns1__calculateRelativeJobDirectory = 1;
	short soap_flag;
	a = (struct __ns1__calculateRelativeJobDirectory *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__calculateRelativeJobDirectory, sizeof(struct __ns1__calculateRelativeJobDirectory), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__calculateRelativeJobDirectory(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__calculateRelativeJobDirectory && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__calculateRelativeJobDirectory(soap, "ns1:calculateRelativeJobDirectory", &a->ns1__calculateRelativeJobDirectory, ""))
				{	soap_flag_ns1__calculateRelativeJobDirectory--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getApplicationDetails1(struct soap *soap, struct __ns1__getApplicationDetails1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getApplicationDetails1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getApplicationDetails1(struct soap *soap, const struct __ns1__getApplicationDetails1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getApplicationDetails1(soap, &a->ns1__getApplicationDetails1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getApplicationDetails1(struct soap *soap, const struct __ns1__getApplicationDetails1 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getApplicationDetails1(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getApplicationDetails1(struct soap *soap, const char *tag, int id, const struct __ns1__getApplicationDetails1 *a, const char *type)
{
	soap_out_PointerTo_ns1__getApplicationDetails1(soap, "ns1:getApplicationDetails1", -1, &a->ns1__getApplicationDetails1, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getApplicationDetails1 * SOAP_FMAC4 soap_get___ns1__getApplicationDetails1(struct soap *soap, struct __ns1__getApplicationDetails1 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getApplicationDetails1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getApplicationDetails1 * SOAP_FMAC4 soap_in___ns1__getApplicationDetails1(struct soap *soap, const char *tag, struct __ns1__getApplicationDetails1 *a, const char *type)
{
	short soap_flag_ns1__getApplicationDetails1 = 1;
	short soap_flag;
	a = (struct __ns1__getApplicationDetails1 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getApplicationDetails1, sizeof(struct __ns1__getApplicationDetails1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getApplicationDetails1(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getApplicationDetails1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getApplicationDetails1(soap, "ns1:getApplicationDetails1", &a->ns1__getApplicationDetails1, ""))
				{	soap_flag_ns1__getApplicationDetails1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__ls(struct soap *soap, struct __ns1__ls *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__ls = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__ls(struct soap *soap, const struct __ns1__ls *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__ls(soap, &a->ns1__ls);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__ls(struct soap *soap, const struct __ns1__ls *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__ls(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__ls(struct soap *soap, const char *tag, int id, const struct __ns1__ls *a, const char *type)
{
	soap_out_PointerTo_ns1__ls(soap, "ns1:ls", -1, &a->ns1__ls, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__ls * SOAP_FMAC4 soap_get___ns1__ls(struct soap *soap, struct __ns1__ls *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__ls(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__ls * SOAP_FMAC4 soap_in___ns1__ls(struct soap *soap, const char *tag, struct __ns1__ls *a, const char *type)
{
	short soap_flag_ns1__ls = 1;
	short soap_flag;
	a = (struct __ns1__ls *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__ls, sizeof(struct __ns1__ls), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__ls(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__ls && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__ls(soap, "ns1:ls", &a->ns1__ls, ""))
				{	soap_flag_ns1__ls--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__lastModified(struct soap *soap, struct __ns1__lastModified *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__lastModified = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__lastModified(struct soap *soap, const struct __ns1__lastModified *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__lastModified(soap, &a->ns1__lastModified);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__lastModified(struct soap *soap, const struct __ns1__lastModified *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__lastModified(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__lastModified(struct soap *soap, const char *tag, int id, const struct __ns1__lastModified *a, const char *type)
{
	soap_out_PointerTo_ns1__lastModified(soap, "ns1:lastModified", -1, &a->ns1__lastModified, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__lastModified * SOAP_FMAC4 soap_get___ns1__lastModified(struct soap *soap, struct __ns1__lastModified *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__lastModified(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__lastModified * SOAP_FMAC4 soap_in___ns1__lastModified(struct soap *soap, const char *tag, struct __ns1__lastModified *a, const char *type)
{
	short soap_flag_ns1__lastModified = 1;
	short soap_flag;
	a = (struct __ns1__lastModified *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__lastModified, sizeof(struct __ns1__lastModified), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__lastModified(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__lastModified && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__lastModified(soap, "ns1:lastModified", &a->ns1__lastModified, ""))
				{	soap_flag_ns1__lastModified--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getSite(struct soap *soap, struct __ns1__getSite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getSite = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getSite(struct soap *soap, const struct __ns1__getSite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getSite(soap, &a->ns1__getSite);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getSite(struct soap *soap, const struct __ns1__getSite *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getSite(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getSite(struct soap *soap, const char *tag, int id, const struct __ns1__getSite *a, const char *type)
{
	soap_out_PointerTo_ns1__getSite(soap, "ns1:getSite", -1, &a->ns1__getSite, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getSite * SOAP_FMAC4 soap_get___ns1__getSite(struct soap *soap, struct __ns1__getSite *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getSite(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getSite * SOAP_FMAC4 soap_in___ns1__getSite(struct soap *soap, const char *tag, struct __ns1__getSite *a, const char *type)
{
	short soap_flag_ns1__getSite = 1;
	short soap_flag;
	a = (struct __ns1__getSite *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getSite, sizeof(struct __ns1__getSite), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getSite(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getSite && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getSite(soap, "ns1:getSite", &a->ns1__getSite, ""))
				{	soap_flag_ns1__getSite--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__ps_USCOREstring(struct soap *soap, struct __ns1__ps_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__ps_USCOREstring = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__ps_USCOREstring(struct soap *soap, const struct __ns1__ps_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__ps_USCOREstring(soap, &a->ns1__ps_USCOREstring);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__ps_USCOREstring(struct soap *soap, const struct __ns1__ps_USCOREstring *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__ps_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__ps_USCOREstring(struct soap *soap, const char *tag, int id, const struct __ns1__ps_USCOREstring *a, const char *type)
{
	soap_out_PointerTo_ns1__ps_USCOREstring(soap, "ns1:ps_string", -1, &a->ns1__ps_USCOREstring, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__ps_USCOREstring * SOAP_FMAC4 soap_get___ns1__ps_USCOREstring(struct soap *soap, struct __ns1__ps_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__ps_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__ps_USCOREstring * SOAP_FMAC4 soap_in___ns1__ps_USCOREstring(struct soap *soap, const char *tag, struct __ns1__ps_USCOREstring *a, const char *type)
{
	short soap_flag_ns1__ps_USCOREstring = 1;
	short soap_flag;
	a = (struct __ns1__ps_USCOREstring *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__ps_USCOREstring, sizeof(struct __ns1__ps_USCOREstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__ps_USCOREstring(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__ps_USCOREstring && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__ps_USCOREstring(soap, "ns1:ps_string", &a->ns1__ps_USCOREstring, ""))
				{	soap_flag_ns1__ps_USCOREstring--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__uploadByteArray1(struct soap *soap, struct __ns1__uploadByteArray1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__uploadByteArray1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__uploadByteArray1(struct soap *soap, const struct __ns1__uploadByteArray1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__uploadByteArray1(soap, &a->ns1__uploadByteArray1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__uploadByteArray1(struct soap *soap, const struct __ns1__uploadByteArray1 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__uploadByteArray1(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__uploadByteArray1(struct soap *soap, const char *tag, int id, const struct __ns1__uploadByteArray1 *a, const char *type)
{
	soap_out_PointerTo_ns1__uploadByteArray1(soap, "ns1:uploadByteArray1", -1, &a->ns1__uploadByteArray1, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__uploadByteArray1 * SOAP_FMAC4 soap_get___ns1__uploadByteArray1(struct soap *soap, struct __ns1__uploadByteArray1 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__uploadByteArray1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__uploadByteArray1 * SOAP_FMAC4 soap_in___ns1__uploadByteArray1(struct soap *soap, const char *tag, struct __ns1__uploadByteArray1 *a, const char *type)
{
	short soap_flag_ns1__uploadByteArray1 = 1;
	short soap_flag;
	a = (struct __ns1__uploadByteArray1 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__uploadByteArray1, sizeof(struct __ns1__uploadByteArray1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__uploadByteArray1(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__uploadByteArray1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__uploadByteArray1(soap, "ns1:uploadByteArray1", &a->ns1__uploadByteArray1, ""))
				{	soap_flag_ns1__uploadByteArray1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getVersionsOfApplicationOnSite(struct soap *soap, struct __ns1__getVersionsOfApplicationOnSite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getVersionsOfApplicationOnSite = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getVersionsOfApplicationOnSite(struct soap *soap, const struct __ns1__getVersionsOfApplicationOnSite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getVersionsOfApplicationOnSite(soap, &a->ns1__getVersionsOfApplicationOnSite);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getVersionsOfApplicationOnSite(struct soap *soap, const struct __ns1__getVersionsOfApplicationOnSite *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getVersionsOfApplicationOnSite(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getVersionsOfApplicationOnSite(struct soap *soap, const char *tag, int id, const struct __ns1__getVersionsOfApplicationOnSite *a, const char *type)
{
	soap_out_PointerTo_ns1__getVersionsOfApplicationOnSite(soap, "ns1:getVersionsOfApplicationOnSite", -1, &a->ns1__getVersionsOfApplicationOnSite, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getVersionsOfApplicationOnSite * SOAP_FMAC4 soap_get___ns1__getVersionsOfApplicationOnSite(struct soap *soap, struct __ns1__getVersionsOfApplicationOnSite *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getVersionsOfApplicationOnSite(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getVersionsOfApplicationOnSite * SOAP_FMAC4 soap_in___ns1__getVersionsOfApplicationOnSite(struct soap *soap, const char *tag, struct __ns1__getVersionsOfApplicationOnSite *a, const char *type)
{
	short soap_flag_ns1__getVersionsOfApplicationOnSite = 1;
	short soap_flag;
	a = (struct __ns1__getVersionsOfApplicationOnSite *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getVersionsOfApplicationOnSite, sizeof(struct __ns1__getVersionsOfApplicationOnSite), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getVersionsOfApplicationOnSite(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getVersionsOfApplicationOnSite && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getVersionsOfApplicationOnSite(soap, "ns1:getVersionsOfApplicationOnSite", &a->ns1__getVersionsOfApplicationOnSite, ""))
				{	soap_flag_ns1__getVersionsOfApplicationOnSite--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getAllSubmissionLocations1(struct soap *soap, struct __ns1__getAllSubmissionLocations1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getAllSubmissionLocations1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getAllSubmissionLocations1(struct soap *soap, const struct __ns1__getAllSubmissionLocations1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getAllSubmissionLocations1(soap, &a->ns1__getAllSubmissionLocations1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getAllSubmissionLocations1(struct soap *soap, const struct __ns1__getAllSubmissionLocations1 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getAllSubmissionLocations1(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getAllSubmissionLocations1(struct soap *soap, const char *tag, int id, const struct __ns1__getAllSubmissionLocations1 *a, const char *type)
{
	soap_out_PointerTo_ns1__getAllSubmissionLocations1(soap, "ns1:getAllSubmissionLocations1", -1, &a->ns1__getAllSubmissionLocations1, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getAllSubmissionLocations1 * SOAP_FMAC4 soap_get___ns1__getAllSubmissionLocations1(struct soap *soap, struct __ns1__getAllSubmissionLocations1 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getAllSubmissionLocations1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getAllSubmissionLocations1 * SOAP_FMAC4 soap_in___ns1__getAllSubmissionLocations1(struct soap *soap, const char *tag, struct __ns1__getAllSubmissionLocations1 *a, const char *type)
{
	short soap_flag_ns1__getAllSubmissionLocations1 = 1;
	short soap_flag;
	a = (struct __ns1__getAllSubmissionLocations1 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getAllSubmissionLocations1, sizeof(struct __ns1__getAllSubmissionLocations1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getAllSubmissionLocations1(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getAllSubmissionLocations1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getAllSubmissionLocations1(soap, "ns1:getAllSubmissionLocations1", &a->ns1__getAllSubmissionLocations1, ""))
				{	soap_flag_ns1__getAllSubmissionLocations1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__createJob(struct soap *soap, struct __ns1__createJob *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__createJob = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__createJob(struct soap *soap, const struct __ns1__createJob *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__createJob(soap, &a->ns1__createJob);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__createJob(struct soap *soap, const struct __ns1__createJob *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__createJob(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__createJob(struct soap *soap, const char *tag, int id, const struct __ns1__createJob *a, const char *type)
{
	soap_out_PointerTo_ns1__createJob(soap, "ns1:createJob", -1, &a->ns1__createJob, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__createJob * SOAP_FMAC4 soap_get___ns1__createJob(struct soap *soap, struct __ns1__createJob *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__createJob(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__createJob * SOAP_FMAC4 soap_in___ns1__createJob(struct soap *soap, const char *tag, struct __ns1__createJob *a, const char *type)
{
	short soap_flag_ns1__createJob = 1;
	short soap_flag;
	a = (struct __ns1__createJob *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__createJob, sizeof(struct __ns1__createJob), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__createJob(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__createJob && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__createJob(soap, "ns1:createJob", &a->ns1__createJob, ""))
				{	soap_flag_ns1__createJob--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getInterfaceVersion(struct soap *soap, struct __ns1__getInterfaceVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getInterfaceVersion = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getInterfaceVersion(struct soap *soap, const struct __ns1__getInterfaceVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getInterfaceVersion(soap, &a->ns1__getInterfaceVersion);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getInterfaceVersion(struct soap *soap, const struct __ns1__getInterfaceVersion *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getInterfaceVersion(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getInterfaceVersion(struct soap *soap, const char *tag, int id, const struct __ns1__getInterfaceVersion *a, const char *type)
{
	soap_out_PointerTo_ns1__getInterfaceVersion(soap, "ns1:getInterfaceVersion", -1, &a->ns1__getInterfaceVersion, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getInterfaceVersion * SOAP_FMAC4 soap_get___ns1__getInterfaceVersion(struct soap *soap, struct __ns1__getInterfaceVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getInterfaceVersion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getInterfaceVersion * SOAP_FMAC4 soap_in___ns1__getInterfaceVersion(struct soap *soap, const char *tag, struct __ns1__getInterfaceVersion *a, const char *type)
{
	short soap_flag_ns1__getInterfaceVersion = 1;
	short soap_flag;
	a = (struct __ns1__getInterfaceVersion *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getInterfaceVersion, sizeof(struct __ns1__getInterfaceVersion), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getInterfaceVersion(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getInterfaceVersion && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getInterfaceVersion(soap, "ns1:getInterfaceVersion", &a->ns1__getInterfaceVersion, ""))
				{	soap_flag_ns1__getInterfaceVersion--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getAllSubmissionLocations(struct soap *soap, struct __ns1__getAllSubmissionLocations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getAllSubmissionLocations = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getAllSubmissionLocations(struct soap *soap, const struct __ns1__getAllSubmissionLocations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getAllSubmissionLocations(soap, &a->ns1__getAllSubmissionLocations);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getAllSubmissionLocations(struct soap *soap, const struct __ns1__getAllSubmissionLocations *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getAllSubmissionLocations(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getAllSubmissionLocations(struct soap *soap, const char *tag, int id, const struct __ns1__getAllSubmissionLocations *a, const char *type)
{
	soap_out_PointerTo_ns1__getAllSubmissionLocations(soap, "ns1:getAllSubmissionLocations", -1, &a->ns1__getAllSubmissionLocations, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getAllSubmissionLocations * SOAP_FMAC4 soap_get___ns1__getAllSubmissionLocations(struct soap *soap, struct __ns1__getAllSubmissionLocations *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getAllSubmissionLocations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getAllSubmissionLocations * SOAP_FMAC4 soap_in___ns1__getAllSubmissionLocations(struct soap *soap, const char *tag, struct __ns1__getAllSubmissionLocations *a, const char *type)
{
	short soap_flag_ns1__getAllSubmissionLocations = 1;
	short soap_flag;
	a = (struct __ns1__getAllSubmissionLocations *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getAllSubmissionLocations, sizeof(struct __ns1__getAllSubmissionLocations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getAllSubmissionLocations(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getAllSubmissionLocations && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getAllSubmissionLocations(soap, "ns1:getAllSubmissionLocations", &a->ns1__getAllSubmissionLocations, ""))
				{	soap_flag_ns1__getAllSubmissionLocations--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__addJobProperty(struct soap *soap, struct __ns1__addJobProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__addJobProperty = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__addJobProperty(struct soap *soap, const struct __ns1__addJobProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__addJobProperty(soap, &a->ns1__addJobProperty);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__addJobProperty(struct soap *soap, const struct __ns1__addJobProperty *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__addJobProperty(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__addJobProperty(struct soap *soap, const char *tag, int id, const struct __ns1__addJobProperty *a, const char *type)
{
	soap_out_PointerTo_ns1__addJobProperty(soap, "ns1:addJobProperty", -1, &a->ns1__addJobProperty, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__addJobProperty * SOAP_FMAC4 soap_get___ns1__addJobProperty(struct soap *soap, struct __ns1__addJobProperty *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__addJobProperty(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__addJobProperty * SOAP_FMAC4 soap_in___ns1__addJobProperty(struct soap *soap, const char *tag, struct __ns1__addJobProperty *a, const char *type)
{
	short soap_flag_ns1__addJobProperty = 1;
	short soap_flag;
	a = (struct __ns1__addJobProperty *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__addJobProperty, sizeof(struct __ns1__addJobProperty), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__addJobProperty(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__addJobProperty && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__addJobProperty(soap, "ns1:addJobProperty", &a->ns1__addJobProperty, ""))
				{	soap_flag_ns1__addJobProperty--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__addJobProperties(struct soap *soap, struct __ns1__addJobProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__addJobProperties = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__addJobProperties(struct soap *soap, const struct __ns1__addJobProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__addJobProperties(soap, &a->ns1__addJobProperties);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__addJobProperties(struct soap *soap, const struct __ns1__addJobProperties *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__addJobProperties(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__addJobProperties(struct soap *soap, const char *tag, int id, const struct __ns1__addJobProperties *a, const char *type)
{
	soap_out_PointerTo_ns1__addJobProperties(soap, "ns1:addJobProperties", -1, &a->ns1__addJobProperties, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__addJobProperties * SOAP_FMAC4 soap_get___ns1__addJobProperties(struct soap *soap, struct __ns1__addJobProperties *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__addJobProperties(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__addJobProperties * SOAP_FMAC4 soap_in___ns1__addJobProperties(struct soap *soap, const char *tag, struct __ns1__addJobProperties *a, const char *type)
{
	short soap_flag_ns1__addJobProperties = 1;
	short soap_flag;
	a = (struct __ns1__addJobProperties *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__addJobProperties, sizeof(struct __ns1__addJobProperties), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__addJobProperties(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__addJobProperties && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__addJobProperties(soap, "ns1:addJobProperties", &a->ns1__addJobProperties, ""))
				{	soap_flag_ns1__addJobProperties--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getAllAvailableApplications(struct soap *soap, struct __ns1__getAllAvailableApplications *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getAllAvailableApplications = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getAllAvailableApplications(struct soap *soap, const struct __ns1__getAllAvailableApplications *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getAllAvailableApplications(soap, &a->ns1__getAllAvailableApplications);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getAllAvailableApplications(struct soap *soap, const struct __ns1__getAllAvailableApplications *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getAllAvailableApplications(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getAllAvailableApplications(struct soap *soap, const char *tag, int id, const struct __ns1__getAllAvailableApplications *a, const char *type)
{
	soap_out_PointerTo_ns1__getAllAvailableApplications(soap, "ns1:getAllAvailableApplications", -1, &a->ns1__getAllAvailableApplications, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getAllAvailableApplications * SOAP_FMAC4 soap_get___ns1__getAllAvailableApplications(struct soap *soap, struct __ns1__getAllAvailableApplications *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getAllAvailableApplications(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getAllAvailableApplications * SOAP_FMAC4 soap_in___ns1__getAllAvailableApplications(struct soap *soap, const char *tag, struct __ns1__getAllAvailableApplications *a, const char *type)
{
	short soap_flag_ns1__getAllAvailableApplications = 1;
	short soap_flag;
	a = (struct __ns1__getAllAvailableApplications *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getAllAvailableApplications, sizeof(struct __ns1__getAllAvailableApplications), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getAllAvailableApplications(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getAllAvailableApplications && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getAllAvailableApplications(soap, "ns1:getAllAvailableApplications", &a->ns1__getAllAvailableApplications, ""))
				{	soap_flag_ns1__getAllAvailableApplications--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__kill(struct soap *soap, struct __ns1__kill *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__kill = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__kill(struct soap *soap, const struct __ns1__kill *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__kill(soap, &a->ns1__kill);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__kill(struct soap *soap, const struct __ns1__kill *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__kill(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__kill(struct soap *soap, const char *tag, int id, const struct __ns1__kill *a, const char *type)
{
	soap_out_PointerTo_ns1__kill(soap, "ns1:kill", -1, &a->ns1__kill, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__kill * SOAP_FMAC4 soap_get___ns1__kill(struct soap *soap, struct __ns1__kill *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__kill(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__kill * SOAP_FMAC4 soap_in___ns1__kill(struct soap *soap, const char *tag, struct __ns1__kill *a, const char *type)
{
	short soap_flag_ns1__kill = 1;
	short soap_flag;
	a = (struct __ns1__kill *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__kill, sizeof(struct __ns1__kill), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__kill(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__kill && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__kill(soap, "ns1:kill", &a->ns1__kill, ""))
				{	soap_flag_ns1__kill--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__isFolder(struct soap *soap, struct __ns1__isFolder *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__isFolder = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__isFolder(struct soap *soap, const struct __ns1__isFolder *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__isFolder(soap, &a->ns1__isFolder);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__isFolder(struct soap *soap, const struct __ns1__isFolder *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__isFolder(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__isFolder(struct soap *soap, const char *tag, int id, const struct __ns1__isFolder *a, const char *type)
{
	soap_out_PointerTo_ns1__isFolder(soap, "ns1:isFolder", -1, &a->ns1__isFolder, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__isFolder * SOAP_FMAC4 soap_get___ns1__isFolder(struct soap *soap, struct __ns1__isFolder *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__isFolder(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__isFolder * SOAP_FMAC4 soap_in___ns1__isFolder(struct soap *soap, const char *tag, struct __ns1__isFolder *a, const char *type)
{
	short soap_flag_ns1__isFolder = 1;
	short soap_flag;
	a = (struct __ns1__isFolder *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__isFolder, sizeof(struct __ns1__isFolder), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__isFolder(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__isFolder && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__isFolder(soap, "ns1:isFolder", &a->ns1__isFolder, ""))
				{	soap_flag_ns1__isFolder--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__download(struct soap *soap, struct __ns1__download *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__download = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__download(struct soap *soap, const struct __ns1__download *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__download(soap, &a->ns1__download);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__download(struct soap *soap, const struct __ns1__download *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__download(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__download(struct soap *soap, const char *tag, int id, const struct __ns1__download *a, const char *type)
{
	soap_out_PointerTo_ns1__download(soap, "ns1:download", -1, &a->ns1__download, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__download * SOAP_FMAC4 soap_get___ns1__download(struct soap *soap, struct __ns1__download *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__download(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__download * SOAP_FMAC4 soap_in___ns1__download(struct soap *soap, const char *tag, struct __ns1__download *a, const char *type)
{
	short soap_flag_ns1__download = 1;
	short soap_flag;
	a = (struct __ns1__download *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__download, sizeof(struct __ns1__download), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__download(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__download && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__download(soap, "ns1:download", &a->ns1__download, ""))
				{	soap_flag_ns1__download--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getAllJobProperties(struct soap *soap, struct __ns1__getAllJobProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getAllJobProperties = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getAllJobProperties(struct soap *soap, const struct __ns1__getAllJobProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getAllJobProperties(soap, &a->ns1__getAllJobProperties);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getAllJobProperties(struct soap *soap, const struct __ns1__getAllJobProperties *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getAllJobProperties(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getAllJobProperties(struct soap *soap, const char *tag, int id, const struct __ns1__getAllJobProperties *a, const char *type)
{
	soap_out_PointerTo_ns1__getAllJobProperties(soap, "ns1:getAllJobProperties", -1, &a->ns1__getAllJobProperties, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getAllJobProperties * SOAP_FMAC4 soap_get___ns1__getAllJobProperties(struct soap *soap, struct __ns1__getAllJobProperties *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getAllJobProperties(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getAllJobProperties * SOAP_FMAC4 soap_in___ns1__getAllJobProperties(struct soap *soap, const char *tag, struct __ns1__getAllJobProperties *a, const char *type)
{
	short soap_flag_ns1__getAllJobProperties = 1;
	short soap_flag;
	a = (struct __ns1__getAllJobProperties *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getAllJobProperties, sizeof(struct __ns1__getAllJobProperties), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getAllJobProperties(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getAllJobProperties && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getAllJobProperties(soap, "ns1:getAllJobProperties", &a->ns1__getAllJobProperties, ""))
				{	soap_flag_ns1__getAllJobProperties--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getAllJobnames(struct soap *soap, struct __ns1__getAllJobnames *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getAllJobnames = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getAllJobnames(struct soap *soap, const struct __ns1__getAllJobnames *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getAllJobnames(soap, &a->ns1__getAllJobnames);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getAllJobnames(struct soap *soap, const struct __ns1__getAllJobnames *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getAllJobnames(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getAllJobnames(struct soap *soap, const char *tag, int id, const struct __ns1__getAllJobnames *a, const char *type)
{
	soap_out_PointerTo_ns1__getAllJobnames(soap, "ns1:getAllJobnames", -1, &a->ns1__getAllJobnames, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getAllJobnames * SOAP_FMAC4 soap_get___ns1__getAllJobnames(struct soap *soap, struct __ns1__getAllJobnames *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getAllJobnames(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getAllJobnames * SOAP_FMAC4 soap_in___ns1__getAllJobnames(struct soap *soap, const char *tag, struct __ns1__getAllJobnames *a, const char *type)
{
	short soap_flag_ns1__getAllJobnames = 1;
	short soap_flag;
	a = (struct __ns1__getAllJobnames *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getAllJobnames, sizeof(struct __ns1__getAllJobnames), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getAllJobnames(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getAllJobnames && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getAllJobnames(soap, "ns1:getAllJobnames", &a->ns1__getAllJobnames, ""))
				{	soap_flag_ns1__getAllJobnames--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getDN(struct soap *soap, struct __ns1__getDN *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getDN = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getDN(struct soap *soap, const struct __ns1__getDN *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getDN(soap, &a->ns1__getDN);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getDN(struct soap *soap, const struct __ns1__getDN *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getDN(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getDN(struct soap *soap, const char *tag, int id, const struct __ns1__getDN *a, const char *type)
{
	soap_out_PointerTo_ns1__getDN(soap, "ns1:getDN", -1, &a->ns1__getDN, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getDN * SOAP_FMAC4 soap_get___ns1__getDN(struct soap *soap, struct __ns1__getDN *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getDN(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getDN * SOAP_FMAC4 soap_in___ns1__getDN(struct soap *soap, const char *tag, struct __ns1__getDN *a, const char *type)
{
	short soap_flag_ns1__getDN = 1;
	short soap_flag;
	a = (struct __ns1__getDN *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getDN, sizeof(struct __ns1__getDN), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getDN(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getDN && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getDN(soap, "ns1:getDN", &a->ns1__getDN, ""))
				{	soap_flag_ns1__getDN--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getSubmissionLocationsForApplication(struct soap *soap, struct __ns1__getSubmissionLocationsForApplication *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getSubmissionLocationsForApplication = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getSubmissionLocationsForApplication(struct soap *soap, const struct __ns1__getSubmissionLocationsForApplication *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication(soap, &a->ns1__getSubmissionLocationsForApplication);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getSubmissionLocationsForApplication(struct soap *soap, const struct __ns1__getSubmissionLocationsForApplication *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getSubmissionLocationsForApplication(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getSubmissionLocationsForApplication(struct soap *soap, const char *tag, int id, const struct __ns1__getSubmissionLocationsForApplication *a, const char *type)
{
	soap_out_PointerTo_ns1__getSubmissionLocationsForApplication(soap, "ns1:getSubmissionLocationsForApplication", -1, &a->ns1__getSubmissionLocationsForApplication, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getSubmissionLocationsForApplication * SOAP_FMAC4 soap_get___ns1__getSubmissionLocationsForApplication(struct soap *soap, struct __ns1__getSubmissionLocationsForApplication *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getSubmissionLocationsForApplication(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getSubmissionLocationsForApplication * SOAP_FMAC4 soap_in___ns1__getSubmissionLocationsForApplication(struct soap *soap, const char *tag, struct __ns1__getSubmissionLocationsForApplication *a, const char *type)
{
	short soap_flag_ns1__getSubmissionLocationsForApplication = 1;
	short soap_flag;
	a = (struct __ns1__getSubmissionLocationsForApplication *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getSubmissionLocationsForApplication, sizeof(struct __ns1__getSubmissionLocationsForApplication), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getSubmissionLocationsForApplication(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getSubmissionLocationsForApplication && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getSubmissionLocationsForApplication(soap, "ns1:getSubmissionLocationsForApplication", &a->ns1__getSubmissionLocationsForApplication, ""))
				{	soap_flag_ns1__getSubmissionLocationsForApplication--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__createJob1(struct soap *soap, struct __ns1__createJob1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__createJob1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__createJob1(struct soap *soap, const struct __ns1__createJob1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__createJob1(soap, &a->ns1__createJob1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__createJob1(struct soap *soap, const struct __ns1__createJob1 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__createJob1(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__createJob1(struct soap *soap, const char *tag, int id, const struct __ns1__createJob1 *a, const char *type)
{
	soap_out_PointerTo_ns1__createJob1(soap, "ns1:createJob1", -1, &a->ns1__createJob1, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__createJob1 * SOAP_FMAC4 soap_get___ns1__createJob1(struct soap *soap, struct __ns1__createJob1 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__createJob1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__createJob1 * SOAP_FMAC4 soap_in___ns1__createJob1(struct soap *soap, const char *tag, struct __ns1__createJob1 *a, const char *type)
{
	short soap_flag_ns1__createJob1 = 1;
	short soap_flag;
	a = (struct __ns1__createJob1 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__createJob1, sizeof(struct __ns1__createJob1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__createJob1(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__createJob1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__createJob1(soap, "ns1:createJob1", &a->ns1__createJob1, ""))
				{	soap_flag_ns1__createJob1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getApplicationDetails(struct soap *soap, struct __ns1__getApplicationDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getApplicationDetails = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getApplicationDetails(struct soap *soap, const struct __ns1__getApplicationDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getApplicationDetails(soap, &a->ns1__getApplicationDetails);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getApplicationDetails(struct soap *soap, const struct __ns1__getApplicationDetails *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getApplicationDetails(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getApplicationDetails(struct soap *soap, const char *tag, int id, const struct __ns1__getApplicationDetails *a, const char *type)
{
	soap_out_PointerTo_ns1__getApplicationDetails(soap, "ns1:getApplicationDetails", -1, &a->ns1__getApplicationDetails, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getApplicationDetails * SOAP_FMAC4 soap_get___ns1__getApplicationDetails(struct soap *soap, struct __ns1__getApplicationDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getApplicationDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getApplicationDetails * SOAP_FMAC4 soap_in___ns1__getApplicationDetails(struct soap *soap, const char *tag, struct __ns1__getApplicationDetails *a, const char *type)
{
	short soap_flag_ns1__getApplicationDetails = 1;
	short soap_flag;
	a = (struct __ns1__getApplicationDetails *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getApplicationDetails, sizeof(struct __ns1__getApplicationDetails), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getApplicationDetails(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getApplicationDetails && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getApplicationDetails(soap, "ns1:getApplicationDetails", &a->ns1__getApplicationDetails, ""))
				{	soap_flag_ns1__getApplicationDetails--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getSubmissionLocationsForApplication1(struct soap *soap, struct __ns1__getSubmissionLocationsForApplication1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getSubmissionLocationsForApplication1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getSubmissionLocationsForApplication1(struct soap *soap, const struct __ns1__getSubmissionLocationsForApplication1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication1(soap, &a->ns1__getSubmissionLocationsForApplication1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getSubmissionLocationsForApplication1(struct soap *soap, const struct __ns1__getSubmissionLocationsForApplication1 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getSubmissionLocationsForApplication1(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getSubmissionLocationsForApplication1(struct soap *soap, const char *tag, int id, const struct __ns1__getSubmissionLocationsForApplication1 *a, const char *type)
{
	soap_out_PointerTo_ns1__getSubmissionLocationsForApplication1(soap, "ns1:getSubmissionLocationsForApplication1", -1, &a->ns1__getSubmissionLocationsForApplication1, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getSubmissionLocationsForApplication1 * SOAP_FMAC4 soap_get___ns1__getSubmissionLocationsForApplication1(struct soap *soap, struct __ns1__getSubmissionLocationsForApplication1 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getSubmissionLocationsForApplication1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getSubmissionLocationsForApplication1 * SOAP_FMAC4 soap_in___ns1__getSubmissionLocationsForApplication1(struct soap *soap, const char *tag, struct __ns1__getSubmissionLocationsForApplication1 *a, const char *type)
{
	short soap_flag_ns1__getSubmissionLocationsForApplication1 = 1;
	short soap_flag;
	a = (struct __ns1__getSubmissionLocationsForApplication1 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getSubmissionLocationsForApplication1, sizeof(struct __ns1__getSubmissionLocationsForApplication1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getSubmissionLocationsForApplication1(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getSubmissionLocationsForApplication1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getSubmissionLocationsForApplication1(soap, "ns1:getSubmissionLocationsForApplication1", &a->ns1__getSubmissionLocationsForApplication1, ""))
				{	soap_flag_ns1__getSubmissionLocationsForApplication1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__ls_USCOREstring(struct soap *soap, struct __ns1__ls_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__ls_USCOREstring = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__ls_USCOREstring(struct soap *soap, const struct __ns1__ls_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__ls_USCOREstring(soap, &a->ns1__ls_USCOREstring);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__ls_USCOREstring(struct soap *soap, const struct __ns1__ls_USCOREstring *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__ls_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__ls_USCOREstring(struct soap *soap, const char *tag, int id, const struct __ns1__ls_USCOREstring *a, const char *type)
{
	soap_out_PointerTo_ns1__ls_USCOREstring(soap, "ns1:ls_string", -1, &a->ns1__ls_USCOREstring, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__ls_USCOREstring * SOAP_FMAC4 soap_get___ns1__ls_USCOREstring(struct soap *soap, struct __ns1__ls_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__ls_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__ls_USCOREstring * SOAP_FMAC4 soap_in___ns1__ls_USCOREstring(struct soap *soap, const char *tag, struct __ns1__ls_USCOREstring *a, const char *type)
{
	short soap_flag_ns1__ls_USCOREstring = 1;
	short soap_flag;
	a = (struct __ns1__ls_USCOREstring *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__ls_USCOREstring, sizeof(struct __ns1__ls_USCOREstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__ls_USCOREstring(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__ls_USCOREstring && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__ls_USCOREstring(soap, "ns1:ls_string", &a->ns1__ls_USCOREstring, ""))
				{	soap_flag_ns1__ls_USCOREstring--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__calculateAbsoluteJobDirectory(struct soap *soap, struct __ns1__calculateAbsoluteJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__calculateAbsoluteJobDirectory = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__calculateAbsoluteJobDirectory(struct soap *soap, const struct __ns1__calculateAbsoluteJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__calculateAbsoluteJobDirectory(soap, &a->ns1__calculateAbsoluteJobDirectory);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__calculateAbsoluteJobDirectory(struct soap *soap, const struct __ns1__calculateAbsoluteJobDirectory *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__calculateAbsoluteJobDirectory(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__calculateAbsoluteJobDirectory(struct soap *soap, const char *tag, int id, const struct __ns1__calculateAbsoluteJobDirectory *a, const char *type)
{
	soap_out_PointerTo_ns1__calculateAbsoluteJobDirectory(soap, "ns1:calculateAbsoluteJobDirectory", -1, &a->ns1__calculateAbsoluteJobDirectory, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__calculateAbsoluteJobDirectory * SOAP_FMAC4 soap_get___ns1__calculateAbsoluteJobDirectory(struct soap *soap, struct __ns1__calculateAbsoluteJobDirectory *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__calculateAbsoluteJobDirectory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__calculateAbsoluteJobDirectory * SOAP_FMAC4 soap_in___ns1__calculateAbsoluteJobDirectory(struct soap *soap, const char *tag, struct __ns1__calculateAbsoluteJobDirectory *a, const char *type)
{
	short soap_flag_ns1__calculateAbsoluteJobDirectory = 1;
	short soap_flag;
	a = (struct __ns1__calculateAbsoluteJobDirectory *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__calculateAbsoluteJobDirectory, sizeof(struct __ns1__calculateAbsoluteJobDirectory), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__calculateAbsoluteJobDirectory(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__calculateAbsoluteJobDirectory && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__calculateAbsoluteJobDirectory(soap, "ns1:calculateAbsoluteJobDirectory", &a->ns1__calculateAbsoluteJobDirectory, ""))
				{	soap_flag_ns1__calculateAbsoluteJobDirectory--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getMessagesSince(struct soap *soap, struct __ns1__getMessagesSince *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getMessagesSince = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getMessagesSince(struct soap *soap, const struct __ns1__getMessagesSince *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getMessagesSince(soap, &a->ns1__getMessagesSince);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getMessagesSince(struct soap *soap, const struct __ns1__getMessagesSince *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getMessagesSince(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getMessagesSince(struct soap *soap, const char *tag, int id, const struct __ns1__getMessagesSince *a, const char *type)
{
	soap_out_PointerTo_ns1__getMessagesSince(soap, "ns1:getMessagesSince", -1, &a->ns1__getMessagesSince, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getMessagesSince * SOAP_FMAC4 soap_get___ns1__getMessagesSince(struct soap *soap, struct __ns1__getMessagesSince *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getMessagesSince(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getMessagesSince * SOAP_FMAC4 soap_in___ns1__getMessagesSince(struct soap *soap, const char *tag, struct __ns1__getMessagesSince *a, const char *type)
{
	short soap_flag_ns1__getMessagesSince = 1;
	short soap_flag;
	a = (struct __ns1__getMessagesSince *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getMessagesSince, sizeof(struct __ns1__getMessagesSince), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getMessagesSince(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getMessagesSince && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getMessagesSince(soap, "ns1:getMessagesSince", &a->ns1__getMessagesSince, ""))
				{	soap_flag_ns1__getMessagesSince--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__deleteFiles(struct soap *soap, struct __ns1__deleteFiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__deleteFiles = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__deleteFiles(struct soap *soap, const struct __ns1__deleteFiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__deleteFiles(soap, &a->ns1__deleteFiles);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__deleteFiles(struct soap *soap, const struct __ns1__deleteFiles *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__deleteFiles(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__deleteFiles(struct soap *soap, const char *tag, int id, const struct __ns1__deleteFiles *a, const char *type)
{
	soap_out_PointerTo_ns1__deleteFiles(soap, "ns1:deleteFiles", -1, &a->ns1__deleteFiles, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__deleteFiles * SOAP_FMAC4 soap_get___ns1__deleteFiles(struct soap *soap, struct __ns1__deleteFiles *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__deleteFiles(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__deleteFiles * SOAP_FMAC4 soap_in___ns1__deleteFiles(struct soap *soap, const char *tag, struct __ns1__deleteFiles *a, const char *type)
{
	short soap_flag_ns1__deleteFiles = 1;
	short soap_flag;
	a = (struct __ns1__deleteFiles *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__deleteFiles, sizeof(struct __ns1__deleteFiles), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__deleteFiles(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__deleteFiles && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__deleteFiles(soap, "ns1:deleteFiles", &a->ns1__deleteFiles, ""))
				{	soap_flag_ns1__deleteFiles--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__listHostedApplicationTemplates(struct soap *soap, struct __ns1__listHostedApplicationTemplates *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__listHostedApplicationTemplates = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__listHostedApplicationTemplates(struct soap *soap, const struct __ns1__listHostedApplicationTemplates *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__listHostedApplicationTemplates(soap, &a->ns1__listHostedApplicationTemplates);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__listHostedApplicationTemplates(struct soap *soap, const struct __ns1__listHostedApplicationTemplates *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__listHostedApplicationTemplates(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__listHostedApplicationTemplates(struct soap *soap, const char *tag, int id, const struct __ns1__listHostedApplicationTemplates *a, const char *type)
{
	soap_out_PointerTo_ns1__listHostedApplicationTemplates(soap, "ns1:listHostedApplicationTemplates", -1, &a->ns1__listHostedApplicationTemplates, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__listHostedApplicationTemplates * SOAP_FMAC4 soap_get___ns1__listHostedApplicationTemplates(struct soap *soap, struct __ns1__listHostedApplicationTemplates *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__listHostedApplicationTemplates(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__listHostedApplicationTemplates * SOAP_FMAC4 soap_in___ns1__listHostedApplicationTemplates(struct soap *soap, const char *tag, struct __ns1__listHostedApplicationTemplates *a, const char *type)
{
	short soap_flag_ns1__listHostedApplicationTemplates = 1;
	short soap_flag;
	a = (struct __ns1__listHostedApplicationTemplates *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__listHostedApplicationTemplates, sizeof(struct __ns1__listHostedApplicationTemplates), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__listHostedApplicationTemplates(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__listHostedApplicationTemplates && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__listHostedApplicationTemplates(soap, "ns1:listHostedApplicationTemplates", &a->ns1__listHostedApplicationTemplates, ""))
				{	soap_flag_ns1__listHostedApplicationTemplates--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__downloadByteArray1(struct soap *soap, struct __ns1__downloadByteArray1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__downloadByteArray1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__downloadByteArray1(struct soap *soap, const struct __ns1__downloadByteArray1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__downloadByteArray1(soap, &a->ns1__downloadByteArray1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__downloadByteArray1(struct soap *soap, const struct __ns1__downloadByteArray1 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__downloadByteArray1(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__downloadByteArray1(struct soap *soap, const char *tag, int id, const struct __ns1__downloadByteArray1 *a, const char *type)
{
	soap_out_PointerTo_ns1__downloadByteArray1(soap, "ns1:downloadByteArray1", -1, &a->ns1__downloadByteArray1, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__downloadByteArray1 * SOAP_FMAC4 soap_get___ns1__downloadByteArray1(struct soap *soap, struct __ns1__downloadByteArray1 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__downloadByteArray1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__downloadByteArray1 * SOAP_FMAC4 soap_in___ns1__downloadByteArray1(struct soap *soap, const char *tag, struct __ns1__downloadByteArray1 *a, const char *type)
{
	short soap_flag_ns1__downloadByteArray1 = 1;
	short soap_flag;
	a = (struct __ns1__downloadByteArray1 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__downloadByteArray1, sizeof(struct __ns1__downloadByteArray1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__downloadByteArray1(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__downloadByteArray1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__downloadByteArray1(soap, "ns1:downloadByteArray1", &a->ns1__downloadByteArray1, ""))
				{	soap_flag_ns1__downloadByteArray1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getTemplate1(struct soap *soap, struct __ns1__getTemplate1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getTemplate1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getTemplate1(struct soap *soap, const struct __ns1__getTemplate1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getTemplate1(soap, &a->ns1__getTemplate1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getTemplate1(struct soap *soap, const struct __ns1__getTemplate1 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getTemplate1(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getTemplate1(struct soap *soap, const char *tag, int id, const struct __ns1__getTemplate1 *a, const char *type)
{
	soap_out_PointerTo_ns1__getTemplate1(soap, "ns1:getTemplate1", -1, &a->ns1__getTemplate1, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getTemplate1 * SOAP_FMAC4 soap_get___ns1__getTemplate1(struct soap *soap, struct __ns1__getTemplate1 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getTemplate1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getTemplate1 * SOAP_FMAC4 soap_in___ns1__getTemplate1(struct soap *soap, const char *tag, struct __ns1__getTemplate1 *a, const char *type)
{
	short soap_flag_ns1__getTemplate1 = 1;
	short soap_flag;
	a = (struct __ns1__getTemplate1 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getTemplate1, sizeof(struct __ns1__getTemplate1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getTemplate1(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getTemplate1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getTemplate1(soap, "ns1:getTemplate1", &a->ns1__getTemplate1, ""))
				{	soap_flag_ns1__getTemplate1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, struct __ns1__getSubmissionLocationsPerVersionOfApplication *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getSubmissionLocationsPerVersionOfApplication = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, const struct __ns1__getSubmissionLocationsPerVersionOfApplication *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication(soap, &a->ns1__getSubmissionLocationsPerVersionOfApplication);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, const struct __ns1__getSubmissionLocationsPerVersionOfApplication *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getSubmissionLocationsPerVersionOfApplication(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, const char *tag, int id, const struct __ns1__getSubmissionLocationsPerVersionOfApplication *a, const char *type)
{
	soap_out_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication(soap, "ns1:getSubmissionLocationsPerVersionOfApplication", -1, &a->ns1__getSubmissionLocationsPerVersionOfApplication, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getSubmissionLocationsPerVersionOfApplication * SOAP_FMAC4 soap_get___ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, struct __ns1__getSubmissionLocationsPerVersionOfApplication *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getSubmissionLocationsPerVersionOfApplication(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getSubmissionLocationsPerVersionOfApplication * SOAP_FMAC4 soap_in___ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, const char *tag, struct __ns1__getSubmissionLocationsPerVersionOfApplication *a, const char *type)
{
	short soap_flag_ns1__getSubmissionLocationsPerVersionOfApplication = 1;
	short soap_flag;
	a = (struct __ns1__getSubmissionLocationsPerVersionOfApplication *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getSubmissionLocationsPerVersionOfApplication, sizeof(struct __ns1__getSubmissionLocationsPerVersionOfApplication), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getSubmissionLocationsPerVersionOfApplication(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getSubmissionLocationsPerVersionOfApplication && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getSubmissionLocationsPerVersionOfApplication(soap, "ns1:getSubmissionLocationsPerVersionOfApplication", &a->ns1__getSubmissionLocationsPerVersionOfApplication, ""))
				{	soap_flag_ns1__getSubmissionLocationsPerVersionOfApplication--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getDataLocationsForVO(struct soap *soap, struct __ns1__getDataLocationsForVO *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getDataLocationsForVO = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getDataLocationsForVO(struct soap *soap, const struct __ns1__getDataLocationsForVO *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getDataLocationsForVO(soap, &a->ns1__getDataLocationsForVO);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getDataLocationsForVO(struct soap *soap, const struct __ns1__getDataLocationsForVO *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getDataLocationsForVO(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getDataLocationsForVO(struct soap *soap, const char *tag, int id, const struct __ns1__getDataLocationsForVO *a, const char *type)
{
	soap_out_PointerTo_ns1__getDataLocationsForVO(soap, "ns1:getDataLocationsForVO", -1, &a->ns1__getDataLocationsForVO, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getDataLocationsForVO * SOAP_FMAC4 soap_get___ns1__getDataLocationsForVO(struct soap *soap, struct __ns1__getDataLocationsForVO *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getDataLocationsForVO(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getDataLocationsForVO * SOAP_FMAC4 soap_in___ns1__getDataLocationsForVO(struct soap *soap, const char *tag, struct __ns1__getDataLocationsForVO *a, const char *type)
{
	short soap_flag_ns1__getDataLocationsForVO = 1;
	short soap_flag;
	a = (struct __ns1__getDataLocationsForVO *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getDataLocationsForVO, sizeof(struct __ns1__getDataLocationsForVO), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getDataLocationsForVO(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getDataLocationsForVO && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getDataLocationsForVO(soap, "ns1:getDataLocationsForVO", &a->ns1__getDataLocationsForVO, ""))
				{	soap_flag_ns1__getDataLocationsForVO--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__mkdir(struct soap *soap, struct __ns1__mkdir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__mkdir = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__mkdir(struct soap *soap, const struct __ns1__mkdir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__mkdir(soap, &a->ns1__mkdir);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__mkdir(struct soap *soap, const struct __ns1__mkdir *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__mkdir(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__mkdir(struct soap *soap, const char *tag, int id, const struct __ns1__mkdir *a, const char *type)
{
	soap_out_PointerTo_ns1__mkdir(soap, "ns1:mkdir", -1, &a->ns1__mkdir, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__mkdir * SOAP_FMAC4 soap_get___ns1__mkdir(struct soap *soap, struct __ns1__mkdir *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__mkdir(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__mkdir * SOAP_FMAC4 soap_in___ns1__mkdir(struct soap *soap, const char *tag, struct __ns1__mkdir *a, const char *type)
{
	short soap_flag_ns1__mkdir = 1;
	short soap_flag;
	a = (struct __ns1__mkdir *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__mkdir, sizeof(struct __ns1__mkdir), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__mkdir(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__mkdir && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__mkdir(soap, "ns1:mkdir", &a->ns1__mkdir, ""))
				{	soap_flag_ns1__mkdir--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getUserProperty(struct soap *soap, struct __ns1__getUserProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getUserProperty = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getUserProperty(struct soap *soap, const struct __ns1__getUserProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getUserProperty(soap, &a->ns1__getUserProperty);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getUserProperty(struct soap *soap, const struct __ns1__getUserProperty *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getUserProperty(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getUserProperty(struct soap *soap, const char *tag, int id, const struct __ns1__getUserProperty *a, const char *type)
{
	soap_out_PointerTo_ns1__getUserProperty(soap, "ns1:getUserProperty", -1, &a->ns1__getUserProperty, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getUserProperty * SOAP_FMAC4 soap_get___ns1__getUserProperty(struct soap *soap, struct __ns1__getUserProperty *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getUserProperty(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getUserProperty * SOAP_FMAC4 soap_in___ns1__getUserProperty(struct soap *soap, const char *tag, struct __ns1__getUserProperty *a, const char *type)
{
	short soap_flag_ns1__getUserProperty = 1;
	short soap_flag;
	a = (struct __ns1__getUserProperty *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getUserProperty, sizeof(struct __ns1__getUserProperty), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getUserProperty(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getUserProperty && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getUserProperty(soap, "ns1:getUserProperty", &a->ns1__getUserProperty, ""))
				{	soap_flag_ns1__getUserProperty--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, struct __ns1__getStagingFileSystemForSubmissionLocation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getStagingFileSystemForSubmissionLocation = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, const struct __ns1__getStagingFileSystemForSubmissionLocation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getStagingFileSystemForSubmissionLocation(soap, &a->ns1__getStagingFileSystemForSubmissionLocation);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, const struct __ns1__getStagingFileSystemForSubmissionLocation *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getStagingFileSystemForSubmissionLocation(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, const char *tag, int id, const struct __ns1__getStagingFileSystemForSubmissionLocation *a, const char *type)
{
	soap_out_PointerTo_ns1__getStagingFileSystemForSubmissionLocation(soap, "ns1:getStagingFileSystemForSubmissionLocation", -1, &a->ns1__getStagingFileSystemForSubmissionLocation, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getStagingFileSystemForSubmissionLocation * SOAP_FMAC4 soap_get___ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, struct __ns1__getStagingFileSystemForSubmissionLocation *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getStagingFileSystemForSubmissionLocation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getStagingFileSystemForSubmissionLocation * SOAP_FMAC4 soap_in___ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, const char *tag, struct __ns1__getStagingFileSystemForSubmissionLocation *a, const char *type)
{
	short soap_flag_ns1__getStagingFileSystemForSubmissionLocation = 1;
	short soap_flag;
	a = (struct __ns1__getStagingFileSystemForSubmissionLocation *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getStagingFileSystemForSubmissionLocation, sizeof(struct __ns1__getStagingFileSystemForSubmissionLocation), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getStagingFileSystemForSubmissionLocation(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getStagingFileSystemForSubmissionLocation && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getStagingFileSystemForSubmissionLocation(soap, "ns1:getStagingFileSystemForSubmissionLocation", &a->ns1__getStagingFileSystemForSubmissionLocation, ""))
				{	soap_flag_ns1__getStagingFileSystemForSubmissionLocation--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__ps(struct soap *soap, struct __ns1__ps *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__ps = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__ps(struct soap *soap, const struct __ns1__ps *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__ps(soap, &a->ns1__ps);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__ps(struct soap *soap, const struct __ns1__ps *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__ps(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__ps(struct soap *soap, const char *tag, int id, const struct __ns1__ps *a, const char *type)
{
	soap_out_PointerTo_ns1__ps(soap, "ns1:ps", -1, &a->ns1__ps, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__ps * SOAP_FMAC4 soap_get___ns1__ps(struct soap *soap, struct __ns1__ps *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__ps(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__ps * SOAP_FMAC4 soap_in___ns1__ps(struct soap *soap, const char *tag, struct __ns1__ps *a, const char *type)
{
	short soap_flag_ns1__ps = 1;
	short soap_flag;
	a = (struct __ns1__ps *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__ps, sizeof(struct __ns1__ps), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__ps(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__ps && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__ps(soap, "ns1:ps", &a->ns1__ps, ""))
				{	soap_flag_ns1__ps--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getSubmissionLocationsForApplication2(struct soap *soap, struct __ns1__getSubmissionLocationsForApplication2 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getSubmissionLocationsForApplication2 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getSubmissionLocationsForApplication2(struct soap *soap, const struct __ns1__getSubmissionLocationsForApplication2 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication2(soap, &a->ns1__getSubmissionLocationsForApplication2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getSubmissionLocationsForApplication2(struct soap *soap, const struct __ns1__getSubmissionLocationsForApplication2 *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getSubmissionLocationsForApplication2(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getSubmissionLocationsForApplication2(struct soap *soap, const char *tag, int id, const struct __ns1__getSubmissionLocationsForApplication2 *a, const char *type)
{
	soap_out_PointerTo_ns1__getSubmissionLocationsForApplication2(soap, "ns1:getSubmissionLocationsForApplication2", -1, &a->ns1__getSubmissionLocationsForApplication2, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getSubmissionLocationsForApplication2 * SOAP_FMAC4 soap_get___ns1__getSubmissionLocationsForApplication2(struct soap *soap, struct __ns1__getSubmissionLocationsForApplication2 *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getSubmissionLocationsForApplication2(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getSubmissionLocationsForApplication2 * SOAP_FMAC4 soap_in___ns1__getSubmissionLocationsForApplication2(struct soap *soap, const char *tag, struct __ns1__getSubmissionLocationsForApplication2 *a, const char *type)
{
	short soap_flag_ns1__getSubmissionLocationsForApplication2 = 1;
	short soap_flag;
	a = (struct __ns1__getSubmissionLocationsForApplication2 *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getSubmissionLocationsForApplication2, sizeof(struct __ns1__getSubmissionLocationsForApplication2), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getSubmissionLocationsForApplication2(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getSubmissionLocationsForApplication2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getSubmissionLocationsForApplication2(soap, "ns1:getSubmissionLocationsForApplication2", &a->ns1__getSubmissionLocationsForApplication2, ""))
				{	soap_flag_ns1__getSubmissionLocationsForApplication2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__downloadByteArray(struct soap *soap, struct __ns1__downloadByteArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__downloadByteArray = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__downloadByteArray(struct soap *soap, const struct __ns1__downloadByteArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__downloadByteArray(soap, &a->ns1__downloadByteArray);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__downloadByteArray(struct soap *soap, const struct __ns1__downloadByteArray *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__downloadByteArray(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__downloadByteArray(struct soap *soap, const char *tag, int id, const struct __ns1__downloadByteArray *a, const char *type)
{
	soap_out_PointerTo_ns1__downloadByteArray(soap, "ns1:downloadByteArray", -1, &a->ns1__downloadByteArray, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__downloadByteArray * SOAP_FMAC4 soap_get___ns1__downloadByteArray(struct soap *soap, struct __ns1__downloadByteArray *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__downloadByteArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__downloadByteArray * SOAP_FMAC4 soap_in___ns1__downloadByteArray(struct soap *soap, const char *tag, struct __ns1__downloadByteArray *a, const char *type)
{
	short soap_flag_ns1__downloadByteArray = 1;
	short soap_flag;
	a = (struct __ns1__downloadByteArray *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__downloadByteArray, sizeof(struct __ns1__downloadByteArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__downloadByteArray(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__downloadByteArray && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__downloadByteArray(soap, "ns1:downloadByteArray", &a->ns1__downloadByteArray, ""))
				{	soap_flag_ns1__downloadByteArray--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__df(struct soap *soap, struct __ns1__df *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__df = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__df(struct soap *soap, const struct __ns1__df *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__df(soap, &a->ns1__df);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__df(struct soap *soap, const struct __ns1__df *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__df(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__df(struct soap *soap, const char *tag, int id, const struct __ns1__df *a, const char *type)
{
	soap_out_PointerTo_ns1__df(soap, "ns1:df", -1, &a->ns1__df, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__df * SOAP_FMAC4 soap_get___ns1__df(struct soap *soap, struct __ns1__df *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__df(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__df * SOAP_FMAC4 soap_in___ns1__df(struct soap *soap, const char *tag, struct __ns1__df *a, const char *type)
{
	short soap_flag_ns1__df = 1;
	short soap_flag;
	a = (struct __ns1__df *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__df, sizeof(struct __ns1__df), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__df(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__df && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__df(soap, "ns1:df", &a->ns1__df, ""))
				{	soap_flag_ns1__df--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getFqans(struct soap *soap, struct __ns1__getFqans *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getFqans = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getFqans(struct soap *soap, const struct __ns1__getFqans *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getFqans(soap, &a->ns1__getFqans);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getFqans(struct soap *soap, const struct __ns1__getFqans *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getFqans(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getFqans(struct soap *soap, const char *tag, int id, const struct __ns1__getFqans *a, const char *type)
{
	soap_out_PointerTo_ns1__getFqans(soap, "ns1:getFqans", -1, &a->ns1__getFqans, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getFqans * SOAP_FMAC4 soap_get___ns1__getFqans(struct soap *soap, struct __ns1__getFqans *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getFqans(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getFqans * SOAP_FMAC4 soap_in___ns1__getFqans(struct soap *soap, const char *tag, struct __ns1__getFqans *a, const char *type)
{
	short soap_flag_ns1__getFqans = 1;
	short soap_flag;
	a = (struct __ns1__getFqans *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getFqans, sizeof(struct __ns1__getFqans), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getFqans(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getFqans && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getFqans(soap, "ns1:getFqans", &a->ns1__getFqans, ""))
				{	soap_flag_ns1__getFqans--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getTemplate(struct soap *soap, struct __ns1__getTemplate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getTemplate = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getTemplate(struct soap *soap, const struct __ns1__getTemplate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getTemplate(soap, &a->ns1__getTemplate);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getTemplate(struct soap *soap, const struct __ns1__getTemplate *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getTemplate(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getTemplate(struct soap *soap, const char *tag, int id, const struct __ns1__getTemplate *a, const char *type)
{
	soap_out_PointerTo_ns1__getTemplate(soap, "ns1:getTemplate", -1, &a->ns1__getTemplate, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getTemplate * SOAP_FMAC4 soap_get___ns1__getTemplate(struct soap *soap, struct __ns1__getTemplate *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getTemplate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getTemplate * SOAP_FMAC4 soap_in___ns1__getTemplate(struct soap *soap, const char *tag, struct __ns1__getTemplate *a, const char *type)
{
	short soap_flag_ns1__getTemplate = 1;
	short soap_flag;
	a = (struct __ns1__getTemplate *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getTemplate, sizeof(struct __ns1__getTemplate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getTemplate(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getTemplate && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getTemplate(soap, "ns1:getTemplate", &a->ns1__getTemplate, ""))
				{	soap_flag_ns1__getTemplate--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__login(struct soap *soap, struct __ns1__login *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__login = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__login(struct soap *soap, const struct __ns1__login *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__login(soap, &a->ns1__login);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__login(struct soap *soap, const struct __ns1__login *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__login(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__login(struct soap *soap, const char *tag, int id, const struct __ns1__login *a, const char *type)
{
	soap_out_PointerTo_ns1__login(soap, "ns1:login", -1, &a->ns1__login, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__login * SOAP_FMAC4 soap_get___ns1__login(struct soap *soap, struct __ns1__login *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__login(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__login * SOAP_FMAC4 soap_in___ns1__login(struct soap *soap, const char *tag, struct __ns1__login *a, const char *type)
{
	short soap_flag_ns1__login = 1;
	short soap_flag;
	a = (struct __ns1__login *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__login, sizeof(struct __ns1__login), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__login(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__login && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__login(soap, "ns1:login", &a->ns1__login, ""))
				{	soap_flag_ns1__login--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__mount(struct soap *soap, struct __ns1__mount *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__mount = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__mount(struct soap *soap, const struct __ns1__mount *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__mount(soap, &a->ns1__mount);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__mount(struct soap *soap, const struct __ns1__mount *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__mount(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__mount(struct soap *soap, const char *tag, int id, const struct __ns1__mount *a, const char *type)
{
	soap_out_PointerTo_ns1__mount(soap, "ns1:mount", -1, &a->ns1__mount, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__mount * SOAP_FMAC4 soap_get___ns1__mount(struct soap *soap, struct __ns1__mount *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__mount(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__mount * SOAP_FMAC4 soap_in___ns1__mount(struct soap *soap, const char *tag, struct __ns1__mount *a, const char *type)
{
	short soap_flag_ns1__mount = 1;
	short soap_flag;
	a = (struct __ns1__mount *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__mount, sizeof(struct __ns1__mount), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__mount(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__mount && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__mount(soap, "ns1:mount", &a->ns1__mount, ""))
				{	soap_flag_ns1__mount--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getJobFqan(struct soap *soap, struct __ns1__getJobFqan *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getJobFqan = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getJobFqan(struct soap *soap, const struct __ns1__getJobFqan *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getJobFqan(soap, &a->ns1__getJobFqan);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getJobFqan(struct soap *soap, const struct __ns1__getJobFqan *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getJobFqan(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getJobFqan(struct soap *soap, const char *tag, int id, const struct __ns1__getJobFqan *a, const char *type)
{
	soap_out_PointerTo_ns1__getJobFqan(soap, "ns1:getJobFqan", -1, &a->ns1__getJobFqan, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getJobFqan * SOAP_FMAC4 soap_get___ns1__getJobFqan(struct soap *soap, struct __ns1__getJobFqan *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getJobFqan(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getJobFqan * SOAP_FMAC4 soap_in___ns1__getJobFqan(struct soap *soap, const char *tag, struct __ns1__getJobFqan *a, const char *type)
{
	short soap_flag_ns1__getJobFqan = 1;
	short soap_flag;
	a = (struct __ns1__getJobFqan *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getJobFqan, sizeof(struct __ns1__getJobFqan), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getJobFqan(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getJobFqan && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getJobFqan(soap, "ns1:getJobFqan", &a->ns1__getJobFqan, ""))
				{	soap_flag_ns1__getJobFqan--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___ns1__getChildrenFiles(struct soap *soap, struct __ns1__getChildrenFiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__getChildrenFiles = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___ns1__getChildrenFiles(struct soap *soap, const struct __ns1__getChildrenFiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTo_ns1__getChildrenFiles(soap, &a->ns1__getChildrenFiles);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___ns1__getChildrenFiles(struct soap *soap, const struct __ns1__getChildrenFiles *a, const char *tag, const char *type)
{
	register int id = 0;
	if (soap_out___ns1__getChildrenFiles(soap, tag, id, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___ns1__getChildrenFiles(struct soap *soap, const char *tag, int id, const struct __ns1__getChildrenFiles *a, const char *type)
{
	soap_out_PointerTo_ns1__getChildrenFiles(soap, "ns1:getChildrenFiles", -1, &a->ns1__getChildrenFiles, "");
	return SOAP_OK;
}

SOAP_FMAC3 struct __ns1__getChildrenFiles * SOAP_FMAC4 soap_get___ns1__getChildrenFiles(struct soap *soap, struct __ns1__getChildrenFiles *p, const char *tag, const char *type)
{
	if ((p = soap_in___ns1__getChildrenFiles(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct __ns1__getChildrenFiles * SOAP_FMAC4 soap_in___ns1__getChildrenFiles(struct soap *soap, const char *tag, struct __ns1__getChildrenFiles *a, const char *type)
{
	short soap_flag_ns1__getChildrenFiles = 1;
	short soap_flag;
	a = (struct __ns1__getChildrenFiles *)soap_id_enter(soap, "", a, SOAP_TYPE___ns1__getChildrenFiles, sizeof(struct __ns1__getChildrenFiles), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___ns1__getChildrenFiles(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__getChildrenFiles && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTo_ns1__getChildrenFiles(soap, "ns1:getChildrenFiles", &a->ns1__getChildrenFiles, ""))
				{	soap_flag_ns1__getChildrenFiles--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				if (soap_flag)
				{	soap->error = SOAP_OK;
					break;
				}
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->ns1__JobCreationException = NULL;
	a->ns1__JobDescriptionNotValidException = NULL;
	a->ns1__JobSubmissionException = NULL;
	a->ns1__NoSuchJobException = NULL;
	a->ns1__NoSuchTemplateException = NULL;
	a->ns1__NoValidCredentialException = NULL;
	a->ns1__RemoteFileSystemException = NULL;
	a->ns1__VomsException = NULL;
	a->__type = 0;
	a->fault = NULL;
	a->__any = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons4__JobCreationException(soap, &a->ns1__JobCreationException);
	soap_serialize_PointerTons2__JobDescriptionNotValidException(soap, &a->ns1__JobDescriptionNotValidException);
	soap_serialize_PointerTons2__JobSubmissionException(soap, &a->ns1__JobSubmissionException);
	soap_serialize_PointerTons2__NoSuchJobException(soap, &a->ns1__NoSuchJobException);
	soap_serialize_PointerTons2__NoSuchTemplateException(soap, &a->ns1__NoSuchTemplateException);
	soap_serialize_PointerTons2__NoValidCredentialException(soap, &a->ns1__NoValidCredentialException);
	soap_serialize_PointerTons2__RemoteFileSystemException(soap, &a->ns1__RemoteFileSystemException);
	soap_serialize_PointerTons2__VomsException(soap, &a->ns1__VomsException);
	soap_markelement(soap, a->fault, a->__type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Detail);
	if (soap_out_SOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type);
	soap_out_PointerTons4__JobCreationException(soap, "ns1:JobCreationException", -1, &a->ns1__JobCreationException, "");
	soap_out_PointerTons2__JobDescriptionNotValidException(soap, "ns1:JobDescriptionNotValidException", -1, &a->ns1__JobDescriptionNotValidException, "");
	soap_out_PointerTons2__JobSubmissionException(soap, "ns1:JobSubmissionException", -1, &a->ns1__JobSubmissionException, "");
	soap_out_PointerTons2__NoSuchJobException(soap, "ns1:NoSuchJobException", -1, &a->ns1__NoSuchJobException, "");
	soap_out_PointerTons2__NoSuchTemplateException(soap, "ns1:NoSuchTemplateException", -1, &a->ns1__NoSuchTemplateException, "");
	soap_out_PointerTons2__NoValidCredentialException(soap, "ns1:NoValidCredentialException", -1, &a->ns1__NoValidCredentialException, "");
	soap_out_PointerTons2__RemoteFileSystemException(soap, "ns1:RemoteFileSystemException", -1, &a->ns1__RemoteFileSystemException, "");
	soap_out_PointerTons2__VomsException(soap, "ns1:VomsException", -1, &a->ns1__VomsException, "");
	soap_putelement(soap, a->fault, "fault", -1, a->__type);
	soap_outliteral(soap, "-any", &a->__any, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	short soap_flag_ns1__JobCreationException = 1, soap_flag_ns1__JobDescriptionNotValidException = 1, soap_flag_ns1__JobSubmissionException = 1, soap_flag_ns1__NoSuchJobException = 1, soap_flag_ns1__NoSuchTemplateException = 1, soap_flag_ns1__NoValidCredentialException = 1, soap_flag_ns1__RemoteFileSystemException = 1, soap_flag_ns1__VomsException = 1, soap_flag_fault = 1, soap_flag___any = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_ns1__JobCreationException && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons4__JobCreationException(soap, "ns1:JobCreationException", &a->ns1__JobCreationException, "ns4:JobCreationException"))
				{	soap_flag_ns1__JobCreationException--;
					continue;
				}
			if (soap_flag_ns1__JobDescriptionNotValidException && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__JobDescriptionNotValidException(soap, "ns1:JobDescriptionNotValidException", &a->ns1__JobDescriptionNotValidException, "ns2:JobDescriptionNotValidException"))
				{	soap_flag_ns1__JobDescriptionNotValidException--;
					continue;
				}
			if (soap_flag_ns1__JobSubmissionException && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__JobSubmissionException(soap, "ns1:JobSubmissionException", &a->ns1__JobSubmissionException, "ns2:JobSubmissionException"))
				{	soap_flag_ns1__JobSubmissionException--;
					continue;
				}
			if (soap_flag_ns1__NoSuchJobException && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__NoSuchJobException(soap, "ns1:NoSuchJobException", &a->ns1__NoSuchJobException, "ns2:NoSuchJobException"))
				{	soap_flag_ns1__NoSuchJobException--;
					continue;
				}
			if (soap_flag_ns1__NoSuchTemplateException && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__NoSuchTemplateException(soap, "ns1:NoSuchTemplateException", &a->ns1__NoSuchTemplateException, "ns2:NoSuchTemplateException"))
				{	soap_flag_ns1__NoSuchTemplateException--;
					continue;
				}
			if (soap_flag_ns1__NoValidCredentialException && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__NoValidCredentialException(soap, "ns1:NoValidCredentialException", &a->ns1__NoValidCredentialException, "ns2:NoValidCredentialException"))
				{	soap_flag_ns1__NoValidCredentialException--;
					continue;
				}
			if (soap_flag_ns1__RemoteFileSystemException && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteFileSystemException(soap, "ns1:RemoteFileSystemException", &a->ns1__RemoteFileSystemException, "ns2:RemoteFileSystemException"))
				{	soap_flag_ns1__RemoteFileSystemException--;
					continue;
				}
			if (soap_flag_ns1__VomsException && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__VomsException(soap, "ns1:VomsException", &a->ns1__VomsException, "ns2:VomsException"))
				{	soap_flag_ns1__VomsException--;
					continue;
				}
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
				if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "-any", &a->__any))
				{	soap_flag___any--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, 0, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_fault > 1))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__JobCreationException(struct soap *soap, struct ns4__JobCreationException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__JobCreationException(struct soap *soap, const struct ns4__JobCreationException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__JobCreationException(struct soap *soap, const struct ns4__JobCreationException *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__JobCreationException);
	if (soap_out_ns4__JobCreationException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__JobCreationException(struct soap *soap, const char *tag, int id, const struct ns4__JobCreationException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__JobCreationException), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns4__JobCreationException * SOAP_FMAC4 soap_get_ns4__JobCreationException(struct soap *soap, struct ns4__JobCreationException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__JobCreationException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns4__JobCreationException * SOAP_FMAC4 soap_in_ns4__JobCreationException(struct soap *soap, const char *tag, struct ns4__JobCreationException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__JobCreationException *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__JobCreationException, sizeof(struct ns4__JobCreationException), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__JobCreationException(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__JobCreationException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__JobCreationException, 0, sizeof(struct ns4__JobCreationException), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__JobSubmissionException(struct soap *soap, struct ns2__JobSubmissionException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__JobSubmissionException(struct soap *soap, const struct ns2__JobSubmissionException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__JobSubmissionException(struct soap *soap, const struct ns2__JobSubmissionException *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__JobSubmissionException);
	if (soap_out_ns2__JobSubmissionException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__JobSubmissionException(struct soap *soap, const char *tag, int id, const struct ns2__JobSubmissionException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__JobSubmissionException), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns2__JobSubmissionException * SOAP_FMAC4 soap_get_ns2__JobSubmissionException(struct soap *soap, struct ns2__JobSubmissionException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__JobSubmissionException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__JobSubmissionException * SOAP_FMAC4 soap_in_ns2__JobSubmissionException(struct soap *soap, const char *tag, struct ns2__JobSubmissionException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__JobSubmissionException *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__JobSubmissionException, sizeof(struct ns2__JobSubmissionException), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__JobSubmissionException(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__JobSubmissionException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__JobSubmissionException, 0, sizeof(struct ns2__JobSubmissionException), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__JobDescriptionNotValidException(struct soap *soap, struct ns2__JobDescriptionNotValidException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__JobDescriptionNotValidException(struct soap *soap, const struct ns2__JobDescriptionNotValidException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__JobDescriptionNotValidException(struct soap *soap, const struct ns2__JobDescriptionNotValidException *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__JobDescriptionNotValidException);
	if (soap_out_ns2__JobDescriptionNotValidException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__JobDescriptionNotValidException(struct soap *soap, const char *tag, int id, const struct ns2__JobDescriptionNotValidException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__JobDescriptionNotValidException), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns2__JobDescriptionNotValidException * SOAP_FMAC4 soap_get_ns2__JobDescriptionNotValidException(struct soap *soap, struct ns2__JobDescriptionNotValidException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__JobDescriptionNotValidException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__JobDescriptionNotValidException * SOAP_FMAC4 soap_in_ns2__JobDescriptionNotValidException(struct soap *soap, const char *tag, struct ns2__JobDescriptionNotValidException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__JobDescriptionNotValidException *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__JobDescriptionNotValidException, sizeof(struct ns2__JobDescriptionNotValidException), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__JobDescriptionNotValidException(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__JobDescriptionNotValidException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__JobDescriptionNotValidException, 0, sizeof(struct ns2__JobDescriptionNotValidException), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__NoSuchTemplateException(struct soap *soap, struct ns2__NoSuchTemplateException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__NoSuchTemplateException(struct soap *soap, const struct ns2__NoSuchTemplateException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__NoSuchTemplateException(struct soap *soap, const struct ns2__NoSuchTemplateException *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__NoSuchTemplateException);
	if (soap_out_ns2__NoSuchTemplateException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__NoSuchTemplateException(struct soap *soap, const char *tag, int id, const struct ns2__NoSuchTemplateException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__NoSuchTemplateException), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns2__NoSuchTemplateException * SOAP_FMAC4 soap_get_ns2__NoSuchTemplateException(struct soap *soap, struct ns2__NoSuchTemplateException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__NoSuchTemplateException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__NoSuchTemplateException * SOAP_FMAC4 soap_in_ns2__NoSuchTemplateException(struct soap *soap, const char *tag, struct ns2__NoSuchTemplateException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__NoSuchTemplateException *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__NoSuchTemplateException, sizeof(struct ns2__NoSuchTemplateException), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__NoSuchTemplateException(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__NoSuchTemplateException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__NoSuchTemplateException, 0, sizeof(struct ns2__NoSuchTemplateException), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__NoValidCredentialException(struct soap *soap, struct ns2__NoValidCredentialException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__NoValidCredentialException(struct soap *soap, const struct ns2__NoValidCredentialException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__NoValidCredentialException(struct soap *soap, const struct ns2__NoValidCredentialException *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__NoValidCredentialException);
	if (soap_out_ns2__NoValidCredentialException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__NoValidCredentialException(struct soap *soap, const char *tag, int id, const struct ns2__NoValidCredentialException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__NoValidCredentialException), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns2__NoValidCredentialException * SOAP_FMAC4 soap_get_ns2__NoValidCredentialException(struct soap *soap, struct ns2__NoValidCredentialException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__NoValidCredentialException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__NoValidCredentialException * SOAP_FMAC4 soap_in_ns2__NoValidCredentialException(struct soap *soap, const char *tag, struct ns2__NoValidCredentialException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__NoValidCredentialException *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__NoValidCredentialException, sizeof(struct ns2__NoValidCredentialException), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__NoValidCredentialException(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__NoValidCredentialException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__NoValidCredentialException, 0, sizeof(struct ns2__NoValidCredentialException), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__NoSuchJobException(struct soap *soap, struct ns2__NoSuchJobException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__NoSuchJobException(struct soap *soap, const struct ns2__NoSuchJobException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__NoSuchJobException(struct soap *soap, const struct ns2__NoSuchJobException *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__NoSuchJobException);
	if (soap_out_ns2__NoSuchJobException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__NoSuchJobException(struct soap *soap, const char *tag, int id, const struct ns2__NoSuchJobException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__NoSuchJobException), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns2__NoSuchJobException * SOAP_FMAC4 soap_get_ns2__NoSuchJobException(struct soap *soap, struct ns2__NoSuchJobException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__NoSuchJobException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__NoSuchJobException * SOAP_FMAC4 soap_in_ns2__NoSuchJobException(struct soap *soap, const char *tag, struct ns2__NoSuchJobException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__NoSuchJobException *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__NoSuchJobException, sizeof(struct ns2__NoSuchJobException), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__NoSuchJobException(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__NoSuchJobException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__NoSuchJobException, 0, sizeof(struct ns2__NoSuchJobException), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__RemoteFileSystemException(struct soap *soap, struct ns2__RemoteFileSystemException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__RemoteFileSystemException(struct soap *soap, const struct ns2__RemoteFileSystemException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__RemoteFileSystemException(struct soap *soap, const struct ns2__RemoteFileSystemException *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__RemoteFileSystemException);
	if (soap_out_ns2__RemoteFileSystemException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteFileSystemException(struct soap *soap, const char *tag, int id, const struct ns2__RemoteFileSystemException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteFileSystemException), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns2__RemoteFileSystemException * SOAP_FMAC4 soap_get_ns2__RemoteFileSystemException(struct soap *soap, struct ns2__RemoteFileSystemException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteFileSystemException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__RemoteFileSystemException * SOAP_FMAC4 soap_in_ns2__RemoteFileSystemException(struct soap *soap, const char *tag, struct ns2__RemoteFileSystemException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__RemoteFileSystemException *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteFileSystemException, sizeof(struct ns2__RemoteFileSystemException), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__RemoteFileSystemException(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__RemoteFileSystemException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteFileSystemException, 0, sizeof(struct ns2__RemoteFileSystemException), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns2__VomsException(struct soap *soap, struct ns2__VomsException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns2__VomsException(struct soap *soap, const struct ns2__VomsException *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns2__VomsException(struct soap *soap, const struct ns2__VomsException *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns2__VomsException);
	if (soap_out_ns2__VomsException(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__VomsException(struct soap *soap, const char *tag, int id, const struct ns2__VomsException *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__VomsException), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns2__VomsException * SOAP_FMAC4 soap_get_ns2__VomsException(struct soap *soap, struct ns2__VomsException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__VomsException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns2__VomsException * SOAP_FMAC4 soap_in_ns2__VomsException(struct soap *soap, const char *tag, struct ns2__VomsException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns2__VomsException *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__VomsException, sizeof(struct ns2__VomsException), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns2__VomsException(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns2__VomsException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__VomsException, 0, sizeof(struct ns2__VomsException), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllHostsResponse(struct soap *soap, struct _ns1__getAllHostsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllHostsResponse(struct soap *soap, const struct _ns1__getAllHostsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__anyType2anyTypeMap(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllHostsResponse(struct soap *soap, const struct _ns1__getAllHostsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllHostsResponse);
	if (soap_out__ns1__getAllHostsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllHostsResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getAllHostsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllHostsResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllHostsResponse * SOAP_FMAC4 soap_get__ns1__getAllHostsResponse(struct soap *soap, struct _ns1__getAllHostsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllHostsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllHostsResponse * SOAP_FMAC4 soap_in__ns1__getAllHostsResponse(struct soap *soap, const char *tag, struct _ns1__getAllHostsResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllHostsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllHostsResponse, sizeof(struct _ns1__getAllHostsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllHostsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", &a->out, "ns1:anyType2anyTypeMap"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllHostsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllHostsResponse, 0, sizeof(struct _ns1__getAllHostsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllHosts(struct soap *soap, struct _ns1__getAllHosts *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllHosts(struct soap *soap, const struct _ns1__getAllHosts *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllHosts(struct soap *soap, const struct _ns1__getAllHosts *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllHosts);
	if (soap_out__ns1__getAllHosts(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllHosts(struct soap *soap, const char *tag, int id, const struct _ns1__getAllHosts *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllHosts), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllHosts * SOAP_FMAC4 soap_get__ns1__getAllHosts(struct soap *soap, struct _ns1__getAllHosts *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllHosts(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllHosts * SOAP_FMAC4 soap_in__ns1__getAllHosts(struct soap *soap, const char *tag, struct _ns1__getAllHosts *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllHosts *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllHosts, sizeof(struct _ns1__getAllHosts), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllHosts(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllHosts *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllHosts, 0, sizeof(struct _ns1__getAllHosts), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__submitSupportRequestResponse(struct soap *soap, struct _ns1__submitSupportRequestResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__submitSupportRequestResponse(struct soap *soap, const struct _ns1__submitSupportRequestResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__submitSupportRequestResponse(struct soap *soap, const struct _ns1__submitSupportRequestResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__submitSupportRequestResponse);
	if (soap_out__ns1__submitSupportRequestResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__submitSupportRequestResponse(struct soap *soap, const char *tag, int id, const struct _ns1__submitSupportRequestResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__submitSupportRequestResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__submitSupportRequestResponse * SOAP_FMAC4 soap_get__ns1__submitSupportRequestResponse(struct soap *soap, struct _ns1__submitSupportRequestResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__submitSupportRequestResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__submitSupportRequestResponse * SOAP_FMAC4 soap_in__ns1__submitSupportRequestResponse(struct soap *soap, const char *tag, struct _ns1__submitSupportRequestResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__submitSupportRequestResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__submitSupportRequestResponse, sizeof(struct _ns1__submitSupportRequestResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__submitSupportRequestResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__submitSupportRequestResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__submitSupportRequestResponse, 0, sizeof(struct _ns1__submitSupportRequestResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__submitSupportRequest(struct soap *soap, struct _ns1__submitSupportRequest *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__submitSupportRequest(struct soap *soap, const struct _ns1__submitSupportRequest *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__submitSupportRequest(struct soap *soap, const struct _ns1__submitSupportRequest *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__submitSupportRequest);
	if (soap_out__ns1__submitSupportRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__submitSupportRequest(struct soap *soap, const char *tag, int id, const struct _ns1__submitSupportRequest *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__submitSupportRequest), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__submitSupportRequest * SOAP_FMAC4 soap_get__ns1__submitSupportRequest(struct soap *soap, struct _ns1__submitSupportRequest *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__submitSupportRequest(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__submitSupportRequest * SOAP_FMAC4 soap_in__ns1__submitSupportRequest(struct soap *soap, const char *tag, struct _ns1__submitSupportRequest *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__submitSupportRequest *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__submitSupportRequest, sizeof(struct _ns1__submitSupportRequest), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__submitSupportRequest(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__submitSupportRequest *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__submitSupportRequest, 0, sizeof(struct _ns1__submitSupportRequest), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobPropertyResponse(struct soap *soap, struct _ns1__getJobPropertyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobPropertyResponse(struct soap *soap, const struct _ns1__getJobPropertyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobPropertyResponse(struct soap *soap, const struct _ns1__getJobPropertyResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobPropertyResponse);
	if (soap_out__ns1__getJobPropertyResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobPropertyResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getJobPropertyResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobPropertyResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobPropertyResponse * SOAP_FMAC4 soap_get__ns1__getJobPropertyResponse(struct soap *soap, struct _ns1__getJobPropertyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobPropertyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobPropertyResponse * SOAP_FMAC4 soap_in__ns1__getJobPropertyResponse(struct soap *soap, const char *tag, struct _ns1__getJobPropertyResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobPropertyResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobPropertyResponse, sizeof(struct _ns1__getJobPropertyResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobPropertyResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobPropertyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobPropertyResponse, 0, sizeof(struct _ns1__getJobPropertyResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobProperty(struct soap *soap, struct _ns1__getJobProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobProperty(struct soap *soap, const struct _ns1__getJobProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobProperty(struct soap *soap, const struct _ns1__getJobProperty *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobProperty);
	if (soap_out__ns1__getJobProperty(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobProperty(struct soap *soap, const char *tag, int id, const struct _ns1__getJobProperty *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobProperty), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobProperty * SOAP_FMAC4 soap_get__ns1__getJobProperty(struct soap *soap, struct _ns1__getJobProperty *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobProperty(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobProperty * SOAP_FMAC4 soap_in__ns1__getJobProperty(struct soap *soap, const char *tag, struct _ns1__getJobProperty *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobProperty *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobProperty, sizeof(struct _ns1__getJobProperty), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobProperty(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobProperty *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobProperty, 0, sizeof(struct _ns1__getJobProperty), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__mount1Response(struct soap *soap, struct _ns1__mount1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__mount1Response(struct soap *soap, const struct _ns1__mount1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons3__MountPoint(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__mount1Response(struct soap *soap, const struct _ns1__mount1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__mount1Response);
	if (soap_out__ns1__mount1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__mount1Response(struct soap *soap, const char *tag, int id, const struct _ns1__mount1Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__mount1Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons3__MountPoint(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__mount1Response * SOAP_FMAC4 soap_get__ns1__mount1Response(struct soap *soap, struct _ns1__mount1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__mount1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__mount1Response * SOAP_FMAC4 soap_in__ns1__mount1Response(struct soap *soap, const char *tag, struct _ns1__mount1Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__mount1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__mount1Response, sizeof(struct _ns1__mount1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__mount1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons3__MountPoint(soap, "ns1:out", &a->out, "ns3:MountPoint"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__mount1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__mount1Response, 0, sizeof(struct _ns1__mount1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__mount1(struct soap *soap, struct _ns1__mount1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
	soap_default_string(soap, &a->in2);
	soap_default_xsd__boolean(soap, &a->in3);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__mount1(struct soap *soap, const struct _ns1__mount1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_serialize_string(soap, &a->in2);
	soap_embedded(soap, &a->in3, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__mount1(struct soap *soap, const struct _ns1__mount1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__mount1);
	if (soap_out__ns1__mount1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__mount1(struct soap *soap, const char *tag, int id, const struct _ns1__mount1 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__mount1), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_string(soap, "ns1:in2", -1, &a->in2, "");
	soap_out_xsd__boolean(soap, "ns1:in3", -1, &a->in3, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__mount1 * SOAP_FMAC4 soap_get__ns1__mount1(struct soap *soap, struct _ns1__mount1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__mount1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__mount1 * SOAP_FMAC4 soap_in__ns1__mount1(struct soap *soap, const char *tag, struct _ns1__mount1 *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1, soap_flag_in3 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__mount1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__mount1, sizeof(struct _ns1__mount1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__mount1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in2", &a->in2, "xsd:string"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap_flag_in3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in3", &a->in3, "xsd:boolean"))
				{	soap_flag_in3--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__mount1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__mount1, 0, sizeof(struct _ns1__mount1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0 || soap_flag_in3 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobDetailsResponse(struct soap *soap, struct _ns1__getJobDetailsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobDetailsResponse(struct soap *soap, const struct _ns1__getJobDetailsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobDetailsResponse(struct soap *soap, const struct _ns1__getJobDetailsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobDetailsResponse);
	if (soap_out__ns1__getJobDetailsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobDetailsResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getJobDetailsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobDetailsResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_outliteral(soap, "ns1:out", &a->out, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobDetailsResponse * SOAP_FMAC4 soap_get__ns1__getJobDetailsResponse(struct soap *soap, struct _ns1__getJobDetailsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobDetailsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDetailsResponse * SOAP_FMAC4 soap_in__ns1__getJobDetailsResponse(struct soap *soap, const char *tag, struct _ns1__getJobDetailsResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobDetailsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobDetailsResponse, sizeof(struct _ns1__getJobDetailsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobDetailsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:out", &a->out))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDetailsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobDetailsResponse, 0, sizeof(struct _ns1__getJobDetailsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobDetails(struct soap *soap, struct _ns1__getJobDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobDetails(struct soap *soap, const struct _ns1__getJobDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobDetails(struct soap *soap, const struct _ns1__getJobDetails *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobDetails);
	if (soap_out__ns1__getJobDetails(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobDetails(struct soap *soap, const char *tag, int id, const struct _ns1__getJobDetails *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobDetails), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobDetails * SOAP_FMAC4 soap_get__ns1__getJobDetails(struct soap *soap, struct _ns1__getJobDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDetails * SOAP_FMAC4 soap_in__ns1__getJobDetails(struct soap *soap, const char *tag, struct _ns1__getJobDetails *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobDetails *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobDetails, sizeof(struct _ns1__getJobDetails), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobDetails(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDetails *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobDetails, 0, sizeof(struct _ns1__getJobDetails), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__umountResponse(struct soap *soap, struct _ns1__umountResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__umountResponse(struct soap *soap, const struct _ns1__umountResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__umountResponse(struct soap *soap, const struct _ns1__umountResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__umountResponse);
	if (soap_out__ns1__umountResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__umountResponse(struct soap *soap, const char *tag, int id, const struct _ns1__umountResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__umountResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__umountResponse * SOAP_FMAC4 soap_get__ns1__umountResponse(struct soap *soap, struct _ns1__umountResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__umountResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__umountResponse * SOAP_FMAC4 soap_in__ns1__umountResponse(struct soap *soap, const char *tag, struct _ns1__umountResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__umountResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__umountResponse, sizeof(struct _ns1__umountResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__umountResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__umountResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__umountResponse, 0, sizeof(struct _ns1__umountResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__umount(struct soap *soap, struct _ns1__umount *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__umount(struct soap *soap, const struct _ns1__umount *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__umount(struct soap *soap, const struct _ns1__umount *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__umount);
	if (soap_out__ns1__umount(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__umount(struct soap *soap, const char *tag, int id, const struct _ns1__umount *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__umount), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__umount * SOAP_FMAC4 soap_get__ns1__umount(struct soap *soap, struct _ns1__umount *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__umount(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__umount * SOAP_FMAC4 soap_in__ns1__umount(struct soap *soap, const char *tag, struct _ns1__umount *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__umount *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__umount, sizeof(struct _ns1__umount), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__umount(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__umount *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__umount, 0, sizeof(struct _ns1__umount), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobStatusResponse(struct soap *soap, struct _ns1__getJobStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_int(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobStatusResponse(struct soap *soap, const struct _ns1__getJobStatusResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobStatusResponse(struct soap *soap, const struct _ns1__getJobStatusResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobStatusResponse);
	if (soap_out__ns1__getJobStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobStatusResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getJobStatusResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobStatusResponse), type);
	soap_element_result(soap, "ns1:out");
	soap_out_int(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobStatusResponse * SOAP_FMAC4 soap_get__ns1__getJobStatusResponse(struct soap *soap, struct _ns1__getJobStatusResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobStatusResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobStatusResponse * SOAP_FMAC4 soap_in__ns1__getJobStatusResponse(struct soap *soap, const char *tag, struct _ns1__getJobStatusResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobStatusResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobStatusResponse, sizeof(struct _ns1__getJobStatusResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobStatusResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:out", &a->out, "xsd:int"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobStatusResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobStatusResponse, 0, sizeof(struct _ns1__getJobStatusResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobStatus(struct soap *soap, struct _ns1__getJobStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobStatus(struct soap *soap, const struct _ns1__getJobStatus *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobStatus(struct soap *soap, const struct _ns1__getJobStatus *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobStatus);
	if (soap_out__ns1__getJobStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobStatus(struct soap *soap, const char *tag, int id, const struct _ns1__getJobStatus *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobStatus), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobStatus * SOAP_FMAC4 soap_get__ns1__getJobStatus(struct soap *soap, struct _ns1__getJobStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobStatus * SOAP_FMAC4 soap_in__ns1__getJobStatus(struct soap *soap, const char *tag, struct _ns1__getJobStatus *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobStatus *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobStatus, sizeof(struct _ns1__getJobStatus), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobStatus(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobStatus, 0, sizeof(struct _ns1__getJobStatus), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobDetails_USCOREstringResponse(struct soap *soap, struct _ns1__getJobDetails_USCOREstringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobDetails_USCOREstringResponse(struct soap *soap, const struct _ns1__getJobDetails_USCOREstringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobDetails_USCOREstringResponse(struct soap *soap, const struct _ns1__getJobDetails_USCOREstringResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse);
	if (soap_out__ns1__getJobDetails_USCOREstringResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobDetails_USCOREstringResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getJobDetails_USCOREstringResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobDetails_USCOREstringResponse * SOAP_FMAC4 soap_get__ns1__getJobDetails_USCOREstringResponse(struct soap *soap, struct _ns1__getJobDetails_USCOREstringResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobDetails_USCOREstringResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDetails_USCOREstringResponse * SOAP_FMAC4 soap_in__ns1__getJobDetails_USCOREstringResponse(struct soap *soap, const char *tag, struct _ns1__getJobDetails_USCOREstringResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobDetails_USCOREstringResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse, sizeof(struct _ns1__getJobDetails_USCOREstringResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobDetails_USCOREstringResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDetails_USCOREstringResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse, 0, sizeof(struct _ns1__getJobDetails_USCOREstringResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobDetails_USCOREstring(struct soap *soap, struct _ns1__getJobDetails_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobDetails_USCOREstring(struct soap *soap, const struct _ns1__getJobDetails_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobDetails_USCOREstring(struct soap *soap, const struct _ns1__getJobDetails_USCOREstring *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobDetails_USCOREstring);
	if (soap_out__ns1__getJobDetails_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobDetails_USCOREstring(struct soap *soap, const char *tag, int id, const struct _ns1__getJobDetails_USCOREstring *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobDetails_USCOREstring), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobDetails_USCOREstring * SOAP_FMAC4 soap_get__ns1__getJobDetails_USCOREstring(struct soap *soap, struct _ns1__getJobDetails_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobDetails_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDetails_USCOREstring * SOAP_FMAC4 soap_in__ns1__getJobDetails_USCOREstring(struct soap *soap, const char *tag, struct _ns1__getJobDetails_USCOREstring *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobDetails_USCOREstring *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobDetails_USCOREstring, sizeof(struct _ns1__getJobDetails_USCOREstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobDetails_USCOREstring(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDetails_USCOREstring *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobDetails_USCOREstring, 0, sizeof(struct _ns1__getJobDetails_USCOREstring), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllSitesResponse(struct soap *soap, struct _ns1__getAllSitesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllSitesResponse(struct soap *soap, const struct _ns1__getAllSitesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllSitesResponse(struct soap *soap, const struct _ns1__getAllSitesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllSitesResponse);
	if (soap_out__ns1__getAllSitesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllSitesResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getAllSitesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllSitesResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllSitesResponse * SOAP_FMAC4 soap_get__ns1__getAllSitesResponse(struct soap *soap, struct _ns1__getAllSitesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllSitesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSitesResponse * SOAP_FMAC4 soap_in__ns1__getAllSitesResponse(struct soap *soap, const char *tag, struct _ns1__getAllSitesResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllSitesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllSitesResponse, sizeof(struct _ns1__getAllSitesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllSitesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSitesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllSitesResponse, 0, sizeof(struct _ns1__getAllSitesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllSites(struct soap *soap, struct _ns1__getAllSites *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllSites(struct soap *soap, const struct _ns1__getAllSites *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllSites(struct soap *soap, const struct _ns1__getAllSites *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllSites);
	if (soap_out__ns1__getAllSites(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllSites(struct soap *soap, const char *tag, int id, const struct _ns1__getAllSites *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllSites), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllSites * SOAP_FMAC4 soap_get__ns1__getAllSites(struct soap *soap, struct _ns1__getAllSites *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllSites(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSites * SOAP_FMAC4 soap_in__ns1__getAllSites(struct soap *soap, const char *tag, struct _ns1__getAllSites *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllSites *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllSites, sizeof(struct _ns1__getAllSites), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllSites(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSites *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllSites, 0, sizeof(struct _ns1__getAllSites), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__setJobDescriptionResponse(struct soap *soap, struct _ns1__setJobDescriptionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__setJobDescriptionResponse(struct soap *soap, const struct _ns1__setJobDescriptionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__setJobDescriptionResponse(struct soap *soap, const struct _ns1__setJobDescriptionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__setJobDescriptionResponse);
	if (soap_out__ns1__setJobDescriptionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__setJobDescriptionResponse(struct soap *soap, const char *tag, int id, const struct _ns1__setJobDescriptionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__setJobDescriptionResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__setJobDescriptionResponse * SOAP_FMAC4 soap_get__ns1__setJobDescriptionResponse(struct soap *soap, struct _ns1__setJobDescriptionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__setJobDescriptionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__setJobDescriptionResponse * SOAP_FMAC4 soap_in__ns1__setJobDescriptionResponse(struct soap *soap, const char *tag, struct _ns1__setJobDescriptionResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__setJobDescriptionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__setJobDescriptionResponse, sizeof(struct _ns1__setJobDescriptionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__setJobDescriptionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__setJobDescriptionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__setJobDescriptionResponse, 0, sizeof(struct _ns1__setJobDescriptionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__setJobDescription(struct soap *soap, struct _ns1__setJobDescription *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	a->in1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__setJobDescription(struct soap *soap, const struct _ns1__setJobDescription *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__setJobDescription(struct soap *soap, const struct _ns1__setJobDescription *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__setJobDescription);
	if (soap_out__ns1__setJobDescription(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__setJobDescription(struct soap *soap, const char *tag, int id, const struct _ns1__setJobDescription *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__setJobDescription), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_outliteral(soap, "ns1:in1", &a->in1, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__setJobDescription * SOAP_FMAC4 soap_get__ns1__setJobDescription(struct soap *soap, struct _ns1__setJobDescription *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__setJobDescription(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__setJobDescription * SOAP_FMAC4 soap_in__ns1__setJobDescription(struct soap *soap, const char *tag, struct _ns1__setJobDescription *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__setJobDescription *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__setJobDescription, sizeof(struct _ns1__setJobDescription), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__setJobDescription(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:in1", &a->in1))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__setJobDescription *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__setJobDescription, 0, sizeof(struct _ns1__setJobDescription), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobDirectoryResponse(struct soap *soap, struct _ns1__getJobDirectoryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobDirectoryResponse(struct soap *soap, const struct _ns1__getJobDirectoryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobDirectoryResponse(struct soap *soap, const struct _ns1__getJobDirectoryResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobDirectoryResponse);
	if (soap_out__ns1__getJobDirectoryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobDirectoryResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getJobDirectoryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobDirectoryResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobDirectoryResponse * SOAP_FMAC4 soap_get__ns1__getJobDirectoryResponse(struct soap *soap, struct _ns1__getJobDirectoryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobDirectoryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDirectoryResponse * SOAP_FMAC4 soap_in__ns1__getJobDirectoryResponse(struct soap *soap, const char *tag, struct _ns1__getJobDirectoryResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobDirectoryResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobDirectoryResponse, sizeof(struct _ns1__getJobDirectoryResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobDirectoryResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDirectoryResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobDirectoryResponse, 0, sizeof(struct _ns1__getJobDirectoryResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobDirectory(struct soap *soap, struct _ns1__getJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobDirectory(struct soap *soap, const struct _ns1__getJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobDirectory(struct soap *soap, const struct _ns1__getJobDirectory *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobDirectory);
	if (soap_out__ns1__getJobDirectory(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobDirectory(struct soap *soap, const char *tag, int id, const struct _ns1__getJobDirectory *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobDirectory), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobDirectory * SOAP_FMAC4 soap_get__ns1__getJobDirectory(struct soap *soap, struct _ns1__getJobDirectory *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobDirectory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDirectory * SOAP_FMAC4 soap_in__ns1__getJobDirectory(struct soap *soap, const char *tag, struct _ns1__getJobDirectory *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobDirectory *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobDirectory, sizeof(struct _ns1__getJobDirectory), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobDirectory(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDirectory *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobDirectory, 0, sizeof(struct _ns1__getJobDirectory), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__uploadResponse(struct soap *soap, struct _ns1__uploadResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__uploadResponse(struct soap *soap, const struct _ns1__uploadResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__uploadResponse(struct soap *soap, const struct _ns1__uploadResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__uploadResponse);
	if (soap_out__ns1__uploadResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__uploadResponse(struct soap *soap, const char *tag, int id, const struct _ns1__uploadResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__uploadResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__uploadResponse * SOAP_FMAC4 soap_get__ns1__uploadResponse(struct soap *soap, struct _ns1__uploadResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__uploadResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadResponse * SOAP_FMAC4 soap_in__ns1__uploadResponse(struct soap *soap, const char *tag, struct _ns1__uploadResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__uploadResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__uploadResponse, sizeof(struct _ns1__uploadResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__uploadResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__uploadResponse, 0, sizeof(struct _ns1__uploadResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__upload(struct soap *soap, struct _ns1__upload *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->in0 = NULL;
	soap_default_string(soap, &a->in1);
	soap_default_xsd__boolean(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__upload(struct soap *soap, const struct _ns1__upload *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_embedded(soap, &a->in2, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__upload(struct soap *soap, const struct _ns1__upload *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__upload);
	if (soap_out__ns1__upload(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__upload(struct soap *soap, const char *tag, int id, const struct _ns1__upload *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__upload), type);
	soap_out_PointerToxsd__base64Binary(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_xsd__boolean(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__upload * SOAP_FMAC4 soap_get__ns1__upload(struct soap *soap, struct _ns1__upload *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__upload(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__upload * SOAP_FMAC4 soap_in__ns1__upload(struct soap *soap, const char *tag, struct _ns1__upload *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__upload *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__upload, sizeof(struct _ns1__upload), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__upload(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "ns1:in0", &a->in0, "xsd:base64Binary"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in2", &a->in2, "xsd:boolean"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__upload *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__upload, 0, sizeof(struct _ns1__upload), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__deleteFileResponse(struct soap *soap, struct _ns1__deleteFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__deleteFileResponse(struct soap *soap, const struct _ns1__deleteFileResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__deleteFileResponse(struct soap *soap, const struct _ns1__deleteFileResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__deleteFileResponse);
	if (soap_out__ns1__deleteFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__deleteFileResponse(struct soap *soap, const char *tag, int id, const struct _ns1__deleteFileResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__deleteFileResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__deleteFileResponse * SOAP_FMAC4 soap_get__ns1__deleteFileResponse(struct soap *soap, struct _ns1__deleteFileResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__deleteFileResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__deleteFileResponse * SOAP_FMAC4 soap_in__ns1__deleteFileResponse(struct soap *soap, const char *tag, struct _ns1__deleteFileResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__deleteFileResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__deleteFileResponse, sizeof(struct _ns1__deleteFileResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__deleteFileResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__deleteFileResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__deleteFileResponse, 0, sizeof(struct _ns1__deleteFileResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__deleteFile(struct soap *soap, struct _ns1__deleteFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__deleteFile(struct soap *soap, const struct _ns1__deleteFile *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__deleteFile(struct soap *soap, const struct _ns1__deleteFile *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__deleteFile);
	if (soap_out__ns1__deleteFile(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__deleteFile(struct soap *soap, const char *tag, int id, const struct _ns1__deleteFile *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__deleteFile), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__deleteFile * SOAP_FMAC4 soap_get__ns1__deleteFile(struct soap *soap, struct _ns1__deleteFile *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__deleteFile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__deleteFile * SOAP_FMAC4 soap_in__ns1__deleteFile(struct soap *soap, const char *tag, struct _ns1__deleteFile *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__deleteFile *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__deleteFile, sizeof(struct _ns1__deleteFile), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__deleteFile(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__deleteFile *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__deleteFile, 0, sizeof(struct _ns1__deleteFile), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getFileSizeResponse(struct soap *soap, struct _ns1__getFileSizeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getFileSizeResponse(struct soap *soap, const struct _ns1__getFileSizeResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->out, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getFileSizeResponse(struct soap *soap, const struct _ns1__getFileSizeResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getFileSizeResponse);
	if (soap_out__ns1__getFileSizeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getFileSizeResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getFileSizeResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getFileSizeResponse), type);
	soap_element_result(soap, "ns1:out");
	soap_out_LONG64(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getFileSizeResponse * SOAP_FMAC4 soap_get__ns1__getFileSizeResponse(struct soap *soap, struct _ns1__getFileSizeResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getFileSizeResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getFileSizeResponse * SOAP_FMAC4 soap_in__ns1__getFileSizeResponse(struct soap *soap, const char *tag, struct _ns1__getFileSizeResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getFileSizeResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getFileSizeResponse, sizeof(struct _ns1__getFileSizeResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getFileSizeResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "ns1:out", &a->out, "xsd:long"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getFileSizeResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getFileSizeResponse, 0, sizeof(struct _ns1__getFileSizeResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getFileSize(struct soap *soap, struct _ns1__getFileSize *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getFileSize(struct soap *soap, const struct _ns1__getFileSize *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getFileSize(struct soap *soap, const struct _ns1__getFileSize *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getFileSize);
	if (soap_out__ns1__getFileSize(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getFileSize(struct soap *soap, const char *tag, int id, const struct _ns1__getFileSize *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getFileSize), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getFileSize * SOAP_FMAC4 soap_get__ns1__getFileSize(struct soap *soap, struct _ns1__getFileSize *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getFileSize(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getFileSize * SOAP_FMAC4 soap_in__ns1__getFileSize(struct soap *soap, const char *tag, struct _ns1__getFileSize *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getFileSize *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getFileSize, sizeof(struct _ns1__getFileSize), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getFileSize(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getFileSize *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getFileSize, 0, sizeof(struct _ns1__getFileSize), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__cpResponse(struct soap *soap, struct _ns1__cpResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__cpResponse(struct soap *soap, const struct _ns1__cpResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__cpResponse(struct soap *soap, const struct _ns1__cpResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__cpResponse);
	if (soap_out__ns1__cpResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__cpResponse(struct soap *soap, const char *tag, int id, const struct _ns1__cpResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__cpResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__cpResponse * SOAP_FMAC4 soap_get__ns1__cpResponse(struct soap *soap, struct _ns1__cpResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__cpResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__cpResponse * SOAP_FMAC4 soap_in__ns1__cpResponse(struct soap *soap, const char *tag, struct _ns1__cpResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__cpResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__cpResponse, sizeof(struct _ns1__cpResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__cpResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__cpResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__cpResponse, 0, sizeof(struct _ns1__cpResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__cp(struct soap *soap, struct _ns1__cp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
	soap_default_xsd__boolean(soap, &a->in2);
	soap_default_xsd__boolean(soap, &a->in3);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__cp(struct soap *soap, const struct _ns1__cp *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_embedded(soap, &a->in2, SOAP_TYPE_xsd__boolean);
	soap_embedded(soap, &a->in3, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__cp(struct soap *soap, const struct _ns1__cp *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__cp);
	if (soap_out__ns1__cp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__cp(struct soap *soap, const char *tag, int id, const struct _ns1__cp *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__cp), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_xsd__boolean(soap, "ns1:in2", -1, &a->in2, "");
	soap_out_xsd__boolean(soap, "ns1:in3", -1, &a->in3, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__cp * SOAP_FMAC4 soap_get__ns1__cp(struct soap *soap, struct _ns1__cp *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__cp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__cp * SOAP_FMAC4 soap_in__ns1__cp(struct soap *soap, const char *tag, struct _ns1__cp *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1, soap_flag_in3 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__cp *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__cp, sizeof(struct _ns1__cp), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__cp(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in2", &a->in2, "xsd:boolean"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap_flag_in3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in3", &a->in3, "xsd:boolean"))
				{	soap_flag_in3--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__cp *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__cp, 0, sizeof(struct _ns1__cp), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0 || soap_flag_in3 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__uploadByteArrayResponse(struct soap *soap, struct _ns1__uploadByteArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__uploadByteArrayResponse(struct soap *soap, const struct _ns1__uploadByteArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__uploadByteArrayResponse(struct soap *soap, const struct _ns1__uploadByteArrayResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__uploadByteArrayResponse);
	if (soap_out__ns1__uploadByteArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__uploadByteArrayResponse(struct soap *soap, const char *tag, int id, const struct _ns1__uploadByteArrayResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__uploadByteArrayResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__uploadByteArrayResponse * SOAP_FMAC4 soap_get__ns1__uploadByteArrayResponse(struct soap *soap, struct _ns1__uploadByteArrayResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__uploadByteArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadByteArrayResponse * SOAP_FMAC4 soap_in__ns1__uploadByteArrayResponse(struct soap *soap, const char *tag, struct _ns1__uploadByteArrayResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__uploadByteArrayResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__uploadByteArrayResponse, sizeof(struct _ns1__uploadByteArrayResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__uploadByteArrayResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadByteArrayResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__uploadByteArrayResponse, 0, sizeof(struct _ns1__uploadByteArrayResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__uploadByteArray(struct soap *soap, struct _ns1__uploadByteArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->in0 = NULL;
	soap_default_string(soap, &a->in1);
	soap_default_xsd__boolean(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__uploadByteArray(struct soap *soap, const struct _ns1__uploadByteArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_embedded(soap, &a->in2, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__uploadByteArray(struct soap *soap, const struct _ns1__uploadByteArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__uploadByteArray);
	if (soap_out__ns1__uploadByteArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__uploadByteArray(struct soap *soap, const char *tag, int id, const struct _ns1__uploadByteArray *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__uploadByteArray), type);
	soap_out_PointerToxsd__base64Binary(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_xsd__boolean(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__uploadByteArray * SOAP_FMAC4 soap_get__ns1__uploadByteArray(struct soap *soap, struct _ns1__uploadByteArray *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__uploadByteArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadByteArray * SOAP_FMAC4 soap_in__ns1__uploadByteArray(struct soap *soap, const char *tag, struct _ns1__uploadByteArray *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__uploadByteArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__uploadByteArray, sizeof(struct _ns1__uploadByteArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__uploadByteArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "ns1:in0", &a->in0, "xsd:base64Binary"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in2", &a->in2, "xsd:boolean"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadByteArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__uploadByteArray, 0, sizeof(struct _ns1__uploadByteArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__submitJobResponse(struct soap *soap, struct _ns1__submitJobResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__submitJobResponse(struct soap *soap, const struct _ns1__submitJobResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__submitJobResponse(struct soap *soap, const struct _ns1__submitJobResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__submitJobResponse);
	if (soap_out__ns1__submitJobResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__submitJobResponse(struct soap *soap, const char *tag, int id, const struct _ns1__submitJobResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__submitJobResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__submitJobResponse * SOAP_FMAC4 soap_get__ns1__submitJobResponse(struct soap *soap, struct _ns1__submitJobResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__submitJobResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__submitJobResponse * SOAP_FMAC4 soap_in__ns1__submitJobResponse(struct soap *soap, const char *tag, struct _ns1__submitJobResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__submitJobResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__submitJobResponse, sizeof(struct _ns1__submitJobResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__submitJobResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__submitJobResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__submitJobResponse, 0, sizeof(struct _ns1__submitJobResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__submitJob(struct soap *soap, struct _ns1__submitJob *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__submitJob(struct soap *soap, const struct _ns1__submitJob *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__submitJob(struct soap *soap, const struct _ns1__submitJob *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__submitJob);
	if (soap_out__ns1__submitJob(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__submitJob(struct soap *soap, const char *tag, int id, const struct _ns1__submitJob *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__submitJob), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__submitJob * SOAP_FMAC4 soap_get__ns1__submitJob(struct soap *soap, struct _ns1__submitJob *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__submitJob(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__submitJob * SOAP_FMAC4 soap_in__ns1__submitJob(struct soap *soap, const char *tag, struct _ns1__submitJob *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__submitJob *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__submitJob, sizeof(struct _ns1__submitJob), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__submitJob(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__submitJob *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__submitJob, 0, sizeof(struct _ns1__submitJob), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__logoutResponse(struct soap *soap, struct _ns1__logoutResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__logoutResponse(struct soap *soap, const struct _ns1__logoutResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__logoutResponse(struct soap *soap, const struct _ns1__logoutResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__logoutResponse);
	if (soap_out__ns1__logoutResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__logoutResponse(struct soap *soap, const char *tag, int id, const struct _ns1__logoutResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__logoutResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__logoutResponse * SOAP_FMAC4 soap_get__ns1__logoutResponse(struct soap *soap, struct _ns1__logoutResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__logoutResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__logoutResponse * SOAP_FMAC4 soap_in__ns1__logoutResponse(struct soap *soap, const char *tag, struct _ns1__logoutResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__logoutResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__logoutResponse, sizeof(struct _ns1__logoutResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__logoutResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__logoutResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__logoutResponse, 0, sizeof(struct _ns1__logoutResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__logout(struct soap *soap, struct _ns1__logout *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__logout(struct soap *soap, const struct _ns1__logout *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__logout(struct soap *soap, const struct _ns1__logout *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__logout);
	if (soap_out__ns1__logout(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__logout(struct soap *soap, const char *tag, int id, const struct _ns1__logout *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__logout), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__logout * SOAP_FMAC4 soap_get__ns1__logout(struct soap *soap, struct _ns1__logout *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__logout(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__logout * SOAP_FMAC4 soap_in__ns1__logout(struct soap *soap, const char *tag, struct _ns1__logout *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__logout *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__logout, sizeof(struct _ns1__logout), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__logout(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__logout *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__logout, 0, sizeof(struct _ns1__logout), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__setJobDescription_USCOREstringResponse(struct soap *soap, struct _ns1__setJobDescription_USCOREstringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__setJobDescription_USCOREstringResponse(struct soap *soap, const struct _ns1__setJobDescription_USCOREstringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__setJobDescription_USCOREstringResponse(struct soap *soap, const struct _ns1__setJobDescription_USCOREstringResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse);
	if (soap_out__ns1__setJobDescription_USCOREstringResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__setJobDescription_USCOREstringResponse(struct soap *soap, const char *tag, int id, const struct _ns1__setJobDescription_USCOREstringResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__setJobDescription_USCOREstringResponse * SOAP_FMAC4 soap_get__ns1__setJobDescription_USCOREstringResponse(struct soap *soap, struct _ns1__setJobDescription_USCOREstringResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__setJobDescription_USCOREstringResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__setJobDescription_USCOREstringResponse * SOAP_FMAC4 soap_in__ns1__setJobDescription_USCOREstringResponse(struct soap *soap, const char *tag, struct _ns1__setJobDescription_USCOREstringResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__setJobDescription_USCOREstringResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse, sizeof(struct _ns1__setJobDescription_USCOREstringResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__setJobDescription_USCOREstringResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__setJobDescription_USCOREstringResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse, 0, sizeof(struct _ns1__setJobDescription_USCOREstringResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__setJobDescription_USCOREstring(struct soap *soap, struct _ns1__setJobDescription_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__setJobDescription_USCOREstring(struct soap *soap, const struct _ns1__setJobDescription_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__setJobDescription_USCOREstring(struct soap *soap, const struct _ns1__setJobDescription_USCOREstring *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__setJobDescription_USCOREstring);
	if (soap_out__ns1__setJobDescription_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__setJobDescription_USCOREstring(struct soap *soap, const char *tag, int id, const struct _ns1__setJobDescription_USCOREstring *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__setJobDescription_USCOREstring), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__setJobDescription_USCOREstring * SOAP_FMAC4 soap_get__ns1__setJobDescription_USCOREstring(struct soap *soap, struct _ns1__setJobDescription_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__setJobDescription_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__setJobDescription_USCOREstring * SOAP_FMAC4 soap_in__ns1__setJobDescription_USCOREstring(struct soap *soap, const char *tag, struct _ns1__setJobDescription_USCOREstring *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__setJobDescription_USCOREstring *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__setJobDescription_USCOREstring, sizeof(struct _ns1__setJobDescription_USCOREstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__setJobDescription_USCOREstring(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__setJobDescription_USCOREstring *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__setJobDescription_USCOREstring, 0, sizeof(struct _ns1__setJobDescription_USCOREstring), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, struct _ns1__calculateRelativeJobDirectoryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, const struct _ns1__calculateRelativeJobDirectoryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, const struct _ns1__calculateRelativeJobDirectoryResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse);
	if (soap_out__ns1__calculateRelativeJobDirectoryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, const char *tag, int id, const struct _ns1__calculateRelativeJobDirectoryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__calculateRelativeJobDirectoryResponse * SOAP_FMAC4 soap_get__ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, struct _ns1__calculateRelativeJobDirectoryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__calculateRelativeJobDirectoryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__calculateRelativeJobDirectoryResponse * SOAP_FMAC4 soap_in__ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, const char *tag, struct _ns1__calculateRelativeJobDirectoryResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__calculateRelativeJobDirectoryResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse, sizeof(struct _ns1__calculateRelativeJobDirectoryResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__calculateRelativeJobDirectoryResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__calculateRelativeJobDirectoryResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse, 0, sizeof(struct _ns1__calculateRelativeJobDirectoryResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__calculateRelativeJobDirectory(struct soap *soap, struct _ns1__calculateRelativeJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__calculateRelativeJobDirectory(struct soap *soap, const struct _ns1__calculateRelativeJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__calculateRelativeJobDirectory(struct soap *soap, const struct _ns1__calculateRelativeJobDirectory *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__calculateRelativeJobDirectory);
	if (soap_out__ns1__calculateRelativeJobDirectory(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__calculateRelativeJobDirectory(struct soap *soap, const char *tag, int id, const struct _ns1__calculateRelativeJobDirectory *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__calculateRelativeJobDirectory), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__calculateRelativeJobDirectory * SOAP_FMAC4 soap_get__ns1__calculateRelativeJobDirectory(struct soap *soap, struct _ns1__calculateRelativeJobDirectory *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__calculateRelativeJobDirectory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__calculateRelativeJobDirectory * SOAP_FMAC4 soap_in__ns1__calculateRelativeJobDirectory(struct soap *soap, const char *tag, struct _ns1__calculateRelativeJobDirectory *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__calculateRelativeJobDirectory *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__calculateRelativeJobDirectory, sizeof(struct _ns1__calculateRelativeJobDirectory), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__calculateRelativeJobDirectory(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__calculateRelativeJobDirectory *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__calculateRelativeJobDirectory, 0, sizeof(struct _ns1__calculateRelativeJobDirectory), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getApplicationDetails1Response(struct soap *soap, struct _ns1__getApplicationDetails1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getApplicationDetails1Response(struct soap *soap, const struct _ns1__getApplicationDetails1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__anyType2anyTypeMap(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getApplicationDetails1Response(struct soap *soap, const struct _ns1__getApplicationDetails1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getApplicationDetails1Response);
	if (soap_out__ns1__getApplicationDetails1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getApplicationDetails1Response(struct soap *soap, const char *tag, int id, const struct _ns1__getApplicationDetails1Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getApplicationDetails1Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getApplicationDetails1Response * SOAP_FMAC4 soap_get__ns1__getApplicationDetails1Response(struct soap *soap, struct _ns1__getApplicationDetails1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getApplicationDetails1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getApplicationDetails1Response * SOAP_FMAC4 soap_in__ns1__getApplicationDetails1Response(struct soap *soap, const char *tag, struct _ns1__getApplicationDetails1Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getApplicationDetails1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getApplicationDetails1Response, sizeof(struct _ns1__getApplicationDetails1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getApplicationDetails1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", &a->out, "ns1:anyType2anyTypeMap"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getApplicationDetails1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getApplicationDetails1Response, 0, sizeof(struct _ns1__getApplicationDetails1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getApplicationDetails1(struct soap *soap, struct _ns1__getApplicationDetails1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
	soap_default_string(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getApplicationDetails1(struct soap *soap, const struct _ns1__getApplicationDetails1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_serialize_string(soap, &a->in2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getApplicationDetails1(struct soap *soap, const struct _ns1__getApplicationDetails1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getApplicationDetails1);
	if (soap_out__ns1__getApplicationDetails1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getApplicationDetails1(struct soap *soap, const char *tag, int id, const struct _ns1__getApplicationDetails1 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getApplicationDetails1), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_string(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getApplicationDetails1 * SOAP_FMAC4 soap_get__ns1__getApplicationDetails1(struct soap *soap, struct _ns1__getApplicationDetails1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getApplicationDetails1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getApplicationDetails1 * SOAP_FMAC4 soap_in__ns1__getApplicationDetails1(struct soap *soap, const char *tag, struct _ns1__getApplicationDetails1 *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getApplicationDetails1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getApplicationDetails1, sizeof(struct _ns1__getApplicationDetails1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getApplicationDetails1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in2", &a->in2, "xsd:string"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getApplicationDetails1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getApplicationDetails1, 0, sizeof(struct _ns1__getApplicationDetails1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__lsResponse(struct soap *soap, struct _ns1__lsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__lsResponse(struct soap *soap, const struct _ns1__lsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__lsResponse(struct soap *soap, const struct _ns1__lsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__lsResponse);
	if (soap_out__ns1__lsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__lsResponse(struct soap *soap, const char *tag, int id, const struct _ns1__lsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__lsResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_outliteral(soap, "ns1:out", &a->out, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__lsResponse * SOAP_FMAC4 soap_get__ns1__lsResponse(struct soap *soap, struct _ns1__lsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__lsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__lsResponse * SOAP_FMAC4 soap_in__ns1__lsResponse(struct soap *soap, const char *tag, struct _ns1__lsResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__lsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__lsResponse, sizeof(struct _ns1__lsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__lsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:out", &a->out))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__lsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__lsResponse, 0, sizeof(struct _ns1__lsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__ls(struct soap *soap, struct _ns1__ls *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_int(soap, &a->in1);
	soap_default_xsd__boolean(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__ls(struct soap *soap, const struct _ns1__ls *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_embedded(soap, &a->in2, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__ls(struct soap *soap, const struct _ns1__ls *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__ls);
	if (soap_out__ns1__ls(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__ls(struct soap *soap, const char *tag, int id, const struct _ns1__ls *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__ls), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_int(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_xsd__boolean(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__ls * SOAP_FMAC4 soap_get__ns1__ls(struct soap *soap, struct _ns1__ls *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__ls(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ls * SOAP_FMAC4 soap_in__ns1__ls(struct soap *soap, const char *tag, struct _ns1__ls *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__ls *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__ls, sizeof(struct _ns1__ls), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__ls(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:in1", &a->in1, "xsd:int"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in2", &a->in2, "xsd:boolean"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__ls *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__ls, 0, sizeof(struct _ns1__ls), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__lastModifiedResponse(struct soap *soap, struct _ns1__lastModifiedResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_LONG64(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__lastModifiedResponse(struct soap *soap, const struct _ns1__lastModifiedResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->out, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__lastModifiedResponse(struct soap *soap, const struct _ns1__lastModifiedResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__lastModifiedResponse);
	if (soap_out__ns1__lastModifiedResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__lastModifiedResponse(struct soap *soap, const char *tag, int id, const struct _ns1__lastModifiedResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__lastModifiedResponse), type);
	soap_element_result(soap, "ns1:out");
	soap_out_LONG64(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__lastModifiedResponse * SOAP_FMAC4 soap_get__ns1__lastModifiedResponse(struct soap *soap, struct _ns1__lastModifiedResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__lastModifiedResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__lastModifiedResponse * SOAP_FMAC4 soap_in__ns1__lastModifiedResponse(struct soap *soap, const char *tag, struct _ns1__lastModifiedResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__lastModifiedResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__lastModifiedResponse, sizeof(struct _ns1__lastModifiedResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__lastModifiedResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "ns1:out", &a->out, "xsd:long"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__lastModifiedResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__lastModifiedResponse, 0, sizeof(struct _ns1__lastModifiedResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__lastModified(struct soap *soap, struct _ns1__lastModified *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__lastModified(struct soap *soap, const struct _ns1__lastModified *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__lastModified(struct soap *soap, const struct _ns1__lastModified *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__lastModified);
	if (soap_out__ns1__lastModified(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__lastModified(struct soap *soap, const char *tag, int id, const struct _ns1__lastModified *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__lastModified), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__lastModified * SOAP_FMAC4 soap_get__ns1__lastModified(struct soap *soap, struct _ns1__lastModified *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__lastModified(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__lastModified * SOAP_FMAC4 soap_in__ns1__lastModified(struct soap *soap, const char *tag, struct _ns1__lastModified *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__lastModified *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__lastModified, sizeof(struct _ns1__lastModified), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__lastModified(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__lastModified *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__lastModified, 0, sizeof(struct _ns1__lastModified), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSiteResponse(struct soap *soap, struct _ns1__getSiteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSiteResponse(struct soap *soap, const struct _ns1__getSiteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSiteResponse(struct soap *soap, const struct _ns1__getSiteResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSiteResponse);
	if (soap_out__ns1__getSiteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSiteResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getSiteResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSiteResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSiteResponse * SOAP_FMAC4 soap_get__ns1__getSiteResponse(struct soap *soap, struct _ns1__getSiteResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSiteResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSiteResponse * SOAP_FMAC4 soap_in__ns1__getSiteResponse(struct soap *soap, const char *tag, struct _ns1__getSiteResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSiteResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSiteResponse, sizeof(struct _ns1__getSiteResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSiteResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSiteResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSiteResponse, 0, sizeof(struct _ns1__getSiteResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSite(struct soap *soap, struct _ns1__getSite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSite(struct soap *soap, const struct _ns1__getSite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSite(struct soap *soap, const struct _ns1__getSite *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSite);
	if (soap_out__ns1__getSite(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSite(struct soap *soap, const char *tag, int id, const struct _ns1__getSite *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSite), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSite * SOAP_FMAC4 soap_get__ns1__getSite(struct soap *soap, struct _ns1__getSite *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSite(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSite * SOAP_FMAC4 soap_in__ns1__getSite(struct soap *soap, const char *tag, struct _ns1__getSite *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSite *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSite, sizeof(struct _ns1__getSite), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSite(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSite *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSite, 0, sizeof(struct _ns1__getSite), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__ps_USCOREstringResponse(struct soap *soap, struct _ns1__ps_USCOREstringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__ps_USCOREstringResponse(struct soap *soap, const struct _ns1__ps_USCOREstringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__ps_USCOREstringResponse(struct soap *soap, const struct _ns1__ps_USCOREstringResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__ps_USCOREstringResponse);
	if (soap_out__ns1__ps_USCOREstringResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__ps_USCOREstringResponse(struct soap *soap, const char *tag, int id, const struct _ns1__ps_USCOREstringResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__ps_USCOREstringResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__ps_USCOREstringResponse * SOAP_FMAC4 soap_get__ns1__ps_USCOREstringResponse(struct soap *soap, struct _ns1__ps_USCOREstringResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__ps_USCOREstringResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ps_USCOREstringResponse * SOAP_FMAC4 soap_in__ns1__ps_USCOREstringResponse(struct soap *soap, const char *tag, struct _ns1__ps_USCOREstringResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__ps_USCOREstringResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__ps_USCOREstringResponse, sizeof(struct _ns1__ps_USCOREstringResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__ps_USCOREstringResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__ps_USCOREstringResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__ps_USCOREstringResponse, 0, sizeof(struct _ns1__ps_USCOREstringResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__ps_USCOREstring(struct soap *soap, struct _ns1__ps_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__ps_USCOREstring(struct soap *soap, const struct _ns1__ps_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__ps_USCOREstring(struct soap *soap, const struct _ns1__ps_USCOREstring *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__ps_USCOREstring);
	if (soap_out__ns1__ps_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__ps_USCOREstring(struct soap *soap, const char *tag, int id, const struct _ns1__ps_USCOREstring *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__ps_USCOREstring), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__ps_USCOREstring * SOAP_FMAC4 soap_get__ns1__ps_USCOREstring(struct soap *soap, struct _ns1__ps_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__ps_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ps_USCOREstring * SOAP_FMAC4 soap_in__ns1__ps_USCOREstring(struct soap *soap, const char *tag, struct _ns1__ps_USCOREstring *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__ps_USCOREstring *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__ps_USCOREstring, sizeof(struct _ns1__ps_USCOREstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__ps_USCOREstring(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__ps_USCOREstring *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__ps_USCOREstring, 0, sizeof(struct _ns1__ps_USCOREstring), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__uploadByteArray1Response(struct soap *soap, struct _ns1__uploadByteArray1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__uploadByteArray1Response(struct soap *soap, const struct _ns1__uploadByteArray1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__uploadByteArray1Response(struct soap *soap, const struct _ns1__uploadByteArray1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__uploadByteArray1Response);
	if (soap_out__ns1__uploadByteArray1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__uploadByteArray1Response(struct soap *soap, const char *tag, int id, const struct _ns1__uploadByteArray1Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__uploadByteArray1Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__uploadByteArray1Response * SOAP_FMAC4 soap_get__ns1__uploadByteArray1Response(struct soap *soap, struct _ns1__uploadByteArray1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__uploadByteArray1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadByteArray1Response * SOAP_FMAC4 soap_in__ns1__uploadByteArray1Response(struct soap *soap, const char *tag, struct _ns1__uploadByteArray1Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__uploadByteArray1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__uploadByteArray1Response, sizeof(struct _ns1__uploadByteArray1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__uploadByteArray1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadByteArray1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__uploadByteArray1Response, 0, sizeof(struct _ns1__uploadByteArray1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__uploadByteArray1(struct soap *soap, struct _ns1__uploadByteArray1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->in0 = NULL;
	soap_default_string(soap, &a->in1);
	soap_default_xsd__boolean(soap, &a->in2);
	soap_default_int(soap, &a->in3);
	soap_default_int(soap, &a->in4);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__uploadByteArray1(struct soap *soap, const struct _ns1__uploadByteArray1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_embedded(soap, &a->in2, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__uploadByteArray1(struct soap *soap, const struct _ns1__uploadByteArray1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__uploadByteArray1);
	if (soap_out__ns1__uploadByteArray1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__uploadByteArray1(struct soap *soap, const char *tag, int id, const struct _ns1__uploadByteArray1 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__uploadByteArray1), type);
	soap_out_PointerToxsd__base64Binary(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_xsd__boolean(soap, "ns1:in2", -1, &a->in2, "");
	soap_out_int(soap, "ns1:in3", -1, &a->in3, "");
	soap_out_int(soap, "ns1:in4", -1, &a->in4, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__uploadByteArray1 * SOAP_FMAC4 soap_get__ns1__uploadByteArray1(struct soap *soap, struct _ns1__uploadByteArray1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__uploadByteArray1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadByteArray1 * SOAP_FMAC4 soap_in__ns1__uploadByteArray1(struct soap *soap, const char *tag, struct _ns1__uploadByteArray1 *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1, soap_flag_in3 = 1, soap_flag_in4 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__uploadByteArray1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__uploadByteArray1, sizeof(struct _ns1__uploadByteArray1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__uploadByteArray1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "ns1:in0", &a->in0, "xsd:base64Binary"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in2", &a->in2, "xsd:boolean"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap_flag_in3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:in3", &a->in3, "xsd:int"))
				{	soap_flag_in3--;
					continue;
				}
			if (soap_flag_in4 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:in4", &a->in4, "xsd:int"))
				{	soap_flag_in4--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadByteArray1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__uploadByteArray1, 0, sizeof(struct _ns1__uploadByteArray1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0 || soap_flag_in3 > 0 || soap_flag_in4 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSiteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, const struct _ns1__getVersionsOfApplicationOnSiteResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, const struct _ns1__getVersionsOfApplicationOnSiteResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse);
	if (soap_out__ns1__getVersionsOfApplicationOnSiteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getVersionsOfApplicationOnSiteResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getVersionsOfApplicationOnSiteResponse * SOAP_FMAC4 soap_get__ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSiteResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getVersionsOfApplicationOnSiteResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getVersionsOfApplicationOnSiteResponse * SOAP_FMAC4 soap_in__ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, const char *tag, struct _ns1__getVersionsOfApplicationOnSiteResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getVersionsOfApplicationOnSiteResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse, sizeof(struct _ns1__getVersionsOfApplicationOnSiteResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getVersionsOfApplicationOnSiteResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getVersionsOfApplicationOnSiteResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse, 0, sizeof(struct _ns1__getVersionsOfApplicationOnSiteResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getVersionsOfApplicationOnSite(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getVersionsOfApplicationOnSite(struct soap *soap, const struct _ns1__getVersionsOfApplicationOnSite *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getVersionsOfApplicationOnSite(struct soap *soap, const struct _ns1__getVersionsOfApplicationOnSite *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getVersionsOfApplicationOnSite);
	if (soap_out__ns1__getVersionsOfApplicationOnSite(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getVersionsOfApplicationOnSite(struct soap *soap, const char *tag, int id, const struct _ns1__getVersionsOfApplicationOnSite *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getVersionsOfApplicationOnSite), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getVersionsOfApplicationOnSite * SOAP_FMAC4 soap_get__ns1__getVersionsOfApplicationOnSite(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSite *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getVersionsOfApplicationOnSite(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getVersionsOfApplicationOnSite * SOAP_FMAC4 soap_in__ns1__getVersionsOfApplicationOnSite(struct soap *soap, const char *tag, struct _ns1__getVersionsOfApplicationOnSite *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getVersionsOfApplicationOnSite *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getVersionsOfApplicationOnSite, sizeof(struct _ns1__getVersionsOfApplicationOnSite), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getVersionsOfApplicationOnSite(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getVersionsOfApplicationOnSite *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getVersionsOfApplicationOnSite, 0, sizeof(struct _ns1__getVersionsOfApplicationOnSite), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllSubmissionLocations1Response(struct soap *soap, struct _ns1__getAllSubmissionLocations1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllSubmissionLocations1Response(struct soap *soap, const struct _ns1__getAllSubmissionLocations1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllSubmissionLocations1Response(struct soap *soap, const struct _ns1__getAllSubmissionLocations1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllSubmissionLocations1Response);
	if (soap_out__ns1__getAllSubmissionLocations1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllSubmissionLocations1Response(struct soap *soap, const char *tag, int id, const struct _ns1__getAllSubmissionLocations1Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllSubmissionLocations1Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations1Response * SOAP_FMAC4 soap_get__ns1__getAllSubmissionLocations1Response(struct soap *soap, struct _ns1__getAllSubmissionLocations1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllSubmissionLocations1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations1Response * SOAP_FMAC4 soap_in__ns1__getAllSubmissionLocations1Response(struct soap *soap, const char *tag, struct _ns1__getAllSubmissionLocations1Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllSubmissionLocations1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllSubmissionLocations1Response, sizeof(struct _ns1__getAllSubmissionLocations1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllSubmissionLocations1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSubmissionLocations1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllSubmissionLocations1Response, 0, sizeof(struct _ns1__getAllSubmissionLocations1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllSubmissionLocations1(struct soap *soap, struct _ns1__getAllSubmissionLocations1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllSubmissionLocations1(struct soap *soap, const struct _ns1__getAllSubmissionLocations1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllSubmissionLocations1(struct soap *soap, const struct _ns1__getAllSubmissionLocations1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllSubmissionLocations1);
	if (soap_out__ns1__getAllSubmissionLocations1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllSubmissionLocations1(struct soap *soap, const char *tag, int id, const struct _ns1__getAllSubmissionLocations1 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllSubmissionLocations1), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations1 * SOAP_FMAC4 soap_get__ns1__getAllSubmissionLocations1(struct soap *soap, struct _ns1__getAllSubmissionLocations1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllSubmissionLocations1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations1 * SOAP_FMAC4 soap_in__ns1__getAllSubmissionLocations1(struct soap *soap, const char *tag, struct _ns1__getAllSubmissionLocations1 *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllSubmissionLocations1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllSubmissionLocations1, sizeof(struct _ns1__getAllSubmissionLocations1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllSubmissionLocations1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSubmissionLocations1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllSubmissionLocations1, 0, sizeof(struct _ns1__getAllSubmissionLocations1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__createJobResponse(struct soap *soap, struct _ns1__createJobResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__createJobResponse(struct soap *soap, const struct _ns1__createJobResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__createJobResponse(struct soap *soap, const struct _ns1__createJobResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__createJobResponse);
	if (soap_out__ns1__createJobResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__createJobResponse(struct soap *soap, const char *tag, int id, const struct _ns1__createJobResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__createJobResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__createJobResponse * SOAP_FMAC4 soap_get__ns1__createJobResponse(struct soap *soap, struct _ns1__createJobResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__createJobResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__createJobResponse * SOAP_FMAC4 soap_in__ns1__createJobResponse(struct soap *soap, const char *tag, struct _ns1__createJobResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__createJobResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__createJobResponse, sizeof(struct _ns1__createJobResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__createJobResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__createJobResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__createJobResponse, 0, sizeof(struct _ns1__createJobResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__createJob(struct soap *soap, struct _ns1__createJob *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_int(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__createJob(struct soap *soap, const struct _ns1__createJob *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__createJob(struct soap *soap, const struct _ns1__createJob *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__createJob);
	if (soap_out__ns1__createJob(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__createJob(struct soap *soap, const char *tag, int id, const struct _ns1__createJob *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__createJob), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_int(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__createJob * SOAP_FMAC4 soap_get__ns1__createJob(struct soap *soap, struct _ns1__createJob *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__createJob(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__createJob * SOAP_FMAC4 soap_in__ns1__createJob(struct soap *soap, const char *tag, struct _ns1__createJob *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__createJob *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__createJob, sizeof(struct _ns1__createJob), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__createJob(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:in1", &a->in1, "xsd:int"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__createJob *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__createJob, 0, sizeof(struct _ns1__createJob), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getInterfaceVersionResponse(struct soap *soap, struct _ns1__getInterfaceVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_double(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getInterfaceVersionResponse(struct soap *soap, const struct _ns1__getInterfaceVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getInterfaceVersionResponse(struct soap *soap, const struct _ns1__getInterfaceVersionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getInterfaceVersionResponse);
	if (soap_out__ns1__getInterfaceVersionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getInterfaceVersionResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getInterfaceVersionResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getInterfaceVersionResponse), type);
	soap_element_result(soap, "ns1:out");
	soap_out_double(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getInterfaceVersionResponse * SOAP_FMAC4 soap_get__ns1__getInterfaceVersionResponse(struct soap *soap, struct _ns1__getInterfaceVersionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getInterfaceVersionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getInterfaceVersionResponse * SOAP_FMAC4 soap_in__ns1__getInterfaceVersionResponse(struct soap *soap, const char *tag, struct _ns1__getInterfaceVersionResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getInterfaceVersionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getInterfaceVersionResponse, sizeof(struct _ns1__getInterfaceVersionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getInterfaceVersionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_double(soap, "ns1:out", &a->out, "xsd:double"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getInterfaceVersionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getInterfaceVersionResponse, 0, sizeof(struct _ns1__getInterfaceVersionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getInterfaceVersion(struct soap *soap, struct _ns1__getInterfaceVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getInterfaceVersion(struct soap *soap, const struct _ns1__getInterfaceVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getInterfaceVersion(struct soap *soap, const struct _ns1__getInterfaceVersion *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getInterfaceVersion);
	if (soap_out__ns1__getInterfaceVersion(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getInterfaceVersion(struct soap *soap, const char *tag, int id, const struct _ns1__getInterfaceVersion *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getInterfaceVersion), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getInterfaceVersion * SOAP_FMAC4 soap_get__ns1__getInterfaceVersion(struct soap *soap, struct _ns1__getInterfaceVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getInterfaceVersion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getInterfaceVersion * SOAP_FMAC4 soap_in__ns1__getInterfaceVersion(struct soap *soap, const char *tag, struct _ns1__getInterfaceVersion *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getInterfaceVersion *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getInterfaceVersion, sizeof(struct _ns1__getInterfaceVersion), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getInterfaceVersion(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getInterfaceVersion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getInterfaceVersion, 0, sizeof(struct _ns1__getInterfaceVersion), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllSubmissionLocationsResponse(struct soap *soap, struct _ns1__getAllSubmissionLocationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllSubmissionLocationsResponse(struct soap *soap, const struct _ns1__getAllSubmissionLocationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllSubmissionLocationsResponse(struct soap *soap, const struct _ns1__getAllSubmissionLocationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllSubmissionLocationsResponse);
	if (soap_out__ns1__getAllSubmissionLocationsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllSubmissionLocationsResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getAllSubmissionLocationsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllSubmissionLocationsResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocationsResponse * SOAP_FMAC4 soap_get__ns1__getAllSubmissionLocationsResponse(struct soap *soap, struct _ns1__getAllSubmissionLocationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllSubmissionLocationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocationsResponse * SOAP_FMAC4 soap_in__ns1__getAllSubmissionLocationsResponse(struct soap *soap, const char *tag, struct _ns1__getAllSubmissionLocationsResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllSubmissionLocationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllSubmissionLocationsResponse, sizeof(struct _ns1__getAllSubmissionLocationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllSubmissionLocationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSubmissionLocationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllSubmissionLocationsResponse, 0, sizeof(struct _ns1__getAllSubmissionLocationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllSubmissionLocations(struct soap *soap, struct _ns1__getAllSubmissionLocations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllSubmissionLocations(struct soap *soap, const struct _ns1__getAllSubmissionLocations *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllSubmissionLocations(struct soap *soap, const struct _ns1__getAllSubmissionLocations *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllSubmissionLocations);
	if (soap_out__ns1__getAllSubmissionLocations(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllSubmissionLocations(struct soap *soap, const char *tag, int id, const struct _ns1__getAllSubmissionLocations *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllSubmissionLocations), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations * SOAP_FMAC4 soap_get__ns1__getAllSubmissionLocations(struct soap *soap, struct _ns1__getAllSubmissionLocations *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllSubmissionLocations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations * SOAP_FMAC4 soap_in__ns1__getAllSubmissionLocations(struct soap *soap, const char *tag, struct _ns1__getAllSubmissionLocations *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllSubmissionLocations *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllSubmissionLocations, sizeof(struct _ns1__getAllSubmissionLocations), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllSubmissionLocations(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSubmissionLocations *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllSubmissionLocations, 0, sizeof(struct _ns1__getAllSubmissionLocations), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__addJobPropertyResponse(struct soap *soap, struct _ns1__addJobPropertyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__addJobPropertyResponse(struct soap *soap, const struct _ns1__addJobPropertyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__addJobPropertyResponse(struct soap *soap, const struct _ns1__addJobPropertyResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__addJobPropertyResponse);
	if (soap_out__ns1__addJobPropertyResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__addJobPropertyResponse(struct soap *soap, const char *tag, int id, const struct _ns1__addJobPropertyResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__addJobPropertyResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__addJobPropertyResponse * SOAP_FMAC4 soap_get__ns1__addJobPropertyResponse(struct soap *soap, struct _ns1__addJobPropertyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__addJobPropertyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__addJobPropertyResponse * SOAP_FMAC4 soap_in__ns1__addJobPropertyResponse(struct soap *soap, const char *tag, struct _ns1__addJobPropertyResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__addJobPropertyResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__addJobPropertyResponse, sizeof(struct _ns1__addJobPropertyResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__addJobPropertyResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__addJobPropertyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__addJobPropertyResponse, 0, sizeof(struct _ns1__addJobPropertyResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__addJobProperty(struct soap *soap, struct _ns1__addJobProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
	soap_default_string(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__addJobProperty(struct soap *soap, const struct _ns1__addJobProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_serialize_string(soap, &a->in2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__addJobProperty(struct soap *soap, const struct _ns1__addJobProperty *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__addJobProperty);
	if (soap_out__ns1__addJobProperty(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__addJobProperty(struct soap *soap, const char *tag, int id, const struct _ns1__addJobProperty *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__addJobProperty), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_string(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__addJobProperty * SOAP_FMAC4 soap_get__ns1__addJobProperty(struct soap *soap, struct _ns1__addJobProperty *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__addJobProperty(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__addJobProperty * SOAP_FMAC4 soap_in__ns1__addJobProperty(struct soap *soap, const char *tag, struct _ns1__addJobProperty *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__addJobProperty *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__addJobProperty, sizeof(struct _ns1__addJobProperty), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__addJobProperty(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in2", &a->in2, "xsd:string"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__addJobProperty *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__addJobProperty, 0, sizeof(struct _ns1__addJobProperty), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__addJobPropertiesResponse(struct soap *soap, struct _ns1__addJobPropertiesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__addJobPropertiesResponse(struct soap *soap, const struct _ns1__addJobPropertiesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__addJobPropertiesResponse(struct soap *soap, const struct _ns1__addJobPropertiesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__addJobPropertiesResponse);
	if (soap_out__ns1__addJobPropertiesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__addJobPropertiesResponse(struct soap *soap, const char *tag, int id, const struct _ns1__addJobPropertiesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__addJobPropertiesResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__addJobPropertiesResponse * SOAP_FMAC4 soap_get__ns1__addJobPropertiesResponse(struct soap *soap, struct _ns1__addJobPropertiesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__addJobPropertiesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__addJobPropertiesResponse * SOAP_FMAC4 soap_in__ns1__addJobPropertiesResponse(struct soap *soap, const char *tag, struct _ns1__addJobPropertiesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__addJobPropertiesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__addJobPropertiesResponse, sizeof(struct _ns1__addJobPropertiesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__addJobPropertiesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__addJobPropertiesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__addJobPropertiesResponse, 0, sizeof(struct _ns1__addJobPropertiesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__addJobProperties(struct soap *soap, struct _ns1__addJobProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	a->in1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__addJobProperties(struct soap *soap, const struct _ns1__addJobProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_PointerTons1__anyType2anyTypeMap(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__addJobProperties(struct soap *soap, const struct _ns1__addJobProperties *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__addJobProperties);
	if (soap_out__ns1__addJobProperties(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__addJobProperties(struct soap *soap, const char *tag, int id, const struct _ns1__addJobProperties *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__addJobProperties), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_PointerTons1__anyType2anyTypeMap(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__addJobProperties * SOAP_FMAC4 soap_get__ns1__addJobProperties(struct soap *soap, struct _ns1__addJobProperties *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__addJobProperties(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__addJobProperties * SOAP_FMAC4 soap_in__ns1__addJobProperties(struct soap *soap, const char *tag, struct _ns1__addJobProperties *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__addJobProperties *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__addJobProperties, sizeof(struct _ns1__addJobProperties), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__addJobProperties(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__anyType2anyTypeMap(soap, "ns1:in1", &a->in1, "ns1:anyType2anyTypeMap"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__addJobProperties *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__addJobProperties, 0, sizeof(struct _ns1__addJobProperties), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllAvailableApplicationsResponse(struct soap *soap, struct _ns1__getAllAvailableApplicationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllAvailableApplicationsResponse(struct soap *soap, const struct _ns1__getAllAvailableApplicationsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllAvailableApplicationsResponse(struct soap *soap, const struct _ns1__getAllAvailableApplicationsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllAvailableApplicationsResponse);
	if (soap_out__ns1__getAllAvailableApplicationsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllAvailableApplicationsResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getAllAvailableApplicationsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllAvailableApplicationsResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllAvailableApplicationsResponse * SOAP_FMAC4 soap_get__ns1__getAllAvailableApplicationsResponse(struct soap *soap, struct _ns1__getAllAvailableApplicationsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllAvailableApplicationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllAvailableApplicationsResponse * SOAP_FMAC4 soap_in__ns1__getAllAvailableApplicationsResponse(struct soap *soap, const char *tag, struct _ns1__getAllAvailableApplicationsResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllAvailableApplicationsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllAvailableApplicationsResponse, sizeof(struct _ns1__getAllAvailableApplicationsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllAvailableApplicationsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllAvailableApplicationsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllAvailableApplicationsResponse, 0, sizeof(struct _ns1__getAllAvailableApplicationsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllAvailableApplications(struct soap *soap, struct _ns1__getAllAvailableApplications *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->in0 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllAvailableApplications(struct soap *soap, const struct _ns1__getAllAvailableApplications *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllAvailableApplications(struct soap *soap, const struct _ns1__getAllAvailableApplications *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllAvailableApplications);
	if (soap_out__ns1__getAllAvailableApplications(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllAvailableApplications(struct soap *soap, const char *tag, int id, const struct _ns1__getAllAvailableApplications *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllAvailableApplications), type);
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllAvailableApplications * SOAP_FMAC4 soap_get__ns1__getAllAvailableApplications(struct soap *soap, struct _ns1__getAllAvailableApplications *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllAvailableApplications(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllAvailableApplications * SOAP_FMAC4 soap_in__ns1__getAllAvailableApplications(struct soap *soap, const char *tag, struct _ns1__getAllAvailableApplications *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllAvailableApplications *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllAvailableApplications, sizeof(struct _ns1__getAllAvailableApplications), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllAvailableApplications(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:in0", &a->in0, "ns1:ArrayOfString"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllAvailableApplications *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllAvailableApplications, 0, sizeof(struct _ns1__getAllAvailableApplications), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__killResponse(struct soap *soap, struct _ns1__killResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__killResponse(struct soap *soap, const struct _ns1__killResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__killResponse(struct soap *soap, const struct _ns1__killResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__killResponse);
	if (soap_out__ns1__killResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__killResponse(struct soap *soap, const char *tag, int id, const struct _ns1__killResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__killResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__killResponse * SOAP_FMAC4 soap_get__ns1__killResponse(struct soap *soap, struct _ns1__killResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__killResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__killResponse * SOAP_FMAC4 soap_in__ns1__killResponse(struct soap *soap, const char *tag, struct _ns1__killResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__killResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__killResponse, sizeof(struct _ns1__killResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__killResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__killResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__killResponse, 0, sizeof(struct _ns1__killResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__kill(struct soap *soap, struct _ns1__kill *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_xsd__boolean(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__kill(struct soap *soap, const struct _ns1__kill *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_embedded(soap, &a->in1, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__kill(struct soap *soap, const struct _ns1__kill *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__kill);
	if (soap_out__ns1__kill(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__kill(struct soap *soap, const char *tag, int id, const struct _ns1__kill *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__kill), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_xsd__boolean(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__kill * SOAP_FMAC4 soap_get__ns1__kill(struct soap *soap, struct _ns1__kill *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__kill(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__kill * SOAP_FMAC4 soap_in__ns1__kill(struct soap *soap, const char *tag, struct _ns1__kill *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__kill *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__kill, sizeof(struct _ns1__kill), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__kill(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in1", &a->in1, "xsd:boolean"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__kill *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__kill, 0, sizeof(struct _ns1__kill), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__isFolderResponse(struct soap *soap, struct _ns1__isFolderResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__boolean(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__isFolderResponse(struct soap *soap, const struct _ns1__isFolderResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->out, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__isFolderResponse(struct soap *soap, const struct _ns1__isFolderResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__isFolderResponse);
	if (soap_out__ns1__isFolderResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__isFolderResponse(struct soap *soap, const char *tag, int id, const struct _ns1__isFolderResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__isFolderResponse), type);
	soap_element_result(soap, "ns1:out");
	soap_out_xsd__boolean(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__isFolderResponse * SOAP_FMAC4 soap_get__ns1__isFolderResponse(struct soap *soap, struct _ns1__isFolderResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__isFolderResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__isFolderResponse * SOAP_FMAC4 soap_in__ns1__isFolderResponse(struct soap *soap, const char *tag, struct _ns1__isFolderResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__isFolderResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__isFolderResponse, sizeof(struct _ns1__isFolderResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__isFolderResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:out", &a->out, "xsd:boolean"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__isFolderResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__isFolderResponse, 0, sizeof(struct _ns1__isFolderResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__isFolder(struct soap *soap, struct _ns1__isFolder *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__isFolder(struct soap *soap, const struct _ns1__isFolder *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__isFolder(struct soap *soap, const struct _ns1__isFolder *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__isFolder);
	if (soap_out__ns1__isFolder(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__isFolder(struct soap *soap, const char *tag, int id, const struct _ns1__isFolder *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__isFolder), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__isFolder * SOAP_FMAC4 soap_get__ns1__isFolder(struct soap *soap, struct _ns1__isFolder *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__isFolder(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__isFolder * SOAP_FMAC4 soap_in__ns1__isFolder(struct soap *soap, const char *tag, struct _ns1__isFolder *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__isFolder *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__isFolder, sizeof(struct _ns1__isFolder), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__isFolder(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__isFolder *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__isFolder, 0, sizeof(struct _ns1__isFolder), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__downloadResponse(struct soap *soap, struct _ns1__downloadResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__downloadResponse(struct soap *soap, const struct _ns1__downloadResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__downloadResponse(struct soap *soap, const struct _ns1__downloadResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__downloadResponse);
	if (soap_out__ns1__downloadResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__downloadResponse(struct soap *soap, const char *tag, int id, const struct _ns1__downloadResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__downloadResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerToxsd__base64Binary(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__downloadResponse * SOAP_FMAC4 soap_get__ns1__downloadResponse(struct soap *soap, struct _ns1__downloadResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__downloadResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__downloadResponse * SOAP_FMAC4 soap_in__ns1__downloadResponse(struct soap *soap, const char *tag, struct _ns1__downloadResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__downloadResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__downloadResponse, sizeof(struct _ns1__downloadResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__downloadResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "ns1:out", &a->out, "xsd:base64Binary"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__downloadResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__downloadResponse, 0, sizeof(struct _ns1__downloadResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__download(struct soap *soap, struct _ns1__download *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__download(struct soap *soap, const struct _ns1__download *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__download(struct soap *soap, const struct _ns1__download *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__download);
	if (soap_out__ns1__download(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__download(struct soap *soap, const char *tag, int id, const struct _ns1__download *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__download), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__download * SOAP_FMAC4 soap_get__ns1__download(struct soap *soap, struct _ns1__download *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__download(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__download * SOAP_FMAC4 soap_in__ns1__download(struct soap *soap, const char *tag, struct _ns1__download *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__download *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__download, sizeof(struct _ns1__download), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__download(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__download *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__download, 0, sizeof(struct _ns1__download), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllJobPropertiesResponse(struct soap *soap, struct _ns1__getAllJobPropertiesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllJobPropertiesResponse(struct soap *soap, const struct _ns1__getAllJobPropertiesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__anyType2anyTypeMap(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllJobPropertiesResponse(struct soap *soap, const struct _ns1__getAllJobPropertiesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllJobPropertiesResponse);
	if (soap_out__ns1__getAllJobPropertiesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllJobPropertiesResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getAllJobPropertiesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllJobPropertiesResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllJobPropertiesResponse * SOAP_FMAC4 soap_get__ns1__getAllJobPropertiesResponse(struct soap *soap, struct _ns1__getAllJobPropertiesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllJobPropertiesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllJobPropertiesResponse * SOAP_FMAC4 soap_in__ns1__getAllJobPropertiesResponse(struct soap *soap, const char *tag, struct _ns1__getAllJobPropertiesResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllJobPropertiesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllJobPropertiesResponse, sizeof(struct _ns1__getAllJobPropertiesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllJobPropertiesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", &a->out, "ns1:anyType2anyTypeMap"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllJobPropertiesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllJobPropertiesResponse, 0, sizeof(struct _ns1__getAllJobPropertiesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllJobProperties(struct soap *soap, struct _ns1__getAllJobProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllJobProperties(struct soap *soap, const struct _ns1__getAllJobProperties *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllJobProperties(struct soap *soap, const struct _ns1__getAllJobProperties *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllJobProperties);
	if (soap_out__ns1__getAllJobProperties(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllJobProperties(struct soap *soap, const char *tag, int id, const struct _ns1__getAllJobProperties *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllJobProperties), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllJobProperties * SOAP_FMAC4 soap_get__ns1__getAllJobProperties(struct soap *soap, struct _ns1__getAllJobProperties *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllJobProperties(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllJobProperties * SOAP_FMAC4 soap_in__ns1__getAllJobProperties(struct soap *soap, const char *tag, struct _ns1__getAllJobProperties *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllJobProperties *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllJobProperties, sizeof(struct _ns1__getAllJobProperties), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllJobProperties(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllJobProperties *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllJobProperties, 0, sizeof(struct _ns1__getAllJobProperties), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllJobnamesResponse(struct soap *soap, struct _ns1__getAllJobnamesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllJobnamesResponse(struct soap *soap, const struct _ns1__getAllJobnamesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllJobnamesResponse(struct soap *soap, const struct _ns1__getAllJobnamesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllJobnamesResponse);
	if (soap_out__ns1__getAllJobnamesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllJobnamesResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getAllJobnamesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllJobnamesResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllJobnamesResponse * SOAP_FMAC4 soap_get__ns1__getAllJobnamesResponse(struct soap *soap, struct _ns1__getAllJobnamesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllJobnamesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllJobnamesResponse * SOAP_FMAC4 soap_in__ns1__getAllJobnamesResponse(struct soap *soap, const char *tag, struct _ns1__getAllJobnamesResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllJobnamesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllJobnamesResponse, sizeof(struct _ns1__getAllJobnamesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllJobnamesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllJobnamesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllJobnamesResponse, 0, sizeof(struct _ns1__getAllJobnamesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getAllJobnames(struct soap *soap, struct _ns1__getAllJobnames *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getAllJobnames(struct soap *soap, const struct _ns1__getAllJobnames *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getAllJobnames(struct soap *soap, const struct _ns1__getAllJobnames *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getAllJobnames);
	if (soap_out__ns1__getAllJobnames(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getAllJobnames(struct soap *soap, const char *tag, int id, const struct _ns1__getAllJobnames *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getAllJobnames), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getAllJobnames * SOAP_FMAC4 soap_get__ns1__getAllJobnames(struct soap *soap, struct _ns1__getAllJobnames *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getAllJobnames(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllJobnames * SOAP_FMAC4 soap_in__ns1__getAllJobnames(struct soap *soap, const char *tag, struct _ns1__getAllJobnames *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getAllJobnames *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getAllJobnames, sizeof(struct _ns1__getAllJobnames), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getAllJobnames(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllJobnames *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getAllJobnames, 0, sizeof(struct _ns1__getAllJobnames), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getDNResponse(struct soap *soap, struct _ns1__getDNResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getDNResponse(struct soap *soap, const struct _ns1__getDNResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getDNResponse(struct soap *soap, const struct _ns1__getDNResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getDNResponse);
	if (soap_out__ns1__getDNResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getDNResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getDNResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getDNResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getDNResponse * SOAP_FMAC4 soap_get__ns1__getDNResponse(struct soap *soap, struct _ns1__getDNResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getDNResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getDNResponse * SOAP_FMAC4 soap_in__ns1__getDNResponse(struct soap *soap, const char *tag, struct _ns1__getDNResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getDNResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getDNResponse, sizeof(struct _ns1__getDNResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getDNResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getDNResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getDNResponse, 0, sizeof(struct _ns1__getDNResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getDN(struct soap *soap, struct _ns1__getDN *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getDN(struct soap *soap, const struct _ns1__getDN *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getDN(struct soap *soap, const struct _ns1__getDN *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getDN);
	if (soap_out__ns1__getDN(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getDN(struct soap *soap, const char *tag, int id, const struct _ns1__getDN *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getDN), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getDN * SOAP_FMAC4 soap_get__ns1__getDN(struct soap *soap, struct _ns1__getDN *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getDN(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getDN * SOAP_FMAC4 soap_in__ns1__getDN(struct soap *soap, const char *tag, struct _ns1__getDN *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getDN *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getDN, sizeof(struct _ns1__getDN), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getDN(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getDN *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getDN, 0, sizeof(struct _ns1__getDN), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, struct _ns1__getSubmissionLocationsForApplicationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplicationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplicationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse);
	if (soap_out__ns1__getSubmissionLocationsForApplicationResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getSubmissionLocationsForApplicationResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplicationResponse * SOAP_FMAC4 soap_get__ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, struct _ns1__getSubmissionLocationsForApplicationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSubmissionLocationsForApplicationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplicationResponse * SOAP_FMAC4 soap_in__ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsForApplicationResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSubmissionLocationsForApplicationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse, sizeof(struct _ns1__getSubmissionLocationsForApplicationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSubmissionLocationsForApplicationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsForApplicationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse, 0, sizeof(struct _ns1__getSubmissionLocationsForApplicationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSubmissionLocationsForApplication(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSubmissionLocationsForApplication(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSubmissionLocationsForApplication(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSubmissionLocationsForApplication);
	if (soap_out__ns1__getSubmissionLocationsForApplication(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSubmissionLocationsForApplication(struct soap *soap, const char *tag, int id, const struct _ns1__getSubmissionLocationsForApplication *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication * SOAP_FMAC4 soap_get__ns1__getSubmissionLocationsForApplication(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSubmissionLocationsForApplication(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication * SOAP_FMAC4 soap_in__ns1__getSubmissionLocationsForApplication(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsForApplication *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSubmissionLocationsForApplication *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication, sizeof(struct _ns1__getSubmissionLocationsForApplication), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSubmissionLocationsForApplication(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsForApplication *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSubmissionLocationsForApplication, 0, sizeof(struct _ns1__getSubmissionLocationsForApplication), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__createJob1Response(struct soap *soap, struct _ns1__createJob1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__createJob1Response(struct soap *soap, const struct _ns1__createJob1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__createJob1Response(struct soap *soap, const struct _ns1__createJob1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__createJob1Response);
	if (soap_out__ns1__createJob1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__createJob1Response(struct soap *soap, const char *tag, int id, const struct _ns1__createJob1Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__createJob1Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__createJob1Response * SOAP_FMAC4 soap_get__ns1__createJob1Response(struct soap *soap, struct _ns1__createJob1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__createJob1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__createJob1Response * SOAP_FMAC4 soap_in__ns1__createJob1Response(struct soap *soap, const char *tag, struct _ns1__createJob1Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__createJob1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__createJob1Response, sizeof(struct _ns1__createJob1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__createJob1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__createJob1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__createJob1Response, 0, sizeof(struct _ns1__createJob1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__createJob1(struct soap *soap, struct _ns1__createJob1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->in0 = NULL;
	soap_default_int(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__createJob1(struct soap *soap, const struct _ns1__createJob1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__createJob1(struct soap *soap, const struct _ns1__createJob1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__createJob1);
	if (soap_out__ns1__createJob1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__createJob1(struct soap *soap, const char *tag, int id, const struct _ns1__createJob1 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__createJob1), type);
	soap_outliteral(soap, "ns1:in0", &a->in0, NULL);
	soap_out_int(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__createJob1 * SOAP_FMAC4 soap_get__ns1__createJob1(struct soap *soap, struct _ns1__createJob1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__createJob1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__createJob1 * SOAP_FMAC4 soap_in__ns1__createJob1(struct soap *soap, const char *tag, struct _ns1__createJob1 *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__createJob1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__createJob1, sizeof(struct _ns1__createJob1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__createJob1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:in0", &a->in0))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:in1", &a->in1, "xsd:int"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__createJob1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__createJob1, 0, sizeof(struct _ns1__createJob1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getApplicationDetailsResponse(struct soap *soap, struct _ns1__getApplicationDetailsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getApplicationDetailsResponse(struct soap *soap, const struct _ns1__getApplicationDetailsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__anyType2anyTypeMap(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getApplicationDetailsResponse(struct soap *soap, const struct _ns1__getApplicationDetailsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getApplicationDetailsResponse);
	if (soap_out__ns1__getApplicationDetailsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getApplicationDetailsResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getApplicationDetailsResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getApplicationDetailsResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getApplicationDetailsResponse * SOAP_FMAC4 soap_get__ns1__getApplicationDetailsResponse(struct soap *soap, struct _ns1__getApplicationDetailsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getApplicationDetailsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getApplicationDetailsResponse * SOAP_FMAC4 soap_in__ns1__getApplicationDetailsResponse(struct soap *soap, const char *tag, struct _ns1__getApplicationDetailsResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getApplicationDetailsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getApplicationDetailsResponse, sizeof(struct _ns1__getApplicationDetailsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getApplicationDetailsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", &a->out, "ns1:anyType2anyTypeMap"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getApplicationDetailsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getApplicationDetailsResponse, 0, sizeof(struct _ns1__getApplicationDetailsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getApplicationDetails(struct soap *soap, struct _ns1__getApplicationDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getApplicationDetails(struct soap *soap, const struct _ns1__getApplicationDetails *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getApplicationDetails(struct soap *soap, const struct _ns1__getApplicationDetails *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getApplicationDetails);
	if (soap_out__ns1__getApplicationDetails(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getApplicationDetails(struct soap *soap, const char *tag, int id, const struct _ns1__getApplicationDetails *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getApplicationDetails), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getApplicationDetails * SOAP_FMAC4 soap_get__ns1__getApplicationDetails(struct soap *soap, struct _ns1__getApplicationDetails *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getApplicationDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getApplicationDetails * SOAP_FMAC4 soap_in__ns1__getApplicationDetails(struct soap *soap, const char *tag, struct _ns1__getApplicationDetails *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getApplicationDetails *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getApplicationDetails, sizeof(struct _ns1__getApplicationDetails), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getApplicationDetails(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getApplicationDetails *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getApplicationDetails, 0, sizeof(struct _ns1__getApplicationDetails), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSubmissionLocationsForApplication1Response(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSubmissionLocationsForApplication1Response(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSubmissionLocationsForApplication1Response(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSubmissionLocationsForApplication1Response);
	if (soap_out__ns1__getSubmissionLocationsForApplication1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSubmissionLocationsForApplication1Response(struct soap *soap, const char *tag, int id, const struct _ns1__getSubmissionLocationsForApplication1Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication1Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication1Response * SOAP_FMAC4 soap_get__ns1__getSubmissionLocationsForApplication1Response(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSubmissionLocationsForApplication1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication1Response * SOAP_FMAC4 soap_in__ns1__getSubmissionLocationsForApplication1Response(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsForApplication1Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSubmissionLocationsForApplication1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication1Response, sizeof(struct _ns1__getSubmissionLocationsForApplication1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSubmissionLocationsForApplication1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsForApplication1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSubmissionLocationsForApplication1Response, 0, sizeof(struct _ns1__getSubmissionLocationsForApplication1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSubmissionLocationsForApplication1(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSubmissionLocationsForApplication1(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSubmissionLocationsForApplication1(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSubmissionLocationsForApplication1);
	if (soap_out__ns1__getSubmissionLocationsForApplication1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSubmissionLocationsForApplication1(struct soap *soap, const char *tag, int id, const struct _ns1__getSubmissionLocationsForApplication1 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication1), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication1 * SOAP_FMAC4 soap_get__ns1__getSubmissionLocationsForApplication1(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSubmissionLocationsForApplication1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication1 * SOAP_FMAC4 soap_in__ns1__getSubmissionLocationsForApplication1(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsForApplication1 *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSubmissionLocationsForApplication1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication1, sizeof(struct _ns1__getSubmissionLocationsForApplication1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSubmissionLocationsForApplication1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsForApplication1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSubmissionLocationsForApplication1, 0, sizeof(struct _ns1__getSubmissionLocationsForApplication1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__ls_USCOREstringResponse(struct soap *soap, struct _ns1__ls_USCOREstringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__ls_USCOREstringResponse(struct soap *soap, const struct _ns1__ls_USCOREstringResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__ls_USCOREstringResponse(struct soap *soap, const struct _ns1__ls_USCOREstringResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__ls_USCOREstringResponse);
	if (soap_out__ns1__ls_USCOREstringResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__ls_USCOREstringResponse(struct soap *soap, const char *tag, int id, const struct _ns1__ls_USCOREstringResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__ls_USCOREstringResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__ls_USCOREstringResponse * SOAP_FMAC4 soap_get__ns1__ls_USCOREstringResponse(struct soap *soap, struct _ns1__ls_USCOREstringResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__ls_USCOREstringResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ls_USCOREstringResponse * SOAP_FMAC4 soap_in__ns1__ls_USCOREstringResponse(struct soap *soap, const char *tag, struct _ns1__ls_USCOREstringResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__ls_USCOREstringResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__ls_USCOREstringResponse, sizeof(struct _ns1__ls_USCOREstringResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__ls_USCOREstringResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__ls_USCOREstringResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__ls_USCOREstringResponse, 0, sizeof(struct _ns1__ls_USCOREstringResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__ls_USCOREstring(struct soap *soap, struct _ns1__ls_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_int(soap, &a->in1);
	soap_default_xsd__boolean(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__ls_USCOREstring(struct soap *soap, const struct _ns1__ls_USCOREstring *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_embedded(soap, &a->in2, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__ls_USCOREstring(struct soap *soap, const struct _ns1__ls_USCOREstring *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__ls_USCOREstring);
	if (soap_out__ns1__ls_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__ls_USCOREstring(struct soap *soap, const char *tag, int id, const struct _ns1__ls_USCOREstring *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__ls_USCOREstring), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_int(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_xsd__boolean(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__ls_USCOREstring * SOAP_FMAC4 soap_get__ns1__ls_USCOREstring(struct soap *soap, struct _ns1__ls_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__ls_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ls_USCOREstring * SOAP_FMAC4 soap_in__ns1__ls_USCOREstring(struct soap *soap, const char *tag, struct _ns1__ls_USCOREstring *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__ls_USCOREstring *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__ls_USCOREstring, sizeof(struct _ns1__ls_USCOREstring), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__ls_USCOREstring(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:in1", &a->in1, "xsd:int"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in2", &a->in2, "xsd:boolean"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__ls_USCOREstring *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__ls_USCOREstring, 0, sizeof(struct _ns1__ls_USCOREstring), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__calculateAbsoluteJobDirectoryResponse(struct soap *soap, struct _ns1__calculateAbsoluteJobDirectoryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__calculateAbsoluteJobDirectoryResponse(struct soap *soap, const struct _ns1__calculateAbsoluteJobDirectoryResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__calculateAbsoluteJobDirectoryResponse(struct soap *soap, const struct _ns1__calculateAbsoluteJobDirectoryResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__calculateAbsoluteJobDirectoryResponse);
	if (soap_out__ns1__calculateAbsoluteJobDirectoryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__calculateAbsoluteJobDirectoryResponse(struct soap *soap, const char *tag, int id, const struct _ns1__calculateAbsoluteJobDirectoryResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__calculateAbsoluteJobDirectoryResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__calculateAbsoluteJobDirectoryResponse * SOAP_FMAC4 soap_get__ns1__calculateAbsoluteJobDirectoryResponse(struct soap *soap, struct _ns1__calculateAbsoluteJobDirectoryResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__calculateAbsoluteJobDirectoryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__calculateAbsoluteJobDirectoryResponse * SOAP_FMAC4 soap_in__ns1__calculateAbsoluteJobDirectoryResponse(struct soap *soap, const char *tag, struct _ns1__calculateAbsoluteJobDirectoryResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__calculateAbsoluteJobDirectoryResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__calculateAbsoluteJobDirectoryResponse, sizeof(struct _ns1__calculateAbsoluteJobDirectoryResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__calculateAbsoluteJobDirectoryResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__calculateAbsoluteJobDirectoryResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__calculateAbsoluteJobDirectoryResponse, 0, sizeof(struct _ns1__calculateAbsoluteJobDirectoryResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__calculateAbsoluteJobDirectory(struct soap *soap, struct _ns1__calculateAbsoluteJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
	soap_default_string(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__calculateAbsoluteJobDirectory(struct soap *soap, const struct _ns1__calculateAbsoluteJobDirectory *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_serialize_string(soap, &a->in2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__calculateAbsoluteJobDirectory(struct soap *soap, const struct _ns1__calculateAbsoluteJobDirectory *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__calculateAbsoluteJobDirectory);
	if (soap_out__ns1__calculateAbsoluteJobDirectory(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__calculateAbsoluteJobDirectory(struct soap *soap, const char *tag, int id, const struct _ns1__calculateAbsoluteJobDirectory *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__calculateAbsoluteJobDirectory), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_string(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__calculateAbsoluteJobDirectory * SOAP_FMAC4 soap_get__ns1__calculateAbsoluteJobDirectory(struct soap *soap, struct _ns1__calculateAbsoluteJobDirectory *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__calculateAbsoluteJobDirectory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__calculateAbsoluteJobDirectory * SOAP_FMAC4 soap_in__ns1__calculateAbsoluteJobDirectory(struct soap *soap, const char *tag, struct _ns1__calculateAbsoluteJobDirectory *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__calculateAbsoluteJobDirectory *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__calculateAbsoluteJobDirectory, sizeof(struct _ns1__calculateAbsoluteJobDirectory), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__calculateAbsoluteJobDirectory(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in2", &a->in2, "xsd:string"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__calculateAbsoluteJobDirectory *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__calculateAbsoluteJobDirectory, 0, sizeof(struct _ns1__calculateAbsoluteJobDirectory), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getMessagesSinceResponse(struct soap *soap, struct _ns1__getMessagesSinceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getMessagesSinceResponse(struct soap *soap, const struct _ns1__getMessagesSinceResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getMessagesSinceResponse(struct soap *soap, const struct _ns1__getMessagesSinceResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getMessagesSinceResponse);
	if (soap_out__ns1__getMessagesSinceResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getMessagesSinceResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getMessagesSinceResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getMessagesSinceResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_outliteral(soap, "ns1:out", &a->out, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getMessagesSinceResponse * SOAP_FMAC4 soap_get__ns1__getMessagesSinceResponse(struct soap *soap, struct _ns1__getMessagesSinceResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getMessagesSinceResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getMessagesSinceResponse * SOAP_FMAC4 soap_in__ns1__getMessagesSinceResponse(struct soap *soap, const char *tag, struct _ns1__getMessagesSinceResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getMessagesSinceResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getMessagesSinceResponse, sizeof(struct _ns1__getMessagesSinceResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getMessagesSinceResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:out", &a->out))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getMessagesSinceResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getMessagesSinceResponse, 0, sizeof(struct _ns1__getMessagesSinceResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getMessagesSince(struct soap *soap, struct _ns1__getMessagesSince *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_time(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getMessagesSince(struct soap *soap, const struct _ns1__getMessagesSince *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getMessagesSince(struct soap *soap, const struct _ns1__getMessagesSince *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getMessagesSince);
	if (soap_out__ns1__getMessagesSince(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getMessagesSince(struct soap *soap, const char *tag, int id, const struct _ns1__getMessagesSince *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getMessagesSince), type);
	soap_out_time(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getMessagesSince * SOAP_FMAC4 soap_get__ns1__getMessagesSince(struct soap *soap, struct _ns1__getMessagesSince *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getMessagesSince(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getMessagesSince * SOAP_FMAC4 soap_in__ns1__getMessagesSince(struct soap *soap, const char *tag, struct _ns1__getMessagesSince *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getMessagesSince *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getMessagesSince, sizeof(struct _ns1__getMessagesSince), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getMessagesSince(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_time(soap, "ns1:in0", &a->in0, "xsd:dateTime"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getMessagesSince *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getMessagesSince, 0, sizeof(struct _ns1__getMessagesSince), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__deleteFilesResponse(struct soap *soap, struct _ns1__deleteFilesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__deleteFilesResponse(struct soap *soap, const struct _ns1__deleteFilesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__deleteFilesResponse(struct soap *soap, const struct _ns1__deleteFilesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__deleteFilesResponse);
	if (soap_out__ns1__deleteFilesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__deleteFilesResponse(struct soap *soap, const char *tag, int id, const struct _ns1__deleteFilesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__deleteFilesResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__deleteFilesResponse * SOAP_FMAC4 soap_get__ns1__deleteFilesResponse(struct soap *soap, struct _ns1__deleteFilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__deleteFilesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__deleteFilesResponse * SOAP_FMAC4 soap_in__ns1__deleteFilesResponse(struct soap *soap, const char *tag, struct _ns1__deleteFilesResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__deleteFilesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__deleteFilesResponse, sizeof(struct _ns1__deleteFilesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__deleteFilesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__deleteFilesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__deleteFilesResponse, 0, sizeof(struct _ns1__deleteFilesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__deleteFiles(struct soap *soap, struct _ns1__deleteFiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->in0 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__deleteFiles(struct soap *soap, const struct _ns1__deleteFiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__deleteFiles(struct soap *soap, const struct _ns1__deleteFiles *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__deleteFiles);
	if (soap_out__ns1__deleteFiles(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__deleteFiles(struct soap *soap, const char *tag, int id, const struct _ns1__deleteFiles *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__deleteFiles), type);
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__deleteFiles * SOAP_FMAC4 soap_get__ns1__deleteFiles(struct soap *soap, struct _ns1__deleteFiles *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__deleteFiles(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__deleteFiles * SOAP_FMAC4 soap_in__ns1__deleteFiles(struct soap *soap, const char *tag, struct _ns1__deleteFiles *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__deleteFiles *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__deleteFiles, sizeof(struct _ns1__deleteFiles), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__deleteFiles(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:in0", &a->in0, "ns1:ArrayOfString"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__deleteFiles *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__deleteFiles, 0, sizeof(struct _ns1__deleteFiles), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__listHostedApplicationTemplatesResponse(struct soap *soap, struct _ns1__listHostedApplicationTemplatesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__listHostedApplicationTemplatesResponse(struct soap *soap, const struct _ns1__listHostedApplicationTemplatesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__listHostedApplicationTemplatesResponse(struct soap *soap, const struct _ns1__listHostedApplicationTemplatesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__listHostedApplicationTemplatesResponse);
	if (soap_out__ns1__listHostedApplicationTemplatesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__listHostedApplicationTemplatesResponse(struct soap *soap, const char *tag, int id, const struct _ns1__listHostedApplicationTemplatesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__listHostedApplicationTemplatesResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__listHostedApplicationTemplatesResponse * SOAP_FMAC4 soap_get__ns1__listHostedApplicationTemplatesResponse(struct soap *soap, struct _ns1__listHostedApplicationTemplatesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__listHostedApplicationTemplatesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__listHostedApplicationTemplatesResponse * SOAP_FMAC4 soap_in__ns1__listHostedApplicationTemplatesResponse(struct soap *soap, const char *tag, struct _ns1__listHostedApplicationTemplatesResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__listHostedApplicationTemplatesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__listHostedApplicationTemplatesResponse, sizeof(struct _ns1__listHostedApplicationTemplatesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__listHostedApplicationTemplatesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__listHostedApplicationTemplatesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__listHostedApplicationTemplatesResponse, 0, sizeof(struct _ns1__listHostedApplicationTemplatesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__listHostedApplicationTemplates(struct soap *soap, struct _ns1__listHostedApplicationTemplates *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__listHostedApplicationTemplates(struct soap *soap, const struct _ns1__listHostedApplicationTemplates *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__listHostedApplicationTemplates(struct soap *soap, const struct _ns1__listHostedApplicationTemplates *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__listHostedApplicationTemplates);
	if (soap_out__ns1__listHostedApplicationTemplates(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__listHostedApplicationTemplates(struct soap *soap, const char *tag, int id, const struct _ns1__listHostedApplicationTemplates *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__listHostedApplicationTemplates), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__listHostedApplicationTemplates * SOAP_FMAC4 soap_get__ns1__listHostedApplicationTemplates(struct soap *soap, struct _ns1__listHostedApplicationTemplates *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__listHostedApplicationTemplates(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__listHostedApplicationTemplates * SOAP_FMAC4 soap_in__ns1__listHostedApplicationTemplates(struct soap *soap, const char *tag, struct _ns1__listHostedApplicationTemplates *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__listHostedApplicationTemplates *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__listHostedApplicationTemplates, sizeof(struct _ns1__listHostedApplicationTemplates), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__listHostedApplicationTemplates(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__listHostedApplicationTemplates *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__listHostedApplicationTemplates, 0, sizeof(struct _ns1__listHostedApplicationTemplates), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__downloadByteArray1Response(struct soap *soap, struct _ns1__downloadByteArray1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__downloadByteArray1Response(struct soap *soap, const struct _ns1__downloadByteArray1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__downloadByteArray1Response(struct soap *soap, const struct _ns1__downloadByteArray1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__downloadByteArray1Response);
	if (soap_out__ns1__downloadByteArray1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__downloadByteArray1Response(struct soap *soap, const char *tag, int id, const struct _ns1__downloadByteArray1Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__downloadByteArray1Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerToxsd__base64Binary(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__downloadByteArray1Response * SOAP_FMAC4 soap_get__ns1__downloadByteArray1Response(struct soap *soap, struct _ns1__downloadByteArray1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__downloadByteArray1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__downloadByteArray1Response * SOAP_FMAC4 soap_in__ns1__downloadByteArray1Response(struct soap *soap, const char *tag, struct _ns1__downloadByteArray1Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__downloadByteArray1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__downloadByteArray1Response, sizeof(struct _ns1__downloadByteArray1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__downloadByteArray1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "ns1:out", &a->out, "xsd:base64Binary"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__downloadByteArray1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__downloadByteArray1Response, 0, sizeof(struct _ns1__downloadByteArray1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__downloadByteArray1(struct soap *soap, struct _ns1__downloadByteArray1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_int(soap, &a->in1);
	soap_default_int(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__downloadByteArray1(struct soap *soap, const struct _ns1__downloadByteArray1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__downloadByteArray1(struct soap *soap, const struct _ns1__downloadByteArray1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__downloadByteArray1);
	if (soap_out__ns1__downloadByteArray1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__downloadByteArray1(struct soap *soap, const char *tag, int id, const struct _ns1__downloadByteArray1 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__downloadByteArray1), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_int(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_int(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__downloadByteArray1 * SOAP_FMAC4 soap_get__ns1__downloadByteArray1(struct soap *soap, struct _ns1__downloadByteArray1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__downloadByteArray1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__downloadByteArray1 * SOAP_FMAC4 soap_in__ns1__downloadByteArray1(struct soap *soap, const char *tag, struct _ns1__downloadByteArray1 *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__downloadByteArray1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__downloadByteArray1, sizeof(struct _ns1__downloadByteArray1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__downloadByteArray1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:in1", &a->in1, "xsd:int"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "ns1:in2", &a->in2, "xsd:int"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__downloadByteArray1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__downloadByteArray1, 0, sizeof(struct _ns1__downloadByteArray1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getTemplate1Response(struct soap *soap, struct _ns1__getTemplate1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getTemplate1Response(struct soap *soap, const struct _ns1__getTemplate1Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getTemplate1Response(struct soap *soap, const struct _ns1__getTemplate1Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getTemplate1Response);
	if (soap_out__ns1__getTemplate1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getTemplate1Response(struct soap *soap, const char *tag, int id, const struct _ns1__getTemplate1Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getTemplate1Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_outliteral(soap, "ns1:out", &a->out, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getTemplate1Response * SOAP_FMAC4 soap_get__ns1__getTemplate1Response(struct soap *soap, struct _ns1__getTemplate1Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getTemplate1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getTemplate1Response * SOAP_FMAC4 soap_in__ns1__getTemplate1Response(struct soap *soap, const char *tag, struct _ns1__getTemplate1Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getTemplate1Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getTemplate1Response, sizeof(struct _ns1__getTemplate1Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getTemplate1Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:out", &a->out))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getTemplate1Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getTemplate1Response, 0, sizeof(struct _ns1__getTemplate1Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getTemplate1(struct soap *soap, struct _ns1__getTemplate1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getTemplate1(struct soap *soap, const struct _ns1__getTemplate1 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getTemplate1(struct soap *soap, const struct _ns1__getTemplate1 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getTemplate1);
	if (soap_out__ns1__getTemplate1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getTemplate1(struct soap *soap, const char *tag, int id, const struct _ns1__getTemplate1 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getTemplate1), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getTemplate1 * SOAP_FMAC4 soap_get__ns1__getTemplate1(struct soap *soap, struct _ns1__getTemplate1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getTemplate1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getTemplate1 * SOAP_FMAC4 soap_in__ns1__getTemplate1(struct soap *soap, const char *tag, struct _ns1__getTemplate1 *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getTemplate1 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getTemplate1, sizeof(struct _ns1__getTemplate1), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getTemplate1(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getTemplate1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getTemplate1, 0, sizeof(struct _ns1__getTemplate1), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(struct soap *soap, struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(struct soap *soap, const struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__anyType2anyTypeMap(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(struct soap *soap, const struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplicationResponse);
	if (soap_out__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplicationResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse * SOAP_FMAC4 soap_get__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(struct soap *soap, struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse * SOAP_FMAC4 soap_in__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplicationResponse, sizeof(struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSubmissionLocationsPerVersionOfApplicationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", &a->out, "ns1:anyType2anyTypeMap"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplicationResponse, 0, sizeof(struct _ns1__getSubmissionLocationsPerVersionOfApplicationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, struct _ns1__getSubmissionLocationsPerVersionOfApplication *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, const struct _ns1__getSubmissionLocationsPerVersionOfApplication *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, const struct _ns1__getSubmissionLocationsPerVersionOfApplication *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplication);
	if (soap_out__ns1__getSubmissionLocationsPerVersionOfApplication(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, const char *tag, int id, const struct _ns1__getSubmissionLocationsPerVersionOfApplication *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplication), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsPerVersionOfApplication * SOAP_FMAC4 soap_get__ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, struct _ns1__getSubmissionLocationsPerVersionOfApplication *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSubmissionLocationsPerVersionOfApplication(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsPerVersionOfApplication * SOAP_FMAC4 soap_in__ns1__getSubmissionLocationsPerVersionOfApplication(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsPerVersionOfApplication *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSubmissionLocationsPerVersionOfApplication *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplication, sizeof(struct _ns1__getSubmissionLocationsPerVersionOfApplication), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSubmissionLocationsPerVersionOfApplication(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsPerVersionOfApplication *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSubmissionLocationsPerVersionOfApplication, 0, sizeof(struct _ns1__getSubmissionLocationsPerVersionOfApplication), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getDataLocationsForVOResponse(struct soap *soap, struct _ns1__getDataLocationsForVOResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getDataLocationsForVOResponse(struct soap *soap, const struct _ns1__getDataLocationsForVOResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__anyType2anyTypeMap(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getDataLocationsForVOResponse(struct soap *soap, const struct _ns1__getDataLocationsForVOResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getDataLocationsForVOResponse);
	if (soap_out__ns1__getDataLocationsForVOResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getDataLocationsForVOResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getDataLocationsForVOResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getDataLocationsForVOResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getDataLocationsForVOResponse * SOAP_FMAC4 soap_get__ns1__getDataLocationsForVOResponse(struct soap *soap, struct _ns1__getDataLocationsForVOResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getDataLocationsForVOResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getDataLocationsForVOResponse * SOAP_FMAC4 soap_in__ns1__getDataLocationsForVOResponse(struct soap *soap, const char *tag, struct _ns1__getDataLocationsForVOResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getDataLocationsForVOResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getDataLocationsForVOResponse, sizeof(struct _ns1__getDataLocationsForVOResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getDataLocationsForVOResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__anyType2anyTypeMap(soap, "ns1:out", &a->out, "ns1:anyType2anyTypeMap"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getDataLocationsForVOResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getDataLocationsForVOResponse, 0, sizeof(struct _ns1__getDataLocationsForVOResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getDataLocationsForVO(struct soap *soap, struct _ns1__getDataLocationsForVO *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getDataLocationsForVO(struct soap *soap, const struct _ns1__getDataLocationsForVO *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getDataLocationsForVO(struct soap *soap, const struct _ns1__getDataLocationsForVO *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getDataLocationsForVO);
	if (soap_out__ns1__getDataLocationsForVO(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getDataLocationsForVO(struct soap *soap, const char *tag, int id, const struct _ns1__getDataLocationsForVO *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getDataLocationsForVO), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getDataLocationsForVO * SOAP_FMAC4 soap_get__ns1__getDataLocationsForVO(struct soap *soap, struct _ns1__getDataLocationsForVO *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getDataLocationsForVO(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getDataLocationsForVO * SOAP_FMAC4 soap_in__ns1__getDataLocationsForVO(struct soap *soap, const char *tag, struct _ns1__getDataLocationsForVO *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getDataLocationsForVO *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getDataLocationsForVO, sizeof(struct _ns1__getDataLocationsForVO), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getDataLocationsForVO(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getDataLocationsForVO *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getDataLocationsForVO, 0, sizeof(struct _ns1__getDataLocationsForVO), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__mkdirResponse(struct soap *soap, struct _ns1__mkdirResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_xsd__boolean(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__mkdirResponse(struct soap *soap, const struct _ns1__mkdirResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_embedded(soap, &a->out, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__mkdirResponse(struct soap *soap, const struct _ns1__mkdirResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__mkdirResponse);
	if (soap_out__ns1__mkdirResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__mkdirResponse(struct soap *soap, const char *tag, int id, const struct _ns1__mkdirResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__mkdirResponse), type);
	soap_element_result(soap, "ns1:out");
	soap_out_xsd__boolean(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__mkdirResponse * SOAP_FMAC4 soap_get__ns1__mkdirResponse(struct soap *soap, struct _ns1__mkdirResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__mkdirResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__mkdirResponse * SOAP_FMAC4 soap_in__ns1__mkdirResponse(struct soap *soap, const char *tag, struct _ns1__mkdirResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__mkdirResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__mkdirResponse, sizeof(struct _ns1__mkdirResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__mkdirResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:out", &a->out, "xsd:boolean"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__mkdirResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__mkdirResponse, 0, sizeof(struct _ns1__mkdirResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__mkdir(struct soap *soap, struct _ns1__mkdir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__mkdir(struct soap *soap, const struct _ns1__mkdir *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__mkdir(struct soap *soap, const struct _ns1__mkdir *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__mkdir);
	if (soap_out__ns1__mkdir(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__mkdir(struct soap *soap, const char *tag, int id, const struct _ns1__mkdir *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__mkdir), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__mkdir * SOAP_FMAC4 soap_get__ns1__mkdir(struct soap *soap, struct _ns1__mkdir *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__mkdir(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__mkdir * SOAP_FMAC4 soap_in__ns1__mkdir(struct soap *soap, const char *tag, struct _ns1__mkdir *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__mkdir *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__mkdir, sizeof(struct _ns1__mkdir), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__mkdir(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__mkdir *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__mkdir, 0, sizeof(struct _ns1__mkdir), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getUserPropertyResponse(struct soap *soap, struct _ns1__getUserPropertyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getUserPropertyResponse(struct soap *soap, const struct _ns1__getUserPropertyResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getUserPropertyResponse(struct soap *soap, const struct _ns1__getUserPropertyResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getUserPropertyResponse);
	if (soap_out__ns1__getUserPropertyResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getUserPropertyResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getUserPropertyResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getUserPropertyResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getUserPropertyResponse * SOAP_FMAC4 soap_get__ns1__getUserPropertyResponse(struct soap *soap, struct _ns1__getUserPropertyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getUserPropertyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getUserPropertyResponse * SOAP_FMAC4 soap_in__ns1__getUserPropertyResponse(struct soap *soap, const char *tag, struct _ns1__getUserPropertyResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getUserPropertyResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getUserPropertyResponse, sizeof(struct _ns1__getUserPropertyResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getUserPropertyResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getUserPropertyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getUserPropertyResponse, 0, sizeof(struct _ns1__getUserPropertyResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getUserProperty(struct soap *soap, struct _ns1__getUserProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getUserProperty(struct soap *soap, const struct _ns1__getUserProperty *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getUserProperty(struct soap *soap, const struct _ns1__getUserProperty *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getUserProperty);
	if (soap_out__ns1__getUserProperty(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getUserProperty(struct soap *soap, const char *tag, int id, const struct _ns1__getUserProperty *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getUserProperty), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getUserProperty * SOAP_FMAC4 soap_get__ns1__getUserProperty(struct soap *soap, struct _ns1__getUserProperty *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getUserProperty(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getUserProperty * SOAP_FMAC4 soap_in__ns1__getUserProperty(struct soap *soap, const char *tag, struct _ns1__getUserProperty *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getUserProperty *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getUserProperty, sizeof(struct _ns1__getUserProperty), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getUserProperty(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getUserProperty *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getUserProperty, 0, sizeof(struct _ns1__getUserProperty), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getStagingFileSystemForSubmissionLocationResponse(struct soap *soap, struct _ns1__getStagingFileSystemForSubmissionLocationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getStagingFileSystemForSubmissionLocationResponse(struct soap *soap, const struct _ns1__getStagingFileSystemForSubmissionLocationResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getStagingFileSystemForSubmissionLocationResponse(struct soap *soap, const struct _ns1__getStagingFileSystemForSubmissionLocationResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocationResponse);
	if (soap_out__ns1__getStagingFileSystemForSubmissionLocationResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getStagingFileSystemForSubmissionLocationResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getStagingFileSystemForSubmissionLocationResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocationResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getStagingFileSystemForSubmissionLocationResponse * SOAP_FMAC4 soap_get__ns1__getStagingFileSystemForSubmissionLocationResponse(struct soap *soap, struct _ns1__getStagingFileSystemForSubmissionLocationResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getStagingFileSystemForSubmissionLocationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getStagingFileSystemForSubmissionLocationResponse * SOAP_FMAC4 soap_in__ns1__getStagingFileSystemForSubmissionLocationResponse(struct soap *soap, const char *tag, struct _ns1__getStagingFileSystemForSubmissionLocationResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getStagingFileSystemForSubmissionLocationResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocationResponse, sizeof(struct _ns1__getStagingFileSystemForSubmissionLocationResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getStagingFileSystemForSubmissionLocationResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getStagingFileSystemForSubmissionLocationResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocationResponse, 0, sizeof(struct _ns1__getStagingFileSystemForSubmissionLocationResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, struct _ns1__getStagingFileSystemForSubmissionLocation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, const struct _ns1__getStagingFileSystemForSubmissionLocation *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, const struct _ns1__getStagingFileSystemForSubmissionLocation *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocation);
	if (soap_out__ns1__getStagingFileSystemForSubmissionLocation(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, const char *tag, int id, const struct _ns1__getStagingFileSystemForSubmissionLocation *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocation), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getStagingFileSystemForSubmissionLocation * SOAP_FMAC4 soap_get__ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, struct _ns1__getStagingFileSystemForSubmissionLocation *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getStagingFileSystemForSubmissionLocation(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getStagingFileSystemForSubmissionLocation * SOAP_FMAC4 soap_in__ns1__getStagingFileSystemForSubmissionLocation(struct soap *soap, const char *tag, struct _ns1__getStagingFileSystemForSubmissionLocation *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getStagingFileSystemForSubmissionLocation *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocation, sizeof(struct _ns1__getStagingFileSystemForSubmissionLocation), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getStagingFileSystemForSubmissionLocation(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getStagingFileSystemForSubmissionLocation *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getStagingFileSystemForSubmissionLocation, 0, sizeof(struct _ns1__getStagingFileSystemForSubmissionLocation), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__psResponse(struct soap *soap, struct _ns1__psResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__psResponse(struct soap *soap, const struct _ns1__psResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__psResponse(struct soap *soap, const struct _ns1__psResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__psResponse);
	if (soap_out__ns1__psResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__psResponse(struct soap *soap, const char *tag, int id, const struct _ns1__psResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__psResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_outliteral(soap, "ns1:out", &a->out, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__psResponse * SOAP_FMAC4 soap_get__ns1__psResponse(struct soap *soap, struct _ns1__psResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__psResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__psResponse * SOAP_FMAC4 soap_in__ns1__psResponse(struct soap *soap, const char *tag, struct _ns1__psResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__psResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__psResponse, sizeof(struct _ns1__psResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__psResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:out", &a->out))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__psResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__psResponse, 0, sizeof(struct _ns1__psResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__ps(struct soap *soap, struct _ns1__ps *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__ps(struct soap *soap, const struct _ns1__ps *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__ps(struct soap *soap, const struct _ns1__ps *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__ps);
	if (soap_out__ns1__ps(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__ps(struct soap *soap, const char *tag, int id, const struct _ns1__ps *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__ps), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__ps * SOAP_FMAC4 soap_get__ns1__ps(struct soap *soap, struct _ns1__ps *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__ps(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ps * SOAP_FMAC4 soap_in__ns1__ps(struct soap *soap, const char *tag, struct _ns1__ps *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__ps *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__ps, sizeof(struct _ns1__ps), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__ps(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__ps *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__ps, 0, sizeof(struct _ns1__ps), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSubmissionLocationsForApplication2Response(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication2Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSubmissionLocationsForApplication2Response(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication2Response *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSubmissionLocationsForApplication2Response(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication2Response *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSubmissionLocationsForApplication2Response);
	if (soap_out__ns1__getSubmissionLocationsForApplication2Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSubmissionLocationsForApplication2Response(struct soap *soap, const char *tag, int id, const struct _ns1__getSubmissionLocationsForApplication2Response *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication2Response), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication2Response * SOAP_FMAC4 soap_get__ns1__getSubmissionLocationsForApplication2Response(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication2Response *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSubmissionLocationsForApplication2Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication2Response * SOAP_FMAC4 soap_in__ns1__getSubmissionLocationsForApplication2Response(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsForApplication2Response *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSubmissionLocationsForApplication2Response *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication2Response, sizeof(struct _ns1__getSubmissionLocationsForApplication2Response), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSubmissionLocationsForApplication2Response(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsForApplication2Response *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSubmissionLocationsForApplication2Response, 0, sizeof(struct _ns1__getSubmissionLocationsForApplication2Response), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getSubmissionLocationsForApplication2(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication2 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
	soap_default_string(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getSubmissionLocationsForApplication2(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication2 *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_serialize_string(soap, &a->in2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getSubmissionLocationsForApplication2(struct soap *soap, const struct _ns1__getSubmissionLocationsForApplication2 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getSubmissionLocationsForApplication2);
	if (soap_out__ns1__getSubmissionLocationsForApplication2(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getSubmissionLocationsForApplication2(struct soap *soap, const char *tag, int id, const struct _ns1__getSubmissionLocationsForApplication2 *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication2), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_string(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication2 * SOAP_FMAC4 soap_get__ns1__getSubmissionLocationsForApplication2(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication2 *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getSubmissionLocationsForApplication2(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication2 * SOAP_FMAC4 soap_in__ns1__getSubmissionLocationsForApplication2(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsForApplication2 *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getSubmissionLocationsForApplication2 *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication2, sizeof(struct _ns1__getSubmissionLocationsForApplication2), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getSubmissionLocationsForApplication2(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in2", &a->in2, "xsd:string"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsForApplication2 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getSubmissionLocationsForApplication2, 0, sizeof(struct _ns1__getSubmissionLocationsForApplication2), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__downloadByteArrayResponse(struct soap *soap, struct _ns1__downloadByteArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__downloadByteArrayResponse(struct soap *soap, const struct _ns1__downloadByteArrayResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__base64Binary(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__downloadByteArrayResponse(struct soap *soap, const struct _ns1__downloadByteArrayResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__downloadByteArrayResponse);
	if (soap_out__ns1__downloadByteArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__downloadByteArrayResponse(struct soap *soap, const char *tag, int id, const struct _ns1__downloadByteArrayResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__downloadByteArrayResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerToxsd__base64Binary(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__downloadByteArrayResponse * SOAP_FMAC4 soap_get__ns1__downloadByteArrayResponse(struct soap *soap, struct _ns1__downloadByteArrayResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__downloadByteArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__downloadByteArrayResponse * SOAP_FMAC4 soap_in__ns1__downloadByteArrayResponse(struct soap *soap, const char *tag, struct _ns1__downloadByteArrayResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__downloadByteArrayResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__downloadByteArrayResponse, sizeof(struct _ns1__downloadByteArrayResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__downloadByteArrayResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__base64Binary(soap, "ns1:out", &a->out, "xsd:base64Binary"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__downloadByteArrayResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__downloadByteArrayResponse, 0, sizeof(struct _ns1__downloadByteArrayResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__downloadByteArray(struct soap *soap, struct _ns1__downloadByteArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__downloadByteArray(struct soap *soap, const struct _ns1__downloadByteArray *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__downloadByteArray(struct soap *soap, const struct _ns1__downloadByteArray *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__downloadByteArray);
	if (soap_out__ns1__downloadByteArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__downloadByteArray(struct soap *soap, const char *tag, int id, const struct _ns1__downloadByteArray *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__downloadByteArray), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__downloadByteArray * SOAP_FMAC4 soap_get__ns1__downloadByteArray(struct soap *soap, struct _ns1__downloadByteArray *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__downloadByteArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__downloadByteArray * SOAP_FMAC4 soap_in__ns1__downloadByteArray(struct soap *soap, const char *tag, struct _ns1__downloadByteArray *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__downloadByteArray *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__downloadByteArray, sizeof(struct _ns1__downloadByteArray), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__downloadByteArray(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__downloadByteArray *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__downloadByteArray, 0, sizeof(struct _ns1__downloadByteArray), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns3__ArrayOfMountPoint(struct soap *soap, struct ns3__ArrayOfMountPoint *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeMountPoint = 0;
	a->MountPoint = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns3__ArrayOfMountPoint(struct soap *soap, const struct ns3__ArrayOfMountPoint *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->MountPoint)
	{	int i;
		for (i = 0; i < a->__sizeMountPoint; i++)
		{
			soap_embedded(soap, a->MountPoint + i, SOAP_TYPE_ns3__MountPoint);
			soap_serialize_ns3__MountPoint(soap, a->MountPoint + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns3__ArrayOfMountPoint(struct soap *soap, const struct ns3__ArrayOfMountPoint *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns3__ArrayOfMountPoint);
	if (soap_out_ns3__ArrayOfMountPoint(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__ArrayOfMountPoint(struct soap *soap, const char *tag, int id, const struct ns3__ArrayOfMountPoint *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__ArrayOfMountPoint), type);
	if (a->MountPoint)
	{	int i;
		for (i = 0; i < a->__sizeMountPoint; i++)
			soap_out_ns3__MountPoint(soap, "ns3:MountPoint", -1, a->MountPoint + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns3__ArrayOfMountPoint * SOAP_FMAC4 soap_get_ns3__ArrayOfMountPoint(struct soap *soap, struct ns3__ArrayOfMountPoint *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__ArrayOfMountPoint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns3__ArrayOfMountPoint * SOAP_FMAC4 soap_in_ns3__ArrayOfMountPoint(struct soap *soap, const char *tag, struct ns3__ArrayOfMountPoint *a, const char *type)
{
	short soap_flag_MountPoint = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns3__ArrayOfMountPoint *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__ArrayOfMountPoint, sizeof(struct ns3__ArrayOfMountPoint), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns3__ArrayOfMountPoint(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_MountPoint && soap->error == SOAP_TAG_MISMATCH)
			{	struct ns3__MountPoint *p;
				soap_new_block(soap);
				for (a->__sizeMountPoint = 0; !soap_element_begin_in(soap, "ns3:MountPoint", 1, NULL); a->__sizeMountPoint++)
				{	p = (struct ns3__MountPoint *)soap_push_block(soap, sizeof(struct ns3__MountPoint));
					soap_default_ns3__MountPoint(soap, p);
					soap_revert(soap);
					if (!soap_in_ns3__MountPoint(soap, "ns3:MountPoint", p, "ns3:MountPoint"))
						break;
					soap_flag_MountPoint = 0;
				}
				a->MountPoint = (struct ns3__MountPoint *)soap_save_block(soap, NULL, 1);
				if (!soap_flag_MountPoint && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns3__ArrayOfMountPoint *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__ArrayOfMountPoint, 0, sizeof(struct ns3__ArrayOfMountPoint), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__dfResponse(struct soap *soap, struct _ns1__dfResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__dfResponse(struct soap *soap, const struct _ns1__dfResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons3__ArrayOfMountPoint(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__dfResponse(struct soap *soap, const struct _ns1__dfResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__dfResponse);
	if (soap_out__ns1__dfResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__dfResponse(struct soap *soap, const char *tag, int id, const struct _ns1__dfResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__dfResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons3__ArrayOfMountPoint(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__dfResponse * SOAP_FMAC4 soap_get__ns1__dfResponse(struct soap *soap, struct _ns1__dfResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__dfResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__dfResponse * SOAP_FMAC4 soap_in__ns1__dfResponse(struct soap *soap, const char *tag, struct _ns1__dfResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__dfResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__dfResponse, sizeof(struct _ns1__dfResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__dfResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons3__ArrayOfMountPoint(soap, "ns1:out", &a->out, "ns3:ArrayOfMountPoint"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__dfResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__dfResponse, 0, sizeof(struct _ns1__dfResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__df(struct soap *soap, struct _ns1__df *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__df(struct soap *soap, const struct _ns1__df *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__df(struct soap *soap, const struct _ns1__df *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__df);
	if (soap_out__ns1__df(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__df(struct soap *soap, const char *tag, int id, const struct _ns1__df *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__df), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__df * SOAP_FMAC4 soap_get__ns1__df(struct soap *soap, struct _ns1__df *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__df(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__df * SOAP_FMAC4 soap_in__ns1__df(struct soap *soap, const char *tag, struct _ns1__df *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__df *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__df, sizeof(struct _ns1__df), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__df(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__df *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__df, 0, sizeof(struct _ns1__df), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getFqansResponse(struct soap *soap, struct _ns1__getFqansResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getFqansResponse(struct soap *soap, const struct _ns1__getFqansResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getFqansResponse(struct soap *soap, const struct _ns1__getFqansResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getFqansResponse);
	if (soap_out__ns1__getFqansResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getFqansResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getFqansResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getFqansResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getFqansResponse * SOAP_FMAC4 soap_get__ns1__getFqansResponse(struct soap *soap, struct _ns1__getFqansResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getFqansResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getFqansResponse * SOAP_FMAC4 soap_in__ns1__getFqansResponse(struct soap *soap, const char *tag, struct _ns1__getFqansResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getFqansResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getFqansResponse, sizeof(struct _ns1__getFqansResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getFqansResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getFqansResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getFqansResponse, 0, sizeof(struct _ns1__getFqansResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getFqans(struct soap *soap, struct _ns1__getFqans *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getFqans(struct soap *soap, const struct _ns1__getFqans *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getFqans(struct soap *soap, const struct _ns1__getFqans *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getFqans);
	if (soap_out__ns1__getFqans(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getFqans(struct soap *soap, const char *tag, int id, const struct _ns1__getFqans *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getFqans), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getFqans * SOAP_FMAC4 soap_get__ns1__getFqans(struct soap *soap, struct _ns1__getFqans *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getFqans(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getFqans * SOAP_FMAC4 soap_in__ns1__getFqans(struct soap *soap, const char *tag, struct _ns1__getFqans *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getFqans *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getFqans, sizeof(struct _ns1__getFqans), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getFqans(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getFqans *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getFqans, 0, sizeof(struct _ns1__getFqans), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getTemplateResponse(struct soap *soap, struct _ns1__getTemplateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getTemplateResponse(struct soap *soap, const struct _ns1__getTemplateResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getTemplateResponse(struct soap *soap, const struct _ns1__getTemplateResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getTemplateResponse);
	if (soap_out__ns1__getTemplateResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getTemplateResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getTemplateResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getTemplateResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_outliteral(soap, "ns1:out", &a->out, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getTemplateResponse * SOAP_FMAC4 soap_get__ns1__getTemplateResponse(struct soap *soap, struct _ns1__getTemplateResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getTemplateResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getTemplateResponse * SOAP_FMAC4 soap_in__ns1__getTemplateResponse(struct soap *soap, const char *tag, struct _ns1__getTemplateResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getTemplateResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getTemplateResponse, sizeof(struct _ns1__getTemplateResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getTemplateResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:out", &a->out))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getTemplateResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getTemplateResponse, 0, sizeof(struct _ns1__getTemplateResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getTemplate(struct soap *soap, struct _ns1__getTemplate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getTemplate(struct soap *soap, const struct _ns1__getTemplate *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getTemplate(struct soap *soap, const struct _ns1__getTemplate *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getTemplate);
	if (soap_out__ns1__getTemplate(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getTemplate(struct soap *soap, const char *tag, int id, const struct _ns1__getTemplate *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getTemplate), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getTemplate * SOAP_FMAC4 soap_get__ns1__getTemplate(struct soap *soap, struct _ns1__getTemplate *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getTemplate(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getTemplate * SOAP_FMAC4 soap_in__ns1__getTemplate(struct soap *soap, const char *tag, struct _ns1__getTemplate *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getTemplate *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getTemplate, sizeof(struct _ns1__getTemplate), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getTemplate(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getTemplate *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getTemplate, 0, sizeof(struct _ns1__getTemplate), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__loginResponse(struct soap *soap, struct _ns1__loginResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__loginResponse(struct soap *soap, const struct _ns1__loginResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__loginResponse(struct soap *soap, const struct _ns1__loginResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__loginResponse);
	if (soap_out__ns1__loginResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__loginResponse(struct soap *soap, const char *tag, int id, const struct _ns1__loginResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__loginResponse), type);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__loginResponse * SOAP_FMAC4 soap_get__ns1__loginResponse(struct soap *soap, struct _ns1__loginResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__loginResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__loginResponse * SOAP_FMAC4 soap_in__ns1__loginResponse(struct soap *soap, const char *tag, struct _ns1__loginResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__loginResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__loginResponse, sizeof(struct _ns1__loginResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__loginResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__loginResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__loginResponse, 0, sizeof(struct _ns1__loginResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__login(struct soap *soap, struct _ns1__login *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	a->in1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__login(struct soap *soap, const struct _ns1__login *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__login(struct soap *soap, const struct _ns1__login *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__login);
	if (soap_out__ns1__login(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__login(struct soap *soap, const char *tag, int id, const struct _ns1__login *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__login), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__login * SOAP_FMAC4 soap_get__ns1__login(struct soap *soap, struct _ns1__login *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__login(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__login * SOAP_FMAC4 soap_in__ns1__login(struct soap *soap, const char *tag, struct _ns1__login *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__login *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__login, sizeof(struct _ns1__login), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__login(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:in1", &a->in1, "ns1:ArrayOfString"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__login *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__login, 0, sizeof(struct _ns1__login), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns3__MountPoint(struct soap *soap, struct ns3__MountPoint *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->automaticallyMounted = NULL;
	a->disabled = NULL;
	soap_default_string(soap, &a->dn);
	soap_default_string(soap, &a->fqan);
	a->mountPointId = NULL;
	soap_default_string(soap, &a->mountpoint);
	soap_default_string(soap, &a->rootUrl);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns3__MountPoint(struct soap *soap, const struct ns3__MountPoint *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToxsd__boolean(soap, &a->automaticallyMounted);
	soap_serialize_PointerToxsd__boolean(soap, &a->disabled);
	soap_serialize_string(soap, &a->dn);
	soap_serialize_string(soap, &a->fqan);
	soap_serialize_PointerToLONG64(soap, &a->mountPointId);
	soap_serialize_string(soap, &a->mountpoint);
	soap_serialize_string(soap, &a->rootUrl);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns3__MountPoint(struct soap *soap, const struct ns3__MountPoint *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns3__MountPoint);
	if (soap_out_ns3__MountPoint(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__MountPoint(struct soap *soap, const char *tag, int id, const struct ns3__MountPoint *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__MountPoint), type);
	soap_out_PointerToxsd__boolean(soap, "ns3:automaticallyMounted", -1, &a->automaticallyMounted, "");
	soap_out_PointerToxsd__boolean(soap, "ns3:disabled", -1, &a->disabled, "");
	soap_out_string(soap, "ns3:dn", -1, &a->dn, "");
	soap_out_string(soap, "ns3:fqan", -1, &a->fqan, "");
	soap_out_PointerToLONG64(soap, "ns3:mountPointId", -1, &a->mountPointId, "");
	soap_out_string(soap, "ns3:mountpoint", -1, &a->mountpoint, "");
	soap_out_string(soap, "ns3:rootUrl", -1, &a->rootUrl, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns3__MountPoint * SOAP_FMAC4 soap_get_ns3__MountPoint(struct soap *soap, struct ns3__MountPoint *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__MountPoint(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns3__MountPoint * SOAP_FMAC4 soap_in_ns3__MountPoint(struct soap *soap, const char *tag, struct ns3__MountPoint *a, const char *type)
{
	short soap_flag_automaticallyMounted = 1, soap_flag_disabled = 1, soap_flag_dn = 1, soap_flag_fqan = 1, soap_flag_mountPointId = 1, soap_flag_mountpoint = 1, soap_flag_rootUrl = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns3__MountPoint *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__MountPoint, sizeof(struct ns3__MountPoint), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns3__MountPoint(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_automaticallyMounted && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__boolean(soap, "ns3:automaticallyMounted", &a->automaticallyMounted, "xsd:boolean"))
				{	soap_flag_automaticallyMounted--;
					continue;
				}
			if (soap_flag_disabled && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToxsd__boolean(soap, "ns3:disabled", &a->disabled, "xsd:boolean"))
				{	soap_flag_disabled--;
					continue;
				}
			if (soap_flag_dn && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns3:dn", &a->dn, "xsd:string"))
				{	soap_flag_dn--;
					continue;
				}
			if (soap_flag_fqan && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns3:fqan", &a->fqan, "xsd:string"))
				{	soap_flag_fqan--;
					continue;
				}
			if (soap_flag_mountPointId && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "ns3:mountPointId", &a->mountPointId, "xsd:long"))
				{	soap_flag_mountPointId--;
					continue;
				}
			if (soap_flag_mountpoint && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns3:mountpoint", &a->mountpoint, "xsd:string"))
				{	soap_flag_mountpoint--;
					continue;
				}
			if (soap_flag_rootUrl && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns3:rootUrl", &a->rootUrl, "xsd:string"))
				{	soap_flag_rootUrl--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns3__MountPoint *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__MountPoint, 0, sizeof(struct ns3__MountPoint), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__mountResponse(struct soap *soap, struct _ns1__mountResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__mountResponse(struct soap *soap, const struct _ns1__mountResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons3__MountPoint(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__mountResponse(struct soap *soap, const struct _ns1__mountResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__mountResponse);
	if (soap_out__ns1__mountResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__mountResponse(struct soap *soap, const char *tag, int id, const struct _ns1__mountResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__mountResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons3__MountPoint(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__mountResponse * SOAP_FMAC4 soap_get__ns1__mountResponse(struct soap *soap, struct _ns1__mountResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__mountResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__mountResponse * SOAP_FMAC4 soap_in__ns1__mountResponse(struct soap *soap, const char *tag, struct _ns1__mountResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__mountResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__mountResponse, sizeof(struct _ns1__mountResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__mountResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons3__MountPoint(soap, "ns1:out", &a->out, "ns3:MountPoint"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__mountResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__mountResponse, 0, sizeof(struct _ns1__mountResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__mount(struct soap *soap, struct _ns1__mount *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_string(soap, &a->in1);
	soap_default_xsd__boolean(soap, &a->in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__mount(struct soap *soap, const struct _ns1__mount *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_serialize_string(soap, &a->in1);
	soap_embedded(soap, &a->in2, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__mount(struct soap *soap, const struct _ns1__mount *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__mount);
	if (soap_out__ns1__mount(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__mount(struct soap *soap, const char *tag, int id, const struct _ns1__mount *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__mount), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_string(soap, "ns1:in1", -1, &a->in1, "");
	soap_out_xsd__boolean(soap, "ns1:in2", -1, &a->in2, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__mount * SOAP_FMAC4 soap_get__ns1__mount(struct soap *soap, struct _ns1__mount *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__mount(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__mount * SOAP_FMAC4 soap_in__ns1__mount(struct soap *soap, const char *tag, struct _ns1__mount *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1, soap_flag_in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__mount *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__mount, sizeof(struct _ns1__mount), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__mount(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in1", &a->in1, "xsd:string"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap_flag_in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in2", &a->in2, "xsd:boolean"))
				{	soap_flag_in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__mount *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__mount, 0, sizeof(struct _ns1__mount), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0 || soap_flag_in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobFqanResponse(struct soap *soap, struct _ns1__getJobFqanResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->out);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobFqanResponse(struct soap *soap, const struct _ns1__getJobFqanResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobFqanResponse(struct soap *soap, const struct _ns1__getJobFqanResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobFqanResponse);
	if (soap_out__ns1__getJobFqanResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobFqanResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getJobFqanResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobFqanResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_string(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobFqanResponse * SOAP_FMAC4 soap_get__ns1__getJobFqanResponse(struct soap *soap, struct _ns1__getJobFqanResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobFqanResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobFqanResponse * SOAP_FMAC4 soap_in__ns1__getJobFqanResponse(struct soap *soap, const char *tag, struct _ns1__getJobFqanResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobFqanResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobFqanResponse, sizeof(struct _ns1__getJobFqanResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobFqanResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:out", &a->out, "xsd:string"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobFqanResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobFqanResponse, 0, sizeof(struct _ns1__getJobFqanResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getJobFqan(struct soap *soap, struct _ns1__getJobFqan *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getJobFqan(struct soap *soap, const struct _ns1__getJobFqan *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getJobFqan(struct soap *soap, const struct _ns1__getJobFqan *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getJobFqan);
	if (soap_out__ns1__getJobFqan(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getJobFqan(struct soap *soap, const char *tag, int id, const struct _ns1__getJobFqan *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getJobFqan), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getJobFqan * SOAP_FMAC4 soap_get__ns1__getJobFqan(struct soap *soap, struct _ns1__getJobFqan *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getJobFqan(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobFqan * SOAP_FMAC4 soap_in__ns1__getJobFqan(struct soap *soap, const char *tag, struct _ns1__getJobFqan *a, const char *type)
{
	short soap_flag_in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getJobFqan *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getJobFqan, sizeof(struct _ns1__getJobFqan), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getJobFqan(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobFqan *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getJobFqan, 0, sizeof(struct _ns1__getJobFqan), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getChildrenFilesResponse(struct soap *soap, struct _ns1__getChildrenFilesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->out = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getChildrenFilesResponse(struct soap *soap, const struct _ns1__getChildrenFilesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons1__ArrayOfString(soap, &a->out);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getChildrenFilesResponse(struct soap *soap, const struct _ns1__getChildrenFilesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getChildrenFilesResponse);
	if (soap_out__ns1__getChildrenFilesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getChildrenFilesResponse(struct soap *soap, const char *tag, int id, const struct _ns1__getChildrenFilesResponse *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getChildrenFilesResponse), type);
	if (a->out)
		soap_element_result(soap, "ns1:out");
	soap_out_PointerTons1__ArrayOfString(soap, "ns1:out", -1, &a->out, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getChildrenFilesResponse * SOAP_FMAC4 soap_get__ns1__getChildrenFilesResponse(struct soap *soap, struct _ns1__getChildrenFilesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getChildrenFilesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getChildrenFilesResponse * SOAP_FMAC4 soap_in__ns1__getChildrenFilesResponse(struct soap *soap, const char *tag, struct _ns1__getChildrenFilesResponse *a, const char *type)
{
	short soap_flag_out = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getChildrenFilesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getChildrenFilesResponse, sizeof(struct _ns1__getChildrenFilesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getChildrenFilesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_out && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons1__ArrayOfString(soap, "ns1:out", &a->out, "ns1:ArrayOfString"))
				{	soap_flag_out--;
					continue;
				}
			soap_check_result(soap, "ns1:out");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getChildrenFilesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getChildrenFilesResponse, 0, sizeof(struct _ns1__getChildrenFilesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_out > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__getChildrenFiles(struct soap *soap, struct _ns1__getChildrenFiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->in0);
	soap_default_xsd__boolean(soap, &a->in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__getChildrenFiles(struct soap *soap, const struct _ns1__getChildrenFiles *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->in0);
	soap_embedded(soap, &a->in1, SOAP_TYPE_xsd__boolean);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__getChildrenFiles(struct soap *soap, const struct _ns1__getChildrenFiles *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__getChildrenFiles);
	if (soap_out__ns1__getChildrenFiles(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__getChildrenFiles(struct soap *soap, const char *tag, int id, const struct _ns1__getChildrenFiles *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__getChildrenFiles), type);
	soap_out_string(soap, "ns1:in0", -1, &a->in0, "");
	soap_out_xsd__boolean(soap, "ns1:in1", -1, &a->in1, "");
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__getChildrenFiles * SOAP_FMAC4 soap_get__ns1__getChildrenFiles(struct soap *soap, struct _ns1__getChildrenFiles *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__getChildrenFiles(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getChildrenFiles * SOAP_FMAC4 soap_in__ns1__getChildrenFiles(struct soap *soap, const char *tag, struct _ns1__getChildrenFiles *a, const char *type)
{
	short soap_flag_in0 = 1, soap_flag_in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__getChildrenFiles *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__getChildrenFiles, sizeof(struct _ns1__getChildrenFiles), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__getChildrenFiles(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "ns1:in0", &a->in0, "xsd:string"))
				{	soap_flag_in0--;
					continue;
				}
			if (soap_flag_in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_xsd__boolean(soap, "ns1:in1", &a->in1, "xsd:boolean"))
				{	soap_flag_in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__getChildrenFiles *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__getChildrenFiles, 0, sizeof(struct _ns1__getChildrenFiles), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_in0 > 0 || soap_flag_in1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__ns1__anyType2anyTypeMap_entry(struct soap *soap, struct _ns1__anyType2anyTypeMap_entry *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->key = NULL;
	a->value = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__ns1__anyType2anyTypeMap_entry(struct soap *soap, const struct _ns1__anyType2anyTypeMap_entry *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__ns1__anyType2anyTypeMap_entry(struct soap *soap, const struct _ns1__anyType2anyTypeMap_entry *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE__ns1__anyType2anyTypeMap_entry);
	if (soap_out__ns1__anyType2anyTypeMap_entry(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__anyType2anyTypeMap_entry(struct soap *soap, const char *tag, int id, const struct _ns1__anyType2anyTypeMap_entry *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__anyType2anyTypeMap_entry), type);
	soap_outliteral(soap, "ns1:key", &a->key, NULL);
	soap_outliteral(soap, "ns1:value", &a->value, NULL);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _ns1__anyType2anyTypeMap_entry * SOAP_FMAC4 soap_get__ns1__anyType2anyTypeMap_entry(struct soap *soap, struct _ns1__anyType2anyTypeMap_entry *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__anyType2anyTypeMap_entry(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__anyType2anyTypeMap_entry * SOAP_FMAC4 soap_in__ns1__anyType2anyTypeMap_entry(struct soap *soap, const char *tag, struct _ns1__anyType2anyTypeMap_entry *a, const char *type)
{
	short soap_flag_key = 1, soap_flag_value = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct _ns1__anyType2anyTypeMap_entry *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__anyType2anyTypeMap_entry, sizeof(struct _ns1__anyType2anyTypeMap_entry), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__ns1__anyType2anyTypeMap_entry(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_key && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:key", &a->key))
				{	soap_flag_key--;
					continue;
				}
			if (soap_flag_value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_inliteral(soap, "ns1:value", &a->value))
				{	soap_flag_value--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct _ns1__anyType2anyTypeMap_entry *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__anyType2anyTypeMap_entry, 0, sizeof(struct _ns1__anyType2anyTypeMap_entry), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__anyType2anyTypeMap(struct soap *soap, struct ns1__anyType2anyTypeMap *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizeentry = 0;
	a->entry = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__anyType2anyTypeMap(struct soap *soap, const struct ns1__anyType2anyTypeMap *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->entry)
	{	int i;
		for (i = 0; i < a->__sizeentry; i++)
		{
			soap_embedded(soap, a->entry + i, SOAP_TYPE__ns1__anyType2anyTypeMap_entry);
			soap_serialize__ns1__anyType2anyTypeMap_entry(soap, a->entry + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__anyType2anyTypeMap(struct soap *soap, const struct ns1__anyType2anyTypeMap *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__anyType2anyTypeMap);
	if (soap_out_ns1__anyType2anyTypeMap(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__anyType2anyTypeMap(struct soap *soap, const char *tag, int id, const struct ns1__anyType2anyTypeMap *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__anyType2anyTypeMap), type);
	if (a->entry)
	{	int i;
		for (i = 0; i < a->__sizeentry; i++)
			soap_out__ns1__anyType2anyTypeMap_entry(soap, "ns1:entry", -1, a->entry + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns1__anyType2anyTypeMap * SOAP_FMAC4 soap_get_ns1__anyType2anyTypeMap(struct soap *soap, struct ns1__anyType2anyTypeMap *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__anyType2anyTypeMap(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__anyType2anyTypeMap * SOAP_FMAC4 soap_in_ns1__anyType2anyTypeMap(struct soap *soap, const char *tag, struct ns1__anyType2anyTypeMap *a, const char *type)
{
	short soap_flag_entry = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__anyType2anyTypeMap *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__anyType2anyTypeMap, sizeof(struct ns1__anyType2anyTypeMap), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__anyType2anyTypeMap(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_entry && soap->error == SOAP_TAG_MISMATCH)
			{	struct _ns1__anyType2anyTypeMap_entry *p;
				soap_new_block(soap);
				for (a->__sizeentry = 0; !soap_element_begin_in(soap, "ns1:entry", 1, NULL); a->__sizeentry++)
				{	p = (struct _ns1__anyType2anyTypeMap_entry *)soap_push_block(soap, sizeof(struct _ns1__anyType2anyTypeMap_entry));
					soap_default__ns1__anyType2anyTypeMap_entry(soap, p);
					soap_revert(soap);
					if (!soap_in__ns1__anyType2anyTypeMap_entry(soap, "ns1:entry", p, ""))
						break;
					soap_flag_entry = 0;
				}
				a->entry = (struct _ns1__anyType2anyTypeMap_entry *)soap_save_block(soap, NULL, 1);
				if (!soap_flag_entry && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__anyType2anyTypeMap *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__anyType2anyTypeMap, 0, sizeof(struct ns1__anyType2anyTypeMap), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns1__ArrayOfString(struct soap *soap, struct ns1__ArrayOfString *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__sizestring = 0;
	a->string = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns1__ArrayOfString(struct soap *soap, const struct ns1__ArrayOfString *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	if (a->string)
	{	int i;
		for (i = 0; i < a->__sizestring; i++)
		{
			soap_serialize_string(soap, a->string + i);
		}
	}
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns1__ArrayOfString(struct soap *soap, const struct ns1__ArrayOfString *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns1__ArrayOfString);
	if (soap_out_ns1__ArrayOfString(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns1__ArrayOfString(struct soap *soap, const char *tag, int id, const struct ns1__ArrayOfString *a, const char *type)
{
	soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns1__ArrayOfString), type);
	if (a->string)
	{	int i;
		for (i = 0; i < a->__sizestring; i++)
			soap_out_string(soap, "ns1:string", -1, a->string + i, "");
	}
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct ns1__ArrayOfString * SOAP_FMAC4 soap_get_ns1__ArrayOfString(struct soap *soap, struct ns1__ArrayOfString *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns1__ArrayOfString(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct ns1__ArrayOfString * SOAP_FMAC4 soap_in_ns1__ArrayOfString(struct soap *soap, const char *tag, struct ns1__ArrayOfString *a, const char *type)
{
	short soap_flag_string = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns1__ArrayOfString *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns1__ArrayOfString, sizeof(struct ns1__ArrayOfString), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns1__ArrayOfString(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_string && soap->error == SOAP_TAG_MISMATCH)
			{	char **p;
				soap_new_block(soap);
				for (a->__sizestring = 0; !soap_element_begin_in(soap, "ns1:string", 1, NULL); a->__sizestring++)
				{	p = (char **)soap_push_block(soap, sizeof(char *));
					*p = NULL;
					soap_revert(soap);
					if (!soap_in_string(soap, "ns1:string", p, "xsd:string"))
						break;
					soap_flag_string = 0;
				}
				a->string = (char **)soap_save_block(soap, NULL, 1);
				if (!soap_flag_string && soap->error == SOAP_TAG_MISMATCH)
					continue;
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns1__ArrayOfString *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns1__ArrayOfString, 0, sizeof(struct ns1__ArrayOfString), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *a)
{
	a->__size = 0;
	a->__ptr = NULL;
	a->id = NULL;
	a->type = NULL;
	a->options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary const*a)
{
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE_xsd__base64Binary))
		if (a->id || a->type)
			soap->mode |= SOAP_ENC_DIME;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_xsd__base64Binary(struct soap *soap, const struct xsd__base64Binary *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE_xsd__base64Binary);
	if (soap_out_xsd__base64Binary(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_xsd__base64Binary(struct soap *soap, const char *tag, int id, const struct xsd__base64Binary *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE_xsd__base64Binary);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_xsd__base64Binary);
#endif
	if (id < 0)
		return soap->error;
	soap_element_begin_out(soap, tag, id, type);
	soap_putbase64(soap, a->__ptr, a->__size);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_get_xsd__base64Binary(struct soap *soap, struct xsd__base64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_xsd__base64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct xsd__base64Binary * SOAP_FMAC4 soap_in_xsd__base64Binary(struct soap *soap, const char *tag, struct xsd__base64Binary *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct xsd__base64Binary *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_xsd__base64Binary, sizeof(struct xsd__base64Binary), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_xsd__base64Binary(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (struct xsd__base64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_xsd__base64Binary, 0, sizeof(struct xsd__base64Binary), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default__xop__Include(struct soap *soap, struct _xop__Include *a)
{
	a->__size = 0;
	a->__ptr = NULL;
	a->id = NULL;
	a->type = NULL;
	a->options = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__xop__Include(struct soap *soap, struct _xop__Include const*a)
{
	if (a->__ptr && !soap_array_reference(soap, a, (struct soap_array*)&a->__ptr, 1, SOAP_TYPE__xop__Include))
		if (a->id || a->type)
			soap->mode |= SOAP_ENC_DIME;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__xop__Include(struct soap *soap, const struct _xop__Include *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, (struct soap_array*)&a->__ptr, 1, tag, SOAP_TYPE__xop__Include);
	if (soap_out__xop__Include(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__xop__Include(struct soap *soap, const char *tag, int id, const struct _xop__Include *a, const char *type)
{
#ifndef WITH_LEANER
	id = soap_attachment(soap, tag, id, a, (struct soap_array*)&a->__ptr, a->id, a->type, a->options, 1, type, SOAP_TYPE__xop__Include);
#else
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE__xop__Include);
#endif
	if (id < 0)
		return soap->error;
	soap_element_begin_out(soap, tag, id, type);
	soap_putbase64(soap, a->__ptr, a->__size);
	soap_element_end_out(soap, tag);
	return SOAP_OK;
}

SOAP_FMAC3 struct _xop__Include * SOAP_FMAC4 soap_get__xop__Include(struct soap *soap, struct _xop__Include *p, const char *tag, const char *type)
{
	if ((p = soap_in__xop__Include(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _xop__Include * SOAP_FMAC4 soap_in__xop__Include(struct soap *soap, const char *tag, struct _xop__Include *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":base64Binary") && soap_match_tag(soap, soap->type, ":base64"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (struct _xop__Include *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__xop__Include, sizeof(struct _xop__Include), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default__xop__Include(soap, a);
	if (soap->body && !*soap->href)
	{
		a->__ptr = soap_getbase64(soap, &a->__size, 0);
#ifndef WITH_LEANER
		if (soap_xop_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
			return NULL;
#endif
		if ((!a->__ptr && soap->error) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	
#ifndef WITH_LEANER
		if (*soap->href != '#')
		{	if (soap_dime_forward(soap, &a->__ptr, &a->__size, &a->id, &a->type, &a->options))
				return NULL;
		}
		else
#endif
			a = (struct _xop__Include *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__xop__Include, 0, sizeof(struct _xop__Include), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Reason);
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Detail);
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerToSOAP_ENV__Code);
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllHostsResponse(struct soap *soap, struct _ns1__getAllHostsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllHostsResponse))
		soap_serialize__ns1__getAllHostsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllHostsResponse(struct soap *soap, struct _ns1__getAllHostsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllHostsResponse);
	if (soap_out_PointerTo_ns1__getAllHostsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllHostsResponse(struct soap *soap, const char *tag, int id, struct _ns1__getAllHostsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllHostsResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllHostsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllHostsResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllHostsResponse(struct soap *soap, struct _ns1__getAllHostsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllHostsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllHostsResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllHostsResponse(struct soap *soap, const char *tag, struct _ns1__getAllHostsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllHostsResponse **)soap_malloc(soap, sizeof(struct _ns1__getAllHostsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllHostsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllHostsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllHostsResponse, sizeof(struct _ns1__getAllHostsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllHosts(struct soap *soap, struct _ns1__getAllHosts *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllHosts))
		soap_serialize__ns1__getAllHosts(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllHosts(struct soap *soap, struct _ns1__getAllHosts *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllHosts);
	if (soap_out_PointerTo_ns1__getAllHosts(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllHosts(struct soap *soap, const char *tag, int id, struct _ns1__getAllHosts *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllHosts);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllHosts(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllHosts ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllHosts(struct soap *soap, struct _ns1__getAllHosts **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllHosts(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllHosts ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllHosts(struct soap *soap, const char *tag, struct _ns1__getAllHosts **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllHosts **)soap_malloc(soap, sizeof(struct _ns1__getAllHosts *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllHosts(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllHosts **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllHosts, sizeof(struct _ns1__getAllHosts), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__submitSupportRequestResponse(struct soap *soap, struct _ns1__submitSupportRequestResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__submitSupportRequestResponse))
		soap_serialize__ns1__submitSupportRequestResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__submitSupportRequestResponse(struct soap *soap, struct _ns1__submitSupportRequestResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__submitSupportRequestResponse);
	if (soap_out_PointerTo_ns1__submitSupportRequestResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__submitSupportRequestResponse(struct soap *soap, const char *tag, int id, struct _ns1__submitSupportRequestResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__submitSupportRequestResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__submitSupportRequestResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__submitSupportRequestResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__submitSupportRequestResponse(struct soap *soap, struct _ns1__submitSupportRequestResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__submitSupportRequestResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__submitSupportRequestResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__submitSupportRequestResponse(struct soap *soap, const char *tag, struct _ns1__submitSupportRequestResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__submitSupportRequestResponse **)soap_malloc(soap, sizeof(struct _ns1__submitSupportRequestResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__submitSupportRequestResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__submitSupportRequestResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__submitSupportRequestResponse, sizeof(struct _ns1__submitSupportRequestResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__submitSupportRequest(struct soap *soap, struct _ns1__submitSupportRequest *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__submitSupportRequest))
		soap_serialize__ns1__submitSupportRequest(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__submitSupportRequest(struct soap *soap, struct _ns1__submitSupportRequest *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__submitSupportRequest);
	if (soap_out_PointerTo_ns1__submitSupportRequest(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__submitSupportRequest(struct soap *soap, const char *tag, int id, struct _ns1__submitSupportRequest *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__submitSupportRequest);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__submitSupportRequest(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__submitSupportRequest ** SOAP_FMAC4 soap_get_PointerTo_ns1__submitSupportRequest(struct soap *soap, struct _ns1__submitSupportRequest **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__submitSupportRequest(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__submitSupportRequest ** SOAP_FMAC4 soap_in_PointerTo_ns1__submitSupportRequest(struct soap *soap, const char *tag, struct _ns1__submitSupportRequest **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__submitSupportRequest **)soap_malloc(soap, sizeof(struct _ns1__submitSupportRequest *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__submitSupportRequest(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__submitSupportRequest **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__submitSupportRequest, sizeof(struct _ns1__submitSupportRequest), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobPropertyResponse(struct soap *soap, struct _ns1__getJobPropertyResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobPropertyResponse))
		soap_serialize__ns1__getJobPropertyResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobPropertyResponse(struct soap *soap, struct _ns1__getJobPropertyResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobPropertyResponse);
	if (soap_out_PointerTo_ns1__getJobPropertyResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobPropertyResponse(struct soap *soap, const char *tag, int id, struct _ns1__getJobPropertyResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobPropertyResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobPropertyResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobPropertyResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobPropertyResponse(struct soap *soap, struct _ns1__getJobPropertyResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobPropertyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobPropertyResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobPropertyResponse(struct soap *soap, const char *tag, struct _ns1__getJobPropertyResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobPropertyResponse **)soap_malloc(soap, sizeof(struct _ns1__getJobPropertyResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobPropertyResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobPropertyResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobPropertyResponse, sizeof(struct _ns1__getJobPropertyResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobProperty(struct soap *soap, struct _ns1__getJobProperty *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobProperty))
		soap_serialize__ns1__getJobProperty(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobProperty(struct soap *soap, struct _ns1__getJobProperty *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobProperty);
	if (soap_out_PointerTo_ns1__getJobProperty(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobProperty(struct soap *soap, const char *tag, int id, struct _ns1__getJobProperty *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobProperty);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobProperty(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobProperty ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobProperty(struct soap *soap, struct _ns1__getJobProperty **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobProperty(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobProperty ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobProperty(struct soap *soap, const char *tag, struct _ns1__getJobProperty **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobProperty **)soap_malloc(soap, sizeof(struct _ns1__getJobProperty *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobProperty(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobProperty **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobProperty, sizeof(struct _ns1__getJobProperty), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__mount1Response(struct soap *soap, struct _ns1__mount1Response *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__mount1Response))
		soap_serialize__ns1__mount1Response(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__mount1Response(struct soap *soap, struct _ns1__mount1Response *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__mount1Response);
	if (soap_out_PointerTo_ns1__mount1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__mount1Response(struct soap *soap, const char *tag, int id, struct _ns1__mount1Response *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__mount1Response);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__mount1Response(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__mount1Response ** SOAP_FMAC4 soap_get_PointerTo_ns1__mount1Response(struct soap *soap, struct _ns1__mount1Response **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__mount1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__mount1Response ** SOAP_FMAC4 soap_in_PointerTo_ns1__mount1Response(struct soap *soap, const char *tag, struct _ns1__mount1Response **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__mount1Response **)soap_malloc(soap, sizeof(struct _ns1__mount1Response *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__mount1Response(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__mount1Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__mount1Response, sizeof(struct _ns1__mount1Response), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__mount1(struct soap *soap, struct _ns1__mount1 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__mount1))
		soap_serialize__ns1__mount1(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__mount1(struct soap *soap, struct _ns1__mount1 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__mount1);
	if (soap_out_PointerTo_ns1__mount1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__mount1(struct soap *soap, const char *tag, int id, struct _ns1__mount1 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__mount1);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__mount1(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__mount1 ** SOAP_FMAC4 soap_get_PointerTo_ns1__mount1(struct soap *soap, struct _ns1__mount1 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__mount1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__mount1 ** SOAP_FMAC4 soap_in_PointerTo_ns1__mount1(struct soap *soap, const char *tag, struct _ns1__mount1 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__mount1 **)soap_malloc(soap, sizeof(struct _ns1__mount1 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__mount1(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__mount1 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__mount1, sizeof(struct _ns1__mount1), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobDetailsResponse(struct soap *soap, struct _ns1__getJobDetailsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobDetailsResponse))
		soap_serialize__ns1__getJobDetailsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobDetailsResponse(struct soap *soap, struct _ns1__getJobDetailsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobDetailsResponse);
	if (soap_out_PointerTo_ns1__getJobDetailsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobDetailsResponse(struct soap *soap, const char *tag, int id, struct _ns1__getJobDetailsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobDetailsResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobDetailsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobDetailsResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobDetailsResponse(struct soap *soap, struct _ns1__getJobDetailsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobDetailsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDetailsResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobDetailsResponse(struct soap *soap, const char *tag, struct _ns1__getJobDetailsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobDetailsResponse **)soap_malloc(soap, sizeof(struct _ns1__getJobDetailsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobDetailsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDetailsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobDetailsResponse, sizeof(struct _ns1__getJobDetailsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobDetails(struct soap *soap, struct _ns1__getJobDetails *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobDetails))
		soap_serialize__ns1__getJobDetails(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobDetails(struct soap *soap, struct _ns1__getJobDetails *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobDetails);
	if (soap_out_PointerTo_ns1__getJobDetails(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobDetails(struct soap *soap, const char *tag, int id, struct _ns1__getJobDetails *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobDetails);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobDetails(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobDetails ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobDetails(struct soap *soap, struct _ns1__getJobDetails **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobDetails(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDetails ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobDetails(struct soap *soap, const char *tag, struct _ns1__getJobDetails **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobDetails **)soap_malloc(soap, sizeof(struct _ns1__getJobDetails *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobDetails(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDetails **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobDetails, sizeof(struct _ns1__getJobDetails), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__umountResponse(struct soap *soap, struct _ns1__umountResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__umountResponse))
		soap_serialize__ns1__umountResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__umountResponse(struct soap *soap, struct _ns1__umountResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__umountResponse);
	if (soap_out_PointerTo_ns1__umountResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__umountResponse(struct soap *soap, const char *tag, int id, struct _ns1__umountResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__umountResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__umountResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__umountResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__umountResponse(struct soap *soap, struct _ns1__umountResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__umountResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__umountResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__umountResponse(struct soap *soap, const char *tag, struct _ns1__umountResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__umountResponse **)soap_malloc(soap, sizeof(struct _ns1__umountResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__umountResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__umountResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__umountResponse, sizeof(struct _ns1__umountResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__umount(struct soap *soap, struct _ns1__umount *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__umount))
		soap_serialize__ns1__umount(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__umount(struct soap *soap, struct _ns1__umount *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__umount);
	if (soap_out_PointerTo_ns1__umount(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__umount(struct soap *soap, const char *tag, int id, struct _ns1__umount *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__umount);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__umount(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__umount ** SOAP_FMAC4 soap_get_PointerTo_ns1__umount(struct soap *soap, struct _ns1__umount **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__umount(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__umount ** SOAP_FMAC4 soap_in_PointerTo_ns1__umount(struct soap *soap, const char *tag, struct _ns1__umount **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__umount **)soap_malloc(soap, sizeof(struct _ns1__umount *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__umount(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__umount **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__umount, sizeof(struct _ns1__umount), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobStatusResponse(struct soap *soap, struct _ns1__getJobStatusResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobStatusResponse))
		soap_serialize__ns1__getJobStatusResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobStatusResponse(struct soap *soap, struct _ns1__getJobStatusResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobStatusResponse);
	if (soap_out_PointerTo_ns1__getJobStatusResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobStatusResponse(struct soap *soap, const char *tag, int id, struct _ns1__getJobStatusResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobStatusResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobStatusResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobStatusResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobStatusResponse(struct soap *soap, struct _ns1__getJobStatusResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobStatusResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobStatusResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobStatusResponse(struct soap *soap, const char *tag, struct _ns1__getJobStatusResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobStatusResponse **)soap_malloc(soap, sizeof(struct _ns1__getJobStatusResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobStatusResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobStatusResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobStatusResponse, sizeof(struct _ns1__getJobStatusResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobStatus(struct soap *soap, struct _ns1__getJobStatus *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobStatus))
		soap_serialize__ns1__getJobStatus(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobStatus(struct soap *soap, struct _ns1__getJobStatus *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobStatus);
	if (soap_out_PointerTo_ns1__getJobStatus(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobStatus(struct soap *soap, const char *tag, int id, struct _ns1__getJobStatus *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobStatus);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobStatus(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobStatus ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobStatus(struct soap *soap, struct _ns1__getJobStatus **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobStatus ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobStatus(struct soap *soap, const char *tag, struct _ns1__getJobStatus **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobStatus **)soap_malloc(soap, sizeof(struct _ns1__getJobStatus *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobStatus(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobStatus **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobStatus, sizeof(struct _ns1__getJobStatus), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobDetails_USCOREstringResponse(struct soap *soap, struct _ns1__getJobDetails_USCOREstringResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse))
		soap_serialize__ns1__getJobDetails_USCOREstringResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobDetails_USCOREstringResponse(struct soap *soap, struct _ns1__getJobDetails_USCOREstringResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobDetails_USCOREstringResponse);
	if (soap_out_PointerTo_ns1__getJobDetails_USCOREstringResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobDetails_USCOREstringResponse(struct soap *soap, const char *tag, int id, struct _ns1__getJobDetails_USCOREstringResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobDetails_USCOREstringResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobDetails_USCOREstringResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobDetails_USCOREstringResponse(struct soap *soap, struct _ns1__getJobDetails_USCOREstringResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobDetails_USCOREstringResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDetails_USCOREstringResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobDetails_USCOREstringResponse(struct soap *soap, const char *tag, struct _ns1__getJobDetails_USCOREstringResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobDetails_USCOREstringResponse **)soap_malloc(soap, sizeof(struct _ns1__getJobDetails_USCOREstringResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobDetails_USCOREstringResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDetails_USCOREstringResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobDetails_USCOREstringResponse, sizeof(struct _ns1__getJobDetails_USCOREstringResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobDetails_USCOREstring(struct soap *soap, struct _ns1__getJobDetails_USCOREstring *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobDetails_USCOREstring))
		soap_serialize__ns1__getJobDetails_USCOREstring(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobDetails_USCOREstring(struct soap *soap, struct _ns1__getJobDetails_USCOREstring *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobDetails_USCOREstring);
	if (soap_out_PointerTo_ns1__getJobDetails_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobDetails_USCOREstring(struct soap *soap, const char *tag, int id, struct _ns1__getJobDetails_USCOREstring *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobDetails_USCOREstring);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobDetails_USCOREstring(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobDetails_USCOREstring ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobDetails_USCOREstring(struct soap *soap, struct _ns1__getJobDetails_USCOREstring **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobDetails_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDetails_USCOREstring ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobDetails_USCOREstring(struct soap *soap, const char *tag, struct _ns1__getJobDetails_USCOREstring **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobDetails_USCOREstring **)soap_malloc(soap, sizeof(struct _ns1__getJobDetails_USCOREstring *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobDetails_USCOREstring(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDetails_USCOREstring **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobDetails_USCOREstring, sizeof(struct _ns1__getJobDetails_USCOREstring), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllSitesResponse(struct soap *soap, struct _ns1__getAllSitesResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllSitesResponse))
		soap_serialize__ns1__getAllSitesResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllSitesResponse(struct soap *soap, struct _ns1__getAllSitesResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllSitesResponse);
	if (soap_out_PointerTo_ns1__getAllSitesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllSitesResponse(struct soap *soap, const char *tag, int id, struct _ns1__getAllSitesResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllSitesResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllSitesResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllSitesResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllSitesResponse(struct soap *soap, struct _ns1__getAllSitesResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllSitesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSitesResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllSitesResponse(struct soap *soap, const char *tag, struct _ns1__getAllSitesResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllSitesResponse **)soap_malloc(soap, sizeof(struct _ns1__getAllSitesResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllSitesResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSitesResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllSitesResponse, sizeof(struct _ns1__getAllSitesResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllSites(struct soap *soap, struct _ns1__getAllSites *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllSites))
		soap_serialize__ns1__getAllSites(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllSites(struct soap *soap, struct _ns1__getAllSites *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllSites);
	if (soap_out_PointerTo_ns1__getAllSites(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllSites(struct soap *soap, const char *tag, int id, struct _ns1__getAllSites *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllSites);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllSites(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllSites ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllSites(struct soap *soap, struct _ns1__getAllSites **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllSites(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSites ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllSites(struct soap *soap, const char *tag, struct _ns1__getAllSites **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllSites **)soap_malloc(soap, sizeof(struct _ns1__getAllSites *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllSites(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSites **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllSites, sizeof(struct _ns1__getAllSites), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__setJobDescriptionResponse(struct soap *soap, struct _ns1__setJobDescriptionResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__setJobDescriptionResponse))
		soap_serialize__ns1__setJobDescriptionResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__setJobDescriptionResponse(struct soap *soap, struct _ns1__setJobDescriptionResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__setJobDescriptionResponse);
	if (soap_out_PointerTo_ns1__setJobDescriptionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__setJobDescriptionResponse(struct soap *soap, const char *tag, int id, struct _ns1__setJobDescriptionResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__setJobDescriptionResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__setJobDescriptionResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__setJobDescriptionResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__setJobDescriptionResponse(struct soap *soap, struct _ns1__setJobDescriptionResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__setJobDescriptionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__setJobDescriptionResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__setJobDescriptionResponse(struct soap *soap, const char *tag, struct _ns1__setJobDescriptionResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__setJobDescriptionResponse **)soap_malloc(soap, sizeof(struct _ns1__setJobDescriptionResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__setJobDescriptionResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__setJobDescriptionResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__setJobDescriptionResponse, sizeof(struct _ns1__setJobDescriptionResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__setJobDescription(struct soap *soap, struct _ns1__setJobDescription *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__setJobDescription))
		soap_serialize__ns1__setJobDescription(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__setJobDescription(struct soap *soap, struct _ns1__setJobDescription *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__setJobDescription);
	if (soap_out_PointerTo_ns1__setJobDescription(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__setJobDescription(struct soap *soap, const char *tag, int id, struct _ns1__setJobDescription *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__setJobDescription);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__setJobDescription(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__setJobDescription ** SOAP_FMAC4 soap_get_PointerTo_ns1__setJobDescription(struct soap *soap, struct _ns1__setJobDescription **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__setJobDescription(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__setJobDescription ** SOAP_FMAC4 soap_in_PointerTo_ns1__setJobDescription(struct soap *soap, const char *tag, struct _ns1__setJobDescription **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__setJobDescription **)soap_malloc(soap, sizeof(struct _ns1__setJobDescription *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__setJobDescription(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__setJobDescription **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__setJobDescription, sizeof(struct _ns1__setJobDescription), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobDirectoryResponse(struct soap *soap, struct _ns1__getJobDirectoryResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobDirectoryResponse))
		soap_serialize__ns1__getJobDirectoryResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobDirectoryResponse(struct soap *soap, struct _ns1__getJobDirectoryResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobDirectoryResponse);
	if (soap_out_PointerTo_ns1__getJobDirectoryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobDirectoryResponse(struct soap *soap, const char *tag, int id, struct _ns1__getJobDirectoryResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobDirectoryResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobDirectoryResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobDirectoryResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobDirectoryResponse(struct soap *soap, struct _ns1__getJobDirectoryResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobDirectoryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDirectoryResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobDirectoryResponse(struct soap *soap, const char *tag, struct _ns1__getJobDirectoryResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobDirectoryResponse **)soap_malloc(soap, sizeof(struct _ns1__getJobDirectoryResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobDirectoryResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDirectoryResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobDirectoryResponse, sizeof(struct _ns1__getJobDirectoryResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getJobDirectory(struct soap *soap, struct _ns1__getJobDirectory *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getJobDirectory))
		soap_serialize__ns1__getJobDirectory(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getJobDirectory(struct soap *soap, struct _ns1__getJobDirectory *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getJobDirectory);
	if (soap_out_PointerTo_ns1__getJobDirectory(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getJobDirectory(struct soap *soap, const char *tag, int id, struct _ns1__getJobDirectory *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getJobDirectory);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getJobDirectory(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getJobDirectory ** SOAP_FMAC4 soap_get_PointerTo_ns1__getJobDirectory(struct soap *soap, struct _ns1__getJobDirectory **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getJobDirectory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getJobDirectory ** SOAP_FMAC4 soap_in_PointerTo_ns1__getJobDirectory(struct soap *soap, const char *tag, struct _ns1__getJobDirectory **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getJobDirectory **)soap_malloc(soap, sizeof(struct _ns1__getJobDirectory *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getJobDirectory(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getJobDirectory **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getJobDirectory, sizeof(struct _ns1__getJobDirectory), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__uploadResponse(struct soap *soap, struct _ns1__uploadResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__uploadResponse))
		soap_serialize__ns1__uploadResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__uploadResponse(struct soap *soap, struct _ns1__uploadResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__uploadResponse);
	if (soap_out_PointerTo_ns1__uploadResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__uploadResponse(struct soap *soap, const char *tag, int id, struct _ns1__uploadResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__uploadResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__uploadResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__uploadResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__uploadResponse(struct soap *soap, struct _ns1__uploadResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__uploadResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__uploadResponse(struct soap *soap, const char *tag, struct _ns1__uploadResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__uploadResponse **)soap_malloc(soap, sizeof(struct _ns1__uploadResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__uploadResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__uploadResponse, sizeof(struct _ns1__uploadResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__upload(struct soap *soap, struct _ns1__upload *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__upload))
		soap_serialize__ns1__upload(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__upload(struct soap *soap, struct _ns1__upload *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__upload);
	if (soap_out_PointerTo_ns1__upload(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__upload(struct soap *soap, const char *tag, int id, struct _ns1__upload *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__upload);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__upload(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__upload ** SOAP_FMAC4 soap_get_PointerTo_ns1__upload(struct soap *soap, struct _ns1__upload **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__upload(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__upload ** SOAP_FMAC4 soap_in_PointerTo_ns1__upload(struct soap *soap, const char *tag, struct _ns1__upload **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__upload **)soap_malloc(soap, sizeof(struct _ns1__upload *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__upload(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__upload **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__upload, sizeof(struct _ns1__upload), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__deleteFileResponse(struct soap *soap, struct _ns1__deleteFileResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__deleteFileResponse))
		soap_serialize__ns1__deleteFileResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__deleteFileResponse(struct soap *soap, struct _ns1__deleteFileResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__deleteFileResponse);
	if (soap_out_PointerTo_ns1__deleteFileResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__deleteFileResponse(struct soap *soap, const char *tag, int id, struct _ns1__deleteFileResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__deleteFileResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__deleteFileResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__deleteFileResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__deleteFileResponse(struct soap *soap, struct _ns1__deleteFileResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__deleteFileResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__deleteFileResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__deleteFileResponse(struct soap *soap, const char *tag, struct _ns1__deleteFileResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__deleteFileResponse **)soap_malloc(soap, sizeof(struct _ns1__deleteFileResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__deleteFileResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__deleteFileResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__deleteFileResponse, sizeof(struct _ns1__deleteFileResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__deleteFile(struct soap *soap, struct _ns1__deleteFile *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__deleteFile))
		soap_serialize__ns1__deleteFile(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__deleteFile(struct soap *soap, struct _ns1__deleteFile *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__deleteFile);
	if (soap_out_PointerTo_ns1__deleteFile(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__deleteFile(struct soap *soap, const char *tag, int id, struct _ns1__deleteFile *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__deleteFile);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__deleteFile(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__deleteFile ** SOAP_FMAC4 soap_get_PointerTo_ns1__deleteFile(struct soap *soap, struct _ns1__deleteFile **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__deleteFile(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__deleteFile ** SOAP_FMAC4 soap_in_PointerTo_ns1__deleteFile(struct soap *soap, const char *tag, struct _ns1__deleteFile **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__deleteFile **)soap_malloc(soap, sizeof(struct _ns1__deleteFile *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__deleteFile(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__deleteFile **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__deleteFile, sizeof(struct _ns1__deleteFile), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getFileSizeResponse(struct soap *soap, struct _ns1__getFileSizeResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getFileSizeResponse))
		soap_serialize__ns1__getFileSizeResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getFileSizeResponse(struct soap *soap, struct _ns1__getFileSizeResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getFileSizeResponse);
	if (soap_out_PointerTo_ns1__getFileSizeResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getFileSizeResponse(struct soap *soap, const char *tag, int id, struct _ns1__getFileSizeResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getFileSizeResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getFileSizeResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getFileSizeResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getFileSizeResponse(struct soap *soap, struct _ns1__getFileSizeResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getFileSizeResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getFileSizeResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getFileSizeResponse(struct soap *soap, const char *tag, struct _ns1__getFileSizeResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getFileSizeResponse **)soap_malloc(soap, sizeof(struct _ns1__getFileSizeResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getFileSizeResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getFileSizeResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getFileSizeResponse, sizeof(struct _ns1__getFileSizeResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getFileSize(struct soap *soap, struct _ns1__getFileSize *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getFileSize))
		soap_serialize__ns1__getFileSize(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getFileSize(struct soap *soap, struct _ns1__getFileSize *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getFileSize);
	if (soap_out_PointerTo_ns1__getFileSize(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getFileSize(struct soap *soap, const char *tag, int id, struct _ns1__getFileSize *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getFileSize);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getFileSize(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getFileSize ** SOAP_FMAC4 soap_get_PointerTo_ns1__getFileSize(struct soap *soap, struct _ns1__getFileSize **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getFileSize(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getFileSize ** SOAP_FMAC4 soap_in_PointerTo_ns1__getFileSize(struct soap *soap, const char *tag, struct _ns1__getFileSize **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getFileSize **)soap_malloc(soap, sizeof(struct _ns1__getFileSize *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getFileSize(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getFileSize **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getFileSize, sizeof(struct _ns1__getFileSize), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__cpResponse(struct soap *soap, struct _ns1__cpResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__cpResponse))
		soap_serialize__ns1__cpResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__cpResponse(struct soap *soap, struct _ns1__cpResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__cpResponse);
	if (soap_out_PointerTo_ns1__cpResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__cpResponse(struct soap *soap, const char *tag, int id, struct _ns1__cpResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__cpResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__cpResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__cpResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__cpResponse(struct soap *soap, struct _ns1__cpResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__cpResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__cpResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__cpResponse(struct soap *soap, const char *tag, struct _ns1__cpResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__cpResponse **)soap_malloc(soap, sizeof(struct _ns1__cpResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__cpResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__cpResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__cpResponse, sizeof(struct _ns1__cpResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__cp(struct soap *soap, struct _ns1__cp *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__cp))
		soap_serialize__ns1__cp(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__cp(struct soap *soap, struct _ns1__cp *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__cp);
	if (soap_out_PointerTo_ns1__cp(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__cp(struct soap *soap, const char *tag, int id, struct _ns1__cp *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__cp);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__cp(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__cp ** SOAP_FMAC4 soap_get_PointerTo_ns1__cp(struct soap *soap, struct _ns1__cp **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__cp(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__cp ** SOAP_FMAC4 soap_in_PointerTo_ns1__cp(struct soap *soap, const char *tag, struct _ns1__cp **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__cp **)soap_malloc(soap, sizeof(struct _ns1__cp *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__cp(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__cp **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__cp, sizeof(struct _ns1__cp), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__uploadByteArrayResponse(struct soap *soap, struct _ns1__uploadByteArrayResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__uploadByteArrayResponse))
		soap_serialize__ns1__uploadByteArrayResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__uploadByteArrayResponse(struct soap *soap, struct _ns1__uploadByteArrayResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__uploadByteArrayResponse);
	if (soap_out_PointerTo_ns1__uploadByteArrayResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__uploadByteArrayResponse(struct soap *soap, const char *tag, int id, struct _ns1__uploadByteArrayResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__uploadByteArrayResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__uploadByteArrayResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__uploadByteArrayResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__uploadByteArrayResponse(struct soap *soap, struct _ns1__uploadByteArrayResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__uploadByteArrayResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadByteArrayResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__uploadByteArrayResponse(struct soap *soap, const char *tag, struct _ns1__uploadByteArrayResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__uploadByteArrayResponse **)soap_malloc(soap, sizeof(struct _ns1__uploadByteArrayResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__uploadByteArrayResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadByteArrayResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__uploadByteArrayResponse, sizeof(struct _ns1__uploadByteArrayResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__uploadByteArray(struct soap *soap, struct _ns1__uploadByteArray *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__uploadByteArray))
		soap_serialize__ns1__uploadByteArray(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__uploadByteArray(struct soap *soap, struct _ns1__uploadByteArray *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__uploadByteArray);
	if (soap_out_PointerTo_ns1__uploadByteArray(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__uploadByteArray(struct soap *soap, const char *tag, int id, struct _ns1__uploadByteArray *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__uploadByteArray);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__uploadByteArray(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__uploadByteArray ** SOAP_FMAC4 soap_get_PointerTo_ns1__uploadByteArray(struct soap *soap, struct _ns1__uploadByteArray **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__uploadByteArray(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadByteArray ** SOAP_FMAC4 soap_in_PointerTo_ns1__uploadByteArray(struct soap *soap, const char *tag, struct _ns1__uploadByteArray **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__uploadByteArray **)soap_malloc(soap, sizeof(struct _ns1__uploadByteArray *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__uploadByteArray(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadByteArray **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__uploadByteArray, sizeof(struct _ns1__uploadByteArray), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__submitJobResponse(struct soap *soap, struct _ns1__submitJobResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__submitJobResponse))
		soap_serialize__ns1__submitJobResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__submitJobResponse(struct soap *soap, struct _ns1__submitJobResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__submitJobResponse);
	if (soap_out_PointerTo_ns1__submitJobResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__submitJobResponse(struct soap *soap, const char *tag, int id, struct _ns1__submitJobResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__submitJobResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__submitJobResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__submitJobResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__submitJobResponse(struct soap *soap, struct _ns1__submitJobResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__submitJobResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__submitJobResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__submitJobResponse(struct soap *soap, const char *tag, struct _ns1__submitJobResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__submitJobResponse **)soap_malloc(soap, sizeof(struct _ns1__submitJobResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__submitJobResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__submitJobResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__submitJobResponse, sizeof(struct _ns1__submitJobResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__submitJob(struct soap *soap, struct _ns1__submitJob *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__submitJob))
		soap_serialize__ns1__submitJob(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__submitJob(struct soap *soap, struct _ns1__submitJob *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__submitJob);
	if (soap_out_PointerTo_ns1__submitJob(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__submitJob(struct soap *soap, const char *tag, int id, struct _ns1__submitJob *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__submitJob);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__submitJob(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__submitJob ** SOAP_FMAC4 soap_get_PointerTo_ns1__submitJob(struct soap *soap, struct _ns1__submitJob **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__submitJob(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__submitJob ** SOAP_FMAC4 soap_in_PointerTo_ns1__submitJob(struct soap *soap, const char *tag, struct _ns1__submitJob **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__submitJob **)soap_malloc(soap, sizeof(struct _ns1__submitJob *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__submitJob(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__submitJob **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__submitJob, sizeof(struct _ns1__submitJob), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__logoutResponse(struct soap *soap, struct _ns1__logoutResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__logoutResponse))
		soap_serialize__ns1__logoutResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__logoutResponse(struct soap *soap, struct _ns1__logoutResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__logoutResponse);
	if (soap_out_PointerTo_ns1__logoutResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__logoutResponse(struct soap *soap, const char *tag, int id, struct _ns1__logoutResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__logoutResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__logoutResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__logoutResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__logoutResponse(struct soap *soap, struct _ns1__logoutResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__logoutResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__logoutResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__logoutResponse(struct soap *soap, const char *tag, struct _ns1__logoutResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__logoutResponse **)soap_malloc(soap, sizeof(struct _ns1__logoutResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__logoutResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__logoutResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__logoutResponse, sizeof(struct _ns1__logoutResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__logout(struct soap *soap, struct _ns1__logout *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__logout))
		soap_serialize__ns1__logout(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__logout(struct soap *soap, struct _ns1__logout *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__logout);
	if (soap_out_PointerTo_ns1__logout(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__logout(struct soap *soap, const char *tag, int id, struct _ns1__logout *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__logout);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__logout(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__logout ** SOAP_FMAC4 soap_get_PointerTo_ns1__logout(struct soap *soap, struct _ns1__logout **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__logout(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__logout ** SOAP_FMAC4 soap_in_PointerTo_ns1__logout(struct soap *soap, const char *tag, struct _ns1__logout **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__logout **)soap_malloc(soap, sizeof(struct _ns1__logout *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__logout(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__logout **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__logout, sizeof(struct _ns1__logout), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__setJobDescription_USCOREstringResponse(struct soap *soap, struct _ns1__setJobDescription_USCOREstringResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse))
		soap_serialize__ns1__setJobDescription_USCOREstringResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__setJobDescription_USCOREstringResponse(struct soap *soap, struct _ns1__setJobDescription_USCOREstringResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__setJobDescription_USCOREstringResponse);
	if (soap_out_PointerTo_ns1__setJobDescription_USCOREstringResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__setJobDescription_USCOREstringResponse(struct soap *soap, const char *tag, int id, struct _ns1__setJobDescription_USCOREstringResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__setJobDescription_USCOREstringResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__setJobDescription_USCOREstringResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__setJobDescription_USCOREstringResponse(struct soap *soap, struct _ns1__setJobDescription_USCOREstringResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__setJobDescription_USCOREstringResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__setJobDescription_USCOREstringResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__setJobDescription_USCOREstringResponse(struct soap *soap, const char *tag, struct _ns1__setJobDescription_USCOREstringResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__setJobDescription_USCOREstringResponse **)soap_malloc(soap, sizeof(struct _ns1__setJobDescription_USCOREstringResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__setJobDescription_USCOREstringResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__setJobDescription_USCOREstringResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__setJobDescription_USCOREstringResponse, sizeof(struct _ns1__setJobDescription_USCOREstringResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__setJobDescription_USCOREstring(struct soap *soap, struct _ns1__setJobDescription_USCOREstring *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__setJobDescription_USCOREstring))
		soap_serialize__ns1__setJobDescription_USCOREstring(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__setJobDescription_USCOREstring(struct soap *soap, struct _ns1__setJobDescription_USCOREstring *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__setJobDescription_USCOREstring);
	if (soap_out_PointerTo_ns1__setJobDescription_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__setJobDescription_USCOREstring(struct soap *soap, const char *tag, int id, struct _ns1__setJobDescription_USCOREstring *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__setJobDescription_USCOREstring);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__setJobDescription_USCOREstring(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__setJobDescription_USCOREstring ** SOAP_FMAC4 soap_get_PointerTo_ns1__setJobDescription_USCOREstring(struct soap *soap, struct _ns1__setJobDescription_USCOREstring **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__setJobDescription_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__setJobDescription_USCOREstring ** SOAP_FMAC4 soap_in_PointerTo_ns1__setJobDescription_USCOREstring(struct soap *soap, const char *tag, struct _ns1__setJobDescription_USCOREstring **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__setJobDescription_USCOREstring **)soap_malloc(soap, sizeof(struct _ns1__setJobDescription_USCOREstring *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__setJobDescription_USCOREstring(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__setJobDescription_USCOREstring **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__setJobDescription_USCOREstring, sizeof(struct _ns1__setJobDescription_USCOREstring), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, struct _ns1__calculateRelativeJobDirectoryResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse))
		soap_serialize__ns1__calculateRelativeJobDirectoryResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, struct _ns1__calculateRelativeJobDirectoryResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__calculateRelativeJobDirectoryResponse);
	if (soap_out_PointerTo_ns1__calculateRelativeJobDirectoryResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, const char *tag, int id, struct _ns1__calculateRelativeJobDirectoryResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__calculateRelativeJobDirectoryResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__calculateRelativeJobDirectoryResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, struct _ns1__calculateRelativeJobDirectoryResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__calculateRelativeJobDirectoryResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__calculateRelativeJobDirectoryResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__calculateRelativeJobDirectoryResponse(struct soap *soap, const char *tag, struct _ns1__calculateRelativeJobDirectoryResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__calculateRelativeJobDirectoryResponse **)soap_malloc(soap, sizeof(struct _ns1__calculateRelativeJobDirectoryResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__calculateRelativeJobDirectoryResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__calculateRelativeJobDirectoryResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__calculateRelativeJobDirectoryResponse, sizeof(struct _ns1__calculateRelativeJobDirectoryResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__calculateRelativeJobDirectory(struct soap *soap, struct _ns1__calculateRelativeJobDirectory *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__calculateRelativeJobDirectory))
		soap_serialize__ns1__calculateRelativeJobDirectory(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__calculateRelativeJobDirectory(struct soap *soap, struct _ns1__calculateRelativeJobDirectory *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__calculateRelativeJobDirectory);
	if (soap_out_PointerTo_ns1__calculateRelativeJobDirectory(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__calculateRelativeJobDirectory(struct soap *soap, const char *tag, int id, struct _ns1__calculateRelativeJobDirectory *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__calculateRelativeJobDirectory);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__calculateRelativeJobDirectory(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__calculateRelativeJobDirectory ** SOAP_FMAC4 soap_get_PointerTo_ns1__calculateRelativeJobDirectory(struct soap *soap, struct _ns1__calculateRelativeJobDirectory **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__calculateRelativeJobDirectory(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__calculateRelativeJobDirectory ** SOAP_FMAC4 soap_in_PointerTo_ns1__calculateRelativeJobDirectory(struct soap *soap, const char *tag, struct _ns1__calculateRelativeJobDirectory **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__calculateRelativeJobDirectory **)soap_malloc(soap, sizeof(struct _ns1__calculateRelativeJobDirectory *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__calculateRelativeJobDirectory(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__calculateRelativeJobDirectory **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__calculateRelativeJobDirectory, sizeof(struct _ns1__calculateRelativeJobDirectory), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getApplicationDetails1Response(struct soap *soap, struct _ns1__getApplicationDetails1Response *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getApplicationDetails1Response))
		soap_serialize__ns1__getApplicationDetails1Response(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getApplicationDetails1Response(struct soap *soap, struct _ns1__getApplicationDetails1Response *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getApplicationDetails1Response);
	if (soap_out_PointerTo_ns1__getApplicationDetails1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getApplicationDetails1Response(struct soap *soap, const char *tag, int id, struct _ns1__getApplicationDetails1Response *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getApplicationDetails1Response);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getApplicationDetails1Response(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getApplicationDetails1Response ** SOAP_FMAC4 soap_get_PointerTo_ns1__getApplicationDetails1Response(struct soap *soap, struct _ns1__getApplicationDetails1Response **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getApplicationDetails1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getApplicationDetails1Response ** SOAP_FMAC4 soap_in_PointerTo_ns1__getApplicationDetails1Response(struct soap *soap, const char *tag, struct _ns1__getApplicationDetails1Response **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getApplicationDetails1Response **)soap_malloc(soap, sizeof(struct _ns1__getApplicationDetails1Response *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getApplicationDetails1Response(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getApplicationDetails1Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getApplicationDetails1Response, sizeof(struct _ns1__getApplicationDetails1Response), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getApplicationDetails1(struct soap *soap, struct _ns1__getApplicationDetails1 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getApplicationDetails1))
		soap_serialize__ns1__getApplicationDetails1(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getApplicationDetails1(struct soap *soap, struct _ns1__getApplicationDetails1 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getApplicationDetails1);
	if (soap_out_PointerTo_ns1__getApplicationDetails1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getApplicationDetails1(struct soap *soap, const char *tag, int id, struct _ns1__getApplicationDetails1 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getApplicationDetails1);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getApplicationDetails1(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getApplicationDetails1 ** SOAP_FMAC4 soap_get_PointerTo_ns1__getApplicationDetails1(struct soap *soap, struct _ns1__getApplicationDetails1 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getApplicationDetails1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getApplicationDetails1 ** SOAP_FMAC4 soap_in_PointerTo_ns1__getApplicationDetails1(struct soap *soap, const char *tag, struct _ns1__getApplicationDetails1 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getApplicationDetails1 **)soap_malloc(soap, sizeof(struct _ns1__getApplicationDetails1 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getApplicationDetails1(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getApplicationDetails1 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getApplicationDetails1, sizeof(struct _ns1__getApplicationDetails1), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__lsResponse(struct soap *soap, struct _ns1__lsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__lsResponse))
		soap_serialize__ns1__lsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__lsResponse(struct soap *soap, struct _ns1__lsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__lsResponse);
	if (soap_out_PointerTo_ns1__lsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__lsResponse(struct soap *soap, const char *tag, int id, struct _ns1__lsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__lsResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__lsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__lsResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__lsResponse(struct soap *soap, struct _ns1__lsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__lsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__lsResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__lsResponse(struct soap *soap, const char *tag, struct _ns1__lsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__lsResponse **)soap_malloc(soap, sizeof(struct _ns1__lsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__lsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__lsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__lsResponse, sizeof(struct _ns1__lsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__ls(struct soap *soap, struct _ns1__ls *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__ls))
		soap_serialize__ns1__ls(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__ls(struct soap *soap, struct _ns1__ls *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__ls);
	if (soap_out_PointerTo_ns1__ls(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__ls(struct soap *soap, const char *tag, int id, struct _ns1__ls *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__ls);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__ls(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__ls ** SOAP_FMAC4 soap_get_PointerTo_ns1__ls(struct soap *soap, struct _ns1__ls **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__ls(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ls ** SOAP_FMAC4 soap_in_PointerTo_ns1__ls(struct soap *soap, const char *tag, struct _ns1__ls **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__ls **)soap_malloc(soap, sizeof(struct _ns1__ls *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__ls(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__ls **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__ls, sizeof(struct _ns1__ls), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__lastModifiedResponse(struct soap *soap, struct _ns1__lastModifiedResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__lastModifiedResponse))
		soap_serialize__ns1__lastModifiedResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__lastModifiedResponse(struct soap *soap, struct _ns1__lastModifiedResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__lastModifiedResponse);
	if (soap_out_PointerTo_ns1__lastModifiedResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__lastModifiedResponse(struct soap *soap, const char *tag, int id, struct _ns1__lastModifiedResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__lastModifiedResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__lastModifiedResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__lastModifiedResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__lastModifiedResponse(struct soap *soap, struct _ns1__lastModifiedResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__lastModifiedResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__lastModifiedResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__lastModifiedResponse(struct soap *soap, const char *tag, struct _ns1__lastModifiedResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__lastModifiedResponse **)soap_malloc(soap, sizeof(struct _ns1__lastModifiedResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__lastModifiedResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__lastModifiedResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__lastModifiedResponse, sizeof(struct _ns1__lastModifiedResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__lastModified(struct soap *soap, struct _ns1__lastModified *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__lastModified))
		soap_serialize__ns1__lastModified(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__lastModified(struct soap *soap, struct _ns1__lastModified *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__lastModified);
	if (soap_out_PointerTo_ns1__lastModified(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__lastModified(struct soap *soap, const char *tag, int id, struct _ns1__lastModified *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__lastModified);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__lastModified(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__lastModified ** SOAP_FMAC4 soap_get_PointerTo_ns1__lastModified(struct soap *soap, struct _ns1__lastModified **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__lastModified(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__lastModified ** SOAP_FMAC4 soap_in_PointerTo_ns1__lastModified(struct soap *soap, const char *tag, struct _ns1__lastModified **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__lastModified **)soap_malloc(soap, sizeof(struct _ns1__lastModified *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__lastModified(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__lastModified **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__lastModified, sizeof(struct _ns1__lastModified), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getSiteResponse(struct soap *soap, struct _ns1__getSiteResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getSiteResponse))
		soap_serialize__ns1__getSiteResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getSiteResponse(struct soap *soap, struct _ns1__getSiteResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getSiteResponse);
	if (soap_out_PointerTo_ns1__getSiteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getSiteResponse(struct soap *soap, const char *tag, int id, struct _ns1__getSiteResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getSiteResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getSiteResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getSiteResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getSiteResponse(struct soap *soap, struct _ns1__getSiteResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getSiteResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSiteResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getSiteResponse(struct soap *soap, const char *tag, struct _ns1__getSiteResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getSiteResponse **)soap_malloc(soap, sizeof(struct _ns1__getSiteResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getSiteResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSiteResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getSiteResponse, sizeof(struct _ns1__getSiteResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getSite(struct soap *soap, struct _ns1__getSite *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getSite))
		soap_serialize__ns1__getSite(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getSite(struct soap *soap, struct _ns1__getSite *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getSite);
	if (soap_out_PointerTo_ns1__getSite(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getSite(struct soap *soap, const char *tag, int id, struct _ns1__getSite *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getSite);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getSite(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getSite ** SOAP_FMAC4 soap_get_PointerTo_ns1__getSite(struct soap *soap, struct _ns1__getSite **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getSite(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSite ** SOAP_FMAC4 soap_in_PointerTo_ns1__getSite(struct soap *soap, const char *tag, struct _ns1__getSite **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getSite **)soap_malloc(soap, sizeof(struct _ns1__getSite *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getSite(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSite **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getSite, sizeof(struct _ns1__getSite), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__ps_USCOREstringResponse(struct soap *soap, struct _ns1__ps_USCOREstringResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__ps_USCOREstringResponse))
		soap_serialize__ns1__ps_USCOREstringResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__ps_USCOREstringResponse(struct soap *soap, struct _ns1__ps_USCOREstringResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__ps_USCOREstringResponse);
	if (soap_out_PointerTo_ns1__ps_USCOREstringResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__ps_USCOREstringResponse(struct soap *soap, const char *tag, int id, struct _ns1__ps_USCOREstringResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__ps_USCOREstringResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__ps_USCOREstringResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__ps_USCOREstringResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__ps_USCOREstringResponse(struct soap *soap, struct _ns1__ps_USCOREstringResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__ps_USCOREstringResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ps_USCOREstringResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__ps_USCOREstringResponse(struct soap *soap, const char *tag, struct _ns1__ps_USCOREstringResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__ps_USCOREstringResponse **)soap_malloc(soap, sizeof(struct _ns1__ps_USCOREstringResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__ps_USCOREstringResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__ps_USCOREstringResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__ps_USCOREstringResponse, sizeof(struct _ns1__ps_USCOREstringResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__ps_USCOREstring(struct soap *soap, struct _ns1__ps_USCOREstring *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__ps_USCOREstring))
		soap_serialize__ns1__ps_USCOREstring(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__ps_USCOREstring(struct soap *soap, struct _ns1__ps_USCOREstring *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__ps_USCOREstring);
	if (soap_out_PointerTo_ns1__ps_USCOREstring(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__ps_USCOREstring(struct soap *soap, const char *tag, int id, struct _ns1__ps_USCOREstring *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__ps_USCOREstring);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__ps_USCOREstring(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__ps_USCOREstring ** SOAP_FMAC4 soap_get_PointerTo_ns1__ps_USCOREstring(struct soap *soap, struct _ns1__ps_USCOREstring **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__ps_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__ps_USCOREstring ** SOAP_FMAC4 soap_in_PointerTo_ns1__ps_USCOREstring(struct soap *soap, const char *tag, struct _ns1__ps_USCOREstring **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__ps_USCOREstring **)soap_malloc(soap, sizeof(struct _ns1__ps_USCOREstring *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__ps_USCOREstring(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__ps_USCOREstring **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__ps_USCOREstring, sizeof(struct _ns1__ps_USCOREstring), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__uploadByteArray1Response(struct soap *soap, struct _ns1__uploadByteArray1Response *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__uploadByteArray1Response))
		soap_serialize__ns1__uploadByteArray1Response(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__uploadByteArray1Response(struct soap *soap, struct _ns1__uploadByteArray1Response *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__uploadByteArray1Response);
	if (soap_out_PointerTo_ns1__uploadByteArray1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__uploadByteArray1Response(struct soap *soap, const char *tag, int id, struct _ns1__uploadByteArray1Response *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__uploadByteArray1Response);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__uploadByteArray1Response(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__uploadByteArray1Response ** SOAP_FMAC4 soap_get_PointerTo_ns1__uploadByteArray1Response(struct soap *soap, struct _ns1__uploadByteArray1Response **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__uploadByteArray1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadByteArray1Response ** SOAP_FMAC4 soap_in_PointerTo_ns1__uploadByteArray1Response(struct soap *soap, const char *tag, struct _ns1__uploadByteArray1Response **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__uploadByteArray1Response **)soap_malloc(soap, sizeof(struct _ns1__uploadByteArray1Response *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__uploadByteArray1Response(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadByteArray1Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__uploadByteArray1Response, sizeof(struct _ns1__uploadByteArray1Response), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__uploadByteArray1(struct soap *soap, struct _ns1__uploadByteArray1 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__uploadByteArray1))
		soap_serialize__ns1__uploadByteArray1(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__uploadByteArray1(struct soap *soap, struct _ns1__uploadByteArray1 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__uploadByteArray1);
	if (soap_out_PointerTo_ns1__uploadByteArray1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__uploadByteArray1(struct soap *soap, const char *tag, int id, struct _ns1__uploadByteArray1 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__uploadByteArray1);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__uploadByteArray1(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__uploadByteArray1 ** SOAP_FMAC4 soap_get_PointerTo_ns1__uploadByteArray1(struct soap *soap, struct _ns1__uploadByteArray1 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__uploadByteArray1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__uploadByteArray1 ** SOAP_FMAC4 soap_in_PointerTo_ns1__uploadByteArray1(struct soap *soap, const char *tag, struct _ns1__uploadByteArray1 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__uploadByteArray1 **)soap_malloc(soap, sizeof(struct _ns1__uploadByteArray1 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__uploadByteArray1(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__uploadByteArray1 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__uploadByteArray1, sizeof(struct _ns1__uploadByteArray1), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSiteResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse))
		soap_serialize__ns1__getVersionsOfApplicationOnSiteResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSiteResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse);
	if (soap_out_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, const char *tag, int id, struct _ns1__getVersionsOfApplicationOnSiteResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getVersionsOfApplicationOnSiteResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getVersionsOfApplicationOnSiteResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSiteResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getVersionsOfApplicationOnSiteResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getVersionsOfApplicationOnSiteResponse(struct soap *soap, const char *tag, struct _ns1__getVersionsOfApplicationOnSiteResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getVersionsOfApplicationOnSiteResponse **)soap_malloc(soap, sizeof(struct _ns1__getVersionsOfApplicationOnSiteResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getVersionsOfApplicationOnSiteResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getVersionsOfApplicationOnSiteResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getVersionsOfApplicationOnSiteResponse, sizeof(struct _ns1__getVersionsOfApplicationOnSiteResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getVersionsOfApplicationOnSite(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSite *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getVersionsOfApplicationOnSite))
		soap_serialize__ns1__getVersionsOfApplicationOnSite(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getVersionsOfApplicationOnSite(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSite *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getVersionsOfApplicationOnSite);
	if (soap_out_PointerTo_ns1__getVersionsOfApplicationOnSite(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getVersionsOfApplicationOnSite(struct soap *soap, const char *tag, int id, struct _ns1__getVersionsOfApplicationOnSite *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getVersionsOfApplicationOnSite);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getVersionsOfApplicationOnSite(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getVersionsOfApplicationOnSite ** SOAP_FMAC4 soap_get_PointerTo_ns1__getVersionsOfApplicationOnSite(struct soap *soap, struct _ns1__getVersionsOfApplicationOnSite **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getVersionsOfApplicationOnSite(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getVersionsOfApplicationOnSite ** SOAP_FMAC4 soap_in_PointerTo_ns1__getVersionsOfApplicationOnSite(struct soap *soap, const char *tag, struct _ns1__getVersionsOfApplicationOnSite **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getVersionsOfApplicationOnSite **)soap_malloc(soap, sizeof(struct _ns1__getVersionsOfApplicationOnSite *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getVersionsOfApplicationOnSite(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getVersionsOfApplicationOnSite **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getVersionsOfApplicationOnSite, sizeof(struct _ns1__getVersionsOfApplicationOnSite), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllSubmissionLocations1Response(struct soap *soap, struct _ns1__getAllSubmissionLocations1Response *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllSubmissionLocations1Response))
		soap_serialize__ns1__getAllSubmissionLocations1Response(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllSubmissionLocations1Response(struct soap *soap, struct _ns1__getAllSubmissionLocations1Response *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations1Response);
	if (soap_out_PointerTo_ns1__getAllSubmissionLocations1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllSubmissionLocations1Response(struct soap *soap, const char *tag, int id, struct _ns1__getAllSubmissionLocations1Response *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllSubmissionLocations1Response);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllSubmissionLocations1Response(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations1Response ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllSubmissionLocations1Response(struct soap *soap, struct _ns1__getAllSubmissionLocations1Response **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllSubmissionLocations1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations1Response ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllSubmissionLocations1Response(struct soap *soap, const char *tag, struct _ns1__getAllSubmissionLocations1Response **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllSubmissionLocations1Response **)soap_malloc(soap, sizeof(struct _ns1__getAllSubmissionLocations1Response *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllSubmissionLocations1Response(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSubmissionLocations1Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllSubmissionLocations1Response, sizeof(struct _ns1__getAllSubmissionLocations1Response), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllSubmissionLocations1(struct soap *soap, struct _ns1__getAllSubmissionLocations1 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllSubmissionLocations1))
		soap_serialize__ns1__getAllSubmissionLocations1(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllSubmissionLocations1(struct soap *soap, struct _ns1__getAllSubmissionLocations1 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations1);
	if (soap_out_PointerTo_ns1__getAllSubmissionLocations1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllSubmissionLocations1(struct soap *soap, const char *tag, int id, struct _ns1__getAllSubmissionLocations1 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllSubmissionLocations1);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllSubmissionLocations1(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations1 ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllSubmissionLocations1(struct soap *soap, struct _ns1__getAllSubmissionLocations1 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllSubmissionLocations1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations1 ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllSubmissionLocations1(struct soap *soap, const char *tag, struct _ns1__getAllSubmissionLocations1 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllSubmissionLocations1 **)soap_malloc(soap, sizeof(struct _ns1__getAllSubmissionLocations1 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllSubmissionLocations1(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSubmissionLocations1 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllSubmissionLocations1, sizeof(struct _ns1__getAllSubmissionLocations1), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__createJobResponse(struct soap *soap, struct _ns1__createJobResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__createJobResponse))
		soap_serialize__ns1__createJobResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__createJobResponse(struct soap *soap, struct _ns1__createJobResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__createJobResponse);
	if (soap_out_PointerTo_ns1__createJobResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__createJobResponse(struct soap *soap, const char *tag, int id, struct _ns1__createJobResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__createJobResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__createJobResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__createJobResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__createJobResponse(struct soap *soap, struct _ns1__createJobResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__createJobResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__createJobResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__createJobResponse(struct soap *soap, const char *tag, struct _ns1__createJobResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__createJobResponse **)soap_malloc(soap, sizeof(struct _ns1__createJobResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__createJobResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__createJobResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__createJobResponse, sizeof(struct _ns1__createJobResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__createJob(struct soap *soap, struct _ns1__createJob *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__createJob))
		soap_serialize__ns1__createJob(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__createJob(struct soap *soap, struct _ns1__createJob *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__createJob);
	if (soap_out_PointerTo_ns1__createJob(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__createJob(struct soap *soap, const char *tag, int id, struct _ns1__createJob *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__createJob);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__createJob(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__createJob ** SOAP_FMAC4 soap_get_PointerTo_ns1__createJob(struct soap *soap, struct _ns1__createJob **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__createJob(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__createJob ** SOAP_FMAC4 soap_in_PointerTo_ns1__createJob(struct soap *soap, const char *tag, struct _ns1__createJob **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__createJob **)soap_malloc(soap, sizeof(struct _ns1__createJob *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__createJob(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__createJob **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__createJob, sizeof(struct _ns1__createJob), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getInterfaceVersionResponse(struct soap *soap, struct _ns1__getInterfaceVersionResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getInterfaceVersionResponse))
		soap_serialize__ns1__getInterfaceVersionResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getInterfaceVersionResponse(struct soap *soap, struct _ns1__getInterfaceVersionResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getInterfaceVersionResponse);
	if (soap_out_PointerTo_ns1__getInterfaceVersionResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getInterfaceVersionResponse(struct soap *soap, const char *tag, int id, struct _ns1__getInterfaceVersionResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getInterfaceVersionResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getInterfaceVersionResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getInterfaceVersionResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getInterfaceVersionResponse(struct soap *soap, struct _ns1__getInterfaceVersionResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getInterfaceVersionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getInterfaceVersionResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getInterfaceVersionResponse(struct soap *soap, const char *tag, struct _ns1__getInterfaceVersionResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getInterfaceVersionResponse **)soap_malloc(soap, sizeof(struct _ns1__getInterfaceVersionResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getInterfaceVersionResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getInterfaceVersionResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getInterfaceVersionResponse, sizeof(struct _ns1__getInterfaceVersionResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getInterfaceVersion(struct soap *soap, struct _ns1__getInterfaceVersion *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getInterfaceVersion))
		soap_serialize__ns1__getInterfaceVersion(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getInterfaceVersion(struct soap *soap, struct _ns1__getInterfaceVersion *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getInterfaceVersion);
	if (soap_out_PointerTo_ns1__getInterfaceVersion(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getInterfaceVersion(struct soap *soap, const char *tag, int id, struct _ns1__getInterfaceVersion *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getInterfaceVersion);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getInterfaceVersion(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getInterfaceVersion ** SOAP_FMAC4 soap_get_PointerTo_ns1__getInterfaceVersion(struct soap *soap, struct _ns1__getInterfaceVersion **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getInterfaceVersion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getInterfaceVersion ** SOAP_FMAC4 soap_in_PointerTo_ns1__getInterfaceVersion(struct soap *soap, const char *tag, struct _ns1__getInterfaceVersion **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getInterfaceVersion **)soap_malloc(soap, sizeof(struct _ns1__getInterfaceVersion *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getInterfaceVersion(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getInterfaceVersion **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getInterfaceVersion, sizeof(struct _ns1__getInterfaceVersion), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllSubmissionLocationsResponse(struct soap *soap, struct _ns1__getAllSubmissionLocationsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllSubmissionLocationsResponse))
		soap_serialize__ns1__getAllSubmissionLocationsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllSubmissionLocationsResponse(struct soap *soap, struct _ns1__getAllSubmissionLocationsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocationsResponse);
	if (soap_out_PointerTo_ns1__getAllSubmissionLocationsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllSubmissionLocationsResponse(struct soap *soap, const char *tag, int id, struct _ns1__getAllSubmissionLocationsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllSubmissionLocationsResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllSubmissionLocationsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocationsResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllSubmissionLocationsResponse(struct soap *soap, struct _ns1__getAllSubmissionLocationsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllSubmissionLocationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocationsResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllSubmissionLocationsResponse(struct soap *soap, const char *tag, struct _ns1__getAllSubmissionLocationsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllSubmissionLocationsResponse **)soap_malloc(soap, sizeof(struct _ns1__getAllSubmissionLocationsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllSubmissionLocationsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSubmissionLocationsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllSubmissionLocationsResponse, sizeof(struct _ns1__getAllSubmissionLocationsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllSubmissionLocations(struct soap *soap, struct _ns1__getAllSubmissionLocations *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllSubmissionLocations))
		soap_serialize__ns1__getAllSubmissionLocations(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllSubmissionLocations(struct soap *soap, struct _ns1__getAllSubmissionLocations *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllSubmissionLocations);
	if (soap_out_PointerTo_ns1__getAllSubmissionLocations(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllSubmissionLocations(struct soap *soap, const char *tag, int id, struct _ns1__getAllSubmissionLocations *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllSubmissionLocations);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllSubmissionLocations(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllSubmissionLocations(struct soap *soap, struct _ns1__getAllSubmissionLocations **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllSubmissionLocations(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllSubmissionLocations ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllSubmissionLocations(struct soap *soap, const char *tag, struct _ns1__getAllSubmissionLocations **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllSubmissionLocations **)soap_malloc(soap, sizeof(struct _ns1__getAllSubmissionLocations *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllSubmissionLocations(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllSubmissionLocations **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllSubmissionLocations, sizeof(struct _ns1__getAllSubmissionLocations), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__addJobPropertyResponse(struct soap *soap, struct _ns1__addJobPropertyResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__addJobPropertyResponse))
		soap_serialize__ns1__addJobPropertyResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__addJobPropertyResponse(struct soap *soap, struct _ns1__addJobPropertyResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__addJobPropertyResponse);
	if (soap_out_PointerTo_ns1__addJobPropertyResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__addJobPropertyResponse(struct soap *soap, const char *tag, int id, struct _ns1__addJobPropertyResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__addJobPropertyResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__addJobPropertyResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__addJobPropertyResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__addJobPropertyResponse(struct soap *soap, struct _ns1__addJobPropertyResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__addJobPropertyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__addJobPropertyResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__addJobPropertyResponse(struct soap *soap, const char *tag, struct _ns1__addJobPropertyResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__addJobPropertyResponse **)soap_malloc(soap, sizeof(struct _ns1__addJobPropertyResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__addJobPropertyResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__addJobPropertyResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__addJobPropertyResponse, sizeof(struct _ns1__addJobPropertyResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__addJobProperty(struct soap *soap, struct _ns1__addJobProperty *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__addJobProperty))
		soap_serialize__ns1__addJobProperty(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__addJobProperty(struct soap *soap, struct _ns1__addJobProperty *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__addJobProperty);
	if (soap_out_PointerTo_ns1__addJobProperty(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__addJobProperty(struct soap *soap, const char *tag, int id, struct _ns1__addJobProperty *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__addJobProperty);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__addJobProperty(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__addJobProperty ** SOAP_FMAC4 soap_get_PointerTo_ns1__addJobProperty(struct soap *soap, struct _ns1__addJobProperty **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__addJobProperty(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__addJobProperty ** SOAP_FMAC4 soap_in_PointerTo_ns1__addJobProperty(struct soap *soap, const char *tag, struct _ns1__addJobProperty **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__addJobProperty **)soap_malloc(soap, sizeof(struct _ns1__addJobProperty *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__addJobProperty(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__addJobProperty **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__addJobProperty, sizeof(struct _ns1__addJobProperty), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__addJobPropertiesResponse(struct soap *soap, struct _ns1__addJobPropertiesResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__addJobPropertiesResponse))
		soap_serialize__ns1__addJobPropertiesResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__addJobPropertiesResponse(struct soap *soap, struct _ns1__addJobPropertiesResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__addJobPropertiesResponse);
	if (soap_out_PointerTo_ns1__addJobPropertiesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__addJobPropertiesResponse(struct soap *soap, const char *tag, int id, struct _ns1__addJobPropertiesResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__addJobPropertiesResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__addJobPropertiesResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__addJobPropertiesResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__addJobPropertiesResponse(struct soap *soap, struct _ns1__addJobPropertiesResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__addJobPropertiesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__addJobPropertiesResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__addJobPropertiesResponse(struct soap *soap, const char *tag, struct _ns1__addJobPropertiesResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__addJobPropertiesResponse **)soap_malloc(soap, sizeof(struct _ns1__addJobPropertiesResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__addJobPropertiesResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__addJobPropertiesResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__addJobPropertiesResponse, sizeof(struct _ns1__addJobPropertiesResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__addJobProperties(struct soap *soap, struct _ns1__addJobProperties *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__addJobProperties))
		soap_serialize__ns1__addJobProperties(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__addJobProperties(struct soap *soap, struct _ns1__addJobProperties *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__addJobProperties);
	if (soap_out_PointerTo_ns1__addJobProperties(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__addJobProperties(struct soap *soap, const char *tag, int id, struct _ns1__addJobProperties *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__addJobProperties);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__addJobProperties(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__addJobProperties ** SOAP_FMAC4 soap_get_PointerTo_ns1__addJobProperties(struct soap *soap, struct _ns1__addJobProperties **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__addJobProperties(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__addJobProperties ** SOAP_FMAC4 soap_in_PointerTo_ns1__addJobProperties(struct soap *soap, const char *tag, struct _ns1__addJobProperties **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__addJobProperties **)soap_malloc(soap, sizeof(struct _ns1__addJobProperties *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__addJobProperties(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__addJobProperties **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__addJobProperties, sizeof(struct _ns1__addJobProperties), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllAvailableApplicationsResponse(struct soap *soap, struct _ns1__getAllAvailableApplicationsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllAvailableApplicationsResponse))
		soap_serialize__ns1__getAllAvailableApplicationsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllAvailableApplicationsResponse(struct soap *soap, struct _ns1__getAllAvailableApplicationsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllAvailableApplicationsResponse);
	if (soap_out_PointerTo_ns1__getAllAvailableApplicationsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllAvailableApplicationsResponse(struct soap *soap, const char *tag, int id, struct _ns1__getAllAvailableApplicationsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllAvailableApplicationsResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllAvailableApplicationsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllAvailableApplicationsResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllAvailableApplicationsResponse(struct soap *soap, struct _ns1__getAllAvailableApplicationsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllAvailableApplicationsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllAvailableApplicationsResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllAvailableApplicationsResponse(struct soap *soap, const char *tag, struct _ns1__getAllAvailableApplicationsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllAvailableApplicationsResponse **)soap_malloc(soap, sizeof(struct _ns1__getAllAvailableApplicationsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllAvailableApplicationsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllAvailableApplicationsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllAvailableApplicationsResponse, sizeof(struct _ns1__getAllAvailableApplicationsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllAvailableApplications(struct soap *soap, struct _ns1__getAllAvailableApplications *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllAvailableApplications))
		soap_serialize__ns1__getAllAvailableApplications(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllAvailableApplications(struct soap *soap, struct _ns1__getAllAvailableApplications *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllAvailableApplications);
	if (soap_out_PointerTo_ns1__getAllAvailableApplications(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllAvailableApplications(struct soap *soap, const char *tag, int id, struct _ns1__getAllAvailableApplications *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllAvailableApplications);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllAvailableApplications(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllAvailableApplications ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllAvailableApplications(struct soap *soap, struct _ns1__getAllAvailableApplications **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllAvailableApplications(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllAvailableApplications ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllAvailableApplications(struct soap *soap, const char *tag, struct _ns1__getAllAvailableApplications **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllAvailableApplications **)soap_malloc(soap, sizeof(struct _ns1__getAllAvailableApplications *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllAvailableApplications(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllAvailableApplications **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllAvailableApplications, sizeof(struct _ns1__getAllAvailableApplications), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__killResponse(struct soap *soap, struct _ns1__killResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__killResponse))
		soap_serialize__ns1__killResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__killResponse(struct soap *soap, struct _ns1__killResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__killResponse);
	if (soap_out_PointerTo_ns1__killResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__killResponse(struct soap *soap, const char *tag, int id, struct _ns1__killResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__killResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__killResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__killResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__killResponse(struct soap *soap, struct _ns1__killResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__killResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__killResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__killResponse(struct soap *soap, const char *tag, struct _ns1__killResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__killResponse **)soap_malloc(soap, sizeof(struct _ns1__killResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__killResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__killResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__killResponse, sizeof(struct _ns1__killResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__kill(struct soap *soap, struct _ns1__kill *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__kill))
		soap_serialize__ns1__kill(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__kill(struct soap *soap, struct _ns1__kill *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__kill);
	if (soap_out_PointerTo_ns1__kill(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__kill(struct soap *soap, const char *tag, int id, struct _ns1__kill *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__kill);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__kill(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__kill ** SOAP_FMAC4 soap_get_PointerTo_ns1__kill(struct soap *soap, struct _ns1__kill **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__kill(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__kill ** SOAP_FMAC4 soap_in_PointerTo_ns1__kill(struct soap *soap, const char *tag, struct _ns1__kill **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__kill **)soap_malloc(soap, sizeof(struct _ns1__kill *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__kill(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__kill **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__kill, sizeof(struct _ns1__kill), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__isFolderResponse(struct soap *soap, struct _ns1__isFolderResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__isFolderResponse))
		soap_serialize__ns1__isFolderResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__isFolderResponse(struct soap *soap, struct _ns1__isFolderResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__isFolderResponse);
	if (soap_out_PointerTo_ns1__isFolderResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__isFolderResponse(struct soap *soap, const char *tag, int id, struct _ns1__isFolderResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__isFolderResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__isFolderResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__isFolderResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__isFolderResponse(struct soap *soap, struct _ns1__isFolderResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__isFolderResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__isFolderResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__isFolderResponse(struct soap *soap, const char *tag, struct _ns1__isFolderResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__isFolderResponse **)soap_malloc(soap, sizeof(struct _ns1__isFolderResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__isFolderResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__isFolderResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__isFolderResponse, sizeof(struct _ns1__isFolderResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__isFolder(struct soap *soap, struct _ns1__isFolder *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__isFolder))
		soap_serialize__ns1__isFolder(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__isFolder(struct soap *soap, struct _ns1__isFolder *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__isFolder);
	if (soap_out_PointerTo_ns1__isFolder(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__isFolder(struct soap *soap, const char *tag, int id, struct _ns1__isFolder *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__isFolder);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__isFolder(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__isFolder ** SOAP_FMAC4 soap_get_PointerTo_ns1__isFolder(struct soap *soap, struct _ns1__isFolder **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__isFolder(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__isFolder ** SOAP_FMAC4 soap_in_PointerTo_ns1__isFolder(struct soap *soap, const char *tag, struct _ns1__isFolder **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__isFolder **)soap_malloc(soap, sizeof(struct _ns1__isFolder *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__isFolder(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__isFolder **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__isFolder, sizeof(struct _ns1__isFolder), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__downloadResponse(struct soap *soap, struct _ns1__downloadResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__downloadResponse))
		soap_serialize__ns1__downloadResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__downloadResponse(struct soap *soap, struct _ns1__downloadResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__downloadResponse);
	if (soap_out_PointerTo_ns1__downloadResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__downloadResponse(struct soap *soap, const char *tag, int id, struct _ns1__downloadResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__downloadResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__downloadResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__downloadResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__downloadResponse(struct soap *soap, struct _ns1__downloadResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__downloadResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__downloadResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__downloadResponse(struct soap *soap, const char *tag, struct _ns1__downloadResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__downloadResponse **)soap_malloc(soap, sizeof(struct _ns1__downloadResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__downloadResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__downloadResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__downloadResponse, sizeof(struct _ns1__downloadResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__download(struct soap *soap, struct _ns1__download *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__download))
		soap_serialize__ns1__download(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__download(struct soap *soap, struct _ns1__download *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__download);
	if (soap_out_PointerTo_ns1__download(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__download(struct soap *soap, const char *tag, int id, struct _ns1__download *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__download);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__download(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__download ** SOAP_FMAC4 soap_get_PointerTo_ns1__download(struct soap *soap, struct _ns1__download **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__download(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__download ** SOAP_FMAC4 soap_in_PointerTo_ns1__download(struct soap *soap, const char *tag, struct _ns1__download **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__download **)soap_malloc(soap, sizeof(struct _ns1__download *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__download(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__download **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__download, sizeof(struct _ns1__download), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllJobPropertiesResponse(struct soap *soap, struct _ns1__getAllJobPropertiesResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllJobPropertiesResponse))
		soap_serialize__ns1__getAllJobPropertiesResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllJobPropertiesResponse(struct soap *soap, struct _ns1__getAllJobPropertiesResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllJobPropertiesResponse);
	if (soap_out_PointerTo_ns1__getAllJobPropertiesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllJobPropertiesResponse(struct soap *soap, const char *tag, int id, struct _ns1__getAllJobPropertiesResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllJobPropertiesResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllJobPropertiesResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllJobPropertiesResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllJobPropertiesResponse(struct soap *soap, struct _ns1__getAllJobPropertiesResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllJobPropertiesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllJobPropertiesResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllJobPropertiesResponse(struct soap *soap, const char *tag, struct _ns1__getAllJobPropertiesResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllJobPropertiesResponse **)soap_malloc(soap, sizeof(struct _ns1__getAllJobPropertiesResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllJobPropertiesResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllJobPropertiesResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllJobPropertiesResponse, sizeof(struct _ns1__getAllJobPropertiesResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllJobProperties(struct soap *soap, struct _ns1__getAllJobProperties *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllJobProperties))
		soap_serialize__ns1__getAllJobProperties(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllJobProperties(struct soap *soap, struct _ns1__getAllJobProperties *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllJobProperties);
	if (soap_out_PointerTo_ns1__getAllJobProperties(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllJobProperties(struct soap *soap, const char *tag, int id, struct _ns1__getAllJobProperties *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllJobProperties);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllJobProperties(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllJobProperties ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllJobProperties(struct soap *soap, struct _ns1__getAllJobProperties **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllJobProperties(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllJobProperties ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllJobProperties(struct soap *soap, const char *tag, struct _ns1__getAllJobProperties **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllJobProperties **)soap_malloc(soap, sizeof(struct _ns1__getAllJobProperties *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllJobProperties(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllJobProperties **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllJobProperties, sizeof(struct _ns1__getAllJobProperties), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllJobnamesResponse(struct soap *soap, struct _ns1__getAllJobnamesResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllJobnamesResponse))
		soap_serialize__ns1__getAllJobnamesResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllJobnamesResponse(struct soap *soap, struct _ns1__getAllJobnamesResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllJobnamesResponse);
	if (soap_out_PointerTo_ns1__getAllJobnamesResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllJobnamesResponse(struct soap *soap, const char *tag, int id, struct _ns1__getAllJobnamesResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllJobnamesResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllJobnamesResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllJobnamesResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllJobnamesResponse(struct soap *soap, struct _ns1__getAllJobnamesResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllJobnamesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllJobnamesResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllJobnamesResponse(struct soap *soap, const char *tag, struct _ns1__getAllJobnamesResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllJobnamesResponse **)soap_malloc(soap, sizeof(struct _ns1__getAllJobnamesResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllJobnamesResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllJobnamesResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllJobnamesResponse, sizeof(struct _ns1__getAllJobnamesResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getAllJobnames(struct soap *soap, struct _ns1__getAllJobnames *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getAllJobnames))
		soap_serialize__ns1__getAllJobnames(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getAllJobnames(struct soap *soap, struct _ns1__getAllJobnames *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getAllJobnames);
	if (soap_out_PointerTo_ns1__getAllJobnames(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getAllJobnames(struct soap *soap, const char *tag, int id, struct _ns1__getAllJobnames *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getAllJobnames);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getAllJobnames(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getAllJobnames ** SOAP_FMAC4 soap_get_PointerTo_ns1__getAllJobnames(struct soap *soap, struct _ns1__getAllJobnames **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getAllJobnames(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getAllJobnames ** SOAP_FMAC4 soap_in_PointerTo_ns1__getAllJobnames(struct soap *soap, const char *tag, struct _ns1__getAllJobnames **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getAllJobnames **)soap_malloc(soap, sizeof(struct _ns1__getAllJobnames *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getAllJobnames(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getAllJobnames **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getAllJobnames, sizeof(struct _ns1__getAllJobnames), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getDNResponse(struct soap *soap, struct _ns1__getDNResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getDNResponse))
		soap_serialize__ns1__getDNResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getDNResponse(struct soap *soap, struct _ns1__getDNResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getDNResponse);
	if (soap_out_PointerTo_ns1__getDNResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getDNResponse(struct soap *soap, const char *tag, int id, struct _ns1__getDNResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getDNResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getDNResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getDNResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getDNResponse(struct soap *soap, struct _ns1__getDNResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getDNResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getDNResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getDNResponse(struct soap *soap, const char *tag, struct _ns1__getDNResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getDNResponse **)soap_malloc(soap, sizeof(struct _ns1__getDNResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getDNResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getDNResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getDNResponse, sizeof(struct _ns1__getDNResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getDN(struct soap *soap, struct _ns1__getDN *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getDN))
		soap_serialize__ns1__getDN(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getDN(struct soap *soap, struct _ns1__getDN *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getDN);
	if (soap_out_PointerTo_ns1__getDN(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getDN(struct soap *soap, const char *tag, int id, struct _ns1__getDN *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getDN);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getDN(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getDN ** SOAP_FMAC4 soap_get_PointerTo_ns1__getDN(struct soap *soap, struct _ns1__getDN **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getDN(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getDN ** SOAP_FMAC4 soap_in_PointerTo_ns1__getDN(struct soap *soap, const char *tag, struct _ns1__getDN **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getDN **)soap_malloc(soap, sizeof(struct _ns1__getDN *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getDN(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getDN **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getDN, sizeof(struct _ns1__getDN), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, struct _ns1__getSubmissionLocationsForApplicationResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse))
		soap_serialize__ns1__getSubmissionLocationsForApplicationResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, struct _ns1__getSubmissionLocationsForApplicationResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplicationResponse);
	if (soap_out_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, const char *tag, int id, struct _ns1__getSubmissionLocationsForApplicationResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getSubmissionLocationsForApplicationResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplicationResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, struct _ns1__getSubmissionLocationsForApplicationResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplicationResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getSubmissionLocationsForApplicationResponse(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsForApplicationResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getSubmissionLocationsForApplicationResponse **)soap_malloc(soap, sizeof(struct _ns1__getSubmissionLocationsForApplicationResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getSubmissionLocationsForApplicationResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsForApplicationResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getSubmissionLocationsForApplicationResponse, sizeof(struct _ns1__getSubmissionLocationsForApplicationResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getSubmissionLocationsForApplication(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication))
		soap_serialize__ns1__getSubmissionLocationsForApplication(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getSubmissionLocationsForApplication(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getSubmissionLocationsForApplication);
	if (soap_out_PointerTo_ns1__getSubmissionLocationsForApplication(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getSubmissionLocationsForApplication(struct soap *soap, const char *tag, int id, struct _ns1__getSubmissionLocationsForApplication *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getSubmissionLocationsForApplication);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getSubmissionLocationsForApplication(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication ** SOAP_FMAC4 soap_get_PointerTo_ns1__getSubmissionLocationsForApplication(struct soap *soap, struct _ns1__getSubmissionLocationsForApplication **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getSubmissionLocationsForApplication(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getSubmissionLocationsForApplication ** SOAP_FMAC4 soap_in_PointerTo_ns1__getSubmissionLocationsForApplication(struct soap *soap, const char *tag, struct _ns1__getSubmissionLocationsForApplication **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getSubmissionLocationsForApplication **)soap_malloc(soap, sizeof(struct _ns1__getSubmissionLocationsForApplication *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getSubmissionLocationsForApplication(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getSubmissionLocationsForApplication **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getSubmissionLocationsForApplication, sizeof(struct _ns1__getSubmissionLocationsForApplication), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__createJob1Response(struct soap *soap, struct _ns1__createJob1Response *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__createJob1Response))
		soap_serialize__ns1__createJob1Response(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__createJob1Response(struct soap *soap, struct _ns1__createJob1Response *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__createJob1Response);
	if (soap_out_PointerTo_ns1__createJob1Response(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__createJob1Response(struct soap *soap, const char *tag, int id, struct _ns1__createJob1Response *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__createJob1Response);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__createJob1Response(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__createJob1Response ** SOAP_FMAC4 soap_get_PointerTo_ns1__createJob1Response(struct soap *soap, struct _ns1__createJob1Response **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__createJob1Response(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__createJob1Response ** SOAP_FMAC4 soap_in_PointerTo_ns1__createJob1Response(struct soap *soap, const char *tag, struct _ns1__createJob1Response **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__createJob1Response **)soap_malloc(soap, sizeof(struct _ns1__createJob1Response *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__createJob1Response(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__createJob1Response **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__createJob1Response, sizeof(struct _ns1__createJob1Response), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__createJob1(struct soap *soap, struct _ns1__createJob1 *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__createJob1))
		soap_serialize__ns1__createJob1(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__createJob1(struct soap *soap, struct _ns1__createJob1 *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__createJob1);
	if (soap_out_PointerTo_ns1__createJob1(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__createJob1(struct soap *soap, const char *tag, int id, struct _ns1__createJob1 *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__createJob1);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__createJob1(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__createJob1 ** SOAP_FMAC4 soap_get_PointerTo_ns1__createJob1(struct soap *soap, struct _ns1__createJob1 **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__createJob1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__createJob1 ** SOAP_FMAC4 soap_in_PointerTo_ns1__createJob1(struct soap *soap, const char *tag, struct _ns1__createJob1 **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__createJob1 **)soap_malloc(soap, sizeof(struct _ns1__createJob1 *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__createJob1(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__createJob1 **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__createJob1, sizeof(struct _ns1__createJob1), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_ns1__getApplicationDetailsResponse(struct soap *soap, struct _ns1__getApplicationDetailsResponse *const*a)
{
	if (!soap_reference(soap, *a, SOAP_TYPE__ns1__getApplicationDetailsResponse))
		soap_serialize__ns1__getApplicationDetailsResponse(soap, *a);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_ns1__getApplicationDetailsResponse(struct soap *soap, struct _ns1__getApplicationDetailsResponse *const*a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_PointerTo_ns1__getApplicationDetailsResponse);
	if (soap_out_PointerTo_ns1__getApplicationDetailsResponse(soap, tag, id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_ns1__getApplicationDetailsResponse(struct soap *soap, const char *tag, int id, struct _ns1__getApplicationDetailsResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__ns1__getApplicationDetailsResponse);
	if (id < 0)
		return soap->error;
	return soap_out__ns1__getApplicationDetailsResponse(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct _ns1__getApplicationDetailsResponse ** SOAP_FMAC4 soap_get_PointerTo_ns1__getApplicationDetailsResponse(struct soap *soap, struct _ns1__getApplicationDetailsResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_ns1__getApplicationDetailsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 struct _ns1__getApplicationDetailsResponse ** SOAP_FMAC4 soap_in_PointerTo_ns1__getApplicationDetailsResponse(struct soap *soap, const char *tag, struct _ns1__getApplicationDetailsResponse **a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct _ns1__getApplicationDetailsResponse **)soap_malloc(soap, sizeof(struct _ns1__getApplicationDetailsResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in__ns1__getApplicationDetailsResponse(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct _ns1__getApplicationDetailsResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__ns1__getApplicationDetailsResponse, sizeof(struct _ns1__getApplicationDetailsResponse), 0);
		if (soap->body && soap_element_end_in(soap, tag))
			r