/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

const TEST_PAGE = "https://example.com/document-builder.sjs?html=tab";

add_task(async function test_broadcasting_two_tabs_command() {
  info("Navigate the initial tab to the test URL");
  const tab1 = gBrowser.selectedTab;
  await loadURL(tab1.linkedBrowser, TEST_PAGE);
  const browsingContext1 = tab1.linkedBrowser.browsingContext;

  info("Open a new tab on the same test URL");
  const tab2 = await addTab(TEST_PAGE);
  const browsingContext2 = tab2.linkedBrowser.browsingContext;

  const rootMessageHandler = createRootMessageHandler(
    "session-id-broadcasting_two_tabs_command"
  );

  const broadcastValue = await sendTestBroadcastCommand(
    "commandwindowglobalonly",
    "testBroadcast",
    {},
    contextDescriptorAll,
    rootMessageHandler
  );

  ok(
    Array.isArray(broadcastValue),
    "The broadcast returned an array of values"
  );

  is(broadcastValue.length, 2, "The broadcast returned 2 values as expected");

  ok(
    broadcastValue.includes("broadcast-" + browsingContext1.id),
    "The broadcast returned the expected value from tab1"
  );
  ok(
    broadcastValue.includes("broadcast-" + browsingContext2.id),
    "The broadcast returned the expected value from tab2"
  );

  info("Unload the first tab and broadcast again");
  await gBrowser.explicitUnloadTabs([tab1]);

  const broadcastAfterUnload = await sendTestBroadcastCommand(
    "commandwindowglobalonly",
    "testBroadcast",
    {},
    contextDescriptorAll,
    rootMessageHandler
  );

  ok(
    Array.isArray(broadcastAfterUnload),
    "The broadcast (after unload) returned an array of values"
  );

  is(
    broadcastAfterUnload.length,
    1,
    "The broadcast (after unload) only returned 1 value"
  );

  is(
    broadcastAfterUnload[0],
    "broadcast-" + browsingContext2.id,
    "The broadcast (after unload) returned the expected value from tab2"
  );

  rootMessageHandler.destroy();
});
